<?php
$sub_menu = '750400';

include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

auth_check_menu($auth, $sub_menu, "w");

$g5['title'] = '푸시매니저 발송 로그';
include_once(G5_ADMIN_PATH.'/admin.head.php');

// 설정 확인
$config = get_pushmanager_config();
if (!$config) {
    alert('푸시매니저 설정이 필요합니다.', './api_config.php');
}

// 페이징 설정
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$per_page = 30;
$offset = ($page - 1) * $per_page;

// 검색 조건
$search_type = isset($_GET['search_type']) ? clean_xss_tags($_GET['search_type']) : '';
$search_keyword = isset($_GET['search_keyword']) ? clean_xss_tags($_GET['search_keyword']) : '';
$log_type = isset($_GET['log_type']) ? clean_xss_tags($_GET['log_type']) : '';
$date_from = isset($_GET['date_from']) ? clean_xss_tags($_GET['date_from']) : '';
$date_to = isset($_GET['date_to']) ? clean_xss_tags($_GET['date_to']) : '';

// 로그 삭제 처리
if (isset($_POST['delete_log']) && $_POST['delete_log']) {
    $log_id = intval($_POST['log_id']);
    
    if ($log_id > 0) {
        $sql = "DELETE FROM pushmanager_logs WHERE id = {$log_id}";
        $result = sql_query($sql);
        
        if ($result) {
            alert('로그가 삭제되었습니다.', './push_logs.php');
        } else {
            alert('로그 삭제에 실패했습니다.');
        }
    }
}

// 일괄 삭제 처리
if (isset($_POST['bulk_delete']) && $_POST['bulk_delete']) {
    $selected_ids = $_POST['selected_ids'] ?? array();
    
    if (!empty($selected_ids) && is_array($selected_ids)) {
        $ids = implode(',', array_map('intval', $selected_ids));
        $sql = "DELETE FROM pushmanager_logs WHERE id IN ({$ids})";
        $result = sql_query($sql);
        
        if ($result) {
            $count = count($selected_ids);
            alert("{$count}개의 로그가 삭제되었습니다.", './push_logs.php');
        } else {
            alert('로그 삭제에 실패했습니다.');
        }
    } else {
        alert('삭제할 로그를 선택해주세요.');
    }
}

// 오래된 로그 삭제 처리
if (isset($_POST['delete_old_logs']) && $_POST['delete_old_logs']) {
    $days = intval($_POST['delete_days']);
    
    if ($days > 0) {
        $sql = "DELETE FROM pushmanager_logs WHERE created_at < DATE_SUB(NOW(), INTERVAL {$days} DAY)";
        $result = sql_query($sql);
        
        if ($result) {
            $affected_rows = sql_affected_rows();
            log_pushmanager_activity('config', '오래된 로그 삭제', "{$days}일 이전 로그 {$affected_rows}개 삭제");
            alert("{$days}일 이전 로그 {$affected_rows}개가 삭제되었습니다.", './push_logs.php');
        } else {
            alert('로그 삭제에 실패했습니다.');
        }
    }
}

// 검색 조건 구성
$where_clause = "1=1";
$search_params = array();

if (!empty($search_keyword)) {
    switch ($search_type) {
        case 'title':
            $where_clause .= " AND title LIKE '%{$search_keyword}%'";
            break;
        case 'message':
            $where_clause .= " AND message LIKE '%{$search_keyword}%'";
            break;
        case 'error_message':
            $where_clause .= " AND error_message LIKE '%{$search_keyword}%'";
            break;
    }
    $search_params[] = "search_type={$search_type}";
    $search_params[] = "search_keyword=" . urlencode($search_keyword);
}

if (!empty($log_type)) {
    $where_clause .= " AND type = '{$log_type}'";
    $search_params[] = "log_type={$log_type}";
}

if (!empty($date_from)) {
    $where_clause .= " AND DATE(created_at) >= '{$date_from}'";
    $search_params[] = "date_from={$date_from}";
}

if (!empty($date_to)) {
    $where_clause .= " AND DATE(created_at) <= '{$date_to}'";
    $search_params[] = "date_to={$date_to}";
}

// 전체 로그 수 조회
$count_sql = "SELECT COUNT(*) as cnt FROM pushmanager_logs WHERE {$where_clause}";
$count_result = sql_fetch($count_sql);
$total_count = $count_result['cnt'];

// 로그 목록 조회
$list_sql = "SELECT * FROM pushmanager_logs 
             WHERE {$where_clause} 
             ORDER BY created_at DESC 
             LIMIT {$offset}, {$per_page}";
$list_result = sql_query($list_sql);

// 페이징
$total_pages = ceil($total_count / $per_page);
$query_string = !empty($search_params) ? '&' . implode('&', $search_params) : '';

// 로그 통계
$stats_sql = "SELECT 
                type,
                COUNT(*) as count,
                SUM(CASE WHEN target_count IS NOT NULL THEN target_count ELSE 0 END) as total_targets,
                SUM(CASE WHEN success_count IS NOT NULL THEN success_count ELSE 0 END) as total_success,
                SUM(CASE WHEN error_count IS NOT NULL THEN error_count ELSE 0 END) as total_errors
              FROM pushmanager_logs 
              WHERE created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)
              GROUP BY type 
              ORDER BY type";
$stats_result = sql_query($stats_sql);
$log_stats = array();
while ($row = sql_fetch_array($stats_result)) {
    $log_stats[$row['type']] = $row;
}

// 최근 발송 성공률
$recent_stats_sql = "SELECT 
                       SUM(CASE WHEN target_count IS NOT NULL THEN target_count ELSE 0 END) as total_sent,
                       SUM(CASE WHEN success_count IS NOT NULL THEN success_count ELSE 0 END) as total_success,
                       COUNT(*) as total_logs
                     FROM pushmanager_logs 
                     WHERE type = 'send' AND created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)";
$recent_stats = sql_fetch($recent_stats_sql);
$success_rate = $recent_stats['total_sent'] > 0 ? round(($recent_stats['total_success'] / $recent_stats['total_sent']) * 100, 1) : 0;

// 로그 타입별 색상 및 텍스트
function get_log_type_info($type) {
    switch ($type) {
        case 'send':
            return array('class' => 'fc_373', 'text' => '발송', 'badge' => 'success');
        case 'error':
            return array('class' => 'fc_197', 'text' => '오류', 'badge' => 'danger');
        case 'config':
            return array('class' => 'fc_blue', 'text' => '설정', 'badge' => 'info');
        default:
            return array('class' => 'fc_999', 'text' => '기타', 'badge' => 'secondary');
    }
}
?>

<div class="local_desc01 local_desc">
    <p>
        푸시 알림 발송 로그와 시스템 활동 로그를 조회할 수 있습니다.<br>
        발송 결과를 확인하고 문제가 발생한 경우 원인을 파악할 수 있습니다.
    </p>
</div>

<!-- 로그 통계 -->
<div class="tbl_frm01 tbl_wrap">
    <table>
        <caption>로그 통계 (최근 30일)</caption>
        <colgroup>
            <col class="grid_3">
            <col>
            <col class="grid_3">
            <col>
            <col class="grid_3">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row">최근 7일 성공률</th>
                <td>
                    <strong class="<?php echo $success_rate >= 90 ? 'fc_373' : ($success_rate >= 70 ? 'fc_fd7e14' : 'fc_197') ?>">
                        <?php echo $success_rate ?>%
                    </strong>
                    <div style="font-size:11px; color:#666;">
                        (<?php echo number_format($recent_stats['total_success']) ?>/<?php echo number_format($recent_stats['total_sent']) ?>)
                    </div>
                </td>
                <th scope="row">발송 로그</th>
                <td>
                    <?php echo number_format($log_stats['send']['count'] ?? 0) ?>건
                    <?php if (isset($log_stats['send'])): ?>
                    <div style="font-size:11px; color:#666;">
                        성공: <?php echo number_format($log_stats['send']['total_success']) ?>건
                    </div>
                    <?php endif; ?>
                </td>
                <th scope="row">오류 로그</th>
                <td>
                    <span class="<?php echo ($log_stats['error']['count'] ?? 0) > 0 ? 'fc_197' : 'fc_999' ?>">
                        <?php echo number_format($log_stats['error']['count'] ?? 0) ?>건
                    </span>
                </td>
            </tr>
            <tr>
                <th scope="row">설정 로그</th>
                <td><?php echo number_format($log_stats['config']['count'] ?? 0) ?>건</td>
                <th scope="row">전체 로그</th>
                <td><strong><?php echo number_format($total_count) ?>건</strong></td>
                <th scope="row">용량 관리</th>
                <td>
                    <button type="button" onclick="showCleanupModal()" class="btn_03 btn" style="font-size:11px;">정리</button>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 검색 폼 -->
<div class="local_sch01 local_sch">
    <form name="fsearch" method="get">
        <fieldset>
            <legend>로그 검색</legend>
            
            <label for="log_type">로그 유형</label>
            <select name="log_type" id="log_type">
                <option value="">전체</option>
                <option value="send"<?php echo $log_type == 'send' ? ' selected' : '' ?>>발송</option>
                <option value="error"<?php echo $log_type == 'error' ? ' selected' : '' ?>>오류</option>
                <option value="config"<?php echo $log_type == 'config' ? ' selected' : '' ?>>설정</option>
            </select>
            
            <label for="search_type" class="sound_only">검색대상</label>
            <select name="search_type" id="search_type">
                <option value="">검색 항목</option>
                <option value="title"<?php echo $search_type == 'title' ? ' selected' : '' ?>>제목</option>
                <option value="message"<?php echo $search_type == 'message' ? ' selected' : '' ?>>메시지</option>
                <option value="error_message"<?php echo $search_type == 'error_message' ? ' selected' : '' ?>>오류메시지</option>
            </select>
            <label for="search_keyword" class="sound_only">검색어</label>
            <input type="text" name="search_keyword" id="search_keyword" value="<?php echo $search_keyword ?>" placeholder="검색어 입력">
            
            <label for="date_from">기간</label>
            <input type="date" name="date_from" id="date_from" value="<?php echo $date_from ?>" class="frm_input">
            ~
            <input type="date" name="date_to" id="date_to" value="<?php echo $date_to ?>" class="frm_input">
            
            <input type="submit" value="검색" class="btn_submit">
            <a href="./push_logs.php" class="btn btn_06">전체목록</a>
        </fieldset>
    </form>
</div>

<!-- 로그 목록 -->
<form name="flist" method="post" onsubmit="return confirmBulkDelete()">
<div class="tbl_head01 tbl_wrap">
    <table>
        <caption><?php echo $g5['title'] ?> 목록</caption>
        <thead>
        <tr>
            <th scope="col">
                <label for="chkall" class="sound_only">전체</label>
                <input type="checkbox" name="chkall" id="chkall" onclick="check_all(this.form)">
            </th>
            <th scope="col">유형</th>
            <th scope="col">내용</th>
            <th scope="col">발송 결과<br>(대상/성공/실패)</th>
            <th scope="col">일시</th>
            <th scope="col">관리</th>
        </tr>
        </thead>
        <tbody>
        <?php
        if (sql_num_rows($list_result) > 0) {
            while ($row = sql_fetch_array($list_result)) {
                $type_info = get_log_type_info($row['type']);
                $has_error = !empty($row['error_message']);
                $success_rate_row = 0;
                
                if ($row['type'] == 'send' && $row['target_count'] > 0) {
                    $success_rate_row = round(($row['success_count'] / $row['target_count']) * 100, 1);
                }
        ?>
        <tr>
            <td class="td_chk">
                <label for="chk_<?php echo $row['id'] ?>" class="sound_only"><?php echo $row['id'] ?> 선택</label>
                <input type="checkbox" name="selected_ids[]" value="<?php echo $row['id'] ?>" id="chk_<?php echo $row['id'] ?>">
            </td>
            <td class="td_center">
                <span class="<?php echo $type_info['class'] ?>" style="font-weight:bold;">
                    <?php echo $type_info['text'] ?>
                </span>
                <?php if ($has_error): ?>
                <br><span style="color:#dc3545; font-size:10px;">⚠ 오류</span>
                <?php endif; ?>
            </td>
            <td class="td_left">
                <?php if (!empty($row['title'])): ?>
                <div style="font-weight:bold; margin-bottom:3px;">
                    <?php echo htmlspecialchars($row['title']) ?>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($row['message'])): ?>
                <div style="color:#666; font-size:12px; margin-bottom:5px;">
                    <?php echo nl2br(htmlspecialchars(mb_substr($row['message'], 0, 100) . (mb_strlen($row['message']) > 100 ? '...' : ''))) ?>
                </div>
                <?php endif; ?>
                
                <?php if ($has_error): ?>
                <div style="color:#dc3545; font-size:11px; background:#fff5f5; padding:3px 6px; border-radius:3px; margin-top:5px;">
                    <strong>오류:</strong> <?php echo htmlspecialchars(mb_substr($row['error_message'], 0, 80) . (mb_strlen($row['error_message']) > 80 ? '...' : '')) ?>
                </div>
                <?php endif; ?>
            </td>

			<td class="td_center">
                <?php if ($row['type'] == 'send'): ?>
                    <?php if ($row['target_count'] > 0): ?>
                    <div style="font-size:12px;">
                        <div style="margin-bottom:3px;">
                            (<?php echo number_format($row['target_count']) ?>/<?php echo number_format($row['success_count']) ?>/<?php echo number_format($row['error_count']) ?>)
                        </div>
                        <div>
                            <span class="<?php echo $success_rate_row >= 90 ? 'fc_373' : ($success_rate_row >= 70 ? 'fc_fd7e14' : 'fc_197') ?>" style="font-weight:bold;">
                                <?php echo $success_rate_row ?>%
                            </span>
                        </div>
                    </div>
                    <?php else: ?>
                    <span style="color:#999; font-size:11px;">-</span>
                    <?php endif; ?>
                <?php else: ?>
                    <span style="color:#999; font-size:11px;">-</span>
                <?php endif; ?>
            </td>
            <td class="td_center">
                <div style="font-size:11px;">
                    <?php echo date('Y-m-d', strtotime($row['created_at'])) ?><br>
                    <?php echo date('H:i:s', strtotime($row['created_at'])) ?>
                </div>
            </td>
            <td class="td_center">
                <button type="button" onclick="showLogDetail(<?php echo $row['id'] ?>)" class="btn_03 btn">상세</button>
                <button type="button" onclick="deleteLog(<?php echo $row['id'] ?>)" class="btn_02 btn">삭제</button>
            </td>
        </tr>
        <?php
            }
        } else {
        ?>
        <tr>
            <td colspan="6" class="empty_table">로그가 없습니다.</td>
        </tr>
        <?php } ?>
        </tbody>
    </table>
</div>

<?php if ($total_count > 0): ?>
<div class="btn_fixed_top">
    <input type="submit" name="bulk_delete" value="선택삭제" class="btn_02 btn">
</div>
<?php endif; ?>
</form>

<!-- 페이징 -->
<?php if ($total_pages > 1): ?>
<nav class="pg_wrap">
    <div class="pg">
        <?php
        $prev_page = max(1, $page - 1);
        $next_page = min($total_pages, $page + 1);
        $start_page = max(1, $page - 5);
        $end_page = min($total_pages, $page + 5);
        ?>
        
        <?php if ($page > 1): ?>
        <a href="?page=1<?php echo $query_string ?>" class="pg_page pg_start">처음</a>
        <a href="?page=<?php echo $prev_page ?><?php echo $query_string ?>" class="pg_page pg_prev">이전</a>
        <?php endif; ?>
        
        <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
            <?php if ($i == $page): ?>
            <strong class="pg_current"><?php echo $i ?></strong>
            <?php else: ?>
            <a href="?page=<?php echo $i ?><?php echo $query_string ?>" class="pg_page"><?php echo $i ?></a>
            <?php endif; ?>
        <?php endfor; ?>
        
        <?php if ($page < $total_pages): ?>
        <a href="?page=<?php echo $next_page ?><?php echo $query_string ?>" class="pg_page pg_next">다음</a>
        <a href="?page=<?php echo $total_pages ?><?php echo $query_string ?>" class="pg_page pg_end">마지막</a>
        <?php endif; ?>
    </div>
</nav>
<?php endif; ?>

<!-- 로그 상세 모달 -->
<div id="logDetailModal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:1000;">
    <div style="position:absolute; top:50%; left:50%; transform:translate(-50%,-50%); background:white; padding:20px; border-radius:5px; max-width:800px; width:90%; max-height:80%; overflow-y:auto;">
        <h3 style="margin-top:0;">로그 상세 정보</h3>
        <div id="logDetailContent">
            로딩 중...
        </div>
        <div style="text-align:center; margin-top:20px;">
            <button type="button" onclick="closeLogDetailModal()" class="btn_02 btn">닫기</button>
        </div>
    </div>
</div>

<!-- 로그 정리 모달 -->
<div id="cleanupModal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:1000;">
    <div style="position:absolute; top:50%; left:50%; transform:translate(-50%,-50%); background:white; padding:20px; border-radius:5px; max-width:500px; width:90%;">
        <h3 style="margin-top:0;">로그 정리</h3>
        <form method="post" onsubmit="return confirmOldLogDelete()">
            <div style="margin-bottom:15px;">
                <label for="delete_days">삭제할 로그 기간:</label><br>
                <select name="delete_days" id="delete_days" class="frm_input" style="margin-top:5px;">
                    <option value="30">30일 이전</option>
                    <option value="60">60일 이전</option>
                    <option value="90">3개월 이전</option>
                    <option value="180">6개월 이전</option>
                    <option value="365">1년 이전</option>
                </select>
            </div>
            <div style="background:#fff3cd; padding:10px; border-radius:3px; font-size:12px; color:#856404; margin-bottom:15px;">
                <strong>주의:</strong> 삭제된 로그는 복구할 수 없습니다.<br>
                정기적인 로그 정리로 데이터베이스 성능을 유지하세요.
            </div>
            <div style="text-align:center;">
                <input type="submit" name="delete_old_logs" value="삭제 실행" class="btn_02 btn">
                <button type="button" onclick="closeCleanupModal()" class="btn_03 btn">취소</button>
            </div>
        </form>
    </div>
</div>

<script>
function check_all(form) {
    var checkboxes = form.querySelectorAll('input[name="selected_ids[]"]');
    var checkAll = form.querySelector('#chkall');
    
    checkboxes.forEach(function(checkbox) {
        checkbox.checked = checkAll.checked;
    });
}

function deleteLog(id) {
    if (!confirm('이 로그를 삭제하시겠습니까?')) {
        return false;
    }
    
    var form = document.createElement('form');
    form.method = 'post';
    form.innerHTML = '<input type="hidden" name="delete_log" value="1">' +
                     '<input type="hidden" name="log_id" value="' + id + '">';
    document.body.appendChild(form);
    form.submit();
}

function confirmBulkDelete() {
    var checked = document.querySelectorAll('input[name="selected_ids[]"]:checked');
    if (checked.length === 0) {
        alert('삭제할 로그를 선택해주세요.');
        return false;
    }
    
    return confirm('선택된 ' + checked.length + '개의 로그를 삭제하시겠습니까?');
}

function showLogDetail(logId) {
    var modal = document.getElementById('logDetailModal');
    var content = document.getElementById('logDetailContent');
    
    modal.style.display = 'block';
    content.innerHTML = '로딩 중...';
    
    // AJAX로 로그 상세 정보 조회
    fetch('./push_log_detail.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'log_id=' + logId
    })
    .then(response => response.text())
    .then(data => {
        content.innerHTML = data;
    })
    .catch(error => {
        content.innerHTML = '데이터 로딩 중 오류가 발생했습니다.';
        console.error('Error:', error);
    });
}

function closeLogDetailModal() {
    document.getElementById('logDetailModal').style.display = 'none';
}

function showCleanupModal() {
    document.getElementById('cleanupModal').style.display = 'block';
}

function closeCleanupModal() {
    document.getElementById('cleanupModal').style.display = 'none';
}

function confirmOldLogDelete() {
    var days = document.getElementById('delete_days').value;
    return confirm(days + '일 이전의 모든 로그를 삭제하시겠습니까?\\n이 작업은 되돌릴 수 없습니다.');
}

// 모달 배경 클릭시 닫기
document.addEventListener('click', function(e) {
    var logModal = document.getElementById('logDetailModal');
    var cleanupModal = document.getElementById('cleanupModal');
    
    if (e.target === logModal) {
        closeLogDetailModal();
    }
    if (e.target === cleanupModal) {
        closeCleanupModal();
    }
});

// ESC 키로 모달 닫기
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeLogDetailModal();
        closeCleanupModal();
    }
});

// 날짜 필드 기본값 설정 (오늘부터 7일 전까지)
document.addEventListener('DOMContentLoaded', function() {
    var dateFrom = document.getElementById('date_from');
    var dateTo = document.getElementById('date_to');
    
    if (!dateFrom.value && !dateTo.value) {
        var today = new Date();
        var weekAgo = new Date(today.getTime() - 7 * 24 * 60 * 60 * 1000);
        
        // dateTo.value = today.toISOString().split('T')[0];
        // dateFrom.value = weekAgo.toISOString().split('T')[0];
    }
});
</script>

<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');
?>