<?php
$sub_menu = '750200';

include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

auth_check_menu($auth, $sub_menu, "w");

$g5['title'] = '푸시매니저 푸시 발송';
include_once(G5_ADMIN_PATH.'/admin.head.php');

// 설정 확인
$config = get_pushmanager_config();
if (!$config || !$config['api_key']) {
    alert('푸시매니저 설정이 필요합니다.', './api_config.php');
}

// 푸시 발송 처리
if (isset($_POST['send_push']) && $_POST['send_push']) {
    $send_type = $_POST['send_type']; // single, level, gender, selected, all
    $title = clean_xss_tags($_POST['title']);
    $message = clean_xss_tags($_POST['message']);
    
    // 기본 유효성 검사
    if (empty($title)) {
        alert('제목을 입력해주세요.');
    }
    
    if (empty($message)) {
        alert('메시지를 입력해주세요.');
    }
    
    try {
        // 기본 옵션 구성
        $options = array();
        $options['notification_type'] = 'system'; // 관리자 발송은 시스템 타입 (사용자 설정 무시)
        
        // 선택적 옵션들
        if (!empty($_POST['icon'])) {
            $options['icon'] = clean_xss_tags($_POST['icon']);
        }
        if (!empty($_POST['image'])) {
            $options['image'] = clean_xss_tags($_POST['image']);
        }
        if (!empty($_POST['url'])) {
            $options['click_action'] = clean_xss_tags($_POST['url']);
        }
        if (isset($_POST['require_interaction'])) {
            $options['require_interaction'] = true;
        }
        
        // 발송 대상 및 필터 설정 (통합 방식)
        $recipients = array();
        $target_info = '';
        
        switch ($send_type) {
            case 'single':
                $member_id = clean_xss_tags($_POST['single_member_id']);
                if (empty($member_id)) {
                    alert('회원 아이디를 입력해주세요.');
                }
                
                $recipients = array($member_id);
                $target_info = "회원 ID: {$member_id}";
                break;
                
            case 'level':
                $target_level = intval($_POST['target_level']);
                if ($target_level < 1) {
                    alert('올바른 레벨을 선택해주세요.');
                }
                
                $recipients = array(); // 빈 배열 = 전체에서 필터링
                $options['level'] = $target_level;
                $target_info = "레벨 {$target_level}";
                break;
                
            case 'gender':
                $target_gender = $_POST['target_gender'];
                if (!in_array($target_gender, array('M', 'F'))) {
                    alert('올바른 성별을 선택해주세요.');
                }
                
                $recipients = array(); // 빈 배열 = 전체에서 필터링
                $options['gender'] = $target_gender;
                $gender_text = $target_gender == 'M' ? '남성' : '여성';
                $target_info = "성별: {$gender_text}";
                break;
                
            case 'selected':
                $selected_members = $_POST['selected_members'] ?? array();
                if (empty($selected_members) || !is_array($selected_members)) {
                    alert('발송할 회원을 선택해주세요.');
                }
                
                $recipients = $selected_members;
                $target_info = "선택된 회원 " . count($selected_members) . "명";
                break;
                
            case 'all':
                $recipients = array(); // 빈 배열 = 전체 구독자
                $target_info = "전체 구독자";
                break;
                
            default:
                alert('올바른 발송 유형을 선택해주세요.');
        }
        
        // 통합 함수로 발송
        $result = send_push_unified($recipients, $title, $message, $options);
        
        if ($result['success']) {
            $data = $result['data'];
            $total_count = $data['total'] ?? 0;
            $success_count = $data['sent'] ?? 0;
            $failed_count = $data['failed'] ?? 0;
            $success_rate = $data['success_rate'] ?? 0;
            
            $msg = "푸시 발송이 완료되었습니다.\\n\\n";
            $msg .= "대상: {$target_info}\\n";
            $msg .= "총 {$total_count}명 중 {$success_count}명 성공, {$failed_count}명 실패\\n";
            $msg .= "성공률: {$success_rate}%";
            
            // 추가 정보가 있으면 표시
            if (isset($data['processing_time'])) {
                $msg .= "\\n처리 시간: " . $data['processing_time'] . "ms";
            }
            
            alert($msg, './push_send.php');
        } else {
            // 에러 로깅 (기존과 동일)
            $error_log = "푸시 발송 실패 - " . date('Y-m-d H:i:s') . "\n";
            $error_log .= "결과: " . json_encode($result, JSON_UNESCAPED_UNICODE) . "\n";
            $error_log .= "발송 타입: {$send_type}\n";
            $error_log .= "대상: {$target_info}\n";
            $error_log .= "---\n";
            
            // 로그 파일에 기록 (data/log 디렉토리가 있다면)
            if (is_dir(G5_DATA_PATH.'/log') && is_writable(G5_DATA_PATH.'/log')) {
                file_put_contents(G5_DATA_PATH.'/log/push_error.log', $error_log, FILE_APPEND | LOCK_EX);
            }
            
            alert('푸시 발송에 실패했습니다.\\n오류: ' . $result['message']);
        }
        
    } catch (Exception $e) {
        alert('푸시 발송 중 오류가 발생했습니다.\\n오류: ' . $e->getMessage());
    }
}

// 회원 레벨 목록 조회
$level_list = array();
$sql = "SELECT DISTINCT mb_level FROM {$g5['member_table']} WHERE mb_level > 0 ORDER BY mb_level";
$result = sql_query($sql);
while ($row = sql_fetch_array($result)) {
    $level_list[] = $row['mb_level'];
}

// 구독자 통계
$subscription_stats = get_subscription_stats();
?>

<div class="local_desc01 local_desc">
    <p>
        <strong>관리자 발송은 사용자 알림 설정을 무시하고 모든 구독자에게 발송됩니다.</strong>
    </p>
</div>

<form name="fpush" method="post" onsubmit="return validateForm()">
<div class="tbl_frm01 tbl_wrap">
    <table>
        <caption>푸시 발송 설정</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row">발송 방식</th>
                <td>
                    <label><input type="radio" name="send_type" value="single" onclick="toggleSendType(this.value)"> 단일 회원</label>
                    <label><input type="radio" name="send_type" value="level" onclick="toggleSendType(this.value)"> 레벨별</label>
                    <label><input type="radio" name="send_type" value="gender" onclick="toggleSendType(this.value)"> 성별</label>
                    <label><input type="radio" name="send_type" value="selected" onclick="toggleSendType(this.value)"> 선택 회원</label>
                    <label><input type="radio" name="send_type" value="all" onclick="toggleSendType(this.value)"> 전체</label>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 단일 회원 발송 -->
<div id="single_options" class="tbl_frm01 tbl_wrap" style="display:none; margin-top:20px;">
    <table>
        <caption>단일 회원 발송</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row"><label for="single_member_id">회원 아이디</label></th>
                <td>
                    <input type="text" name="single_member_id" id="single_member_id" class="frm_input" size="20" maxlength="20" placeholder="발송할 회원의 아이디">
                    <button type="button" onclick="checkMember()" class="btn_frmline">확인</button>
                    <div id="member_check_result" style="margin-top:5px;"></div>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 레벨별 발송 -->
<div id="level_options" class="tbl_frm01 tbl_wrap" style="display:none; margin-top:20px;">
    <table>
        <caption>레벨별 발송</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row"><label for="target_level">대상 레벨</label></th>
                <td>
                    <select name="target_level" id="target_level" class="frm_input" onchange="getLevelCount()">
                        <option value="">레벨 선택</option>
                        <?php foreach ($level_list as $level): ?>
                        <option value="<?php echo $level ?>"><?php echo $level ?>레벨</option>
                        <?php endforeach; ?>
                    </select>
                    <div id="level_count_result" style="margin-top:5px;"></div>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 성별 발송 -->
<div id="gender_options" class="tbl_frm01 tbl_wrap" style="display:none; margin-top:20px;">
    <table>
        <caption>성별 발송</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row">대상 성별</th>
                <td>
                    <label><input type="radio" name="target_gender" value="M" onchange="getGenderCount()"> 남성</label>
                    <label><input type="radio" name="target_gender" value="F" onchange="getGenderCount()"> 여성</label>
                    <div id="gender_count_result" style="margin-top:5px;"></div>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 선택 회원 발송 -->
<div id="selected_options" class="tbl_frm01 tbl_wrap" style="display:none; margin-top:20px;">
    <table>
        <caption>선택 회원 발송</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row">회원 검색</th>
                <td>
                    <input type="text" id="member_search" class="frm_input" size="20" placeholder="아이디, 이름, 이메일로 검색">
                    <button type="button" onclick="searchMembers()" class="btn_frmline">검색</button>
                </td>
            </tr>
            <tr>
                <th scope="row">선택된 회원</th>
                <td>
                    <div id="member_search_results" style="max-height:200px; overflow-y:auto; border:1px solid #ddd; padding:10px; margin-bottom:10px;">
                        검색 결과가 여기에 표시됩니다.
                    </div>
                    <div id="selected_members_list" style="max-height:150px; overflow-y:auto; border:1px solid #e3f2fd; background:#f8f9fa; padding:10px;">
                        선택된 회원이 없습니다.
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 전체 발송 안내 -->
<div id="all_options" class="tbl_frm01 tbl_wrap" style="display:none; margin-top:20px;">
    <table>
        <caption>전체 발송</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row">발송 대상</th>
                <td>
                    <strong class="fc_197">전체 활성 구독자 <?php echo number_format($subscription_stats['active']) ?>명</strong>에게 발송됩니다.
                    <div class="frm_info">
                        ⚠️ <strong>시스템 알림</strong>으로 발송되어 사용자의 개별 알림 설정과 관계없이 모든 구독자에게 전달됩니다.<br>
                        신중하게 결정해주세요.
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 푸시 메시지 설정 -->
<div class="tbl_frm01 tbl_wrap" style="margin-top:30px;">
    <table>
        <caption>푸시 메시지 설정</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row"><label for="title">제목<strong class="sound_only">필수</strong></label></th>
                <td>
                    <input type="text" name="title" id="title" required class="frm_input required" size="50" maxlength="100" placeholder="푸시 알림 제목">
                    <div class="frm_info">최대 100자</div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="message">메시지<strong class="sound_only">필수</strong></label></th>
                <td>
                    <textarea name="message" id="message" required class="frm_input required" style="width:100%; height:80px;" maxlength="300" placeholder="푸시 알림 내용"></textarea>
                    <div class="frm_info">최대 300자</div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="icon">아이콘 URL</label></th>
                <td>
                    <input type="url" name="icon" id="icon" class="frm_input" size="50" placeholder="https://example.com/icon.png">
                    <div class="frm_info">192x192 이상 권장. 비워두면 기본 아이콘 사용</div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="image">이미지 URL</label></th>
                <td>
                    <input type="url" name="image" id="image" class="frm_input" size="50" placeholder="https://example.com/image.jpg">
                    <div class="frm_info">선택사항 - 큰 이미지 표시</div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="url">클릭 URL</label></th>
                <td>
                    <input type="url" name="url" id="url" class="frm_input" size="50" placeholder="https://example.com/page">
                    <div class="frm_info">알림 클릭 시 이동할 페이지</div>
                </td>
            </tr>
            <tr>
                <th scope="row">추가 옵션</th>
                <td>
                    <label><input type="checkbox" name="require_interaction"> 사용자 상호작용 필요</label>
                    <div class="frm_info">체크하면 사용자가 직접 닫을 때까지 알림이 유지됩니다.</div>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<div class="btn_fixed_top">
    <input type="submit" name="send_push" value="푸시 발송" class="btn_submit btn" onclick="return confirm('정말 푸시 알림을 발송하시겠습니까?');">
    <a href="./api_config.php" class="btn_02 btn">설정 관리</a>
    <a href="./push_logs.php" class="btn_02 btn">발송 로그</a>
</div>
</form>

<script>
var selectedMembers = [];

function toggleSendType(type) {
    // 모든 옵션 숨기기
    document.getElementById('single_options').style.display = 'none';
    document.getElementById('level_options').style.display = 'none';
    document.getElementById('gender_options').style.display = 'none';
    document.getElementById('selected_options').style.display = 'none';
    document.getElementById('all_options').style.display = 'none';
    
    // 선택된 옵션 표시
    if (type) {
        document.getElementById(type + '_options').style.display = 'block';
    }
    
    // 선택된 회원 목록 초기화
    if (type !== 'selected') {
        selectedMembers = [];
        updateSelectedMembersList();
    }
}

function validateForm() {
    var sendType = document.querySelector('input[name="send_type"]:checked');
    if (!sendType) {
        alert('발송 방식을 선택해주세요.');
        return false;
    }
    
    var title = document.getElementById('title').value;
    var message = document.getElementById('message').value;
    
    if (!title.trim()) {
        alert('제목을 입력해주세요.');
        document.getElementById('title').focus();
        return false;
    }
    
    if (!message.trim()) {
        alert('메시지를 입력해주세요.');
        document.getElementById('message').focus();
        return false;
    }
    
    // 발송 유형별 검증
    switch (sendType.value) {
        case 'single':
            var memberId = document.getElementById('single_member_id').value;
            if (!memberId.trim()) {
                alert('회원 아이디를 입력해주세요.');
                return false;
            }
            break;
            
        case 'level':
            var level = document.getElementById('target_level').value;
            if (!level) {
                alert('대상 레벨을 선택해주세요.');
                return false;
            }
            break;
            
        case 'gender':
            var gender = document.querySelector('input[name="target_gender"]:checked');
            if (!gender) {
                alert('대상 성별을 선택해주세요.');
                return false;
            }
            break;
            
        case 'selected':
            if (selectedMembers.length === 0) {
                alert('발송할 회원을 선택해주세요.');
                return false;
            }
            break;
            
        case 'all':
            return confirm('전체 구독자에게 시스템 알림을 발송하시겠습니까?\\n\\n이 알림은 사용자의 개별 설정과 관계없이 모든 구독자에게 전달됩니다.\\n\\n이 작업은 취소할 수 없습니다.');
    }
    
    return true;
}

function checkMember() {
    var memberId = document.getElementById('single_member_id').value;
    if (!memberId.trim()) {
        alert('회원 아이디를 입력해주세요.');
        return;
    }
    
    fetch('./push_ajax.php?action=check_member', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ member_id: memberId })
    })
    .then(response => response.json())
    .then(data => {
        var resultDiv = document.getElementById('member_check_result');
        if (data.success) {
            if (data.data.has_subscription) {
                resultDiv.innerHTML = '<span class="fc_373">✓ ' + data.data.member_name + ' (구독 중)</span>';
            } else {
                resultDiv.innerHTML = '<span class="fc_197">회원은 존재하지만 푸시 구독하지 않음</span>';
            }
        } else {
            resultDiv.innerHTML = '<span class="fc_197">✗ ' + data.message + '</span>';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        document.getElementById('member_check_result').innerHTML = '<span class="fc_197">확인 중 오류 발생</span>';
    });
}

function getLevelCount() {
    var level = document.getElementById('target_level').value;
    if (!level) {
        document.getElementById('level_count_result').innerHTML = '';
        return;
    }
    
    fetch('./push_ajax.php?action=get_level_count', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ level: parseInt(level) })
    })
    .then(response => response.json())
    .then(data => {
        var resultDiv = document.getElementById('level_count_result');
        if (data.success) {
            resultDiv.innerHTML = '<span class="fc_373">대상: ' + data.data.total_members + '명 (구독자: ' + data.data.subscription_count + '명)</span>';
        } else {
            resultDiv.innerHTML = '<span class="fc_197">확인 실패</span>';
        }
    });
}

function getGenderCount() {
    var gender = document.querySelector('input[name="target_gender"]:checked');
    if (!gender) return;
    
    fetch('./push_ajax.php?action=get_gender_count', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ gender: gender.value })
    })
    .then(response => response.json())
    .then(data => {
        var resultDiv = document.getElementById('gender_count_result');
        if (data.success) {
            var genderText = gender.value === 'M' ? '남성' : '여성';
            resultDiv.innerHTML = '<span class="fc_373">' + genderText + ' 대상: ' + data.data.total_members + '명 (구독자: ' + data.data.subscription_count + '명)</span>';
        } else {
            resultDiv.innerHTML = '<span class="fc_197">확인 실패</span>';
        }
    });
}

function searchMembers() {
    var searchText = document.getElementById('member_search').value;
    if (!searchText.trim()) {
        alert('검색어를 입력해주세요.');
        return;
    }
    
    fetch('./push_ajax.php?action=search_members', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ search: searchText })
    })
    .then(response => response.json())
    .then(data => {
        var resultsDiv = document.getElementById('member_search_results');
        if (data.success && data.data.members.length > 0) {
            var html = '';
            data.data.members.forEach(function(member) {
                var isSelected = selectedMembers.includes(member.mb_id);
                var statusText = member.has_subscription ? '구독중' : '미구독';
                var statusClass = member.has_subscription ? 'fc_373' : 'fc_999';
                
                html += '<div style="padding:5px; border-bottom:1px solid #eee;">';
                html += '<label style="cursor:pointer;">';
                html += '<input type="checkbox" value="' + member.mb_id + '" ' + (isSelected ? 'checked' : '') + ' onchange="toggleMemberSelection(this)">';
                html += ' ' + member.mb_id + ' (' + member.mb_name + ') ';
                html += '<span class="' + statusClass + '">[' + statusText + ']</span>';
                html += '</label>';
                html += '</div>';
            });
            resultsDiv.innerHTML = html;
        } else {
            resultsDiv.innerHTML = '검색 결과가 없습니다.';
        }
    });
}

function toggleMemberSelection(checkbox) {
    var memberId = checkbox.value;
    if (checkbox.checked) {
        if (!selectedMembers.includes(memberId)) {
            selectedMembers.push(memberId);
        }
    } else {
        var index = selectedMembers.indexOf(memberId);
        if (index > -1) {
            selectedMembers.splice(index, 1);
        }
    }
    updateSelectedMembersList();
}

function updateSelectedMembersList() {
    var listDiv = document.getElementById('selected_members_list');
    if (selectedMembers.length === 0) {
        listDiv.innerHTML = '선택된 회원이 없습니다.';
        return;
    }
    
    var html = '<strong>선택된 회원 (' + selectedMembers.length + '명):</strong><br>';
    selectedMembers.forEach(function(memberId, index) {
        html += '<span style="display:inline-block; margin:2px; padding:2px 8px; background:#e3f2fd; border-radius:3px;">';
        html += memberId + ' <a href="javascript:removeMember(\'' + memberId + '\')" style="color:#999;">[×]</a>';
        html += '</span>';
        
        // 숨겨진 input 추가
        html += '<input type="hidden" name="selected_members[]" value="' + memberId + '">';
    });
    
    listDiv.innerHTML = html;
}

function removeMember(memberId) {
    var index = selectedMembers.indexOf(memberId);
    if (index > -1) {
        selectedMembers.splice(index, 1);
        updateSelectedMembersList();
        
        // 검색 결과에서도 체크 해제
        var checkbox = document.querySelector('input[value="' + memberId + '"]');
        if (checkbox) {
            checkbox.checked = false;
        }
    }
}
</script>

<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');
?>