<?php
include_once('./_common.php');

// 관리자 권한 확인
if (!$is_admin) {
    alert('관리자만 접근 가능합니다.');
}

$skin = $_GET['skin'] ?? 'default';
$title = $_GET['title'] ?? '앱 설치 안내';
$description = $_GET['description'] ?? '홈 화면에 추가하여 앱처럼 편리하게 이용하세요!';

// XSS 방지
$skin = preg_replace('/[^a-zA-Z0-9_-]/', '', $skin);
$title = htmlspecialchars($title);
$description = htmlspecialchars($description);
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PWA 팝업 테스트 - <?php echo $skin ?> 스킨</title>
    <style>
        body {
            margin: 0;
            padding: 20px;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', system-ui, sans-serif;
            background: #f8f9fa;
            line-height: 1.6;
        }
        
        .test-info {
            background: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .test-content {
            background: white;
            padding: 40px 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            min-height: 400px;
            position: relative;
        }
        
        .test-buttons {
            margin-top: 20px;
            text-align: center;
        }
        
        .btn {
            padding: 8px 16px;
            margin: 0 5px;
            border: 1px solid #ddd;
            border-radius: 4px;
            background: white;
            cursor: pointer;
            font-size: 14px;
        }
        
        .btn-primary {
            background: #007bff;
            color: white;
            border-color: #007bff;
        }
        
        .dummy-content {
            margin-bottom: 20px;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 4px;
            border-left: 4px solid #007bff;
        }
    </style>
</head>
<body>
    <div class="test-info">
        <h2>PWA 팝업 테스트</h2>
        <p><strong>테스트 스킨:</strong> <?php echo $skin ?></p>
        <p><strong>타이틀:</strong> <?php echo $title ?></p>
        <p><strong>설명:</strong> <?php echo $description ?></p>
    </div>
    
    <div class="test-content">
        <div class="dummy-content">
            <h3>샘플 컨텐츠</h3>
            <p>이것은 실제 사이트 컨텐츠를 시뮬레이션하는 더미 텍스트입니다. PWA 팝업이 실제 컨텐츠와 어떻게 상호작용하는지 확인할 수 있습니다.</p>
        </div>
        
        <div class="dummy-content">
            <h4>게시글 제목 예시</h4>
            <p>여기에는 실제 게시글 내용이 들어갈 것입니다. 사용자가 컨텐츠를 읽는 동안 PWA 설치 팝업이 어떻게 표시되는지 확인해보세요.</p>
        </div>
        
        <div class="test-buttons">
            <button class="btn btn-primary" onclick="showTestPopup()">팝업 표시</button>
            <button class="btn" onclick="hideTestPopup()">팝업 숨기기</button>
            <button class="btn" onclick="window.close()">창 닫기</button>
        </div>
    </div>

    <!-- PWA Installer 스크립트 로드 -->
    <script>
        // g5_url 설정 (테스트용)
        var g5_url = '<?php echo G5_URL ?>';
    </script>
    <script src="<?php echo G5_URL ?>/plugin/pushmanager/js/pwa-installer.js"></script>
    
    <script>
        // 테스트용 함수들
        async function showTestPopup() {
            try {
                // 스킨과 함께 팝업 초기화
                await pwaInstaller.initPopup({
                    skin: '<?php echo $skin ?>',
                    title: '<?php echo $title ?>',
                    description: '<?php echo $description ?>',
                    installButtonText: '설치하기',
                    laterButtonText: '나중에',
                    useServerConfig: false,
                    autoShow: false
                });
                
                // 팝업 표시
                await pwaInstaller.showPopup();
                
            } catch (error) {
                alert('팝업 표시 중 오류가 발생했습니다: ' + error.message);
                console.error('PWA Popup Test Error:', error);
            }
        }
        
        function hideTestPopup() {
            if (pwaInstaller) {
                pwaInstaller.hidePopup();
            }
        }
        
        // 페이지 로드 시 자동으로 팝업 표시
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(showTestPopup, 1000);
        });
        
        // 디버그 정보
        console.log('PWA Popup Test Started');
        console.log('Skin:', '<?php echo $skin ?>');
        console.log('Title:', '<?php echo $title ?>');
        console.log('Description:', '<?php echo $description ?>');
    </script>
</body>
</html>