<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once("./_common.php");
?>

<style type="text/css">
.pm-floating-notification {
    position: absolute;
    right: -20px;
    width: 380px;
    background: white;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
    overflow: hidden;
    z-index: 1000000000;
    font-size: 14px;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.pm-floating-notification.top {
    top: 30px;
    transform: translateY(-100%);
}
.pm-floating-notification.top.show {
    opacity: 1;
    visibility: visible;
    transform: translateY(0);
}

.pm-floating-notification.bottom {
    bottom: 30px;
    transform: translateY(100%);
}
.pm-floating-notification.bottom.show {
    opacity: 1;
    visibility: visible;
    transform: translateY(0);
}

.pm-notification-header {
    padding: 16px 20px;
    border-bottom: 1px solid #f0f0f0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.pm-notification-title {
    font-size: 16px;
    font-weight: 600;
}

.pm-header-icons {
    display: flex;
    gap: 12px;
    align-items: center;
}

.pm-header-icon {
    width: 28px;
    height: 28px;
    color: #999;
    cursor: pointer;
    border-radius: 50%;
    padding: 4px;
    transition: all 0.2s;
    display: flex;
    align-items: center;
    justify-content: center;
}

.pm-header-icon:hover {
    background-color: #f0f0f0;
    color: #666;
}

.pm-header-icon a {
    color: #999;
}
.pm-header-icon a:hover {
    color: #666;
}

.pm-header-icon svg {
    width: 20px;
    height: 20px;
    fill: currentColor;
    vertical-align: middle;
}

.pm-notification-filters {
    padding: 12px 20px;
    background: #fafafa;
    border-bottom: 1px solid #f0f0f0;
}

.pm-filter-tabs {
    display: flex;
    gap: 8px;
}

.pm-filter-tab {
    padding: 6px 12px;
    border-radius: 16px;
    font-size: 13px;
    cursor: pointer;
    border: 1px solid #e0e0e0;
    background: white;
    color: #666;
    transition: all 0.2s;
}

.pm-filter-tab.active {
    background: #1976d2;
    color: white;
    border-color: #1976d2;
}

.pm-notification-list {
    max-height: 400px;
    overflow-y: auto;
}


.pm-notification-item {
    padding: 20px 24px;
    margin: 16px 12px;
    background: #fff;
    border-radius: 14px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.10);
    display: flex;
    align-items: flex-start;
    gap: 16px;
    cursor: pointer;
    border: none;
    transition: box-shadow 0.25s, transform 0.25s, background 0.2s;
    position: relative;
}


.pm-notification-item:hover {
    box-shadow: 0 8px 24px rgba(25, 118, 210, 0.18);
    transform: translateY(-2px) scale(1.02);
    background: #f4f8ff;
}


.pm-notification-item:last-child {
    margin-bottom: 24px;
}


.pm-notification-item.unread {
    box-shadow: 0 4px 16px rgba(25, 118, 210, 0.15);
    border-left: 4px solid #1976d2;
    background: #e3f0ff;
}

.pm-notification-icon {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    flex-shrink: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 12px;
    font-weight: bold;
    color: white;
}

.pm-icon-message { background: #4285f4; }
.pm-icon-post { background: #34a853; }
.pm-icon-system { background: #ea4335; }

.pm-notification-icon svg {
    width: 16px;
    height: 16px;
    fill: white;
}

.pm-notification-content {
    flex: 1;
    min-width: 0;
}

.pm-notification-text {
    color: #333;
    line-height: 1.4;
    margin-bottom: 4px;
    word-break: break-word;
}

.pm-notification-time {
    font-size: 12px;
    color: #999;
}

.pm-close-icon {
    color: #999;
    cursor: pointer;
    padding: 4px;
    border-radius: 50%;
    transition: all 0.2s;
    display: flex;
    align-items: center;
    justify-content: center;
    width: 24px;
    height: 24px;
}

.pm-close-icon:hover {
    background-color: #f0f0f0;
    color: #666;
}

.pm-close-icon svg {
    width: 14px;
    height: 14px;
    fill: currentColor;
}

.pm-notification-list::-webkit-scrollbar {
    width: 6px;
}

.pm-notification-list::-webkit-scrollbar-track {
    background: transparent;
}

.pm-notification-list::-webkit-scrollbar-thumb {
    background: #ddd;
    border-radius: 3px;
}

.pm-loading {
    padding: 20px;
    text-align: center;
    color: #999;
}

.pm-empty {
    padding: 40px 20px;
    text-align: center;
    color: #999;
}

.pm-unread-badge {
    background: #ff4444;
    color: white;
    border-radius: 10px;
    padding: 2px 6px;
    font-size: 11px;
    font-weight: bold;
    margin-left: 8px;
}

/* 부모 요소 뱃지 스타일 */
.pm-parent-notification-badge {
    position: absolute;
    top: -4px;
    right: -4px;
    background: #ef4444;
    color: white;
    font-size: 10px;
    border-radius: 50%;
    width: 18px;
    height: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
}
</style>

<div class="pm-floating-notification <?php echo (isset($floating_direction) && $floating_direction === 'bottom') ? 'bottom' : 'top'; ?>">
    <div class="pm-notification-header">
        <span class="pm-notification-title">알림 <span id="pm-unread-badge" class="pm-unread-badge" style="display: none;">0</span></span>
        <div class="pm-header-icons">
            <div class="pm-header-icon pm-mark-all-read" title="모두 읽음 처리" onclick="markAllAsRead()">
                <svg viewBox="0 0 24 24" width="20" height="20">
                  <path d="M9 16.2l-3.5-3.5L4 14.2l5 5 9-9-1.4-1.4z"/>
                </svg>
            </div>
            <div class="pm-header-icon pm-settings-icon" title="알림 설정">
                <a href="<?php echo defined('PUSHMANAGER_URL') ? PUSHMANAGER_URL : G5_ADMIN_URL . '/pushmanager'; ?>/notification_setting.php" target="_blank">
                <svg viewBox="0 0 24 24">
                    <path d="M12,15.5A3.5,3.5 0 0,1 8.5,12A3.5,3.5 0 0,1 12,8.5A3.5,3.5 0 0,1 15.5,12A3.5,3.5 0 0,1 12,15.5M19.43,12.97C19.47,12.65 19.5,12.33 19.5,12C19.5,11.67 19.47,11.34 19.43,11.03L21.54,9.37C21.73,9.22 21.78,8.95 21.66,8.73L19.66,5.27C19.54,5.05 19.27,4.96 19.05,5.05L16.56,6.05C16.04,5.66 15.5,5.32 14.87,5.07L14.5,2.42C14.46,2.18 14.25,2 14,2H10C9.75,2 9.54,2.18 9.5,2.42L9.13,5.07C8.5,5.32 7.96,5.66 7.44,6.05L4.95,5.05C4.73,4.96 4.46,5.05 4.34,5.27L2.34,8.73C2.22,8.95 2.27,9.22 2.46,9.37L4.57,11.03C4.53,11.34 4.5,11.67 4.5,12C4.5,12.33 4.53,12.65 4.57,12.97L2.46,14.63C2.27,14.78 2.22,15.05 2.34,15.27L4.34,18.73C4.46,18.95 4.73,19.03 4.95,18.95L7.44,17.94C7.96,18.34 8.5,18.68 9.13,18.93L9.5,21.58C9.54,21.82 9.75,22 10,22H14C14.25,22 14.46,21.82 14.5,21.58L14.87,18.93C15.5,18.68 16.04,18.34 16.56,17.94L19.05,18.95C19.27,19.03 19.54,18.95 19.66,18.73L21.66,15.27C21.78,15.05 21.73,14.78 21.54,14.63L19.43,12.97Z"/>
                </svg>
                </a>
            </div>
            <div class="pm-header-icon pm-close-notification" onclick="closeFloatingNotification()">
                <svg viewBox="0 0 24 24">
                    <path d="M19 6.41L17.59 5L12 10.59L6.41 5L5 6.41L10.59 12L5 17.59L6.41 19L12 13.41L17.59 19L19 17.59L13.41 12L19 6.41Z"/>
                </svg>
            </div>
        </div>
    </div>

    <div class="pm-notification-filters">
        <div class="pm-filter-tabs">
            <div class="pm-filter-tab active" data-filter="all">전체</div>
            <div class="pm-filter-tab" data-filter="message">쪽지</div>
            <div class="pm-filter-tab" data-filter="comment,newpost">게시글</div>
            <div class="pm-filter-tab" data-filter="system">시스템</div>
        </div>
    </div>

    <div class="pm-notification-list" id="pm-notification-list">
        <div class="pm-loading">알림을 불러오는 중...</div>
    </div>
</div>

<script>
// AJAX 요청 기본 URL
const AJAX_URL = '<?php echo PUSHMANAGER_URL;?>/components/push_history_ajax.php';

let notifications = [];
let currentFilter = 'all';

// 페이지 로드 시 알림 불러오기
document.addEventListener('DOMContentLoaded', function() {
    loadNotifications();
});

// 알림 데이터 로드
function loadNotifications() {
    fetch(`${AJAX_URL}?action=get_notifications&filter=${currentFilter}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                notifications = data.data.notifications;
                updateUnreadBadge(data.data.unread_count);
                renderNotifications();
            } else {
                showError(data.message || '알림을 불러올 수 없습니다.');
            }
        })
        .catch(error => {
            console.error('알림 로드 실패:', error);
            showError('알림을 불러올 수 없습니다.');
        });
}

// 에러 메시지 표시
function showError(message) {
    document.getElementById('pm-notification-list').innerHTML = 
        `<div class="pm-empty">${message}</div>`;
}

// 읽지 않은 알림 개수 업데이트
function updateUnreadBadge(count) {
    const badge = document.getElementById('pm-unread-badge');
    if (count > 0) {
        badge.textContent = count;
        badge.style.display = 'inline-block';
    } else {
        badge.style.display = 'none';
    }

    // 부모 요소에 뱃지 추가/업데이트
    updateParentBadge(count);
}

// 부모 요소에 뱃지 업데이트하는 함수
function updateParentBadge(count) {
    // .pm-floating-notification의 부모 요소 찾기
    const floatingNotification = document.querySelector('.pm-floating-notification');
    if (!floatingNotification) return;
    
    const parentElement = floatingNotification.parentElement;
    if (!parentElement) return;
    
    // 기존 뱃지 제거
    const existingBadge = parentElement.querySelector('.pm-parent-notification-badge');
    if (existingBadge) {
        existingBadge.remove();
    }
    
    // 새 뱃지 추가 (count가 0보다 클 때만)
    if (count > 0) {
        const parentBadge = document.createElement('div');
        parentBadge.className = 'pm-parent-notification-badge';
        parentBadge.textContent = count > 99 ? '99+' : count.toString();
        
        // 부모 요소를 relative로 만들어서 absolute 위치 지정이 가능하도록
        const parentStyle = window.getComputedStyle(parentElement);
        if (parentStyle.position === 'static') {
            parentElement.style.position = 'relative';
        }
        
        parentElement.appendChild(parentBadge);
    }
}

// 알림 목록 렌더링
function renderNotifications() {
    const container = document.getElementById('pm-notification-list');
    
    if (notifications.length === 0) {
        container.innerHTML = '<div class="pm-empty">알림이 없습니다.</div>';
        return;
    }
    

    const html = notifications.map(notification => {
        if (notification.type === 'message') {
            return `
            <div class="pm-notification-item ${!notification.is_read ? 'unread' : ''}"
                 onclick="win_memo('${notification.click_url}');"
                 data-id="${notification.id}">
                <div class="pm-notification-icon ${notification.icon_class}">
                    ${notification.icon_svg}
                </div>
                <div class="pm-notification-content">
                    <div class="pm-notification-text">${escapeHtml(notification.content)}</div>
                    <div class="pm-notification-time">${notification.time_ago} <span style='color:#bbb;margin:0 4px;'>|</span> <span style='font-weight:500;color:#1976d2;'>${notification.sender_name}</span></div>
                </div>
                <div class="pm-close-icon" onclick="removeNotification(event, ${notification.id})" title="삭제">
                    <svg viewBox="0 0 24 24">
                        <path d="M19 6.41L17.59 5L12 10.59L6.41 5L5 6.41L10.59 12L5 17.59L6.41 19L12 13.41L17.59 19L19 17.59L13.41 12L19 6.41Z"/>
                    </svg>
                </div>
            </div>
            `;
        } else {
            return `
            <div class="pm-notification-item ${!notification.is_read ? 'unread' : ''}" 
                 onclick="openNotification(${notification.id}, '${notification.click_url}')"
                 data-id="${notification.id}">
                <div class="pm-notification-icon ${notification.icon_class}">
                    ${notification.icon_svg}
                </div>
                <div class="pm-notification-content">
                    <div class="pm-notification-text">${escapeHtml(notification.content)}</div>
                    <div class="pm-notification-time">${notification.time_ago} <span style='color:#bbb;margin:0 4px;'>|</span> <span style='font-weight:500;color:#1976d2;'>${notification.sender_name}</span></div>
                </div>
                <div class="pm-close-icon" onclick="removeNotification(event, ${notification.id})" title="삭제">
                    <svg viewBox="0 0 24 24">
                        <path d="M19 6.41L17.59 5L12 10.59L6.41 5L5 6.41L10.59 12L5 17.59L6.41 19L12 13.41L17.59 19L19 17.59L13.41 12L19 6.41Z"/>
                    </svg>
                </div>
            </div>
            `;
        }
    }).join('');
    
    container.innerHTML = html;
}

// 알림 클릭 처리
function openNotification(notificationId, clickUrl) {
    // 읽음 처리
    markAsRead(notificationId);
    
    // URL 이동
    if (clickUrl && clickUrl !== '#') {
        if (clickUrl.startsWith('http')) {
            window.open(clickUrl, '_self');
        } else {
            window.parent.location.href = clickUrl;
        }
    }
}

// 읽음 처리
function markAsRead(notificationId) {
    fetch(`${AJAX_URL}?action=mark_read&id=${notificationId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // 로컬 데이터 업데이트
                const notification = notifications.find(n => n.id == notificationId);
                if (notification) {
                    notification.is_read = 1;
                }
                renderNotifications();
                updateUnreadBadge(data.unread_count);
            }
        })
        .catch(error => console.error('읽음 처리 실패:', error));
}

// 모든 알림 읽음 처리
function markAllAsRead() {
    fetch(`${AJAX_URL}?action=mark_all_read`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                notifications.forEach(n => n.is_read = 1);
                renderNotifications();
                updateUnreadBadge(0);
            }
        })
        .catch(error => console.error('전체 읽음 처리 실패:', error));
}

// 알림 삭제
function removeNotification(event, notificationId) {
    event.stopPropagation();
    
    fetch(`${AJAX_URL}?action=delete_notification&id=${notificationId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // 로컬에서 제거
                notifications = notifications.filter(n => n.id != notificationId);
                renderNotifications();
                updateUnreadBadge(data.unread_count);
                
                // 애니메이션
                const item = document.querySelector(`[data-id="${notificationId}"]`);
                if (item) {
                    item.style.transition = 'all 0.3s ease';
                    item.style.transform = 'translateX(100%)';
                    item.style.opacity = '0';
                }
            }
        })
        .catch(error => console.error('삭제 실패:', error));
}

// 플로팅 알림 닫기
function closeFloatingNotification() {
    hideFloatingNotification();
    
    // 부모 창에 메시지 전송 (필요한 경우)
    if (window.parent) {
        window.parent.postMessage('closeNotification', '*');
    }
}

// 플로팅 알림 토글 함수
function toggleFloatingNotification() {
    const floatingNotification = document.querySelector('.pm-floating-notification');
    
    if (floatingNotification.classList.contains('show')) {
        hideFloatingNotification();
    } else {
        showFloatingNotification();
    }
}

// 플로팅 알림 보이기
function showFloatingNotification() {
    const floatingNotification = document.querySelector('.pm-floating-notification');
    floatingNotification.classList.add('show');
    // 알림 데이터 새로고침
    loadNotifications();
}

// 플로팅 알림 숨기기
function hideFloatingNotification() {
    const floatingNotification = document.querySelector('.pm-floating-notification');
    floatingNotification.classList.remove('show');
}

// 필터 탭 클릭 이벤트
document.querySelectorAll('.pm-filter-tab').forEach(tab => {
    tab.addEventListener('click', function() {
        document.querySelectorAll('.pm-filter-tab').forEach(t => t.classList.remove('active'));
        this.classList.add('active');
        
        currentFilter = this.getAttribute('data-filter');
        loadNotifications(); // 필터 변경 시 다시 로드
    });
});

// HTML 이스케이프 함수
function escapeHtml(unsafe) {
    return unsafe
         .replace(/&/g, "&amp;")
         .replace(/</g, "&lt;")
         .replace(/>/g, "&gt;")
         .replace(/"/g, "&quot;")
         .replace(/'/g, "&#039;");
}

// 주기적으로 알림 업데이트 (30초마다)
setInterval(loadNotifications, 30000);
</script>