<?php
include_once("./_common.php");
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

header('Content-Type: application/json; charset=utf-8');

// 로그인 체크
if (!$member['mb_id']) {
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

$action = $_GET['action'] ?? $_POST['action'] ?? '';

switch ($action) {
    case 'get_notifications':
        handle_get_notifications();
        break;
        
    case 'mark_read':
        handle_mark_read();
        break;
        
    case 'mark_all_read':
        handle_mark_all_read();
        break;
        
    case 'delete_notification':
        handle_delete_notification();
        break;
        
    case 'get_unread_count':
        handle_get_unread_count();
        break;
        
    default:
        echo json_encode(['success' => false, 'message' => '잘못된 요청입니다.']);
        break;
}

/**
 * 알림 목록 조회
 */
function handle_get_notifications() {
    global $member;
    
    $limit = intval($_GET['limit'] ?? 20);
    $offset = intval($_GET['offset'] ?? 0);
    $filter = $_GET['filter'] ?? 'all';
    
    try {
        $notifications = get_user_push_history($member['mb_id'], $limit, $offset);
        $unread_count = get_unread_push_count($member['mb_id']);
        
        $formatted_notifications = array();
        
        foreach ($notifications as $notification) {
            // 필터 적용
            if ($filter !== 'all') {
                $filter_types = explode(',', $filter);
                if (!in_array($notification['notification_type'], $filter_types)) {
                    continue;
                }
            }
            
            $formatted_notifications[] = array(
                'id' => $notification['id'],
                'type' => $notification['notification_type'],
                'icon_class' => get_notification_icon_class($notification['notification_type']),
                'icon_svg' => get_notification_icon_svg($notification['notification_type']),
                'sender_name' => $notification['sender_name'],
                'content' => $notification['push_content'],
                'time_ago' => time_ago($notification['sent_at']),
                'sent_at' => $notification['sent_at'],
                'is_read' => $notification['is_read'],
                'click_url' => get_notification_click_url($notification),
                'type_name' => get_notification_type_name($notification['notification_type'])
            );
        }
        
        echo json_encode([
            'success' => true,
            'data' => [
                'notifications' => $formatted_notifications,
                'unread_count' => $unread_count,
                'total_count' => count($formatted_notifications),
                'has_more' => count($notifications) >= $limit
            ]
        ]);
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => '알림을 불러올 수 없습니다.']);
    }
}

/**
 * 알림 읽음 처리
 */
function handle_mark_read() {
    global $member;
    
    $history_id = intval($_GET['id'] ?? $_POST['id'] ?? 0);
    
    if (!$history_id) {
        echo json_encode(['success' => false, 'message' => '알림 ID가 필요합니다.']);
        return;
    }
    
    try {
        $result = mark_push_as_read($history_id, $member['mb_id']);
        
        if ($result) {
            $unread_count = get_unread_push_count($member['mb_id']);
            echo json_encode([
                'success' => true, 
                'message' => '읽음 처리되었습니다.',
                'unread_count' => $unread_count
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => '읽음 처리에 실패했습니다.']);
        }
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => '처리 중 오류가 발생했습니다.']);
    }
}

/**
 * 모든 알림 읽음 처리
 */
function handle_mark_all_read() {
    global $member;
    
    try {
        $result = mark_all_push_as_read($member['mb_id']);
        
        if ($result) {
            echo json_encode([
                'success' => true, 
                'message' => '모든 알림이 읽음 처리되었습니다.',
                'unread_count' => 0
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => '읽음 처리에 실패했습니다.']);
        }
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => '처리 중 오류가 발생했습니다.']);
    }
}

/**
 * 알림 삭제
 */
function handle_delete_notification() {
    global $member;
    
    $history_id = intval($_GET['id'] ?? $_POST['id'] ?? 0);
    
    if (!$history_id) {
        echo json_encode(['success' => false, 'message' => '알림 ID가 필요합니다.']);
        return;
    }
    
    try {
        $result = delete_push_history($history_id, $member['mb_id']);
        
        if ($result) {
            $unread_count = get_unread_push_count($member['mb_id']);
            echo json_encode([
                'success' => true, 
                'message' => '알림이 삭제되었습니다.',
                'unread_count' => $unread_count
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => '삭제에 실패했습니다.']);
        }
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => '처리 중 오류가 발생했습니다.']);
    }
}

/**
 * 읽지 않은 알림 개수만 조회
 */
function handle_get_unread_count() {
    global $member;
    
    try {
        $unread_count = get_unread_push_count($member['mb_id']);
        echo json_encode([
            'success' => true,
            'unread_count' => $unread_count
        ]);
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => '조회 중 오류가 발생했습니다.']);
    }
}

/**
 * 알림 타입별 아이콘 클래스 반환
 */
function get_notification_icon_class($type) {
    $classes = array(
        'message' => 'pm-icon-message',
        'comment' => 'pm-icon-post',
        'newpost' => 'pm-icon-post', 
        'system' => 'pm-icon-system',
        'inquiry' => 'pm-icon-message'
    );
    
    return isset($classes[$type]) ? $classes[$type] : 'pm-icon-system';
}

/**
 * 알림 타입별 SVG 아이콘 반환
 */
function get_notification_icon_svg($type) {
    $icons = array(
        'message' => '<svg viewBox="0 0 24 24"><path d="M20 4H4C2.9 4 2 4.9 2 6V18C2 19.1 2.9 20 4 20H20C21.1 20 22 19.1 22 18V6C22 4.9 21.1 4 20 4ZM20 8L12 13L4 8V6L12 11L20 6V8Z"/></svg>',
        'comment' => '<svg viewBox="0 0 24 24"><path d="M9,22A1,1 0 0,1 8,21V18H4A2,2 0 0,1 2,16V4C2,2.89 2.9,2 4,2H20A2,2 0 0,1 22,4V16A2,2 0 0,1 20,18H13.9L10.2,21.71C10,21.9 9.75,22 9.5,22V22H9Z"/></svg>',
        'newpost' => '<svg viewBox="0 0 24 24"><path d="M19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM14 17H7V15H14V17ZM17 13H7V11H17V13ZM17 9H7V7H17V9Z"/></svg>',
        'system' => '<svg viewBox="0 0 24 24"><path d="M12,15.5A3.5,3.5 0 0,1 8.5,12A3.5,3.5 0 0,1 12,8.5A3.5,3.5 0 0,1 15.5,12A3.5,3.5 0 0,1 12,15.5M19.43,12.97C19.47,12.65 19.5,12.33 19.5,12C19.5,11.67 19.47,11.34 19.43,11.03L21.54,9.37C21.73,9.22 21.78,8.95 21.66,8.73L19.66,5.27C19.54,5.05 19.27,4.96 19.05,5.05L16.56,6.05C16.04,5.66 15.5,5.32 14.87,5.07L14.5,2.42C14.46,2.18 14.25,2 14,2H10C9.75,2 9.54,2.18 9.5,2.42L9.13,5.07C8.5,5.32 7.96,5.66 7.44,6.05L4.95,5.05C4.73,4.96 4.46,5.05 4.34,5.27L2.34,8.73C2.22,8.95 2.27,9.22 2.46,9.37L4.57,11.03C4.53,11.34 4.5,11.67 4.5,12C4.5,12.33 4.53,12.65 4.57,12.97L2.46,14.63C2.27,14.78 2.22,15.05 2.34,15.27L4.34,18.73C4.46,18.95 4.73,19.03 4.95,18.95L7.44,17.94C7.96,18.34 8.5,18.68 9.13,18.93L9.5,21.58C9.54,21.82 9.75,22 10,22H14C14.25,22 14.46,21.82 14.5,21.58L14.87,18.93C15.5,18.68 16.04,18.34 16.56,17.94L19.05,18.95C19.27,19.03 19.54,18.95 19.66,18.73L21.66,15.27C21.78,15.05 21.73,14.78 21.54,14.63L19.43,12.97Z"/></svg>',
        'inquiry' => '<svg viewBox="0 0 24 24"><path d="M18,8A6,6 0 0,0 12,2A6,6 0 0,0 6,8H8A4,4 0 0,1 12,4A4,4 0 0,1 16,8V10H18M19,11H5A1,1 0 0,0 4,12V21A1,1 0 0,0 5,22H19A1,1 0 0,0 20,21V12A1,1 0 0,0 19,11Z"/></svg>'
    );
    
    return isset($icons[$type]) ? $icons[$type] : $icons['system'];
}

/**
 * 알림 클릭 시 이동할 URL 생성
 */
function get_notification_click_url($notification) {
    $base_url = get_site_origin();
    
    switch ($notification['notification_type']) {
        case 'message':
            if ($notification['related_id']) {
                return $base_url . "/bbs/memo_view.php?me_id=" . $notification['related_id'] . "&kind=recv";
            }
            return $base_url . "/bbs/memo.php";
            
        case 'comment':
        case 'newpost':
            if ($notification['related_table'] && $notification['related_id']) {
                return $base_url . "/bbs/board.php?bo_table=" . $notification['related_table'] . "&wr_id=" . $notification['related_id'];
            }
            return '#';
            
        case 'inquiry':
            if ($notification['related_id']) {
                return $base_url . "/bbs/qa_view.php?qa_id=" . $notification['related_id'];
            }
            return $base_url . "/bbs/qalist.php";
            
        default:
            return '#';
    }
}

/**
 * 알림 타입별 한글명 반환
 */
function get_notification_type_name($type) {
    $names = array(
        'message' => '쪽지',
        'comment' => '댓글',
        'newpost' => '새글',
        'system' => '시스템',
        'inquiry' => '문의'
    );
    
    return isset($names[$type]) ? $names[$type] : '알림';
}

/**
 * 시간 경과 표시 함수
 */
function time_ago($datetime) {
    $time = time() - strtotime($datetime);
    
    if ($time < 60) {
        return '방금 전';
    } elseif ($time < 3600) {
        return floor($time / 60) . '분 전';
    } elseif ($time < 86400) {
        return floor($time / 3600) . '시간 전';
    } elseif ($time < 2592000) {
        return floor($time / 86400) . '일 전';
    } else {
        return date('n월 j일', strtotime($datetime));
    }
}
?>