<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once("./_common.php");
?>

<style type="text/css">
body.pwa-mobile {
    padding-bottom: 100px;
}
/* 플로팅 탭바 스타일 - 모바일에서만 표시 */
.floating-tabbar {
    display: none;
    position: fixed;
    bottom: 30px;
    left: 20px;
    right: 20px;
    height: 60px;
    background: rgba(0, 0, 0, 0.4);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 30px;
    z-index: 1000;
    padding: 0 10px;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
    transition: all 0.3s ease;
}

.floating-tabbar.hidden {
    transform: translateY(calc(100% + 30px));
    opacity: 0;
}

/* 밝은 배경용 스타일 */
.floating-tabbar.light-mode {
    background: rgba(255, 255, 255, 0.9);
    border: 1px solid rgba(0, 0, 0, 0.1);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.15);
}

.floating-tabbar-container {
    display: flex;
    align-items: center;
    justify-content: space-between;
    height: 100%;
    width: 100%;
}

/* 히스토리 네비게이션 */
.floating-tabbar-history {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-right: 3px;
}

.floating-tabbar-history-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 50px;
    height: 35px;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.floating-tabbar-history-btn:disabled {
    opacity: 0.3;
    cursor: not-allowed;
}

.floating-tabbar-history-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.floating-tabbar.light-mode .floating-tabbar-history-btn::before {
    background: rgba(0, 0, 0, 0.1);
}

.floating-tabbar-history-btn:not(:disabled):active::before {
    opacity: 1;
}

.floating-tabbar-history-btn:not(:disabled):active {
    transform: scale(0.9);
}

.floating-tabbar-history-icon {
    width: 24px;
    height: 24px;
    stroke: rgba(255, 255, 255, 0.9);
    transition: all 0.3s ease;
}

.floating-tabbar.light-mode .floating-tabbar-history-icon {
    stroke: rgba(0, 0, 0, 0.8);
}

.floating-tabbar-menu {
    display: flex;
    align-items: center;
    flex: 1;
}
.floating-tabbar-menu > div {
    flex: 1;
}

.floating-tabbar-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 4px;
    cursor: pointer;
    transition: all 0.3s ease;
    padding: 8px 12px;
    border-radius: 12px;
    user-select: none;
    position: relative;
    overflow: hidden;
    flex: 1;
    text-decoration: none;
}

.floating-tabbar-item::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 12px;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.floating-tabbar.light-mode .floating-tabbar-item::before {
    background: rgba(0, 0, 0, 0.1);
}

.floating-tabbar-item:active::before {
    opacity: 1;
}

.floating-tabbar-icon {
    width: 20px;
    height: 20px;
    stroke: rgba(255, 255, 255, 0.9);
    transition: all 0.3s ease;
}

.floating-tabbar.light-mode .floating-tabbar-icon {
    stroke: rgba(0, 0, 0, 0.8);
}

.floating-tabbar-item:active .floating-tabbar-icon {
    transform: scale(0.9);
}

.floating-tabbar-label {
    font-size: 10px;
    color: rgba(255, 255, 255, 0.8);
    font-weight: 500;
    transition: color 0.3s ease;
}

.floating-tabbar.light-mode .floating-tabbar-label {
    color: rgba(0, 0, 0, 0.7);
}

.floating-tabbar-refresh {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 44px;
    height: 44px;
    background: rgba(255, 255, 255, 0.3);
    border: 1px solid rgba(255, 255, 255, 0.4);
    border-radius: 50%;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.floating-tabbar.light-mode .floating-tabbar-refresh {
    background: rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(0, 0, 0, 0.2);
}

.floating-tabbar-refresh::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.floating-tabbar.light-mode .floating-tabbar-refresh::before {
    background: rgba(0, 0, 0, 0.1);
}

.floating-tabbar-refresh:active::before {
    opacity: 1;
}

.floating-tabbar-refresh:active {
    transform: scale(0.95);
}

.floating-tabbar-refresh-icon {
    width: 20px;
    height: 20px;
    stroke: #fff;
    stroke-width: 2;
    transition: transform 0.6s ease;
}

.floating-tabbar.light-mode .floating-tabbar-refresh-icon {
    stroke: #000;
}

.floating-tabbar-refresh.spinning .floating-tabbar-refresh-icon {
    transform: rotate(360deg);
}

/* PWA 모바일에서만 표시 */
.pwa-mobile .floating-tabbar {
        display: block;
    }

/* 매우 작은 화면에서 간격 조정 */
@media (max-width: 400px) {
    .floating-tabbar {
        left: 8px;
        right: 8px;
        bottom: 8px;
        padding: 0 8px;
    }
    
    .floating-tabbar-item {
        padding: 6px 6px;
    }
    
    .floating-tabbar-refresh {
        width: 40px;
        height: 40px;
    }
    
    .floating-tabbar-history {
        margin-right: 4px;
    }
    
    .floating-tabbar-history-btn {
        width: 24px;
        height: 24px;
    }
    
    .floating-tabbar-history-icon {
        width: 12px;
        height: 12px;
    }
}

/* 안전 영역 대응 (iPhone X 이후) */
@supports (bottom: env(safe-area-inset-bottom)) {
    .floating-tabbar {
        bottom: max(20px, env(safe-area-inset-bottom));
        left: max(20px, env(safe-area-inset-left));
        right: max(20px, env(safe-area-inset-right));
    }
}
</style>

<!-- 모바일 플로팅 탭바 -->
<div class="floating-tabbar">
    <div class="floating-tabbar-container">
        <!-- 히스토리 네비게이션 -->
        <div class="floating-tabbar-history">
            <button class="floating-tabbar-history-btn" id="historyBack" onclick="goBack()" disabled>
                <svg class="floating-tabbar-history-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <polyline points="15,18 9,12 15,6"/>
                </svg>
            </button>
            <button class="floating-tabbar-history-btn" id="historyForward" onclick="goForward()" disabled>
                <svg class="floating-tabbar-history-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <polyline points="9,18 15,12 9,6"/>
                </svg>
            </button>
        </div>
        
        <div class="floating-tabbar-menu">
        <?php if (isset($is_member) ? $is_member : '') { ?>
            <!-- 회원용 탭바 -->
            <!-- 홈 버튼 -->
            <div><a href="<?php echo G5_URL ?>" class="floating-tabbar-item">
                <svg class="floating-tabbar-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                    <polyline points="9,22 9,12 15,12 15,22"/>
                </svg>
                <span class="floating-tabbar-label">홈</span>
            </a></div>

            <!-- 대시보드 버튼 -->
            <div><a href="<?php echo G5_URL ?>/dashboard" class="floating-tabbar-item">
                <svg class="floating-tabbar-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <rect x="3" y="3" width="7" height="7"/>
                    <rect x="14" y="3" width="7" height="7"/>
                    <rect x="14" y="14" width="7" height="7"/>
                    <rect x="3" y="14" width="7" height="7"/>
                </svg>
                <span class="floating-tabbar-label">대시보드</span>
            </a></div>

            <!-- 쪽지 버튼 -->
            <div><a href="javascript:void(0);" onclick="toggleFloatingNotification()" class="floating-tabbar-item">
                <svg class="floating-tabbar-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                    <polyline points="22,6 12,13 2,6"/>
                </svg>
                <span class="floating-tabbar-label">알림</span>
            </a></div>

            <!-- 마이페이지 버튼 -->
            <div><a href="<?php echo G5_URL ?>/rb/home.php?mb_id=<?php echo $member['mb_id'] ?>" class="floating-tabbar-item">
                <svg class="floating-tabbar-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                    <circle cx="12" cy="7" r="4"/>
                </svg>
                <span class="floating-tabbar-label">마이페이지</span>
            </a></div>

        <?php } else { ?>
            <!-- 비회원용 탭바 -->
            <!-- 홈 버튼 -->
            <div><a href="<?php echo G5_URL ?>" class="floating-tabbar-item">
                <svg class="floating-tabbar-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                    <polyline points="9,22 9,12 15,12 15,22"/>
                </svg>
                <span class="floating-tabbar-label">홈</span>
            </a></div>

            <!-- 게시판 버튼 -->
            <div><a href="<?php echo G5_BBS_URL ?>/board.php?bo_table=free" class="floating-tabbar-item">
                <svg class="floating-tabbar-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 3h18v18H3zM9 9h6m-6 4h6m-6 4h4"/>
                    <line x1="9" y1="9" x2="15" y2="9"/>
                    <line x1="9" y1="13" x2="15" y2="13"/>
                    <line x1="9" y1="17" x2="13" y2="17"/>
                </svg>
                <span class="floating-tabbar-label">게시판</span>
            </a></div>

            <!-- 공지사항 버튼 -->
            <div><a href="<?php echo G5_BBS_URL ?>/board.php?bo_table=notice" class="floating-tabbar-item">
                <svg class="floating-tabbar-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                    <polyline points="14,2 14,8 20,8"/>
                    <line x1="16" y1="13" x2="8" y2="13"/>
                    <line x1="16" y1="17" x2="8" y2="17"/>
                    <polyline points="10,9 9,9 8,9"/>
                </svg>
                <span class="floating-tabbar-label">공지사항</span>
            </a></div>

            <!-- 로그인 버튼 -->
            <div><a href="<?php echo G5_BBS_URL ?>/login.php" class="floating-tabbar-item">
                <svg class="floating-tabbar-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M15 3h4a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2h-4"/>
                    <polyline points="10,17 15,12 10,7"/>
                    <line x1="15" y1="12" x2="3" y2="12"/>
                </svg>
                <span class="floating-tabbar-label">로그인</span>
            </a></div>

        <?php } ?>
        </div>
        
        <button class="floating-tabbar-refresh" onclick="floatingTabbarRefresh()">
            <svg class="floating-tabbar-refresh-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0 3.181 3.183a8.25 8.25 0 0 0 13.803-3.7M4.031 9.865a8.25 8.25 0 0 1 13.803-3.7l3.181 3.182m0-4.991v4.99" />
            </svg>
        </button>
    </div>
</div>

<script>
// 히스토리 네비게이션 함수들
function updateHistoryButtons() {
    const backBtn = document.getElementById('historyBack');
    const forwardBtn = document.getElementById('historyForward');
    
    // 히스토리 상태 확인
    const canGoBack = window.history.length > 1;
    const canGoForward = window.history.state && window.history.state.canGoForward;
    
    // 실제로는 브라우저 히스토리 API의 제한으로 정확한 forward 상태를 알기 어려우므로
    // 세션 스토리지를 활용한 간단한 추적 방식 사용
    const currentIndex = parseInt(sessionStorage.getItem('historyIndex') || '0');
    const maxIndex = parseInt(sessionStorage.getItem('maxHistoryIndex') || '0');
    
    backBtn.disabled = currentIndex <= 0;
    forwardBtn.disabled = currentIndex >= maxIndex;
}

function goBack() {
    if (window.history.length > 1) {
        const currentIndex = parseInt(sessionStorage.getItem('historyIndex') || '0');
        sessionStorage.setItem('historyIndex', Math.max(0, currentIndex - 1).toString());
        window.history.back();
    }
}

function goForward() {
    const currentIndex = parseInt(sessionStorage.getItem('historyIndex') || '0');
    const maxIndex = parseInt(sessionStorage.getItem('maxHistoryIndex') || '0');
    
    if (currentIndex < maxIndex) {
        sessionStorage.setItem('historyIndex', (currentIndex + 1).toString());
        window.history.forward();
    }
}

// 페이지 로드 시 히스토리 인덱스 업데이트
function trackPageNavigation() {
    const currentIndex = parseInt(sessionStorage.getItem('historyIndex') || '0');
    const maxIndex = parseInt(sessionStorage.getItem('maxHistoryIndex') || '0');
    
    // 새 페이지로 이동한 경우
    if (performance.navigation.type === 0) { // TYPE_NAVIGATE
        const newIndex = currentIndex + 1;
        sessionStorage.setItem('historyIndex', newIndex.toString());
        sessionStorage.setItem('maxHistoryIndex', newIndex.toString());
    }
    
    updateHistoryButtons();
}

// 배경 밝기 감지 및 테마 자동 변경
function detectFloatingTabbarBrightness() {
    const tabbar = document.querySelector('.floating-tabbar');
    if (!tabbar) return;

    // 페이지의 배경색을 기반으로 간단하게 판단
    const scrollY = window.scrollY;
    const footer = document.querySelector('footer');
    
    if (footer) {
        const footerRect = footer.getBoundingClientRect();
        const tabbarRect = tabbar.getBoundingClientRect();
        
        // 탭바가 푸터(어두운 배경) 위에 있는지 확인
        if (tabbarRect.bottom > footerRect.top && tabbarRect.top < footerRect.bottom) {
            tabbar.classList.remove('light-mode');
        } else {
            // 일반 페이지 배경(밝은 색상)에 있을 때
            tabbar.classList.add('light-mode');
        }
    } else {
        // 푸터가 없거나 찾을 수 없는 경우 기본적으로 라이트 모드
        tabbar.classList.add('light-mode');
    }
}

// 스크롤 시 배경 감지
let floatingTabbarTicking = false;
function updateFloatingTabbarTheme() {
    if (!floatingTabbarTicking) {
        requestAnimationFrame(() => {
            detectFloatingTabbarBrightness();
            floatingTabbarTicking = false;
        });
        floatingTabbarTicking = true;
    }
}

// 스크롤 방향 감지 및 탭바 숨김/표시
let lastScrollY = window.scrollY;
let scrollDirection = 'down';
let scrollThreshold = 10; // 스크롤 임계값

function handleTabbarScroll() {
    const currentScrollY = window.scrollY;
    const tabbar = document.querySelector('.floating-tabbar');
    
    if (!tabbar) return;
    
    // 스크롤 방향 감지
    if (Math.abs(currentScrollY - lastScrollY) > scrollThreshold) {
        if (currentScrollY > lastScrollY && currentScrollY > 100) {
            // 아래로 스크롤 - 탭바 숨김
            scrollDirection = 'down';
            tabbar.classList.add('hidden');
        } else if (currentScrollY < lastScrollY) {
            // 위로 스크롤 - 탭바 표시
            scrollDirection = 'up';
            tabbar.classList.remove('hidden');
        }
        
        lastScrollY = currentScrollY;
    }
}

// 스크롤 이벤트 최적화
let scrollTicking = false;
function optimizedScrollHandler() {
    if (!scrollTicking) {
        requestAnimationFrame(() => {
            handleTabbarScroll();
            updateFloatingTabbarTheme(); // 기존 테마 업데이트도 함께
            scrollTicking = false;
        });
        scrollTicking = true;
    }
}

// 새로고침 버튼
function floatingTabbarRefresh() {
    const refreshBtn = document.querySelector('.floating-tabbar-refresh');
    
    // 스피닝 애니메이션 시작
    refreshBtn.classList.add('spinning');
    
    // 실제 새로고침 (0.6초 후)
    setTimeout(() => {
        location.reload();
    }, 600);
}

// popstate 이벤트 리스너 (뒤로가기/앞으로가기 감지)
window.addEventListener('popstate', function(event) {
    setTimeout(updateHistoryButtons, 100); // 약간의 지연 후 버튼 상태 업데이트
});

// 터치 피드백 향상
document.addEventListener('DOMContentLoaded', function() {
    // 히스토리 추적 시작
    trackPageNavigation();
    
    // 이벤트 리스너
    window.addEventListener('scroll', optimizedScrollHandler);
    window.addEventListener('resize', updateFloatingTabbarTheme);
    
    // 초기 실행
    detectFloatingTabbarBrightness();
    updateHistoryButtons();
    
    // 터치 피드백
    document.querySelectorAll('.floating-tabbar-item, .floating-tabbar-refresh, .floating-tabbar-history-btn').forEach(element => {
        element.addEventListener('touchstart', function() {
            if (!this.disabled) {
                this.style.transform = 'scale(0.95)';
            }
        });
        
        element.addEventListener('touchend', function() {
            setTimeout(() => {
                this.style.transform = '';
            }, 150);
        });
    });
});
</script>