<?php
include_once('./_common.php');

if(!$is_member) {
    alert("로그인 후 이용해주세요.");
}

$pushmanager_lib = G5_LIB_PATH . '/pushmanager.lib.php';
if (file_exists($pushmanager_lib)) {
    include_once($pushmanager_lib);
} else {
    alert('Push Manager 라이브러리를 찾을 수 없습니다.', G5_URL);
}

$tab = $_GET['tab'] ?? 'basic';
$allowed_tabs = ['basic', 'board'];
if (!in_array($tab, $allowed_tabs)) {
    $tab = 'basic';
}

$g5['title'] = '알림 설정';
include_once(G5_PATH.'/head.php');
?>

<link rel="stylesheet" href="./css/common.css">

<div class="pushmanager-container">
    <div class="page-header">
        <div class="page-header-content">
            <h1 class="page-title">알림 설정</h1>
            <p class="page-subtitle">
                받고 싶은 푸시 알림을 선택하고 기기별로 설정을 관리할 수 있습니다.
            </p>
        </div>
    </div>
    
    <div class="tab-navigation">
        <div class="tab-nav-container">
            <button class="tab-btn <?php echo $tab === 'basic' ? 'active' : ''; ?>" 
                    onclick="location.href='?tab=basic'">
                기본 설정
            </button>
            <button class="tab-btn <?php echo $tab === 'board' ? 'active' : ''; ?>" 
                    onclick="location.href='?tab=board'">
                게시판별 설정
            </button>
        </div>
    </div>
    
    <div class="tab-content">
        <?php
        switch($tab) {
            case 'basic':
                include 'tab_basic_notification_setting.php';
                break;
            case 'board':
                include 'tab_board_notification_setting.php';
                break;
            default:
                include 'tab_basic_notification_setting.php';
        }
        ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    console.log('[알림 설정] 페이지 로드 완료');
    
    if (window.PushManagerCommon && window.PushManagerCommon.initializePushManagerCommon) {
        window.PushManagerCommon.initializePushManagerCommon();
    } else {
        console.error('[알림 설정] PushManagerCommon이 로드되지 않았습니다');
    }
});
</script>

<?php
include_once(G5_PATH.'/tail.php');
?>