<?php
// notification_setting_update.php - 알림 설정 저장 처리
include_once('./_common.php');

// pushmanager.lib.php 포함
$pushmanager_lib = G5_LIB_PATH . '/pushmanager.lib.php';
if (file_exists($pushmanager_lib)) {
    include_once($pushmanager_lib);
} else {
    alert('Push Manager 라이브러리를 찾을 수 없습니다.', './notification_setting.php');
}

// 로그인 확인
if (!$is_member) {
    alert('로그인 후 이용해주세요.', './notification_setting.php');
}

// POST 요청만 허용
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    alert('잘못된 접근입니다.', './notification_setting.php');
}

// save_settings 확인
if (!isset($_POST['save_settings'])) {
    alert('잘못된 요청입니다.', './notification_setting.php');
}

// 탭 파라미터 확인
$tab = $_POST['tab'] ?? 'basic';
$allowed_tabs = ['basic', 'board'];
if (!in_array($tab, $allowed_tabs)) {
    $tab = 'basic';
}

// 리다이렉트 URL 설정
$redirect_url = './notification_setting.php';
if ($tab !== 'basic') {
    $redirect_url .= '?tab=' . $tab;
}

try {
    if ($tab === 'basic') {
        // ========================================
        // 기본 설정 저장 (기존 로직)
        // ========================================
        
        // 필수 함수 존재 확인
        if (!function_exists('save_user_notification_settings')) {
            alert('설정 저장 기능을 사용할 수 없습니다.', $redirect_url);
        }

        // 설정 배열 생성
        $settings = array(
            'message_notification' => isset($_POST['message_notification']) ? 1 : 0,
            'comment_notification' => isset($_POST['comment_notification']) ? 1 : 0,
            'inquiry_notification' => isset($_POST['inquiry_notification']) ? 1 : 0,
            'newpost_notification' => isset($_POST['newpost_notification']) ? 1 : 0
        );

        // 알림 설정 저장
        $save_success = false;
        try {
            $save_success = save_user_notification_settings($settings);
        } catch (Exception $e) {
            alert('설정 저장 중 오류가 발생했습니다: ' . $e->getMessage(), $redirect_url);
        }

        // 저장 실패 시 수동 저장 시도
        if (!$save_success) {
            $member_id = addslashes($member['mb_id']);
            $manual_sql = "
                INSERT INTO pushmanager_user_settings 
                (member_id, message_notification, comment_notification, inquiry_notification, newpost_notification, created_at) 
                VALUES 
                ('{$member_id}', {$settings['message_notification']}, {$settings['comment_notification']}, {$settings['inquiry_notification']}, {$settings['newpost_notification']}, NOW())
                ON DUPLICATE KEY UPDATE 
                message_notification = {$settings['message_notification']},
                comment_notification = {$settings['comment_notification']},
                inquiry_notification = {$settings['inquiry_notification']},
                newpost_notification = {$settings['newpost_notification']},
                updated_at = NOW()
            ";
            
            $manual_result = sql_query($manual_sql, false);
            if ($manual_result) {
                $save_success = true;
            } else {
                alert('설정 저장에 실패했습니다. 다시 시도해주세요.', $redirect_url);
            }
        }

        // 알림 설정 저장 성공 시 기기별 설정 처리
        if ($save_success && function_exists('get_user_devices') && function_exists('toggle_device_notification')) {
            // 모든 기기 목록 가져오기
            $all_devices = get_user_devices();
            
            // 체크된 기기들 활성화
            if (isset($_POST['device_settings']) && is_array($_POST['device_settings'])) {
                foreach ($_POST['device_settings'] as $device_id => $is_active) {
                    toggle_device_notification(intval($device_id), 1);
                }
            }
            
            // 체크되지 않은 기기들 비활성화
            foreach ($all_devices as $device) {
                if (!isset($_POST['device_settings'][$device['id']])) {
                    toggle_device_notification($device['id'], 0);
                }
            }
        }

        if ($save_success) {
            alert('기본 알림 설정이 성공적으로 저장되었습니다.', $redirect_url);
        } else {
            alert('설정 저장에 실패했습니다. 다시 시도해주세요.', $redirect_url);
        }
        
    } elseif ($tab === 'board') {
        // ========================================
        // 게시판별 설정 저장 (신규 로직)
        // ========================================
        
        $member_id = addslashes($member['mb_id']);
        $board_settings = $_POST['board_settings'] ?? array();
        
        // 읽기 권한이 있는 게시판 목록 조회 (보안 체크)
        $accessible_boards = array();
        $sql = "SELECT bo_table, bo_subject, bo_list_level 
                FROM {$g5['board_table']} 
                WHERE bo_use_cert = '' 
                ORDER BY bo_table ASC";
        
        $result = sql_query($sql);
        while ($row = sql_fetch_array($result)) {
            $required_level = intval($row['bo_list_level']);
            $member_level = intval($member['mb_level']);
            
            // 읽기 권한이 있는 게시판만 포함
            if ($member_level >= $required_level) {
                $accessible_boards[$row['bo_table']] = $row;
            }
        }
        
        if (empty($accessible_boards)) {
            alert('접근 가능한 게시판이 없습니다.', $redirect_url);
        }
        
        // 트랜잭션 시작
        sql_query("START TRANSACTION");
        
        try {
            // 해당 회원의 기존 게시판 알림 설정 삭제
            $delete_sql = "DELETE FROM pushmanager_board_notifications WHERE member_id = '{$member_id}'";
            $delete_result = sql_query($delete_sql);
            
            if (!$delete_result) {
                throw new Exception('기존 설정 삭제에 실패했습니다.');
            }
            
            // 새로운 설정 저장
            $saved_count = 0;
            $total_submitted = 0;
            
            foreach ($board_settings as $bo_table => $is_active) {
                $bo_table = trim($bo_table);
                $total_submitted++;
                
                // 권한 체크: 접근 가능한 게시판인지 확인
                if (!isset($accessible_boards[$bo_table])) {
                    throw new Exception("'{$bo_table}' 게시판에 대한 권한이 없습니다.");
                }
                
                // 활성화된 게시판만 저장
                if ($is_active) {
                    $insert_sql = "INSERT INTO pushmanager_board_notifications 
                                  (member_id, bo_table, is_active, created_at) 
                                  VALUES 
                                  ('{$member_id}', '" . addslashes($bo_table) . "', 1, NOW())";
                    
                    $insert_result = sql_query($insert_sql);
                    if ($insert_result) {
                        $saved_count++;
                    } else {
                        throw new Exception("'{$bo_table}' 게시판 설정 저장에 실패했습니다.");
                    }
                }
            }
            
            // 트랜잭션 커밋
            sql_query("COMMIT");
            
            // 로그 기록
            if (function_exists('log_pushmanager_activity')) {
                log_pushmanager_activity(
                    'config', 
                    '게시판별 알림 설정', 
                    "{$member['mb_id']} 회원의 {$saved_count}개 게시판 알림 설정 저장"
                );
            }
            
            // 성공 메시지
            if ($saved_count > 0) {
                alert("{$saved_count}개 게시판의 새글 알림 설정이 저장되었습니다.", $redirect_url);
            } else {
                alert('모든 게시판 알림이 해제되었습니다.', $redirect_url);
            }
            
        } catch (Exception $e) {
            // 트랜잭션 롤백
            sql_query("ROLLBACK");
            
            // 에러 로그 기록
            if (function_exists('log_pushmanager_activity')) {
                log_pushmanager_activity(
                    'error', 
                    '게시판별 알림 설정 오류', 
                    $e->getMessage()
                );
            }
            
            alert('설정 저장 중 오류가 발생했습니다: ' . $e->getMessage(), $redirect_url);
        }
        
    } else {
        // 알 수 없는 탭
        alert('알 수 없는 설정 유형입니다.', './notification_setting.php');
    }
    
} catch (Exception $e) {
    // 전체 오류 처리
    if (function_exists('log_pushmanager_activity')) {
        log_pushmanager_activity(
            'error', 
            '알림 설정 처리 오류', 
            $e->getMessage()
        );
    }
    
    alert('설정 처리 중 오류가 발생했습니다: ' . $e->getMessage(), $redirect_url);
}

// 여기까지 오면 안되지만 안전장치
alert('예상치 못한 오류가 발생했습니다.', './notification_setting.php');
?>