<?php
include_once("./_common.php");

// 로그인한 사용자만 접근 가능
if (!$member['mb_id']) {
    alert('로그인이 필요합니다.', G5_URL);
}

$g5['title'] = '알림';
?>

<style type="text/css">
/* 모바일 전체 페이지용 스타일 */
.pm-mobile-container {
    min-height: 100vh;
    background: #f8f9fa;
    padding: 0;
}

.pm-mobile-header {
    background: white;
    border-bottom: 1px solid #e9ecef;
    padding: 12px 16px;
    position: sticky;
    top: 0;
    z-index: 100;
    display: flex;
    align-items: center;
    gap: 12px;
}

.pm-back-button {
    width: 24px;
    height: 24px;
    color: #666;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 8px;
    margin: -8px;
    border-radius: 50%;
    transition: all 0.2s;
}

.pm-back-button:hover {
    background-color: #f0f0f0;
    color: #333;
}

.pm-back-button svg {
    width: 20px;
    height: 20px;
    fill: currentColor;
}

.pm-mobile-title {
    font-size: 18px;
    font-weight: 600;
    color: #333;
    flex: 1;
}

.pm-mobile-actions {
    display: flex;
    gap: 8px;
    align-items: center;
}

.pm-mobile-action-btn {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    border: none;
    background: #f8f9fa;
    color: #666;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s;
}

.pm-mobile-action-btn:hover {
    background: #e9ecef;
    color: #333;
}

.pm-mobile-action-btn svg {
    width: 18px;
    height: 18px;
    fill: currentColor;
}

.pm-mobile-filters {
    background: white;
    padding: 16px;
    border-bottom: 1px solid #e9ecef;
}

.pm-mobile-filter-tabs {
    display: flex;
    gap: 8px;
    overflow-x: auto;
    scrollbar-width: none;
    -ms-overflow-style: none;
}

.pm-mobile-filter-tabs::-webkit-scrollbar {
    display: none;
}

.pm-mobile-filter-tab {
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 14px;
    cursor: pointer;
    border: 1px solid #e0e0e0;
    background: white;
    color: #666;
    transition: all 0.2s;
    white-space: nowrap;
    flex-shrink: 0;
}

.pm-mobile-filter-tab.active {
    background: #007bff;
    color: white;
    border-color: #007bff;
}

.pm-mobile-notification-list {
    background: white;
    margin: 8px 16px;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.pm-mobile-notification-item {
    padding: 16px;
    border-bottom: 1px solid #f5f5f5;
    display: flex;
    align-items: flex-start;
    gap: 12px;
    cursor: pointer;
    transition: background-color 0.2s;
    position: relative;
}

.pm-mobile-notification-item:hover {
    background-color: #f8f9fa;
}

.pm-mobile-notification-item:last-child {
    border-bottom: none;
}

.pm-mobile-notification-item.unread {
    background-color: #f8f9ff;
    border-left: 3px solid #007bff;
}

.pm-mobile-notification-item.unread::before {
    content: '';
    position: absolute;
    top: 20px;
    right: 16px;
    width: 8px;
    height: 8px;
    background: #007bff;
    border-radius: 50%;
}

.pm-mobile-notification-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    flex-shrink: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
    font-weight: bold;
    color: white;
}

.pm-mobile-icon-message { background: #007bff; }
.pm-mobile-icon-post { background: #28a745; }
.pm-mobile-icon-system { background: #dc3545; }

.pm-mobile-notification-icon svg {
    width: 20px;
    height: 20px;
    fill: white;
}

.pm-mobile-notification-content {
    flex: 1;
    min-width: 0;
}

.pm-mobile-notification-text {
    color: #333;
    line-height: 1.5;
    margin-bottom: 6px;
    word-break: break-word;
    font-size: 15px;
}

.pm-mobile-notification-meta {
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 13px;
    color: #666;
}

.pm-mobile-notification-time {
    color: #999;
}

.pm-mobile-notification-type {
    background: #e9ecef;
    color: #666;
    padding: 2px 6px;
    border-radius: 10px;
    font-size: 11px;
}

.pm-mobile-delete-btn {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    border: none;
    background: #f8f9fa;
    color: #999;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s;
    flex-shrink: 0;
}

.pm-mobile-delete-btn:hover {
    background: #e9ecef;
    color: #666;
}

.pm-mobile-delete-btn svg {
    width: 16px;
    height: 16px;
    fill: currentColor;
}

.pm-mobile-empty {
    text-align: center;
    padding: 60px 20px;
    color: #999;
}

.pm-mobile-empty-icon {
    width: 64px;
    height: 64px;
    margin: 0 auto 16px;
    color: #ddd;
}

.pm-mobile-empty-icon svg {
    width: 100%;
    height: 100%;
    fill: currentColor;
}

.pm-mobile-loading {
    text-align: center;
    padding: 40px 20px;
    color: #999;
}

.pm-unread-badge {
    background: #dc3545;
    color: white;
    border-radius: 10px;
    padding: 2px 6px;
    font-size: 12px;
    font-weight: bold;
    margin-left: 8px;
    min-width: 18px;
    text-align: center;
}

/* 반응형 */
@media (max-width: 768px) {
    .pm-mobile-container {
        margin: 0;
        padding: 0;
    }
    
    .pm-mobile-notification-list {
        margin: 8px;
    }
}

/* 스와이프 삭제 애니메이션 */
.pm-swipe-delete {
    transform: translateX(-100%);
    opacity: 0;
    transition: all 0.3s ease;
}

/* 로딩 스피너 */
.pm-loading-spinner {
    width: 20px;
    height: 20px;
    border: 2px solid #f3f3f3;
    border-top: 2px solid #007bff;
    border-radius: 50%;
    animation: pm-spin 1s linear infinite;
    margin: 0 auto;
}

@keyframes pm-spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
</style>

<div class="pm-mobile-container">
    <!-- 헤더 -->
    <div class="pm-mobile-header">
        <div class="pm-back-button" onclick="goBack()">
            <svg viewBox="0 0 24 24">
                <path d="M15.41,16.58L10.83,12L15.41,7.41L14,6L8,12L14,18L15.41,16.58Z"/>
            </svg>
        </div>
        <div class="pm-mobile-title">
            알림
            <span id="pm-mobile-unread-badge" class="pm-unread-badge" style="display: none;">0</span>
        </div>
        <div class="pm-mobile-actions">
            <button class="pm-mobile-action-btn" title="모두 읽음 처리" onclick="markAllAsRead()">
                <svg viewBox="0 0 24 24">
                    <path d="M18,7L16.6,5.6L10.25,12L7.4,9.15L6,10.55L10.25,14.8L18,7Z"/>
                </svg>
            </button>
            <button class="pm-mobile-action-btn" title="설정" onclick="openSettings()">
                <svg viewBox="0 0 24 24">
                    <path d="M12,15.5A3.5,3.5 0 0,1 8.5,12A3.5,3.5 0 0,1 12,8.5A3.5,3.5 0 0,1 15.5,12A3.5,3.5 0 0,1 12,15.5M19.43,12.97C19.47,12.65 19.5,12.33 19.5,12C19.5,11.67 19.47,11.34 19.43,11.03L21.54,9.37C21.73,9.22 21.78,8.95 21.66,8.73L19.66,5.27C19.54,5.05 19.27,4.96 19.05,5.05L16.56,6.05C16.04,5.66 15.5,5.32 14.87,5.07L14.5,2.42C14.46,2.18 14.25,2 14,2H10C9.75,2 9.54,2.18 9.5,2.42L9.13,5.07C8.5,5.32 7.96,5.66 7.44,6.05L4.95,5.05C4.73,4.96 4.46,5.05 4.34,5.27L2.34,8.73C2.22,8.95 2.27,9.22 2.46,9.37L4.57,11.03C4.53,11.34 4.5,11.67 4.5,12C4.5,12.33 4.53,12.65 4.57,12.97L2.46,14.63C2.27,14.78 2.22,15.05 2.34,15.27L4.34,18.73C4.46,18.95 4.73,19.03 4.95,18.95L7.44,17.94C7.96,18.34 8.5,18.68 9.13,18.93L9.5,21.58C9.54,21.82 9.75,22 10,22H14C14.25,22 14.46,21.82 14.5,21.58L14.87,18.93C15.5,18.68 16.04,18.34 16.56,17.94L19.05,18.95C19.27,19.03 19.54,18.95 19.66,18.73L21.66,15.27C21.78,15.05 21.73,14.78 21.54,14.63L19.43,12.97Z"/>
                </svg>
            </button>
        </div>
    </div>

    <!-- 필터 -->
    <div class="pm-mobile-filters">
        <div class="pm-mobile-filter-tabs">
            <div class="pm-mobile-filter-tab active" data-filter="all">전체</div>
            <div class="pm-mobile-filter-tab" data-filter="message">쪽지</div>
            <div class="pm-mobile-filter-tab" data-filter="comment,newpost">게시글</div>
            <div class="pm-mobile-filter-tab" data-filter="system">시스템</div>
        </div>
    </div>

    <!-- 알림 목록 -->
    <div class="pm-mobile-notification-list" id="pm-mobile-notification-list">
        <div class="pm-mobile-loading">
            <div class="pm-loading-spinner"></div>
            <div style="margin-top: 12px;">알림을 불러오는 중...</div>
        </div>
    </div>
</div>

<script>
// AJAX 요청 기본 URL
const AJAX_URL = '<?php echo PUSHMANAGER_URL;?>/components/push_history_ajax.php';

let notifications = [];
let currentFilter = 'all';
let isLoading = false;

// 페이지 로드 시 알림 불러오기
document.addEventListener('DOMContentLoaded', function() {
    loadNotifications();
    
    // 스와이프 이벤트 리스너 추가
    addSwipeListeners();
});

// 뒤로가기
function goBack() {
    if (window.history.length > 1) {
        window.history.back();
    } else {
        window.location.href = '<?php echo G5_URL; ?>';
    }
}

// 설정 페이지 열기
function openSettings() {
    window.location.href = '<?php echo defined("PUSHMANAGER_URL") ? PUSHMANAGER_URL : G5_ADMIN_URL . "/pushmanager"; ?>/notification_setting.php';
}

// 알림 데이터 로드
function loadNotifications() {
    if (isLoading) return;
    
    isLoading = true;
    showLoading();
    
    fetch(`${AJAX_URL}?action=get_notifications&filter=${currentFilter}&limit=50`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                notifications = data.data.notifications;
                updateUnreadBadge(data.data.unread_count);
                renderNotifications();
            } else {
                showError(data.message || '알림을 불러올 수 없습니다.');
            }
        })
        .catch(error => {
            console.error('알림 로드 실패:', error);
            showError('알림을 불러올 수 없습니다.');
        })
        .finally(() => {
            isLoading = false;
        });
}

// 로딩 표시
function showLoading() {
    document.getElementById('pm-mobile-notification-list').innerHTML = `
        <div class="pm-mobile-loading">
            <div class="pm-loading-spinner"></div>
            <div style="margin-top: 12px;">알림을 불러오는 중...</div>
        </div>
    `;
}

// 에러 메시지 표시
function showError(message) {
    document.getElementById('pm-mobile-notification-list').innerHTML = `
        <div class="pm-mobile-empty">
            <div class="pm-mobile-empty-icon">
                <svg viewBox="0 0 24 24">
                    <path d="M12,2C13.1,2 14,2.9 14,4C14,5.1 13.1,6 12,6C10.9,6 10,5.1 10,4C10,2.9 10.9,2 12,2ZM21,9V7L15,1H5C3.89,1 3,1.89 3,3V21A2,2 0 0,0 5,23H19A2,2 0 0,0 21,21V9M19,9H14V4L19,9Z"/>
                </svg>
            </div>
            <div>${message}</div>
        </div>
    `;
}

// 읽지 않은 알림 개수 업데이트
function updateUnreadBadge(count) {
    const badge = document.getElementById('pm-mobile-unread-badge');
    if (count > 0) {
        badge.textContent = count;
        badge.style.display = 'inline-block';
    } else {
        badge.style.display = 'none';
    }
}

// 알림 목록 렌더링
function renderNotifications() {
    const container = document.getElementById('pm-mobile-notification-list');
    
    if (notifications.length === 0) {
        container.innerHTML = `
            <div class="pm-mobile-empty">
                <div class="pm-mobile-empty-icon">
                    <svg viewBox="0 0 24 24">
                        <path d="M10,21H14A2,2 0 0,1 12,23A2,2 0 0,1 10,21M21,19V20H3V19L5,17V11C5,7.9 7.03,5.17 10,4.29C10,4.19 10,4.1 10,4A2,2 0 0,1 12,2A2,2 0 0,1 14,4C14,4.1 14,4.19 14,4.29C16.97,5.17 19,7.9 19,11V17L21,19M17,11A5,5 0 0,0 12,6A5,5 0 0,0 7,11V18H17V11Z"/>
                    </svg>
                </div>
                <div>알림이 없습니다</div>
            </div>
        `;
        return;
    }
    
    const html = notifications.map(notification => `
        <div class="pm-mobile-notification-item ${!notification.is_read ? 'unread' : ''}" 
             onclick="openNotification(${notification.id}, '${notification.click_url}')"
             data-id="${notification.id}">
            <div class="pm-mobile-notification-icon pm-mobile-icon-${notification.icon_class.replace('pm-icon-', '')}">
                ${notification.icon_svg}
            </div>
            <div class="pm-mobile-notification-content">
                <div class="pm-mobile-notification-text">${escapeHtml(notification.content)}</div>
                <div class="pm-mobile-notification-meta">
                    <span class="pm-mobile-notification-time">${notification.time_ago} • ${notification.sender_name}</span>
                    <span class="pm-mobile-notification-type">${notification.type_name}</span>
                </div>
            </div>
            <button class="pm-mobile-delete-btn" onclick="removeNotification(event, ${notification.id})" title="삭제">
                <svg viewBox="0 0 24 24">
                    <path d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z"/>
                </svg>
            </button>
        </div>
    `).join('');
    
    container.innerHTML = html;
}

// 알림 클릭 처리
function openNotification(notificationId, clickUrl) {
    // 읽음 처리
    markAsRead(notificationId);
    
    // URL 이동
    if (clickUrl && clickUrl !== '#') {
        console.log('URL 이동:', clickUrl);
        
        if (clickUrl.startsWith('http')) {
            window.open(clickUrl, '_blank');
        } else {
            const fullUrl = window.location.origin + clickUrl;
            window.location.href = fullUrl;
        }
    }
}

// 읽음 처리
function markAsRead(notificationId) {
    fetch(`${AJAX_URL}?action=mark_read&id=${notificationId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // 로컬 데이터 업데이트
                const notification = notifications.find(n => n.id == notificationId);
                if (notification) {
                    notification.is_read = 1;
                }
                renderNotifications();
                updateUnreadBadge(data.unread_count);
            }
        })
        .catch(error => console.error('읽음 처리 실패:', error));
}

// 모든 알림 읽음 처리
function markAllAsRead() {
    if (!confirm('모든 알림을 읽음 처리하시겠습니까?')) return;
    
    fetch(`${AJAX_URL}?action=mark_all_read`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                notifications.forEach(n => n.is_read = 1);
                renderNotifications();
                updateUnreadBadge(0);
                
                // 토스트 메시지 표시
                showToast('모든 알림이 읽음 처리되었습니다.');
            }
        })
        .catch(error => console.error('전체 읽음 처리 실패:', error));
}

// 알림 삭제
function removeNotification(event, notificationId) {
    event.stopPropagation();
    
    const item = document.querySelector(`[data-id="${notificationId}"]`);
    
    // 애니메이션 시작
    item.classList.add('pm-swipe-delete');
    
    setTimeout(() => {
        fetch(`${AJAX_URL}?action=delete_notification&id=${notificationId}`)
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // 로컬에서 제거
                    notifications = notifications.filter(n => n.id != notificationId);
                    renderNotifications();
                    updateUnreadBadge(data.unread_count);
                    
                    showToast('알림이 삭제되었습니다.');
                } else {
                    // 실패 시 애니메이션 복구
                    item.classList.remove('pm-swipe-delete');
                }
            })
            .catch(error => {
                console.error('삭제 실패:', error);
                // 실패 시 애니메이션 복구
                item.classList.remove('pm-swipe-delete');
            });
    }, 150);
}

// 필터 탭 클릭 이벤트
document.querySelectorAll('.pm-mobile-filter-tab').forEach(tab => {
    tab.addEventListener('click', function() {
        document.querySelectorAll('.pm-mobile-filter-tab').forEach(t => t.classList.remove('active'));
        this.classList.add('active');
        
        currentFilter = this.getAttribute('data-filter');
        loadNotifications();
    });
});

// HTML 이스케이프 함수
function escapeHtml(unsafe) {
    return unsafe
         .replace(/&/g, "&amp;")
         .replace(/</g, "&lt;")
         .replace(/>/g, "&gt;")
         .replace(/"/g, "&quot;")
         .replace(/'/g, "&#039;");
}

// 토스트 메시지 표시
function showToast(message) {
    const toast = document.createElement('div');
    toast.style.cssText = `
        position: fixed;
        bottom: 20px;
        left: 50%;
        transform: translateX(-50%);
        background: #333;
        color: white;
        padding: 12px 20px;
        border-radius: 24px;
        font-size: 14px;
        z-index: 10000;
        animation: pm-toast-show 0.3s ease;
    `;
    toast.textContent = message;
    
    document.body.appendChild(toast);
    
    setTimeout(() => {
        toast.style.animation = 'pm-toast-hide 0.3s ease';
        setTimeout(() => {
            document.body.removeChild(toast);
        }, 300);
    }, 2000);
}

// 토스트 애니메이션 CSS 추가
const style = document.createElement('style');
style.textContent = `
    @keyframes pm-toast-show {
        from { opacity: 0; transform: translateX(-50%) translateY(20px); }
        to { opacity: 1; transform: translateX(-50%) translateY(0); }
    }
    @keyframes pm-toast-hide {
        from { opacity: 1; transform: translateX(-50%) translateY(0); }
        to { opacity: 0; transform: translateX(-50%) translateY(20px); }
    }
`;
document.head.appendChild(style);

// 스와이프 이벤트 리스너 추가 (향후 확장용)
function addSwipeListeners() {
    // 터치 이벤트로 스와이프 삭제 기능 구현 가능
    // 현재는 버튼 클릭으로 삭제 처리
}

// 주기적으로 알림 업데이트 (1분마다)
setInterval(() => {
    if (!isLoading) {
        loadNotifications();
    }
}, 60000);

// 페이지 visibility 변경 시 알림 업데이트
document.addEventListener('visibilitychange', function() {
    if (!document.hidden && !isLoading) {
        loadNotifications();
    }
});
</script>