<?php 
include_once("_common.php");
include_once(G5_PATH . "/head.sub.php");
?>

<!-- PWA 설치 전용 스타일 -->
<link rel="stylesheet" href="./css/pwa-install.css">

<div class="container">
    <div class="brand">PWA INSTALLER</div>
    
    <h1 class="hero-title">홈화면에 앱 추가하기</h1>
    
    <p class="hero-description">
        더 빠르고 편리한 앱 경험을 위해 홈화면에 설치하세요. 
        브라우저 없이 네이티브 앱처럼 사용할 수 있습니다.
    </p>
    
    <!-- PWA 설치 버튼 -->
    <div id="pwa-install-section" class="install-section hidden">
        <button id="install-button" class="install-button">
            지금 설치하기
        </button>
    </div>

    <!-- iOS 안내 -->
    <div id="ios-install-section" class="install-section hidden">
        <div class="steps-container">
            <div class="steps-title">iOS에서 홈화면에 추가하기</div>
            <div class="steps">
                <div class="step">
                    <div class="step-title">공유 버튼 탭</div>
                    <div class="step-description">화면 하단의 공유 버튼을 탭하세요</div>
                </div>
                <div class="step">
                    <div class="step-title">홈 화면에 추가</div>
                    <div class="step-description">메뉴에서 '홈 화면에 추가'를 선택하세요</div>
                </div>
                <div class="step">
                    <div class="step-title">추가 완료</div>
                    <div class="step-description">우상단 '추가' 버튼을 탭하세요</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Android 안내 -->
    <div id="android-install-section" class="install-section hidden">
        <div class="steps-container">
            <div class="steps-title">Android에서 앱 설치하기</div>
            <div class="steps">
                <div class="step">
                    <div class="step-title">메뉴 열기</div>
                    <div class="step-description">우상단 점 세 개 메뉴를 탭하세요</div>
                </div>
                <div class="step">
                    <div class="step-title">앱 설치</div>
                    <div class="step-description">'앱 설치' 또는 '홈 화면에 추가'를 선택하세요</div>
                </div>
                <div class="step">
                    <div class="step-title">설치 완료</div>
                    <div class="step-description">확인 버튼을 탭하세요</div>
                </div>
            </div>
        </div>
    </div>

    <!-- 기타 브라우저 -->
    <div id="other-browser-section" class="install-section hidden">
        <div class="info-box">
            <p>Chrome, Safari, Edge에서 접속하면 앱 설치가 가능합니다</p>
        </div>
    </div>

    <!-- PWA 설치 장점 -->
    <div class="benefits">
        <h3>앱 설치 시 장점</h3>
        <div class="benefit-list">
            <div class="benefit-item">
                <div class="benefit-title">빠른 실행</div>
                <div class="benefit-desc">홈화면에서 바로 접속</div>
            </div>
            <div class="benefit-item">
                <div class="benefit-title">푸시 알림</div>
                <div class="benefit-desc">중요한 업데이트를 놓치지 않음</div>
            </div>
            <div class="benefit-item">
                <div class="benefit-title">전체화면</div>
                <div class="benefit-desc">브라우저 UI 없이 깔끔한 화면</div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
window.addEventListener('load', function() {
    const main = document.querySelector('main');
    if (main && main.parentNode) {
        // main의 자식 노드를 부모로 올림
        while (main.firstChild) {
            main.parentNode.insertBefore(main.firstChild, main);
        }
        // main 태그 삭제
        main.parentNode.removeChild(main);
    }
});
</script>

<?php 
include_once(G5_PATH . "/tail.sub.php");