<?php
// tab_basic_notification_setting.php (기본 설정 탭)
// 이 파일은 notification_setting.php에서 include 되어 사용됩니다.

// 현재 설정 불러오기
$current_settings = array(
    'message_notification' => 1,
    'comment_notification' => 1,  
    'inquiry_notification' => 1,
    'newpost_notification' => 1
);

$user_devices = array();

if (function_exists('get_user_notification_settings')) {
    $current_settings = get_user_notification_settings();
}

if (function_exists('get_user_devices')) {
    $user_devices = get_user_devices();
}
?>

<!-- 푸시 구독 섹션 -->
<div class="push-subscription-section">
    <p class="push-subscription-description">
        푸시 알림을 받으려면 브라우저에서 알림 권한을 허용하고 구독해야 합니다.
    </p>
    
    <div class="push-status-container">
        <div class="push-status-info">
            <div class="push-status-text" id="push-status">
                <div class="push-status-indicator status-checking" id="push-indicator"></div>
                브라우저 지원 확인 중...
            </div>
            <div class="push-status-detail" id="push-status-detail">
                잠시만 기다려주세요...
            </div>
        </div>
        
        <div class="push-action-buttons">
            <button type="button" class="btn-push" id="push-subscribe-btn" style="display: none;">
                구독하기
            </button>
            <button type="button" class="btn-push secondary" id="push-unsubscribe-btn" style="display: none;">
                구독 해제
            </button>
        </div>
    </div>
</div>

<form method="post" action="./notification_setting_update.php">
    <input type="hidden" name="tab" value="basic">
    
    <!-- 알림 종류 설정 -->
    <div class="section">
        <h2 class="section-title">
            알림 종류
        </h2>
        <div class="setting-grid">
            <div class="setting-item">
                <div class="setting-info">
                    <h4>쪽지 알림</h4>
                    <p>새로운 쪽지가 도착했을 때 알림을 받습니다</p>
                </div>
                <label class="switch">
                    <input type="checkbox" name="message_notification" value="1" 
                           <?php echo $current_settings['message_notification'] ? 'checked' : ''; ?>>
                    <span class="slider"></span>
                </label>
            </div>

            <div class="setting-item">
                <div class="setting-info">
                    <h4>새글 알림</h4>
                    <p>구독한 게시판에 새글이 등록되었을 때 알림을 받습니다</p>
                </div>
                <label class="switch">
                    <input type="checkbox" name="newpost_notification" value="1"
                        <?php echo ($current_settings['newpost_notification'] ?? 1) ? 'checked' : ''; ?>>
                    <span class="slider"></span>
                </label>
            </div>

            <div class="setting-item">
                <div class="setting-info">
                    <h4>댓글 알림</h4>
                    <p>내 게시물에 새로운 댓글이 달렸을 때 알림을 받습니다</p>
                </div>
                <label class="switch">
                    <input type="checkbox" name="comment_notification" value="1"
                           <?php echo $current_settings['comment_notification'] ? 'checked' : ''; ?>>
                    <span class="slider"></span>
                </label>
            </div>

            <div class="setting-item">
                <div class="setting-info">
                    <h4>1:1 문의 답변</h4>
                    <p>1:1 문의에 대한 답변이 등록되었을 때 알림을 받습니다</p>
                </div>
                <label class="switch">
                    <input type="checkbox" name="inquiry_notification" value="1"
                           <?php echo $current_settings['inquiry_notification'] ? 'checked' : ''; ?>>
                    <span class="slider"></span>
                </label>
            </div>
        </div>
    </div>

    <!-- 기기별 설정 -->
    <div class="section">
        <h2 class="section-title">
            등록된 기기 (<?php echo count($user_devices); ?>개)
        </h2>
        
        <?php if (empty($user_devices)): ?>
            <div class="empty-state">
                <span class="emoji">📱</span>
                <h3>등록된 기기가 없습니다</h3>
                <p>위의 "알림 구독하기" 버튼을 클릭하여 푸시 알림을 구독하면 기기가 자동으로 등록됩니다.</p>
            </div>
        <?php else: ?>
            <div class="test-section">
                <h3>테스트 알림</h3>
                <p>등록된 기기에 테스트 푸시를 발송하여 알림이 정상적으로 작동하는지 확인할 수 있습니다.</p>
                <button type="button" class="btn-test-all" onclick="sendTestToAll()">
                    모든 활성 기기에 테스트 발송
                </button>
            </div>
            
            <div class="device-grid">
                <?php foreach ($user_devices as $device): ?>
                    <div class="device-item">
                        <div class="device-header">
                            <div class="device-info">
                                <span class="device-icon"><?php echo $device['device_icon'] ?? '🖥️'; ?></span>
                                <div class="device-details">
                                    <h5><?php echo htmlspecialchars($device['device_name'] ?? 'Unknown Device'); ?></h5>
                                    <small><?php echo htmlspecialchars(substr($device['device_description'] ?? '', 0, 80)); ?></small>
                                    <small class="device-status <?php echo $device['is_active'] ? 'status-active' : 'status-inactive'; ?>">
                                        <?php echo $device['is_active'] ? '● 활성' : '● 비활성'; ?> | 
                                        등록일: <?php echo date('m/d H:i', strtotime($device['created_at'])); ?>
                                    </small>
                                </div>
                            </div>
                            <div class="device-controls">
                                <?php if ($device['is_active']): ?>
                                    <button type="button" class="btn-test" onclick="sendTestPush(<?php echo $device['id']; ?>, this)">
                                        테스트
                                    </button>
                                <?php endif; ?>
                                <label class="switch">
                                    <input type="checkbox" name="device_settings[<?php echo $device['id']; ?>]" value="1"
                                           <?php echo $device['is_active'] ? 'checked' : ''; ?>>
                                    <span class="slider"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- 저장 버튼 -->
    <div class="save-section">
        <!-- 확실한 전송을 위한 hidden input -->
        <input type="hidden" name="save_settings" value="1">
        <button type="submit" class="btn-save" id="saveBtn">
            설정 저장
        </button>
    </div>
</form>