<?php
// tab_board_notification_setting.php (게시판별 알림 설정 탭)
// 이 파일은 notification_setting.php에서 include 되어 사용됩니다.

// 로그인 확인
if (!$is_member) {
    echo '<div class="empty-state">';
    echo '<span class="emoji">🔒</span>';
    echo '<h3>로그인이 필요합니다</h3>';
    echo '<p>게시판별 알림 설정은 회원만 이용할 수 있습니다.</p>';
    echo '</div>';
    return;
}

// 현재 회원의 게시판별 알림 설정 조회
$current_board_settings = array();
if (function_exists('get_board_notification_settings')) {
    $board_settings_result = get_board_notification_settings($member['mb_id']);
    if (is_array($board_settings_result)) {
        foreach ($board_settings_result as $setting) {
            $current_board_settings[$setting['bo_table']] = true;
        }
    }
}

// 읽기 권한이 있는 게시판 목록 조회
$accessible_boards = array();
$sql = "SELECT bo_table, bo_subject, bo_list_level, bo_write_level, bo_admin 
        FROM {$g5['board_table']} 
        WHERE bo_use_cert = '' 
        ORDER BY bo_order ASC, bo_table ASC";

$result = sql_query($sql);
if ($result) {
    while ($row = sql_fetch_array($result)) {
        // 현재 회원의 레벨과 게시판 읽기 권한 비교
        $required_level = intval($row['bo_list_level']);
        $member_level = intval($member['mb_level']);
        
        // 읽기 권한이 있는 게시판만 포함
        if ($member_level >= $required_level) {
            $accessible_boards[] = $row;
        }
    }
}

// 게시판이 없는 경우 처리
if (empty($accessible_boards)) {
    echo '<div class="empty-state">';
    echo '<span class="emoji">📋</span>';
    echo '<h3>접근 가능한 게시판이 없습니다</h3>';
    echo '<p>현재 회원 권한으로 읽기가 가능한 게시판이 없습니다.</p>';
    echo '</div>';
    return;
}

// 현재 설정된 게시판 수 계산
$enabled_count = count($current_board_settings);
$total_count = count($accessible_boards);
?>

<!-- 게시판별 알림 설정 안내 -->
<div class="board-notification-intro">
    <p class="intro-text">선택한 게시판에 새로운 글이 올라올 때 푸시 알림을 받을 수 있습니다.</p>
    <p class="current-status">
        현재 <strong><?php echo number_format($enabled_count); ?>개</strong> 게시판 알림 활성화 
        <span class="total-count">(전체 <?php echo number_format($total_count); ?>개)</span>
    </p>
</div>

<form method="post" action="./notification_setting_update.php">
    <input type="hidden" name="tab" value="board">
    <input type="hidden" name="save_settings" value="1">
    
    <!-- 게시판 목록 섹션 -->
    <div class="section">
        <div class="section-header">
            <h2 class="section-title">게시판 선택</h2>
            <div class="section-controls">
                <button type="button" class="btn-control" onclick="toggleAllBoards(true)">전체 선택</button>
                <button type="button" class="btn-control" onclick="toggleAllBoards(false)">전체 해제</button>
            </div>
        </div>
        
        <div class="board-list">
            <?php foreach ($accessible_boards as $board): 
                $is_enabled = isset($current_board_settings[$board['bo_table']]);
                $board_id = 'board_' . $board['bo_table'];
            ?>
            <div class="board-row <?php echo $is_enabled ? 'board-enabled' : ''; ?>">
                <div class="board-checkbox">
                    <label class="switch">
                        <input type="checkbox" 
                               name="board_settings[<?php echo $board['bo_table']; ?>]" 
                               value="1"
                               id="<?php echo $board_id; ?>"
                               <?php echo $is_enabled ? 'checked' : ''; ?>>
                        <span class="slider"></span>
                    </label>
                </div>
                
                <div class="board-info">
                    <label for="<?php echo $board_id; ?>" class="board-label">
                        <div class="board-name"><?php echo htmlspecialchars($board['bo_subject']); ?></div>
                        <div class="board-meta">
                            <span class="board-table"><?php echo $board['bo_table']; ?></span>
                            <span class="board-levels">읽기 Lv.<?php echo $board['bo_list_level']; ?></span>
                            <?php if ($board['bo_write_level'] > 0): ?>
                            <span class="board-levels">쓰기 Lv.<?php echo $board['bo_write_level']; ?></span>
                            <?php endif; ?>
                            <?php if (!empty($board['bo_admin'])): ?>
                            <span class="board-admin">관리자: <?php echo htmlspecialchars($board['bo_admin']); ?></span>
                            <?php endif; ?>
                        </div>
                    </label>
                </div>
                
                <div class="board-status">
                    <?php if ($is_enabled): ?>
                    <span class="status-badge enabled">알림 ON</span>
                    <?php else: ?>
                    <span class="status-badge disabled">알림 OFF</span>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    
    <!-- 알림 미리보기 섹션 -->
    <div class="section">
        <h2 class="section-title">알림 미리보기</h2>
        <div class="notification-preview">
            <div class="preview-device">📱</div>
            <div class="preview-content">
                <div class="preview-title">자유게시판 게시판에 새글 알림</div>
                <div class="preview-message">홍길동님의 게시글: 안녕하세요, 새로운 글입니다!</div>
                <div class="preview-time">방금 전</div>
            </div>
        </div>
        <p class="preview-note">
            <small>💡 실제 알림은 게시글 제목과 작성자에 따라 내용이 달라집니다.</small>
        </p>
    </div>
    
    <!-- 저장 버튼 -->
    <div class="save-section">
        <button type="submit" class="btn-save" id="saveBoardSettings">
            게시판 알림 설정 저장
        </button>
        <p class="save-note">
            설정 변경 사항은 즉시 적용되며, 선택한 게시판에 새글이 올라올 때부터 알림을 받게 됩니다.
        </p>
    </div>
</form>

<style>
/* 게시판별 알림 설정 전용 스타일 */
.board-notification-intro {
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 6px;
    padding: 16px 20px;
    margin-bottom: 24px;
}

.intro-text {
    margin: 0 0 8px 0;
    font-size: 14px;
    color: #495057;
    line-height: 1.5;
}

.current-status {
    margin: 0;
    font-size: 13px;
    color: #6c757d;
}

.current-status strong {
    color: #495057;
    font-weight: 600;
}

.total-count {
    color: #868e96;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.section-controls {
    display: flex;
    gap: 8px;
}

.btn-control {
    padding: 6px 12px;
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 6px;
    font-size: 12px;
    cursor: pointer;
    transition: all 0.2s;
}

.btn-control:hover {
    background: #e9ecef;
    border-color: #adb5bd;
}

.board-list {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    overflow: hidden;
    margin-bottom: 30px;
}

.board-row {
    display: flex;
    align-items: center;
    padding: 16px 20px;
    border-bottom: 1px solid #f3f4f6;
    transition: all 0.2s ease;
    min-height: 70px;
}

.board-row:last-child {
    border-bottom: none;
}

.board-row:hover {
    background: #f9fafb;
}

.board-row.board-enabled {
    background: #f0fdf4;
    border-left: 4px solid #10b981;
}

.board-row.board-enabled:hover {
    background: #ecfdf5;
}

.board-checkbox {
    flex-shrink: 0;
    margin-right: 16px;
}

.board-info {
    flex: 1;
    min-width: 0;
}

.board-label {
    cursor: pointer;
    display: block;
}

.board-name {
    font-size: 15px;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 4px;
    line-height: 1.4;
}

.board-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 12px;
    align-items: center;
}

.board-table {
    font-family: 'Courier New', monospace;
    font-size: 11px;
    color: #6b7280;
    background: #f3f4f6;
    padding: 2px 6px;
    border-radius: 3px;
}

.board-levels {
    font-size: 11px;
    color: #6b7280;
}

.board-admin {
    font-size: 11px;
    color: #059669;
}

.board-status {
    flex-shrink: 0;
    margin-left: 16px;
}

.status-badge {
    display: inline-block;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: 500;
    text-align: center;
    min-width: 60px;
}

.status-badge.enabled {
    background: #dcfce7;
    color: #166534;
}

.status-badge.disabled {
    background: #f3f4f6;
    color: #6b7280;
}

/* 알림 미리보기 스타일 */
.notification-preview {
    display: flex;
    align-items: flex-start;
    gap: 12px;
    background: #f8fafc;
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 12px;
}

.preview-device {
    font-size: 24px;
    flex-shrink: 0;
}

.preview-content {
    flex: 1;
}

.preview-title {
    font-weight: 600;
    font-size: 14px;
    color: #1e293b;
    margin-bottom: 4px;
}

.preview-message {
    font-size: 13px;
    color: #475569;
    margin-bottom: 4px;
    line-height: 1.4;
}

.preview-time {
    font-size: 11px;
    color: #94a3b8;
}

.preview-note {
    margin: 0;
    text-align: center;
    color: #6b7280;
}

.save-note {
    margin: 12px 0 0 0;
    text-align: center;
    font-size: 13px;
    color: #6b7280;
    line-height: 1.4;
}

/* 반응형 */
@media (max-width: 768px) {
    .section-header {
        flex-direction: column;
        align-items: stretch;
        gap: 12px;
    }
    
    .section-controls {
        justify-content: center;
    }
    
    .board-row {
        flex-direction: column;
        align-items: stretch;
        gap: 12px;
        padding: 16px;
    }
    
    .board-checkbox {
        margin-right: 0;
        align-self: flex-end;
    }
    
    .board-meta {
        gap: 8px;
    }
    
    .board-status {
        margin-left: 0;
        align-self: flex-end;
    }
}

/* 빈 상태 스타일 */
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: #6b7280;
}

.empty-state .emoji {
    font-size: 48px;
    display: block;
    margin-bottom: 16px;
}

.empty-state h3 {
    margin: 0 0 8px 0;
    font-size: 18px;
    color: #374151;
}

.empty-state p {
    margin: 0;
    font-size: 14px;
}
</style>

<script>
// 전체 선택/해제 함수
function toggleAllBoards(checked) {
    const checkboxes = document.querySelectorAll('input[name^="board_settings"]');
    checkboxes.forEach(function(checkbox) {
        checkbox.checked = checked;
        updateBoardItemStyle(checkbox);
    });
    
    updateStatusBadge();
}

// 개별 체크박스 변경 시 스타일 업데이트
document.addEventListener('DOMContentLoaded', function() {
    const checkboxes = document.querySelectorAll('input[name^="board_settings"]');
    
    checkboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', function() {
            updateBoardItemStyle(this);
            updateStatusBadge();
        });
    });
    
    // 폼 제출 시 확인
    document.getElementById('saveBoardSettings').addEventListener('click', function(e) {
        const checkedCount = document.querySelectorAll('input[name^="board_settings"]:checked').length;
        
        if (checkedCount === 0) {
            if (!confirm('모든 게시판 알림을 해제하시겠습니까?')) {
                e.preventDefault();
                return false;
            }
        } else {
            if (!confirm(checkedCount + '개 게시판의 새글 알림을 설정하시겠습니까?')) {
                e.preventDefault();
                return false;
            }
        }
    });
});

// 게시판 아이템 스타일 업데이트
function updateBoardItemStyle(checkbox) {
    const boardRow = checkbox.closest('.board-row');
    const statusBadge = boardRow.querySelector('.status-badge');
    
    if (checkbox.checked) {
        boardRow.classList.add('board-enabled');
        statusBadge.classList.remove('disabled');
        statusBadge.classList.add('enabled');
        statusBadge.textContent = '알림 ON';
    } else {
        boardRow.classList.remove('board-enabled');
        statusBadge.classList.remove('enabled');
        statusBadge.classList.add('disabled');
        statusBadge.textContent = '알림 OFF';
    }
}

// 상태 배지 업데이트
function updateStatusBadge() {
    const checkedCount = document.querySelectorAll('input[name^="board_settings"]:checked').length;
    const totalCount = document.querySelectorAll('input[name^="board_settings"]').length;
    const statusBadge = document.querySelector('.current-status');
    
    if (statusBadge) {
        statusBadge.innerHTML = `현재 <strong>${checkedCount.toLocaleString()}개</strong> 게시판 알림 활성화 <small>(전체 ${totalCount.toLocaleString()}개 중)</small>`;
    }
}
</script>