<?php
// 오늘 날짜 (YYYY-MM-DD 형식)
include_once('./_common.php');
$today = date('Y-m-d');

// 오늘 로그인한 회원 수 조회
$count_sql = "SELECT COUNT(*) as cnt FROM {$g5['member_table']} 
              WHERE DATE(mb_today_login) = '{$today}' 
              AND mb_today_login != '0000-00-00 00:00:00'";
$count_result = sql_fetch($count_sql);
$total_count = $count_result['cnt'];

// 오늘 로그인한 회원 목록 조회 (최근 로그인 순)
$sql = "SELECT mb_id, mb_nick, mb_name, mb_today_login, mb_level, mb_email, mb_homepage 
        FROM {$g5['member_table']} 
        WHERE DATE(mb_today_login) = '{$today}' 
        AND mb_today_login != '0000-00-00 00:00:00'
        ORDER BY mb_today_login DESC";
$result = sql_query($sql);
?>

<style>
.today-login-widget {
    background: #fff;
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 20px;
    margin: 20px 0;
}

.today-login-header {
    text-align: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 2px solid #f5f5f5;
}

.today-login-header h3 {
    margin: 0 0 10px 0;
    color: #333;
    font-size: 1.4em;
}

.member-count {
    background: #f8f9fa;
    padding: 10px 20px;
    border-radius: 20px;
    display: inline-block;
    font-size: 1em;
    color: #495057;
    border: 1px solid #e9ecef;
}

.member-list {
    max-height: 400px;
}

.member-item {
    display: flex;
    align-items: center;
    padding: 12px;
    border-bottom: 1px solid #f0f0f0;
     background: #f8f9fa;
}


.member-item:last-child {
    border-bottom: none;
}

.member-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 1em;
    margin-right: 12px;
}
.member-avatar a{font-size: 0; overflow: hidden;}
.member-avatar .profile_img img{width: 32px !important; height: 32px !important;}

.member-info {
    flex: 1;
}

.member-name {
    font-size: 1em;
    font-weight: bold;
    color: #333;
    margin-bottom: 3px;
}


.login-time {
    text-align: right;
    color: #888;
    font-size: 0.85em;
    min-width: 80px;
}

.login-date {
    font-weight: bold;
    color: #333;
    font-size: 0.9em;
}

.login-hour {
    color: #666;
    font-size: 0.8em;
}

.no-members {
    text-align: center;
    padding: 30px 20px;
    color: #666;
}


</style>

<div class="today-login-widget">
    <div class="today-login-header">
        <h3>📊 오늘 로그인한 회원</h3>
        <div class="member-count">
            총 <strong><?php echo number_format($total_count); ?>명</strong>이 오늘 로그인했습니다
        </div>
    </div>

    <div class="member-list">
        <?php if ($total_count > 0) { ?>
            <?php while ($row = sql_fetch_array($result)) { ?>
                <?php
                // 로그인 시간 포맷팅
                $login_datetime = new DateTime($row['mb_today_login']);
                $login_date = $login_datetime->format('m월 d일');
                $login_time = $login_datetime->format('H:i');
                
                $tmp_name2 = cut_str($row['mb_name'], $config['cf_cut_name']); // 설정된 자리수 만큼만 이름 출력
                $avatar_char = get_sideview($row['mb_id'], $tmp_name2, $row['mb_email'], $row['mb_homepage']);
                ?>
                <div class="member-item">
                    <div class="member-avatar">
                        <?php echo $avatar_char; ?>
                    </div>
                    <div class="member-info">
                        <div class="member-name">
                            <?php echo get_text($row['mb_nick'] ?: $row['mb_name']); ?>
                        </div>
                    </div>
                    <div class="login-time">
                        <div class="login-date"><?php echo $login_date; ?></div>
                        <div class="login-hour"><?php echo $login_time; ?></div>
                    </div>
                </div>
            <?php } ?>
        <?php } else { ?>
            <div class="no-members">
                <p>😔 오늘 로그인한 회원이 없습니다</p>
            </div>
        <?php } ?>
    </div>
</div>