<?php
/*
 *
 *
|--------------------------------------------------------------------------------------------------------------
| 2025-07-26
| 스팸 디펜스 설정 파일
|--------------------------------------------------------------------------------------------------------------
*/

// 기본 설정값
$spamBBS_Tables = "column,notice,maintenance,operating_manual";  // 스팸 검사할 게시판 목록 (예: notice,pds,free)
$spamMemberY_N  = "n";             // 회원가입 허용 여부 (y: 허용, n: 불허)
$spamBBS_Y_N    = "y";             // 게시판 글쓰기 스팸 검사 여부 (y: 검사, n: 미검사)

if (!$is_admin) {
    $TimeDelay       = "+20 seconds"; // 글쓰기 최소 대기 시간
    $TimeSecond      = 360;            // 스팸 글 검사 시간 간격 (초)
    $spamDelivery    = 4;              // 시간 간격 내 허용 글 수
    $spamOverTime    = "+60 minutes"; // 스팸 감지 시 차단 지속 시간
    $spamMemberOut   = "y";            // 스팸 감지 시 회원 차단 여부
    $spamMemberCnt   = 7;              // 차단 기준 글쓰기 횟수

    // 스팸 내용 필터
    $spamContentFilter = ".jpg,.jpeg,.png,.gif,.swf,.pdf,<script,<embed,<object,<link,<param,<iframe,http://,https://,.mp3,.ogg,.wav,.wmv,.avi,.mov,position:";
}

// 공통 변수 초기화
$TimeOut         = time();
$spamBBS_Cate    = G5_BBS_DIR;
$spamNEW_Table   = $g5['board_new_table'];
$spamMEM_Table   = $g5['member_table'];
$mb_id           = $member['mb_id'];

// 관리자 권한 제외 처리
if (!in_array($is_admin, ["super", "group"])) {

    // 게시판 글쓰기 스팸 검사
    if (!$bo_table) $bo_table = "noTable";
    if (strpos($spamBBS_Tables, $bo_table) !== false && $spamBBS_Y_N === "y" && (!$_POST['w'] || $_POST['w'] === "w")) {

        // 직접 주소창으로 write.php 접근 시 차단
        if (!$_SERVER['HTTP_REFERER'] && strpos($_SERVER['PHP_SELF'], "$spamBBS_Cate/write.php") !== false) {
            exit("스팸처리(이페이지가 보인다면 관리자에게 문의 바랍니다.) code: 001");
        }

        // write.php > write_update.php 이동 시간 검사
        if (strpos($_SERVER['PHP_SELF'], "$spamBBS_Cate/write.php") !== false) {
            set_session('spamTimeOut', strtotime($TimeDelay, $TimeOut));
        }
        if (strpos($_SERVER['PHP_SELF'], "$spamBBS_Cate/write_update.php") !== false) {
            if (get_session('spamTimeOut') > time()) {
                exit("스팸처리(이페이지가 보인다면 관리자에게 문의 바랍니다.) code: 002");
            }
        }

        // 동일 ID 연속 글쓰기 시 회원 차단
        if (strpos($_SERVER['PHP_SELF'], "$spamBBS_Cate/write.php") !== false && $mb_id && $spamMemberOut === "y") {
            $sql = "SELECT COUNT(*) AS spamCnt FROM $spamNEW_Table WHERE mb_id = '{$mb_id}' AND bn_datetime BETWEEN '" . date("Y-m-d H:i:s", time() - 3600) . "' AND '" . date("Y-m-d H:i:s") . "'";
            $row = sql_fetch($sql);
            if ($row['spamCnt'] >= $spamMemberCnt) {
                sql_query("UPDATE $spamMEM_Table SET mb_intercept_date = '" . date("Ymd", $TimeOut) . "' WHERE mb_id = '{$mb_id}'");
                exit("스팸처리(이페이지가 보인다면 관리자에게 문의 바랍니다.) code: 003");
            }
        }

        // 게시판 전체 글 수 검사
        if (strpos($_SERVER['PHP_SELF'], "$spamBBS_Cate/write_update.php") !== false) {
            if (get_session('spamTimeOutTable') >= time()) {
                exit("스팸처리(이페이지가 보인다면 관리자에게 문의 바랍니다.) code: 005");
            }

            $sql = "SELECT COUNT(*) AS spamCnt FROM $spamNEW_Table WHERE bo_table = '{$bo_table}' AND bn_datetime BETWEEN '" . date("Y-m-d H:i:s", time() - $TimeSecond) . "' AND '" . date("Y-m-d H:i:s") . "'";
            $row = sql_fetch($sql);
            if ($row['spamCnt'] >= $spamDelivery) {
                set_session('spamTimeOutTable', strtotime($spamOverTime, $TimeOut));
                exit("스팸처리(이페이지가 보인다면 관리자에게 문의 바랍니다.) code: 006");
            }
        }
    }

    // 회원가입 차단
    if ($spamMemberY_N !== "y") {
        $registerPaths = ["register.php", "register_form.php", "register_form_update.php"];
        foreach ($registerPaths as $path) {
            if (strpos($_SERVER['PHP_SELF'], "$spamBBS_Cate/$path") !== false) {
                exit("회원가입 NO  code: 100");
            }
        }
    }
}


add_event('member_login_head', function () {
    /**
     * 20250726
     * https://sir.kr/cm_free/1713878
     * SGI 서울보증 랜섬웨어 복구화키 해독관련
     */
    include_once(G5_CAPTCHA_PATH.'/captcha.lib.php');

    if (!isset($_SESSION['login_fail_count'])) {
        $_SESSION['login_fail_count'] = 0;
    }

},G5_HOOK_DEFAULT_PRIORITY, 0);



add_event('password_is_wrong', function ($mb) {

    /**
     * 20250726
     * https://sir.kr/cm_free/1713878
     * SGI 서울보증 랜섬웨어 복구화키 해독관련
     */
// 로그인 실패 처리 부분에 추가
    $_SESSION['login_fail_count']++;

},G5_HOOK_DEFAULT_PRIORITY, 1);


add_event('login_session_before', function ($mb, $is_social_login) {
    /**
     * 20250726
     * https://sir.kr/cm_free/1713878
     * SGI 서울보증 랜섬웨어 복구화키 해독관련
     */
    include_once(G5_CAPTCHA_PATH.'/captcha.lib.php');

    if(!chk_captcha()) {
        alert('자동등록방지 숫자를 입력하지 않았거나 올바르지 않습니다.');
    }
},G5_HOOK_DEFAULT_PRIORITY, 2);



/*
특정 IP가 국내 IP 인지 확인하는 함수
작성 : 2025-05-15 김성대
한국인터넷정보센터.한국/jsp/statboard/IPAS/ovrse/natal/IPaddrBandCurrent.jsp?nationCode1=KR
에서 2025년5월 현재 전체국가 IP 리스트 중 한국만 뽑아서 문자열로 저장 (대략 2200개 정도됨)
192.* 172.* 공유기 IP도 포함

테스트
$ip = "104.8.230.50";
$ip=$_SERVER['REMOTE_ADDR'];
$ret=is_ip_in_kr($ip);
echo "한국 IP 확인 결과 $ip : $ret<BR>";
*/
if (!is_ip_in_kr($_SERVER['REMOTE_ADDR'])) {
    die("This service is currently limited to users in Korea. (한국에서만 접속 가능합니다.)");
}


/**
 * 특정 IP가 지정된 서브넷 범위 내에 있는지 확인하는 함수
 *
 * @param string $ip 검사할 IP 주소
 * @param string $subnet 서브넷의 시작 IP 주소
 * @param int $cidr 서브넷 마스크 (CIDR 값)
 * @return bool 해당 IP가 서브넷 범위 내에 있으면 true, 아니면 false
 */
function is_ip_in_subnet($ip, $subnet, $cidr) {
    // 시작 IP 주소를 정수로 변환
    $firstIp = ip2long($subnet);
    //echo "$ip,$subnet,$cidr,<BR>";

    // 서브넷 마스크를 기반으로 마지막 IP 주소 계산
    $lastIp = $firstIp + (1 << (32 - $cidr)) - 1;

    // 입력받은 IP 주소를 정수로 변환 후 범위 비교
    $ipLong = ip2long($ip);
    return $ipLong >= $firstIp && $ipLong <= $lastIp;
}

//2025-05-15 현재 국내 IP 현황
// 127. ... 172... 는 공유기 내부 ip
function is_ip_in_kr($ip) {
    $arr_ip=explode("\n","
127.0.0/16
172.30.1/16
14.128.128/17
14.129.0/16
14.138.0/16
14.192.80/20
45.112.88/21
45.112.96/20
45.112.112/21
45.112.152/21
45.112.160/21
45.112.168/22
43.230.0/22
43.224.104/22
43.250.152/22
43.251.28/22
43.251.68/22
43.251.120/22
14.206.0/16
27.0.236/22
27.1.0/16
27.35.0/16
45.113.44/22
45.113.48/22
43.230.76/22
43.230.80/22
43.230.216/22
27.160.0/12
27.176.0/13
27.232.0/13
27.255.64/19
27.255.96/19
36.38.0/15
43.246.152/22
43.246.180/22
27.100.128/17
27.101.0/16
27.102.0/16
45.119.144/22
45.120.64/22
45.120.68/22
103.141.18/23
43.241.104/22
43.241.108/22
43.247.104/22
43.247.192/22
27.111.96/19
27.112.128/17
27.113.0/17
45.115.152/22
1.11.0/16
1.16.0/14
43.254.244/22
39.4.0/14
39.16.0/12
39.112.0/12
42.8.0/13
42.16.0/12
42.32.0/12
43.227.116/22
43.227.120/22
27.115.128/17
27.116.64/18
27.116.128/17
27.117.0/18
27.117.64/18
27.117.128/18
27.117.192/18
27.118.64/18
27.118.128/17
27.119.0/17
27.119.128/17
27.120.0/18
27.122.128/17
43.242.112/22
45.117.12/22
1.96.0/12
1.176.0/15
1.201.0/16
1.208.0/12
1.224.0/11
14.0.32/19
14.4.0/14
14.32.0/11
14.64.0/11
43.255.248/22
43.255.252/22
45.64.140/22
45.64.144/22
45.64.152/22
45.64.172/22
42.82.0/16
43.228.160/22
27.124.128/17
27.125.0/17
27.126.0/18
43.243.216/22
103.3.36/22
59.186.0/15
61.32.0/13
61.40.0/14
101.53.64/19
101.55.0/17
103.7.32/22
103.7.190/23
103.10.216/22
103.11.24/22
103.11.44/22
103.21.200/22
103.25.16/22
45.121.164/22
45.125.232/22
45.126.148/22
49.1.0/16
49.8.0/14
49.16.0/12
49.50.0/22
49.50.16/20
49.50.32/19
49.56.0/13
49.128.192/19
49.142.0/16
49.143.0/17
58.120.0/13
58.138.192/18
58.140.0/14
58.145.0/17
58.146.192/18
58.147.176/21
58.148.0/14
58.180.0/16
58.181.0/18
58.184.0/16
60.196.0/15
61.47.192/18
61.72.0/14
61.76.0/15
61.78.0/15
61.80.0/14
61.84.0/15
101.202.0/16
101.235.0/16
101.250.0/16
103.4.48/22
103.4.148/22
103.4.176/22
103.4.180/22
103.7.244/22
103.8.100/22
103.11.128/22
103.11.248/22
103.22.220/22
49.160.0/12
49.236.64/18
49.238.64/18
49.238.128/17
49.239.128/18
58.224.0/12
59.0.0/11
59.86.192/18
59.151.192/18
60.253.0/18
60.253.64/19
61.4.192/19
61.4.224/19
61.5.160/19
103.5.128/22
103.5.144/22
103.8.230/24
103.9.32/22
103.9.128/22
103.19.124/22
103.23.80/21
103.27.128/22
103.30.108/22
103.30.160/22
103.30.204/22
45.248.72/22
49.246.0/18
49.246.64/18
49.247.0/16
49.254.0/16
58.29.0/16
59.152.128/18
61.14.208/22
61.245.176/20
61.245.224/19
61.247.64/18
61.247.128/19
61.247.192/19
101.1.8/21
101.1.32/19
103.2.76/22
103.2.84/22
103.2.92/22
103.6.72/22
103.6.80/22
103.6.100/22
103.6.172/22
103.10.92/22
103.12.248/22
103.12.252/22
103.13.52/22
103.13.160/22
103.20.116/22
103.24.8/22
103.27.148/22
103.28.60/22
103.28.64/22
103.31.180/22
45.249.64/22
45.249.160/22
58.65.64/18
58.72.0/13
58.84.44/22
58.87.32/19
58.102.0/15
103.62.228/22
103.51.168/21
103.51.176/22
103.51.184/21
103.51.192/21
103.51.200/22
103.51.240/20
103.55.188/22
103.59.156/22
103.206.74/23
103.194.252/22
103.212.244/22
103.212.248/22
103.216.202/23
103.226.72/22
103.226.76/22
103.226.96/22
103.38.24/22
103.49.44/22
103.52.200/22
103.53.114/24
103.60.120/22
103.60.124/22
103.214.24/22
103.214.88/22
103.39.36/22
103.42.184/22
103.43.64/24
103.50.40/22
103.57.60/22
103.215.144/22
103.218.156/22
103.218.160/22
103.43.120/22
103.55.35/24
103.194.108/22
103.212.124/22
103.212.220/22
103.244.108/22
103.247.220/22
103.247.232/22
103.248.104/22
103.251.104/22
114.200.0/13
115.0.0/12
115.16.0/13
115.31.96/19
115.40.0/15
115.68.0/16
115.69.96/19
110.93.24/21
110.165.0/19
110.165.64/18
110.172.64/18
110.232.96/20
112.72.16/20
112.72.32/19
112.72.128/17
112.76.0/15
113.60.0/16
113.61.0/19
113.61.104/22
113.130.64/19
113.130.128/17
113.131.0/16
113.192.64/18
113.197.80/20
113.198.0/16
113.199.0/17
119.192.0/11
119.235.192/20
119.235.240/21
120.29.128/20
116.68.32/19
116.68.232/21
116.84.0/16
116.89.160/19
116.90.216/21
116.93.160/19
116.93.192/18
117.110.0/15
119.17.0/19
119.17.64/18
119.18.64/18
120.50.64/18
120.50.128/19
103.230.88/22
103.230.112/22
103.234.4/22
103.241.116/22
103.249.28/22
103.252.228/22
106.96.0/13
106.240.0/12
111.65.128/18
111.67.208/20
111.67.224/19
112.106.0/15
112.108.0/16
112.109.32/19
112.121.0/19
112.121.192/18
112.133.0/17
112.133.128/18
112.136.128/17
112.137.176/21
112.140.64/18
112.140.144/21
113.216.0/15
114.29.0/17
114.29.128/18
114.30.0/19
114.30.48/20
114.30.128/17
114.31.32/19
114.31.112/20
115.71.0/16
115.84.160/21
115.86.0/16
115.88.0/13
115.126.192/18
115.136.0/13
115.144.0/16
115.145.0/16
116.120.0/13
116.193.80/21
116.193.88/21
116.199.160/21
116.200.0/15
116.212.0/19
117.123.0/16
118.32.0/11
118.91.0/18
118.91.64/18
118.91.144/20
119.30.128/18
119.31.240/21
119.31.248/21
119.42.160/19
120.136.64/18
120.142.0/16
120.143.160/19
120.143.192/18
121.0.64/18
121.0.128/17
121.1.64/18
103.231.128/22
103.235.24/22
103.238.248/22
103.239.112/22
103.243.20/22
103.246.56/22
103.253.56/22
103.253.240/22
110.5.128/17
110.8.0/13
110.34.64/18
110.35.0/18
110.35.96/19
110.35.128/17
110.44.32/19
110.44.192/18
110.45.0/17
110.45.128/17
110.46.0/15
111.91.128/20
111.91.144/20
111.91.160/19
111.92.188/22
111.118.0/17
112.140.152/21
112.140.192/18
112.144.0/12
112.160.0/11
112.196.192/19
112.212.0/16
112.213.0/19
112.214.0/16
112.216.0/13
113.10.0/18
114.52.0/15
114.70.0/15
114.108.0/17
114.108.128/18
114.110.24/21
114.111.32/20
114.111.48/20
114.111.192/18
114.129.64/18
114.129.192/18
115.160.0/17
115.161.0/16
115.165.176/21
115.178.32/20
115.178.64/19
115.187.80/21
116.255.64/18
118.103.192/19
118.107.160/20
118.127.192/18
118.128.0/14
118.139.192/18
119.56.128/17
119.59.0/18
119.63.224/19
119.64.0/13
119.75.64/18
119.75.128/18
119.77.96/19
119.82.32/19
121.50.16/20
121.50.64/18
121.50.224/19
121.53.0/16
121.54.192/18
121.55.64/18
121.55.128/18
103.239.236/22
103.239.240/22
103.240.28/22
103.240.48/22
103.243.200/22
103.246.236/22
110.68.0/14
110.76.64/18
110.76.140/22
110.92.128/17
111.171.0/17
111.218.0/15
111.221.32/21
113.21.0/19
113.29.128/18
113.29.192/20
113.30.0/18
113.52.136/21
113.52.192/19
113.59.128/18
114.141.40/21
114.141.224/19
114.199.0/18
114.199.128/17
116.32.0/12
116.67.0/17
117.16.0/15
117.20.80/20
117.20.192/18
117.52.0/16
117.53.64/19
117.53.96/19
117.53.192/18
117.55.128/18
117.58.128/20
118.176.0/16
118.216.0/13
118.234.0/15
119.148.112/20
119.148.128/19
119.149.0/16
119.161.0/19
103.229.156/22
103.237.20/22
103.241.76/22
152.99.0/16
154.10.0/16
134.75.0/16
143.248.0/16
144.48.40/22
175.192.0/10
180.64.0/13
180.80.0/14
180.92.64/18
180.92.240/20
158.44.0/16
165.213.0/16
165.229.0/16
165.243.0/16
165.244.0/16
165.246.0/16
166.79.0/16
166.103.0/16
166.104.0/16
166.125.0/16
168.78.0/16
168.115.0/16
168.126.0/16
168.131.0/16
168.154.0/16
168.188.0/16
168.219.0/16
168.248.0/15
169.140.0/16
169.208.0/12
180.222.220/22
180.224.0/13
180.233.192/18
180.236.0/14
182.252.0/18
183.78.128/19
183.78.192/18
183.86.192/18
121.127.64/18
121.127.128/18
121.128.0/11
121.160.0/11
121.200.64/18
121.252.0/15
121.254.0/18
121.254.128/17
122.0.8/21
122.0.32/19
122.32.0/12
122.252.64/18
122.252.192/19
122.254.128/17
123.0.0/20
123.32.0/12
124.28.128/18
124.46.0/17
124.46.128/17
124.48.0/12
124.66.176/20
124.66.208/20
124.80.0/16
125.57.0/16
125.60.0/18
125.60.64/18
125.61.0/17
125.62.216/21
125.128.0/11
125.176.0/12
125.208.64/18
125.208.192/19
125.208.224/19
125.209.0/18
125.209.192/18
137.68.0/16
144.48.44/22
144.48.92/22
144.48.100/22
150.107.68/22
150.107.80/22
150.107.84/22
155.230.0/16
156.147.0/16
160.202.160/22
160.202.172/22
160.202.176/22
163.53.156/22
175.28.32/20
175.41.0/20
180.131.0/18
180.132.0/14
180.148.180/22
182.31.0/16
182.50.32/19
183.90.128/19
183.91.192/18
183.96.0/11
192.100.2/24
192.104.15/24
192.132.15/24
122.49.64/18
122.99.128/17
122.100.32/19
122.101.0/16
123.98.160/19
123.98.192/19
123.99.64/18
123.100.160/19
123.108.16/20
123.108.160/19
123.109.0/16
123.111.0/16
124.111.0/16
124.136.0/14
124.146.0/18
124.153.128/17
125.240.0/13
125.248.0/14
125.252.0/18
139.5.224/22
139.150.0/16
146.88.84/22
147.6.0/16
147.43.0/16
150.129.224/22
150.150.0/16
150.183.0/16
150.197.0/16
157.119.32/22
157.119.36/22
163.152.0/16
163.180.0/16
163.213.0/16
163.222.0/16
175.45.160/21
180.150.192/19
180.150.224/21
180.182.0/16
182.161.96/19
182.161.128/17
182.162.0/16
182.163.128/17
192.5.90/24
192.132.247/24
122.128.32/19
122.128.64/20
122.128.128/18
122.128.192/18
122.129.208/21
122.129.240/21
122.129.248/21
123.140.0/14
123.199.0/17
123.200.64/18
123.212.0/14
123.228.0/15
124.194.0/16
124.195.160/19
124.195.224/19
124.197.128/18
124.197.192/19
124.198.0/17
124.199.0/18
124.199.128/17
124.216.0/16
128.134.0/16
129.254.0/16
141.223.0/16
150.242.132/22
150.242.144/22
157.197.0/16
161.122.0/16
163.229.0/16
163.239.0/16
163.255.0/16
164.124.0/16
164.125.0/16
165.132.0/16
165.133.0/16
165.186.0/16
165.194.0/16
175.107.64/18
175.111.16/20
175.112.0/12
175.158.0/19
175.176.128/20
180.189.64/18
180.189.176/20
180.210.192/21
180.211.0/18
182.172.0/16
182.173.80/20
182.173.96/19
182.192.0/13
182.208.0/12
182.224.0/13
182.237.32/19
182.237.64/18
182.237.192/18
121.64.0/14
121.78.0/16
121.88.0/16
121.100.64/18
121.101.192/20
121.101.224/19
121.124.0/15
121.126.0/16
122.152.96/19
122.153.0/16
122.199.64/18
122.199.128/17
122.202.32/19
122.202.128/17
122.203.0/16
123.248.0/16
123.250.0/15
123.254.64/19
123.254.128/17
124.0.0/15
124.2.0/16
124.3.0/16
124.5.0/16
124.28.0/17
124.243.0/17
124.254.128/17
125.7.128/18
125.7.192/18
125.31.128/18
202.150.176/20
202.131.24/21
202.133.16/20
192.245.249/24
192.245.250/24
192.245.251/24
202.20.82/24
202.20.83/24
202.20.86/24
202.20.99/24
202.20.119/24
202.20.128/17
202.21.0/21
202.43.48/21
202.43.56/21
202.68.224/19
202.93.6/23
202.136.112/20
202.136.128/19
202.158.144/20
192.195.39/24
192.195.40/24
192.249.16/21
192.249.24/23
192.249.26/23
192.249.28/22
198.148.192/22
202.6.95/24
202.22.32/19
202.59.216/21
202.86.8/21
202.126.112/21
202.128.100/23
202.163.128/19
202.165.56/22
192.203.138/24
192.203.139/24
192.203.140/22
192.203.144/24
192.203.145/24
192.203.146/24
202.14.90/23
202.14.103/24
202.14.165/24
202.47.143/24
202.73.132/22
202.89.124/22
202.89.248/22
202.3.16/20
202.8.160/19
203.17.226/24
103.126.234/23
202.171.248/22
202.174.88/22
202.179.176/21
175.106.112/20
202.189.128/24
203.207.16/20
203.128.160/19
203.128.192/19
203.128.236/22
203.129.6/23
203.130.64/19
203.130.96/19
203.130.176/20
203.152.160/19
203.153.144/20
203.175.32/19
203.175.188/22
218.101.128/17
210.2.32/19
210.4.88/21
210.57.224/19
210.216.0/16
210.218.128/18
210.218.192/19
210.218.224/19
210.220.64/19
210.220.96/19
210.222.0/15
223.222.0/16
220.149.0/16
221.138.0/15
221.140.0/14
221.144.0/12
221.160.0/13
221.168.0/16
223.253.0/16
203.82.219/24
203.82.220/23
203.82.240/21
203.83.128/19
203.100.160/19
203.132.160/19
203.133.160/19
203.142.160/19
203.142.216/23
203.160.140/22
203.210.16/20
203.210.32/19
203.212.96/19
203.212.160/19
210.16.192/18
210.80.96/20
210.80.112/20
210.87.192/19
210.89.160/19
210.90.0/15
211.32.0/16
211.36.192/19
211.36.224/19
211.40.0/16
211.42.0/17
211.42.128/19
211.42.160/19
211.42.192/19
211.42.224/19
211.44.0/16
211.45.128/18
211.45.192/18
211.50.0/16
211.51.0/16
211.53.0/16
211.54.0/15
211.60.0/16
211.62.0/17
211.62.128/17
211.63.0/19
211.63.32/19
211.63.128/17
211.116.0/18
218.144.0/12
218.209.0/16
218.232.0/15
218.234.0/15
218.236.0/14
220.230.0/16
222.96.0/12
222.112.0/13
222.120.0/15
222.122.0/16
203.84.240/20
203.109.0/19
203.166.208/21
203.169.4/23
210.92.0/18
203.190.4/22
203.190.26/23
211.116.64/18
203.215.192/19
203.216.160/19
203.217.192/18
210.92.64/18
210.92.128/17
210.96.0/17
210.96.128/17
210.97.0/17
210.98.128/18
210.99.0/16
210.100.0/16
210.101.128/18
210.102.0/19
210.102.32/19
210.102.128/17
210.103.0/17
210.103.128/18
210.103.192/19
210.103.224/19
210.104.0/15
210.106.128/18
210.106.192/19
210.106.224/19
210.107.0/17
210.107.128/17
210.108.0/16
210.109.0/16
210.120.0/16
210.124.0/16
210.178.0/15
210.180.0/19
210.180.32/19
210.180.128/18
210.180.192/19
210.180.224/19
210.182.0/16
210.183.0/16
211.117.0/16
211.176.0/14
211.192.0/13
211.200.0/16
211.201.0/16
211.202.0/15
211.204.0/15
211.206.0/16
211.207.0/16
211.208.0/14
211.212.0/14
211.216.0/16
211.217.0/16
211.218.0/15
211.220.0/14
211.224.0/15
211.226.0/15
211.228.0/14
211.234.0/18
211.234.64/19
211.234.96/19
211.252.0/15
211.254.0/17
211.254.128/18
222.231.0/18
222.232.0/13
222.251.128/17
223.26.128/17
203.77.176/24
203.90.32/19
203.123.192/19
203.149.112/20
203.170.96/19
203.171.160/19
203.173.96/19
203.223.96/19
203.223.177/24
203.224.0/16
203.225.0/16
203.233.0/17
203.248.0/17
203.248.128/17
203.252.0/20
203.252.32/19
210.0.32/19
210.192.64/19
210.210.192/18
210.211.0/20
210.211.64/19
218.48.0/15
218.50.0/15
218.52.0/14
219.240.0/15
220.72.0/13
220.80.0/13
220.88.0/14
220.92.0/14
220.103.0/16
220.116.0/14
220.120.0/13
221.132.64/19
221.133.128/18
223.28.128/17
223.32.0/11
223.130.64/18
223.131.0/16
223.165.128/17
223.168.0/13
223.194.0/15
203.81.8/22
203.81.128/19
202.167.208/22
202.167.212/23
202.167.214/24
103.105.156/22
103.105.160/22
103.182.122/23
103.182.126/23
192.40.0/22
103.182.250/23
202.167.215/24
202.167.216/21
221.133.48/22
221.133.52/23
221.133.54/24
221.133.55/24
221.133.56/21
120.73.0/17
120.73.128/17
103.178.34/23
103.178.80/23
103.187.34/23
103.188.89/24
103.187.108/23
103.149.188/23
103.54.72/22
45.114.128/22
103.141.190/23
211.237.64/23
211.237.66/24
211.237.67/24
211.237.68/22
211.237.72/24
211.237.73/24
211.237.74/23
211.237.76/23
103.71.4/23
103.42.60/23
211.237.78/24
211.237.79/24
101.101.128/21
101.101.136/21
101.101.248/21
103.90.209/24
103.90.244/22
103.77.84/22
103.78.132/23
103.79.132/22
103.140.12/23
101.101.144/20
103.66.188/22
103.66.192/22
103.87.116/22
103.219.124/22
103.219.128/22
45.250.204/22
45.250.208/22
45.250.220/22
116.204.168/22
103.74.0/22
103.60.192/22
103.68.96/22
103.68.148/22
103.68.152/22
202.90.252/22
91.240.89/24
202.148.48/22
103.246.172/22
103.254.248/22
103.85.80/22
202.179.148/22
103.104.86/24
210.16.116/22
103.114.124/22
103.114.62/24
103.122.184/22
43.229.0/22
115.187.20/23
101.79.144/20
101.79.160/20
101.79.192/20
101.79.208/20
101.79.224/20
106.10.0/19
106.10.32/19
106.10.64/18
110.92.20/23
110.92.22/24
110.92.23/24
110.93.128/20
110.93.144/20
110.93.160/19
115.85.160/20
115.85.176/20
118.67.128/19
118.67.160/19
175.106.64/19
175.106.96/20
175.45.192/19
175.45.224/19
182.173.160/20
182.173.176/22
182.173.180/22
182.173.184/21
211.233.128/20
211.233.144/20
211.56.0/20
211.56.16/20
223.130.128/18
223.130.192/20
223.130.240/20
223.255.208/20
27.96.128/21
27.96.136/21
27.96.144/20
27.96.160/19
49.143.128/19
49.143.160/20
49.143.176/22
49.143.180/22
49.143.184/23
49.143.186/24
49.143.187/24
49.143.188/22
49.143.192/20
49.143.208/20
49.236.128/22
49.236.132/22
49.236.136/21
49.236.144/20
49.236.160/21
49.236.168/21
49.236.176/20
49.50.128/20
49.50.160/20
49.50.176/20
103.133.240/23
103.139.84/23
103.54.60/22
45.114.104/22
101.101.160/20
101.101.176/20
101.101.192/20
101.101.208/20
103.132.32/22
103.132.36/22
103.139.118/23
103.124.100/22
103.143.78/23
103.139.214/23
103.139.216/23
123.253.172/22
103.140.220/23
103.127.212/22
167.179.212/22
103.125.108/22
210.217.0/17
210.217.128/19
210.217.160/19
210.217.192/19
210.217.224/19
210.218.0/18
210.218.64/19
210.218.96/19
210.219.0/19
210.219.128/18
210.219.192/18
210.219.32/19
210.219.64/18
210.220.0/19
210.220.128/19
210.220.160/19
210.220.192/18
210.220.32/19
210.221.0/17
210.221.128/19
210.221.160/19
210.221.192/18
210.93.0/17
210.93.128/18
210.93.192/19
210.93.224/19
210.94.0/19
210.94.128/19
210.94.160/19
210.94.192/19
210.94.224/19
210.94.32/19
210.94.64/18
210.95.0/16
210.97.128/19
210.97.160/19
210.97.192/22
210.97.196/22
210.97.200/21
210.97.208/20
210.97.224/20
210.97.240/20
210.98.0/18
210.98.192/19
210.98.224/19
210.98.64/18
211.104.0/14
211.108.0/15
211.110.0/17
211.110.128/18
211.110.192/19
211.110.224/20
211.110.240/20
211.111.0/17
211.111.128/19
211.111.160/20
211.111.176/20
211.111.192/20
211.111.208/20
211.111.224/19
211.112.0/18
211.112.128/17
211.112.64/19
211.112.96/19
211.113.0/17
211.113.128/17
211.114.0/16
211.115.0/19
211.115.128/18
211.115.192/19
211.115.224/19
211.115.32/19
211.115.64/18
211.116.128/19
211.116.160/20
211.116.176/20
211.116.192/19
211.116.224/19
211.118.0/15
211.168.0/14
211.172.0/19
211.172.112/20
211.172.128/20
211.172.144/20
211.172.160/20
211.172.192/20
211.172.208/20
211.172.240/20
211.172.32/19
211.172.64/20
211.172.80/20
211.172.96/20
211.173.0/17
211.173.128/19
211.173.160/19
211.173.192/18
211.174.0/20
211.174.128/17
211.174.16/20
211.174.48/20
211.174.64/19
211.174.96/19
211.175.0/16
211.180.0/15
211.182.0/16
211.183.0/16
211.184.0/15
211.186.0/16
211.187.0/17
211.187.128/20
211.187.144/20
211.187.160/19
211.187.192/18
211.188.0/19
211.188.128/17
211.188.32/19
211.188.64/19
211.189.0/17
211.189.128/19
211.189.160/19
211.189.192/19
211.189.224/19
211.190.0/19
211.190.112/20
211.190.128/20
211.190.144/20
211.190.160/19
211.190.192/19
211.190.224/19
211.190.32/20
211.190.48/20
211.190.64/19
211.190.96/20
211.191.0/20
211.191.112/20
211.191.128/20
211.236.192/19
211.236.224/19
211.191.144/20
211.191.16/20
211.191.160/19
211.191.192/19
211.191.224/20
211.191.240/20
211.191.32/20
211.191.48/20
211.191.64/19
211.191.96/20
211.232.0/17
211.232.128/18
211.232.192/18
211.233.0/18
211.233.160/19
211.233.192/18
211.233.64/19
211.233.96/19
211.234.128/18
211.234.192/19
211.234.224/20
211.234.240/22
211.234.244/22
211.234.248/21
211.235.0/19
211.235.128/18
211.235.192/19
211.235.224/19
211.235.32/19
211.235.64/18
211.236.0/18
211.236.128/19
211.236.64/18
211.237.0/20
211.237.112/20
211.237.128/20
211.237.144/20
211.237.16/20
211.237.160/19
211.237.192/20
211.237.208/20
211.237.224/20
211.237.240/20
211.237.32/20
211.237.48/20
211.237.80/20
211.237.96/20
211.238.0/19
211.238.128/19
211.238.160/20
211.238.176/20
211.238.192/20
211.238.208/20
211.238.224/20
211.238.240/20
211.238.32/19
211.238.64/19
211.238.96/19
211.239.0/16
211.240.0/17
211.240.128/17
211.241.0/17
211.241.128/17
211.242.0/16
211.243.0/16
211.244.0/15
211.246.0/17
211.246.128/17
211.247.0/17
211.247.128/17
211.248.0/16
211.249.0/16
211.250.0/15
211.254.192/19
211.254.224/20
211.254.240/21
211.254.248/22
211.254.252/22
211.255.0/18
211.255.160/19
211.255.192/20
211.255.208/20
211.255.224/19
211.255.64/18
211.33.0/17
211.33.128/17
211.34.0/16
211.35.0/18
211.35.100/22
211.35.104/21
211.35.112/20
211.35.128/17
211.35.64/20
211.35.80/20
211.35.96/22
211.36.0/18
211.36.128/19
211.36.160/19
211.36.64/19
211.36.96/19
211.37.0/17
211.37.128/18
211.37.192/19
211.37.224/19
211.38.0/16
211.39.0/18
211.39.128/19
211.39.160/19
211.39.192/19
211.39.224/19
211.39.64/19
211.39.96/19
211.41.0/18
211.41.128/19
211.41.160/19
211.41.192/20
211.41.208/20
211.41.224/19
211.41.64/19
211.41.96/19
211.43.0/19
211.43.128/20
211.43.144/20
211.43.160/19
211.43.192/19
211.43.224/19
211.43.32/19
211.43.64/18
211.45.0/19
211.45.32/19
211.45.64/19
211.45.96/19
211.46.0/16
211.47.0/18
211.47.128/19
211.47.160/22
211.47.164/22
211.47.168/21
211.47.176/20
211.47.192/19
211.47.224/20
211.47.240/20
211.47.64/20
211.47.80/20
211.47.96/19
211.48.0/16
211.49.0/16
211.52.0/18
211.52.128/20
211.52.144/20
211.52.160/19
211.52.192/18
211.52.64/18
211.56.128/18
211.56.192/19
211.56.224/19
211.56.32/19
211.56.64/18
211.57.0/16
211.58.0/15
211.61.0/18
211.61.112/20
211.61.128/17
211.61.64/19
211.61.96/20
211.63.64/19
211.63.96/19
218.36.0/17
218.36.128/17
218.37.0/17
218.37.128/18
218.37.192/18
218.38.0/15
219.248.0/14
219.252.0/15
219.254.0/15
220.64.0/16
220.65.0/16
220.66.0/15
220.68.0/15
220.70.0/15
61.100.0/17
61.100.128/18
61.100.192/19
61.100.224/20
61.100.240/21
61.100.248/21
61.101.0/17
61.101.128/18
61.101.192/19
61.101.224/20
61.101.240/22
61.101.244/22
61.101.248/21
61.102.0/17
61.102.128/17
61.103.0/16
61.104.0/16
61.105.0/16
61.106.0/19
61.106.128/18
61.106.192/19
61.106.224/20
61.106.240/20
61.106.32/19
61.106.64/20
61.106.80/20
61.106.96/19
61.107.0/16
61.108.0/16
61.109.0/17
61.109.128/17
61.110.0/19
61.110.128/22
61.110.132/22
61.110.136/21
61.110.144/20
61.110.160/19
61.110.32/20
61.110.48/20
61.110.64/18
61.111.0/18
61.111.112/20
61.111.128/18
61.111.192/19
61.111.224/20
61.111.240/20
61.111.64/19
61.111.96/20
61.248.0/17
61.248.128/19
61.248.160/20
61.248.176/20
61.248.192/19
61.248.224/22
61.248.228/22
61.248.232/21
61.248.240/20
61.249.0/18
61.249.128/19
61.249.160/19
61.249.192/19
61.249.224/19
61.249.64/20
61.249.80/21
61.249.88/22
61.249.92/22
61.249.96/19
61.250.0/18
61.250.128/17
61.250.64/18
61.251.0/20
61.251.112/20
61.251.128/19
61.251.16/20
61.251.160/20
61.251.176/20
61.251.192/18
61.251.32/19
61.251.64/20
61.251.80/20
61.251.96/20
61.252.0/20
61.252.128/19
61.252.16/20
61.252.160/19
61.252.192/18
61.252.32/20
61.252.48/20
61.252.64/22
61.252.68/22
61.252.72/22
61.252.76/22
61.252.80/20
61.252.96/19
61.253.0/16
61.254.0/17
61.254.128/19
61.254.160/19
61.254.192/18
61.255.0/16
61.96.0/16
61.97.0/20
61.97.112/20
61.97.128/19
61.97.16/20
61.97.176/20
61.97.192/19
61.97.224/20
61.97.240/20
61.97.32/19
61.97.64/20
61.97.80/20
61.97.96/20
61.98.0/15
110.34.56/21
123.108.0/21
147.46.0/15
152.149.0/19
152.149.128/17
152.149.32/21
152.149.40/21
152.149.48/20
152.149.64/18
192.132.248/22
202.20.84/24
202.20.85/24
202.30.0/19
202.30.112/21
202.30.120/22
202.30.124/24
202.30.125/24
202.30.126/23
202.30.128/17
202.30.32/23
202.30.34/24
202.30.35/24
202.30.36/23
202.30.38/24
202.30.39/24
202.30.40/22
202.30.44/24
202.30.45/24
202.30.46/23
202.30.48/24
202.30.49/24
202.30.50/23
202.30.52/23
202.30.54/24
202.30.55/24
202.30.56/23
202.30.58/24
202.30.59/24
202.30.60/22
202.30.64/19
202.30.96/20
202.31.0/17
202.31.128/20
202.31.144/21
202.31.152/24
202.31.153/24
202.31.154/24
202.31.155/24
202.31.156/22
202.31.160/20
202.31.176/22
202.31.180/24
202.31.181/24
202.31.182/24
202.31.183/24
202.31.184/22
103.138.228/23
202.31.188/22
202.31.192/20
202.31.208/22
202.31.212/22
202.31.216/22
202.31.220/22
202.31.224/19
203.226.0/18
203.226.128/18
203.226.192/19
203.226.224/20
203.226.240/21
203.226.248/22
203.226.252/24
203.226.253/24
203.226.254/23
203.226.64/18
203.227.0/16
203.228.0/17
203.228.128/17
203.229.0/17
203.229.128/17
203.230.0/18
203.230.112/22
203.230.116/22
203.230.120/21
203.230.128/19
203.230.160/19
203.230.192/18
203.230.64/20
203.230.80/20
203.230.96/20
203.231.0/16
203.232.0/17
203.232.128/17
203.233.128/24
203.233.129/24
203.233.130/23
203.233.132/22
203.233.136/21
203.233.144/21
203.233.152/23
203.233.154/23
203.233.156/24
203.233.157/24
203.233.158/23
203.233.160/22
203.233.164/24
203.233.165/24
203.233.166/23
203.233.168/21
203.233.176/20
203.233.192/19
203.233.224/20
203.233.240/20
203.234.0/18
203.234.112/20
203.234.128/17
203.234.64/19
203.234.96/20
203.235.0/17
203.235.128/18
203.235.192/21
203.235.200/23
203.235.202/23
203.235.204/22
203.235.208/20
203.235.224/19
203.236.0/19
203.236.128/18
203.236.192/18
203.236.32/21
203.236.40/22
203.236.44/22
203.236.48/20
203.236.64/18
203.237.0/18
203.237.128/17
203.237.64/19
203.237.96/19
203.238.0/17
203.238.128/19
203.238.160/20
203.238.176/20
203.238.192/19
203.238.224/19
203.239.0/17
203.239.128/18
203.239.192/19
203.239.224/19
203.240.0/18
203.240.100/22
203.240.104/21
203.240.112/20
203.240.128/19
203.240.160/20
203.240.176/21
203.240.184/22
203.240.188/23
203.240.190/24
203.240.191/24
203.240.192/18
203.240.64/19
203.240.96/23
203.240.98/23
203.241.0/19
203.241.112/22
203.241.116/22
203.241.120/22
203.241.124/22
203.241.128/22
203.241.132/22
203.241.136/21
203.241.144/20
203.241.160/22
203.241.164/23
203.241.166/24
203.241.167/24
203.241.168/22
203.241.172/23
203.241.174/24
203.241.175/24
203.241.176/20
203.241.192/20
203.241.208/22
203.241.212/23
203.241.214/23
203.241.216/22
203.241.220/22
203.241.224/19
203.241.32/20
203.241.48/22
203.241.52/22
203.241.56/21
203.241.64/20
203.241.80/22
203.241.84/22
203.241.88/21
203.241.96/20
203.242.0/19
203.242.112/21
203.242.120/21
203.242.128/17
203.242.32/20
203.242.48/21
203.242.56/22
203.242.60/23
203.242.62/24
203.242.63/24
203.242.64/19
203.242.96/20
203.243.0/18
203.243.128/17
203.243.64/18
203.244.0/19
203.244.128/18
203.244.192/19
203.244.224/20
203.244.240/20
203.244.32/19
203.244.64/19
203.244.96/19
203.245.0/18
203.245.128/17
203.245.64/18
203.246.0/17
203.246.128/19
203.246.160/20
203.246.176/21
203.246.184/22
203.246.188/23
203.246.190/23
203.246.192/18
203.247.0/19
203.247.128/19
203.247.160/19
203.247.192/19
203.247.224/19
203.247.32/19
203.247.64/18
203.249.0/18
203.249.128/19
203.249.160/19
203.249.192/19
203.249.224/19
203.249.64/19
203.249.96/19
203.250.0/19
203.250.128/17
203.250.32/19
203.250.64/19
203.250.96/19
203.251.0/17
203.251.128/18
203.251.192/18
203.252.128/18
203.252.16/21
203.252.192/20
203.252.208/20
203.252.224/19
203.252.24/23
203.252.26/24
203.252.27/24
203.252.28/22
203.252.64/19
203.252.96/19
203.253.0/19
203.253.112/20
203.253.128/22
203.253.132/22
203.253.136/21
203.253.144/20
203.253.160/19
203.253.192/19
203.253.224/21
203.253.232/24
203.253.233/24
203.253.234/23
203.253.236/24
203.253.237/24
203.253.238/23
203.253.240/21
203.253.248/21
203.253.32/20
203.253.48/20
203.253.64/19
203.253.96/20
203.254.0/21
203.254.10/23
203.254.12/22
203.254.128/19
203.254.16/20
203.254.160/21
203.254.168/23
203.254.170/24
203.254.171/24
203.254.172/23
203.254.174/24
203.254.175/24
103.106.140/22
203.254.176/20
203.254.192/18
203.254.32/23
203.254.34/23
203.254.36/22
203.254.40/24
203.254.41/24
203.254.42/23
203.254.44/22
203.254.48/23
203.254.50/24
203.254.51/24
203.254.52/22
203.254.56/24
203.254.57/24
203.254.58/23
203.254.60/22
203.254.64/19
203.254.8/24
203.254.9/24
203.254.96/19
203.255.0/18
203.255.112/21
203.255.120/22
203.255.124/22
203.255.128/19
203.255.160/19
203.255.192/20
203.255.208/22
203.255.212/22
203.255.216/22
203.255.220/23
203.255.222/23
203.255.224/21
203.255.232/23
203.255.234/24
203.255.235/24
203.255.236/22
203.255.240/21
203.255.248/21
203.255.64/19
203.255.96/20
210.101.0/18
210.101.192/19
210.101.224/19
210.101.64/18
210.102.64/19
210.102.96/19
210.106.0/18
210.106.64/19
210.106.96/19
210.110.0/17
210.110.128/17
210.111.0/18
210.111.112/20
210.111.128/19
210.111.160/19
210.111.192/19
210.111.224/19
210.111.64/20
210.111.80/20
210.111.96/20
210.112.0/17
210.112.128/19
210.112.160/20
210.112.176/20
210.112.192/19
210.112.224/19
210.113.0/16
210.114.0/18
210.114.104/21
210.114.112/20
210.114.128/19
210.114.160/19
210.114.192/20
210.114.208/20
210.114.224/19
210.114.64/20
210.114.80/21
210.114.88/21
210.114.96/21
210.115.0/19
210.115.128/19
210.115.160/19
210.115.192/19
210.115.224/19
210.115.32/19
210.115.64/19
210.115.96/19
210.116.0/18
210.116.128/17
210.116.64/18
210.117.0/17
210.117.128/18
210.117.192/18
210.118.0/19
210.118.128/17
210.118.32/19
210.118.64/18
210.119.0/17
210.119.128/18
210.119.192/19
210.119.224/20
210.119.240/20
210.121.0/17
210.121.128/17
210.122.0/16
210.123.0/16
210.125.0/20
210.125.128/17
210.125.16/20
210.125.32/19
210.125.64/18
210.126.0/17
210.126.128/17
210.127.0/19
210.127.128/17
210.127.32/19
210.127.64/18
210.180.64/19
210.180.96/19
210.181.0/19
210.181.128/18
210.181.192/19
210.181.224/19
210.181.32/19
210.181.64/18
210.204.0/16
210.205.0/18
210.205.112/20
210.205.128/18
210.205.192/19
210.205.224/20
210.205.240/20
210.205.64/19
210.205.96/20
210.206.0/15
103.143.176/23
103.186.170/23
64.188.32/20
103.131.164/22
165.141.0/18
165.141.112/20
165.141.128/17
165.141.64/19
165.141.96/20
103.144.30/23
103.143.32/23
103.140.208/22
103.117.0/22
103.129.184/22
103.109.64/22
103.21.188/23
103.21.190/23
103.37.0/22
43.240.236/22
103.127.124/22
103.126.64/22
103.199.100/22
103.48.132/22
137.59.16/22
43.229.112/22
103.175.200/23
206.219.0/18
103.167.230/23
103.39.16/22
43.243.188/22
103.162.180/23
103.161.4/23
180.189.52/22
180.210.16/21
180.210.24/22
180.210.28/22
162.222.172/22
223.130.234/23
223.130.224/21
223.130.232/23
103.159.160/23
103.166.222/23
103.157.158/23
103.153.44/23
103.164.78/23
223.130.236/23
223.130.238/23
61.97.160/23
61.97.162/23
61.97.164/22
61.97.168/23
61.97.170/23
61.97.172/23
61.97.174/23
103.44.88/22
43.225.124/22
103.157.208/23
160.20.142/24
103.156.22/23
103.86.44/22
203.160.130/23
203.191.134/23
103.150.62/23
103.162.52/23
103.150.204/23
103.150.160/24
103.150.162/23
103.146.180/23
211.188.104/21
211.188.112/20
211.188.96/21
211.255.128/21
211.255.136/21
211.255.144/20
223.255.192/21
223.255.200/21
103.145.214/23
103.122.144/23
180.94.4/24
59.150.0/21
59.150.100/22
59.150.104/22
59.150.108/23
59.150.110/23
59.150.112/21
59.150.12/24
59.150.120/23
59.150.122/24
59.150.123/24
59.150.124/24
59.150.125/24
59.150.126/23
59.150.128/22
59.150.13/24
59.150.132/23
59.150.134/24
59.150.135/24
59.150.136/24
59.150.137/24
59.150.138/24
59.150.139/24
59.150.14/24
59.150.140/24
59.150.141/24
59.150.142/23
59.150.144/23
59.150.146/23
59.150.148/23
59.150.15/24
59.150.150/24
59.150.151/24
59.150.152/22
59.150.156/24
59.150.157/24
59.150.158/23
59.150.16/23
59.150.160/22
59.150.164/24
59.150.165/24
59.150.166/23
59.150.168/23
59.150.170/24
59.150.171/24
59.150.172/24
59.150.173/24
59.150.174/23
59.150.176/20
59.150.18/24
59.150.19/24
59.150.192/23
59.150.194/24
59.150.195/24
59.150.196/23
59.150.198/23
59.150.20/23
59.150.200/22
59.150.204/23
59.150.206/24
59.150.207/24
59.150.208/20
59.150.22/23
59.150.224/19
59.150.24/21
59.150.32/21
59.150.40/23
59.150.42/24
59.150.43/24
59.150.44/24
59.150.45/24
59.150.46/23
59.150.48/22
59.150.52/23
59.150.54/23
59.150.56/23
59.150.58/23
59.150.60/24
59.150.61/24
59.150.62/23
59.150.64/22
59.150.68/24
59.150.69/24
59.150.70/23
59.150.72/24
59.150.73/24
59.150.74/23
59.150.76/22
59.150.8/22
59.150.80/22
59.150.84/22
59.150.88/22
59.150.92/23
59.150.94/23
59.150.96/23
101.101.240/21
59.150.98/24
59.150.99/24
103.67.58/23
101.79.0/22
101.79.128/21
101.79.136/23
101.79.138/23
101.79.140/22
101.79.16/20
101.79.176/21
101.79.184/22
101.79.188/22
101.79.240/21
101.79.248/22
101.79.252/23
101.79.254/23
101.79.4/22
101.79.48/20
101.79.64/21
101.79.72/22
101.79.76/22
101.79.8/21
101.79.80/20
101.79.96/19
110.4.104/22
110.4.108/22
110.4.112/20
110.4.64/20
110.4.80/21
110.4.88/22
110.4.92/22
110.4.96/21
113.30.96/20
114.141.0/20
114.141.16/21
124.217.192/19
160.250.152/23
160.250.154/23
180.210.32/21
180.210.40/22
180.210.44/22
180.210.48/21
180.210.56/22
180.210.60/22
182.252.128/21
182.252.136/22
182.252.140/22
182.252.144/20
182.252.160/20
210.4.216/22
210.4.220/22
211.172.176/21
211.172.184/22
211.172.188/22
211.172.224/22
211.172.228/22
211.172.232/21
211.236.160/22
211.236.164/22
211.236.168/21
211.236.176/22
211.236.180/22
211.236.184/21
101.101.224/22
101.101.228/22
101.101.232/21
103.11.56/23
103.11.58/23
110.93.120/22
110.93.124/22
211.174.32/20
223.130.208/20
49.50.144/21
49.50.152/22
49.50.156/22
163.61.222/23
160.30.106/23
14.0.64/21
14.0.72/22
14.0.76/23
14.0.78/23
14.0.80/20
14.0.96/19
61.110.192/19
61.110.224/20
61.110.240/21
61.110.248/22
61.110.252/23
61.110.254/24
61.110.255/24
101.79.32/21
101.79.40/22
101.79.44/22
113.30.112/20
113.30.64/21
113.30.72/21
113.30.80/20
114.141.24/21
180.210.0/21
180.210.64/18
180.210.8/21
182.252.176/22
182.252.180/22
182.252.184/21
182.252.192/18
185.130.49/24
110.93.112/21
163.223.162/23
114.110.128/18
114.110.192/18
182.255.128/18
182.255.192/18
160.30.229/24
160.30.232/23
160.30.235/24
160.22.155/24
103.218.172/23
157.66.64/23
160.187.186/23
163.223.94/23
");

    foreach($arr_ip as $buff) {
        $arr=explode("/",trim($buff));
        if ($arr[0] && is_ip_in_subnet($ip, $arr[0].'.0', $arr[1])) {
            return true;
        }
    }
    return false;
}
