function Dog(id, game){
    this.id = id;
    this.game = game; // game object to trigger events on and append to
    this.sounds = {
        sniff: $('#sniff'),
        bark: $('#bark'),
        laugh: $('#laugh'),
        ohYeah: $('#ohyeah')
    };
    this.intervals = {
        sniffInterval: null
    };
    this.animationQueue = {
        jump: null
    };
    $('<div id="'+this.id+'" class="theDog"></div>').appendTo(this.game);
    this.DOM = $("#"+this.id);

    this.DOM.hide();
}

/**
 * Used at the start of a level
 */
Dog.prototype.intro = function(def){
    this.DOM.addClass('searchDog');
    this.DOM.show(); // HA GET IT DOG SHOW!?!
    this.intervals.sniffInterval = setInterval(_.bind(function(){
        this.sounds.sniff[0].play();
    },this),2000);
    this.DOM.sprite({fps: 6, no_of_frames: 4});
    this.DOM.animate({
        left: '240'
    },5300,'linear', _.bind(function(){
        clearInterval(this.intervals.sniffInterval);
        this.sounds.bark[0].play();
        this.DOM.destroy();
        this.DOM.css("background-position","-632px 0px");
        this.animationQueue.jump = setTimeout(_.bind(function(){
            this.css({
                'background-image': 'url(images/jumpDog.png)',
                'bottom': '75px',
                'background-position': '0 0'
            });
            this.sprite({fps: 50, no_of_frames: 2,play_frames: 2});
            this.fadeOut().promise().then(
                _.bind(function(){
                    // reset css modifications so animation can be easily rerun
                    this.attr('style','');
                    this.removeClass('searchDog');
                    def.resolve();
                },this));
            this.spStop();
            this.destroy();
        },this.DOM),500);
    },this));
};

/**
 * Used when duck is shot and the dog retrieves
 */
Dog.prototype.fetch = function(){
    this.DOM.stop(true,false);
    this.DOM.show(); // HA GET IT DOG SHOW!?!
    this.DOM.css("background-position","0px 0px");
    this.sounds.ohYeah[0].play();
    this._upDown();
};

/**
 * Used when ducks are missed
 */
Dog.prototype.laugh = function(){
    this.DOM.stop(true,false);
    this.DOM.show();
    this.DOM.css("background-position","-276px 0px");
    this.sounds.laugh[0].play();
    this._upDown();
};

/**
 * Utility method to move dog up and down
 * @private
 */
Dog.prototype._upDown = function(){
    this.DOM.animate({
        bottom: '110'
    },400,function(){
        setTimeout(_.bind(function(){
            this.animate({
                bottom: '-10'
            },500);
        },$(this)),700);
    });
};

/**
 * This mildly janky function is used to clear the dog state when a custom
 * level is generated by the user.  The main issue is when a level is generated
 * and the dog is still sniffing.
 */
Dog.prototype.inTheCrate = function(){
    if(this.DOM.hasClass('searchDog')){
        clearTimeout(this.animationQueue.jump);
        this.DOM.attr('style','');
        this.DOM.spStop();
        this.DOM.destroy();
        this.DOM.removeClass('searchDog');
        this.DOM.hide();
        clearInterval(this.intervals.sniffInterval);
    }
};