<?php
$sub_menu = '750100';

include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

auth_check_menu($auth, $sub_menu, "w");

$g5['title'] = '푸시매니저 API 설정';
include_once(G5_ADMIN_PATH.'/admin.head.php');

// 테이블 존재 확인
$table_exists = false;
$sql = "SHOW TABLES LIKE 'pushmanager_config'";
$result = sql_query($sql, false);
if ($result && sql_num_rows($result) > 0) {
    $table_exists = true;
}

if (!$table_exists) {
    alert('푸시매니저가 설치되지 않았습니다.', './install.php');
}

// 현재 설정 조회
$config = get_pushmanager_config();
$has_config = $config && $config['site_name'];
$has_api_key = $config && $config['api_key'];
$has_vapid_key = $config && $config['vapid_public_key'];
$has_push_icon = $config && $config['push_icon_url'];
$has_badge_icon = $config && $config['badge_icon_url'];
?>

<div class="local_desc01 local_desc">
    <p>
        푸시매니저 API 서버와의 연동을 위한 설정을 관리합니다.<br>
        사이트 정보를 입력하고 API 키를 설정하여 푸시 서비스를 이용하세요.
    </p>
</div>

<!-- 설정 폼 -->
<form name="fconfig" method="post" action="./api_config_update.php" enctype="multipart/form-data">
<div class="tbl_frm01 tbl_wrap">
    <table>
        <caption>푸시매니저 설정</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row"><label for="site_name">사이트명<strong class="sound_only">필수</strong></label></th>
                <td>
                    <input type="text" name="site_name" id="site_name" value="<?php echo isset($config['site_name']) ? $config['site_name'] : '' ?>" required class="frm_input required" size="30" maxlength="100">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="site_url">사이트 URL<strong class="sound_only">필수</strong></label></th>
                <td>
                    <input type="url" name="site_url" id="site_url" value="<?php echo isset($config['site_url']) ? $config['site_url'] : '' ?>" required class="frm_input required" size="50" maxlength="255" placeholder="https://example.com">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="admin_email">관리자 이메일<strong class="sound_only">필수</strong></label></th>
                <td>
                    <input type="email" name="admin_email" id="admin_email" value="<?php echo isset($config['admin_email']) ? $config['admin_email'] : '' ?>" required class="frm_input required" size="30" maxlength="100">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="api_server_url">API 서버 URL<strong class="sound_only">필수</strong></label></th>
                <td>
                    <input type="url" name="api_server_url" id="api_server_url" value="<?php echo isset($config['api_server_url']) ? $config['api_server_url'] : '' ?>" required class="frm_input required" size="50" maxlength="255" placeholder="https://push-api.example.com">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="api_key">API 키</label></th>
                <td>
                    <input type="text" name="api_key" id="api_key" value="<?php echo isset($config['api_key']) ? $config['api_key'] : '' ?>" class="frm_input" size="60" maxlength="255" placeholder="API 관리자 프론트에서 발급받은 API 키">
                    <div class="frm_info">API 관리자 프론트에서 발급받은 API 키를 입력하세요.</div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="vapid_public_key">VAPID 공개키</label></th>
                <td>
                    <textarea name="vapid_public_key" id="vapid_public_key" class="frm_input" style="width:100%; height:80px;" placeholder="VAPID 공개키를 입력하세요 (예: BNXxxx...)"><?php echo isset($config['vapid_public_key']) ? $config['vapid_public_key'] : '' ?></textarea>
                    <div class="frm_info">푸시 서버에서 생성한 VAPID 공개키를 입력하세요. Base64 URL Safe 형식이어야 합니다.</div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="push_icon">푸시 아이콘</label></th>
                <td>
                    <?php if ($has_push_icon): ?>
                        <div style="margin-bottom: 10px;">
                            <img src="<?php echo $config['push_icon_url'] ?>" alt="푸시 아이콘" style="max-width: 64px; max-height: 64px; border: 1px solid #ddd; padding: 5px;">
                            <div class="frm_info">현재 아이콘 (클릭하면 새 창에서 열립니다): <a href="<?php echo $config['push_icon_url'] ?>" target="_blank"><?php echo basename($config['push_icon_url']) ?></a></div>
                        </div>
                    <?php endif; ?>
                    <input type="file" name="push_icon" id="push_icon" class="frm_input" accept="image/*">
                    <div class="frm_info">푸시 알림에 표시될 아이콘을 업로드하세요. (PNG, JPG, GIF, WebP 형식, 최대 2MB)</div>
                    <?php if ($has_push_icon): ?>
                        <button type="submit" name="delete_push_icon" value="1" class="btn_frmline btn" style="margin-top: 5px;" onclick="return confirm('푸시 아이콘을 삭제하시겠습니까?');">현재 아이콘 삭제</button>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="badge_icon">뱃지 아이콘</label></th>
                <td>
                    <?php if ($has_badge_icon): ?>
                        <div style="margin-bottom: 10px;">
                            <img src="<?php echo $config['badge_icon_url'] ?>" alt="뱃지 아이콘" style="max-width: 64px; max-height: 64px; border: 1px solid #ddd; padding: 5px;">
                            <div class="frm_info">현재 아이콘 (클릭하면 새 창에서 열립니다): <a href="<?php echo $config['badge_icon_url'] ?>" target="_blank"><?php echo basename($config['badge_icon_url']) ?></a></div>
                        </div>
                    <?php endif; ?>
                    <input type="file" name="badge_icon" id="badge_icon" class="frm_input" accept="image/*">
                    <div class="frm_info">푸시 알림의 뱃지에 표시될 아이콘을 업로드하세요. (PNG, JPG, GIF, WebP 형식, 최대 2MB)</div>
                    <?php if ($has_badge_icon): ?>
                        <button type="submit" name="delete_badge_icon" value="1" class="btn_frmline btn" style="margin-top: 5px;" onclick="return confirm('뱃지 아이콘을 삭제하시겠습니까?');">현재 아이콘 삭제</button>
                    <?php endif; ?>
                </td>
            </tr>
            <?php if ($has_api_key && $has_vapid_key): ?>
            <tr>
                <th scope="row">설정 상태</th>
                <td>
                    <span class="fc_373 fc_bl"><b>완료됨</b></span>
                    <span class="fc_999">(<?php echo date('Y-m-d H:i', strtotime($config['updated_at'])) ?>)</span>
                    <div class="frm_info">API 키와 VAPID 키가 모두 설정되어 푸시 서비스를 사용할 수 있습니다.</div>
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<div class="btn_fixed_top">
    <input type="submit" name="save_config" value="설정 저장" class="btn_submit btn">
    <?php if ($has_api_key && $has_vapid_key): ?>
        <input type="submit" name="test_connection" value="연결 테스트" class="btn_02 btn">
        <input type="submit" name="delete_api_key" value="API 키 삭제" class="btn_02 btn" onclick="return confirm('API 키를 삭제하시겠습니까?\\n푸시 서비스를 더 이상 사용할 수 없게 됩니다.');">
    <?php endif; ?>
</div>
</form>


<script>
function toggleApiKey() {
    var input = document.getElementById('api_key_display');
    var btn = event.target;
    
    if (input.type === 'password') {
        input.type = 'text';
        btn.textContent = '숨김';
    } else {
        input.type = 'password';
        btn.textContent = '보기';
    }
}
</script>

<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');
?>