<?php
include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

// 관리자 권한 확인
if (!$is_admin) {
    http_response_code(403);
    echo '<div style="text-align:center; color:#dc3545;">관리자 권한이 필요합니다.</div>';
    exit;
}

$log_id = intval($_POST['log_id']);

if ($log_id <= 0) {
    echo '<div style="text-align:center; color:#dc3545;">로그 ID가 필요합니다.</div>';
    exit;
}

// 로그 정보 조회
$sql = "SELECT * FROM pushmanager_logs WHERE id = {$log_id}";
$log = sql_fetch($sql);

if (!$log) {
    echo '<div style="text-align:center; color:#dc3545;">로그를 찾을 수 없습니다.</div>';
    exit;
}

// 로그 타입별 정보
function get_log_type_info($type) {
    switch ($type) {
        case 'send':
            return array('class' => 'fc_373', 'text' => '푸시 발송', 'badge' => 'success');
        case 'error':
            return array('class' => 'fc_197', 'text' => '시스템 오류', 'badge' => 'danger');
        case 'config':
            return array('class' => 'fc_blue', 'text' => '설정 변경', 'badge' => 'info');
        default:
            return array('class' => 'fc_999', 'text' => '기타', 'badge' => 'secondary');
    }
}

$type_info = get_log_type_info($log['type']);
$has_error = !empty($log['error_message']);
$success_rate = 0;

if ($log['type'] == 'send' && $log['target_count'] > 0) {
    $success_rate = round(($log['success_count'] / $log['target_count']) * 100, 1);
}
?>

<div style="border-bottom:1px solid #eee; padding-bottom:15px; margin-bottom:15px;">
    <div style="display:flex; align-items:center; margin-bottom:10px;">
        <span style="display:inline-block; padding:4px 12px; background:<?php echo $type_info['class'] == 'fc_373' ? '#28a745' : ($type_info['class'] == 'fc_197' ? '#dc3545' : '#17a2b8') ?>; color:white; border-radius:15px; font-size:12px; font-weight:bold; margin-right:10px;">
            <?php echo $type_info['text'] ?>
        </span>
        <span style="color:#666; font-size:14px;">
            <?php echo date('Y년 m월 d일 H시 i분 s초', strtotime($log['created_at'])) ?>
        </span>
        <?php if ($has_error): ?>
        <span style="color:#dc3545; font-size:12px; margin-left:10px;">⚠ 오류 발생</span>
        <?php endif; ?>
    </div>
    
    <div style="font-size:11px; color:#999;">
        로그 ID: <?php echo $log['id'] ?>
    </div>
</div>

<?php if (!empty($log['title'])): ?>
<div style="margin-bottom:15px;">
    <h4 style="margin:0 0 5px 0; color:#333;">제목</h4>
    <div style="padding:10px; background:#f8f9fa; border-radius:3px; font-weight:bold;">
        <?php echo htmlspecialchars($log['title']) ?>
    </div>
</div>
<?php endif; ?>

<?php if (!empty($log['message'])): ?>
<div style="margin-bottom:15px;">
    <h4 style="margin:0 0 5px 0; color:#333;">메시지</h4>
    <div style="padding:10px; background:#f8f9fa; border-radius:3px; white-space:pre-wrap; line-height:1.5;">
        <?php echo htmlspecialchars($log['message']) ?>
    </div>
</div>
<?php endif; ?>

<?php if ($log['type'] == 'send'): ?>
<div style="margin-bottom:15px;">
    <h4 style="margin:0 0 10px 0; color:#333;">발송 결과</h4>
    <div style="display:flex; gap:15px; margin-bottom:10px;">
        <div style="text-align:center; padding:10px; background:#f8f9fa; border-radius:5px; min-width:80px;">
            <div style="font-size:18px; font-weight:bold; color:#333;">
                <?php echo number_format($log['target_count']) ?>
            </div>
            <div style="font-size:11px; color:#666;">대상</div>
        </div>
        <div style="text-align:center; padding:10px; background:#d4edda; border-radius:5px; min-width:80px;">
            <div style="font-size:18px; font-weight:bold; color:#155724;">
                <?php echo number_format($log['success_count']) ?>
            </div>
            <div style="font-size:11px; color:#155724;">성공</div>
        </div>
        <div style="text-align:center; padding:10px; background:#f8d7da; border-radius:5px; min-width:80px;">
            <div style="font-size:18px; font-weight:bold; color:#721c24;">
                <?php echo number_format($log['error_count']) ?>
            </div>
            <div style="font-size:11px; color:#721c24;">실패</div>
        </div>
        <div style="text-align:center; padding:10px; background:#e2e3e5; border-radius:5px; min-width:80px;">
            <div style="font-size:18px; font-weight:bold; color:<?php echo $success_rate >= 90 ? '#155724' : ($success_rate >= 70 ? '#856404' : '#721c24') ?>;">
                <?php echo $success_rate ?>%
            </div>
            <div style="font-size:11px; color:#666;">성공률</div>
        </div>
    </div>
    
    <!-- 성공률 프로그레스 바 -->
    <div style="background:#e9ecef; height:20px; border-radius:10px; overflow:hidden; margin-bottom:10px;">
        <div style="background:<?php echo $success_rate >= 90 ? '#28a745' : ($success_rate >= 70 ? '#ffc107' : '#dc3545') ?>; height:100%; width:<?php echo $success_rate ?>%; transition:width 0.3s; display:flex; align-items:center; justify-content:center; color:white; font-size:11px; font-weight:bold;">
            <?php if ($success_rate > 20): ?><?php echo $success_rate ?>%<?php endif; ?>
        </div>
    </div>
    
    <!-- 성공률 평가 -->
    <div style="font-size:12px; color:#666; text-align:center;">
        <?php if ($success_rate >= 95): ?>
            <span style="color:#28a745;">✓ 매우 좋음 - 발송이 정상적으로 완료되었습니다.</span>
        <?php elseif ($success_rate >= 85): ?>
            <span style="color:#28a745;">✓ 좋음 - 대부분의 발송이 성공했습니다.</span>
        <?php elseif ($success_rate >= 70): ?>
            <span style="color:#ffc107;">⚠ 보통 - 일부 발송 실패가 있었습니다.</span>
        <?php elseif ($success_rate >= 50): ?>
            <span style="color:#fd7e14;">⚠ 주의 - 발송 실패가 많습니다. 설정을 확인해주세요.</span>
        <?php else: ?>
            <span style="color:#dc3545;">✗ 심각 - 대부분의 발송이 실패했습니다. 즉시 확인이 필요합니다.</span>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>

<?php if ($has_error): ?>
<div style="margin-bottom:15px;">
    <h4 style="margin:0 0 5px 0; color:#dc3545;">오류 메시지</h4>
    <div style="padding:10px; background:#fff5f5; border:1px solid #f5c6cb; border-radius:3px; color:#721c24; white-space:pre-wrap; font-family:monospace; font-size:13px; line-height:1.4;">
        <?php echo htmlspecialchars($log['error_message']) ?>
    </div>
    
    <!-- 일반적인 오류 해결 방법 제시 -->
    <div style="margin-top:10px; padding:10px; background:#d1ecf1; border:1px solid #bee5eb; border-radius:3px; font-size:12px;">
        <strong style="color:#0c5460;">💡 문제 해결 팁:</strong>
        <ul style="margin:5px 0; padding-left:20px; color:#0c5460;">
            <li>API 서버 연결 상태를 확인해주세요.</li>
            <li>API 키와 VAPID 키가 올바르게 설정되었는지 확인해주세요.</li>
            <li>구독자의 엔드포인트가 만료되었을 수 있습니다.</li>
            <li>네트워크 연결 상태를 확인해주세요.</li>
            <li>문제가 지속되면 API 서버 관리자에게 문의하세요.</li>
        </ul>
    </div>
</div>
<?php endif; ?>

<!-- 기술적 세부 정보 -->
<div style="margin-top:20px; border-top:1px solid #eee; padding-top:15px;">
    <h4 style="margin:0 0 10px 0; color:#333;">기술적 정보</h4>
    <table style="width:100%; border-collapse:collapse; font-size:12px;">
        <tr>
            <td style="padding:5px; border:1px solid #ddd; background:#f8f9fa; font-weight:bold; width:120px;">로그 ID</td>
            <td style="padding:5px; border:1px solid #ddd;"><?php echo $log['id'] ?></td>
        </tr>
        <tr>
            <td style="padding:5px; border:1px solid #ddd; background:#f8f9fa; font-weight:bold;">로그 유형</td>
            <td style="padding:5px; border:1px solid #ddd;">
                <span class="<?php echo $type_info['class'] ?>"><?php echo $type_info['text'] ?></span>
                <span style="color:#666; margin-left:10px;">(<?php echo $log['type'] ?>)</span>
            </td>
        </tr>
        <tr>
            <td style="padding:5px; border:1px solid #ddd; background:#f8f9fa; font-weight:bold;">생성 일시</td>
            <td style="padding:5px; border:1px solid #ddd;">
                <?php echo date('Y-m-d H:i:s', strtotime($log['created_at'])) ?>
                <span style="color:#666; margin-left:10px;">(<?php echo time_since($log['created_at']) ?>)</span>
            </td>
        </tr>
        <?php if ($log['type'] == 'send'): ?>
        <tr>
            <td style="padding:5px; border:1px solid #ddd; background:#f8f9fa; font-weight:bold;">발송 대상 수</td>
            <td style="padding:5px; border:1px solid #ddd;"><?php echo number_format($log['target_count']) ?>명</td>
        </tr>
        <tr>
            <td style="padding:5px; border:1px solid #ddd; background:#f8f9fa; font-weight:bold;">성공 수</td>
            <td style="padding:5px; border:1px solid #ddd;">
                <span class="fc_373"><?php echo number_format($log['success_count']) ?>명</span>
                <?php if ($log['target_count'] > 0): ?>
                <span style="color:#666; margin-left:10px;">(<?php echo round(($log['success_count'] / $log['target_count']) * 100, 1) ?>%)</span>
                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <td style="padding:5px; border:1px solid #ddd; background:#f8f9fa; font-weight:bold;">실패 수</td>
            <td style="padding:5px; border:1px solid #ddd;">
                <span class="<?php echo $log['error_count'] > 0 ? 'fc_197' : 'fc_999' ?>"><?php echo number_format($log['error_count']) ?>명</span>
                <?php if ($log['target_count'] > 0 && $log['error_count'] > 0): ?>
                <span style="color:#666; margin-left:10px;">(<?php echo round(($log['error_count'] / $log['target_count']) * 100, 1) ?>%)</span>
                <?php endif; ?>
            </td>
        </tr>
        <?php endif; ?>
    </table>
</div>

<?php if ($log['type'] == 'send' && $log['error_count'] > 0): ?>
<!-- 발송 실패 원인 분석 -->
<div style="margin-top:15px; padding:10px; background:#fff3cd; border:1px solid #ffeaa7; border-radius:3px;">
    <h5 style="margin:0 0 5px 0; color:#856404;">📊 발송 실패 분석</h5>
    <div style="font-size:11px; color:#856404;">
        <p style="margin:5px 0;">실패율이 <?php echo round(($log['error_count'] / $log['target_count']) * 100, 1) ?>%입니다. 일반적인 실패 원인:</p>
        <ul style="margin:5px 0; padding-left:20px;">
            <li><strong>구독 만료:</strong> 사용자가 브라우저 설정을 변경했거나 쿠키를 삭제한 경우</li>
            <li><strong>네트워크 오류:</strong> 일시적인 네트워크 연결 문제</li>
            <li><strong>단말기 오프라인:</strong> 사용자의 기기가 인터넷에 연결되지 않은 상태</li>
            <li><strong>브라우저 차단:</strong> 브라우저에서 알림을 차단한 경우</li>
            <li><strong>서비스 제한:</strong> 푸시 서비스 제공업체의 일시적 제한</li>
        </ul>
        <?php if ($log['error_count'] / $log['target_count'] > 0.1): ?>
        <p style="margin:5px 0; color:#dc3545;"><strong>권장사항:</strong> 실패율이 10%를 초과합니다. 구독자 목록을 정리하거나 API 설정을 확인해보세요.</p>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>

<?php
// 시간 경과 표시 함수
function time_since($datetime) {
    $time = time() - strtotime($datetime);
    
    if ($time < 60) {
        return $time . '초 전';
    } elseif ($time < 3600) {
        return floor($time / 60) . '분 전';
    } elseif ($time < 86400) {
        return floor($time / 3600) . '시간 전';
    } else {
        return floor($time / 86400) . '일 전';
    }
}
?>