<?php
$sub_menu = '750300';

include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

auth_check_menu($auth, $sub_menu, "w");

$g5['title'] = '푸시매니저 구독자 현황';
include_once(G5_ADMIN_PATH.'/admin.head.php');

// 설정 확인
$config = get_pushmanager_config();
if (!$config) {
    alert('푸시매니저 설정이 필요합니다.', './api_config.php');
}

// 페이징 설정
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$per_page = 20;
$offset = ($page - 1) * $per_page;

// 검색 조건
$search_type = isset($_GET['search_type']) ? clean_xss_tags($_GET['search_type']) : '';
$search_keyword = isset($_GET['search_keyword']) ? clean_xss_tags($_GET['search_keyword']) : '';
$status_filter = isset($_GET['status_filter']) ? clean_xss_tags($_GET['status_filter']) : '';
$view_type = isset($_GET['view_type']) ? clean_xss_tags($_GET['view_type']) : 'member'; // member, device

// 구독자 삭제 처리 (특정 단말기만)
if (isset($_POST['delete_device']) && $_POST['delete_device']) {
    $subscription_id = intval($_POST['subscription_id']);
    
    if ($subscription_id > 0) {
        $sql = "DELETE FROM pushmanager_subscriptions WHERE id = {$subscription_id}";
        $result = sql_query($sql);
        
        if ($result) {
            log_pushmanager_activity('config', '단말기 구독 삭제', "구독 ID: {$subscription_id}");
            alert('해당 단말기의 구독이 삭제되었습니다.', './push_subscribers.php');
        } else {
            alert('구독 삭제에 실패했습니다.');
        }
    }
}

// 회원의 모든 단말기 삭제 처리
if (isset($_POST['delete_member_all']) && $_POST['delete_member_all']) {
    $member_id = clean_xss_tags($_POST['member_id']);
    
    if (!empty($member_id)) {
        $sql = "DELETE FROM pushmanager_subscriptions WHERE member_id = '{$member_id}'";
        $result = sql_query($sql);
        
        if ($result) {
            log_pushmanager_activity('config', '회원 전체 구독 삭제', "회원 ID: {$member_id}");
            alert('해당 회원의 모든 구독이 삭제되었습니다.', './push_subscribers.php');
        } else {
            alert('구독 삭제에 실패했습니다.');
        }
    }
}

// 일괄 삭제 처리
if (isset($_POST['bulk_delete']) && $_POST['bulk_delete']) {
    if ($view_type == 'member') {
        // 회원별 보기에서는 선택된 회원들의 모든 구독 삭제
        $selected_members = $_POST['selected_members'] ?? array();
        
        if (!empty($selected_members) && is_array($selected_members)) {
            $member_list = "'" . implode("','", array_map('addslashes', $selected_members)) . "'";
            $sql = "DELETE FROM pushmanager_subscriptions WHERE member_id IN ({$member_list})";
            $result = sql_query($sql);
            
            if ($result) {
                $count = count($selected_members);
                log_pushmanager_activity('config', '회원 일괄 구독삭제', "삭제된 회원 수: {$count}명");
                alert("{$count}명의 회원 구독이 모두 삭제되었습니다.", './push_subscribers.php');
            } else {
                alert('구독 삭제에 실패했습니다.');
            }
        }
    } else {
        // 단말기별 보기에서는 선택된 구독 ID들만 삭제
        $selected_ids = $_POST['selected_ids'] ?? array();
        
        if (!empty($selected_ids) && is_array($selected_ids)) {
            $ids = implode(',', array_map('intval', $selected_ids));
            $sql = "DELETE FROM pushmanager_subscriptions WHERE id IN ({$ids})";
            $result = sql_query($sql);
            
            if ($result) {
                $count = count($selected_ids);
                log_pushmanager_activity('config', '단말기 일괄삭제', "삭제된 구독 수: {$count}개");
                alert("{$count}개의 구독이 삭제되었습니다.", './push_subscribers.php');
            } else {
                alert('구독 삭제에 실패했습니다.');
            }
        }
    }
    
    if (empty($selected_members) && empty($selected_ids)) {
        alert('삭제할 항목을 선택해주세요.');
    }
}

// 구독자 통계
$subscription_stats = get_subscription_stats();

// 검색 조건 구성
$where_clause = "1=1";
$search_params = array();

if (!empty($search_keyword)) {
    switch ($search_type) {
        case 'member_id':
            $where_clause .= " AND ps.member_id LIKE '%{$search_keyword}%'";
            break;
        case 'member_name':
            $where_clause .= " AND m.mb_name LIKE '%{$search_keyword}%'";
            break;
        case 'ip_address':
            $where_clause .= " AND ps.ip_address LIKE '%{$search_keyword}%'";
            break;
    }
    $search_params[] = "search_type={$search_type}";
    $search_params[] = "search_keyword=" . urlencode($search_keyword);
}

if ($status_filter !== '') {
    if ($status_filter == '1') {
        $where_clause .= " AND ps.is_active = 1";
    } else {
        $where_clause .= " AND ps.is_active = 0";
    }
    $search_params[] = "status_filter={$status_filter}";
}

$search_params[] = "view_type={$view_type}";

if ($view_type == 'member') {
    // 회원별 그룹화 보기
    
    // 전체 회원 수 조회 (구독이 있는 회원만)
    $count_sql = "SELECT COUNT(DISTINCT CASE WHEN ps.member_id IS NOT NULL AND ps.member_id != '' THEN ps.member_id ELSE CONCAT('guest_', ps.id) END) as cnt 
                  FROM pushmanager_subscriptions ps 
                  LEFT JOIN {$g5['member_table']} m ON ps.member_id = m.mb_id 
                  WHERE {$where_clause}";
    $count_result = sql_fetch($count_sql);
    $total_count = $count_result['cnt'];
    
    // 회원별 구독 현황 조회
    $list_sql = "SELECT 
                    CASE WHEN ps.member_id IS NOT NULL AND ps.member_id != '' THEN ps.member_id ELSE CONCAT('guest_', MIN(ps.id)) END as member_key,
                    ps.member_id,
                    m.mb_name, 
                    m.mb_email, 
                    m.mb_level,
                    COUNT(*) as device_count,
                    SUM(CASE WHEN ps.is_active = 1 THEN 1 ELSE 0 END) as active_count,
                    MIN(ps.created_at) as first_subscription,
                    MAX(ps.updated_at) as last_updated,
                    GROUP_CONCAT(ps.id) as subscription_ids,
                    GROUP_CONCAT(ps.is_active) as device_status
                 FROM pushmanager_subscriptions ps 
                 LEFT JOIN {$g5['member_table']} m ON ps.member_id = m.mb_id 
                 WHERE {$where_clause} 
                 GROUP BY CASE WHEN ps.member_id IS NOT NULL AND ps.member_id != '' THEN ps.member_id ELSE CONCAT('guest_', ps.id) END
                 ORDER BY last_updated DESC 
                 LIMIT {$offset}, {$per_page}";
} else {
    // 단말기별 보기 (기존 방식)
    
    // 전체 구독자 수 조회
    $count_sql = "SELECT COUNT(*) as cnt 
                  FROM pushmanager_subscriptions ps 
                  LEFT JOIN {$g5['member_table']} m ON ps.member_id = m.mb_id 
                  WHERE {$where_clause}";
    $count_result = sql_fetch($count_sql);
    $total_count = $count_result['cnt'];
    
    // 구독자 목록 조회
    $list_sql = "SELECT ps.*, m.mb_name, m.mb_email, m.mb_level 
                 FROM pushmanager_subscriptions ps 
                 LEFT JOIN {$g5['member_table']} m ON ps.member_id = m.mb_id 
                 WHERE {$where_clause} 
                 ORDER BY ps.created_at DESC 
                 LIMIT {$offset}, {$per_page}";
}

$list_result = sql_query($list_sql);

// 페이징
$total_pages = ceil($total_count / $per_page);
$query_string = !empty($search_params) ? '&' . implode('&', $search_params) : '';

// 레벨별 구독자 통계
$level_stats_sql = "SELECT m.mb_level, COUNT(DISTINCT ps.member_id) as member_cnt, COUNT(*) as device_cnt 
                    FROM pushmanager_subscriptions ps 
                    INNER JOIN {$g5['member_table']} m ON ps.member_id = m.mb_id 
                    WHERE ps.is_active = 1 
                    GROUP BY m.mb_level 
                    ORDER BY m.mb_level";
$level_stats_result = sql_query($level_stats_sql);
$level_stats = array();
while ($row = sql_fetch_array($level_stats_result)) {
    $level_stats[$row['mb_level']] = $row;
}

// 성별 구독자 통계
$gender_stats_sql = "SELECT m.mb_sex, COUNT(DISTINCT ps.member_id) as member_cnt, COUNT(*) as device_cnt 
                     FROM pushmanager_subscriptions ps 
                     INNER JOIN {$g5['member_table']} m ON ps.member_id = m.mb_id 
                     WHERE ps.is_active = 1 
                     GROUP BY m.mb_sex";
$gender_stats_result = sql_query($gender_stats_sql);
$gender_stats = array('M' => array('member_cnt' => 0, 'device_cnt' => 0), 'F' => array('member_cnt' => 0, 'device_cnt' => 0));
while ($row = sql_fetch_array($gender_stats_result)) {
    if (in_array($row['mb_sex'], array('M', 'F'))) {
        $gender_stats[$row['mb_sex']] = $row;
    }
}

// 최근 가입 구독자 수 (7일)
$recent_sql = "SELECT COUNT(*) as cnt FROM pushmanager_subscriptions WHERE created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)";
$recent_result = sql_fetch($recent_sql);
$recent_count = $recent_result['cnt'];

// 엔드포인트 마스킹 함수
function mask_endpoint($endpoint) {
    if (empty($endpoint)) return '';
    
    $url_parts = parse_url($endpoint);
    $domain = $url_parts['host'] ?? '';
    $path = $url_parts['path'] ?? '';
    
    // 도메인과 처음 몇 글자, 마지막 몇 글자만 표시
    if (strlen($path) > 20) {
        $masked_path = substr($path, 0, 10) . '***' . substr($path, -7);
    } else {
        $masked_path = substr($path, 0, 5) . '***';
    }
    
    return $domain . $masked_path;
}
?>

<div class="local_desc01 local_desc">
    <p>
        푸시 알림을 구독한 사용자들의 현황을 조회하고 관리할 수 있습니다.<br>
        회원별로 여러 단말기의 구독 현황을 확인하고 필요한 경우 구독을 해지할 수 있습니다.
    </p>
</div>

<!-- 구독자 통계 -->
<div class="tbl_frm01 tbl_wrap">
    <table>
        <caption>구독자 통계</caption>
        <colgroup>
            <col class="grid_4">
            <col>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row">전체 구독 수</th>
                <td><strong class="fc_197"><?php echo number_format($subscription_stats['total']) ?>개</strong></td>
                <th scope="row">활성 구독 수</th>
                <td><strong class="fc_373"><?php echo number_format($subscription_stats['active']) ?>개</strong></td>
            </tr>
            <tr>
                <th scope="row">회원 구독</th>
                <td><?php echo number_format($subscription_stats['member']) ?>개</td>
                <th scope="row">비회원 구독</th>
                <td><?php echo number_format($subscription_stats['guest']) ?>개</td>
            </tr>
            <tr>
                <th scope="row">최근 7일 가입</th>
                <td><?php echo number_format($recent_count) ?>개</td>
                <th scope="row">비활성 구독</th>
                <td><?php echo number_format($subscription_stats['inactive']) ?>개</td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 레벨별/성별 통계 -->
<?php if (!empty($level_stats) || !empty($gender_stats)): ?>
<div class="tbl_frm01 tbl_wrap" style="margin-top:20px;">
    <table>
        <caption>레벨별/성별 구독자 현황</caption>
        <colgroup>
            <col class="grid_4">
            <col>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <?php if (!empty($level_stats)): ?>
            <tr>
                <th scope="row">레벨별 구독자</th>
                <td colspan="3">
                    <?php foreach ($level_stats as $level => $stat): ?>
                        <span style="display:inline-block; margin:2px 10px 2px 0;">
                            <?php echo $level ?>레벨: <strong><?php echo number_format($stat['member_cnt']) ?>명</strong> 
                            (<?php echo number_format($stat['device_cnt']) ?>개 구독)
                        </span>
                    <?php endforeach; ?>
                </td>
            </tr>
            <?php endif; ?>
            <tr>
                <th scope="row">성별 구독자</th>
                <td colspan="3">
                    <span style="display:inline-block; margin:2px 10px 2px 0;">
                        남성: <strong><?php echo number_format($gender_stats['M']['member_cnt']) ?>명</strong> 
                        (<?php echo number_format($gender_stats['M']['device_cnt']) ?>개 구독)
                    </span>
                    <span style="display:inline-block; margin:2px 10px 2px 0;">
                        여성: <strong><?php echo number_format($gender_stats['F']['member_cnt']) ?>명</strong> 
                        (<?php echo number_format($gender_stats['F']['device_cnt']) ?>개 구독)
                    </span>
                </td>
            </tr>
        </tbody>
    </table>
</div>
<?php endif; ?>

<!-- 보기 방식 선택 및 검색 폼 -->
<div class="local_sch01 local_sch">
    <form name="fsearch" method="get">
        <fieldset>
            <legend>구독자 검색</legend>
            
            <!-- 보기 방식 선택 -->
            <label for="view_type">보기방식</label>
            <select name="view_type" id="view_type" onchange="this.form.submit()">
                <option value="member"<?php echo $view_type == 'member' ? ' selected' : '' ?>>회원별 보기</option>
                <option value="device"<?php echo $view_type == 'device' ? ' selected' : '' ?>>단말기별 보기</option>
            </select>
            
            <label for="search_type" class="sound_only">검색대상</label>
            <select name="search_type" id="search_type">
                <option value="">전체</option>
                <option value="member_id"<?php echo $search_type == 'member_id' ? ' selected' : '' ?>>회원ID</option>
                <option value="member_name"<?php echo $search_type == 'member_name' ? ' selected' : '' ?>>회원명</option>
                <?php if ($view_type == 'device'): ?>
                <option value="ip_address"<?php echo $search_type == 'ip_address' ? ' selected' : '' ?>>IP주소</option>
                <?php endif; ?>
            </select>
            <label for="search_keyword" class="sound_only">검색어</label>
            <input type="text" name="search_keyword" id="search_keyword" value="<?php echo $search_keyword ?>" placeholder="검색어를 입력하세요">
            
            <label for="status_filter" class="sound_only">상태</label>
            <select name="status_filter" id="status_filter">
                <option value="">전체</option>
                <option value="1"<?php echo $status_filter === '1' ? ' selected' : '' ?>>활성만</option>
                <option value="0"<?php echo $status_filter === '0' ? ' selected' : '' ?>>비활성만</option>
            </select>
            
            <input type="submit" value="검색" class="btn_submit">
            <a href="./push_subscribers.php?view_type=<?php echo $view_type ?>" class="btn btn_06">전체목록</a>
        </fieldset>
    </form>
</div>

<!-- 구독자 목록 -->
<form name="flist" method="post" onsubmit="return confirmBulkDelete()">
<input type="hidden" name="view_type" value="<?php echo $view_type ?>">

<?php if ($view_type == 'member'): ?>
<!-- 회원별 보기 -->
<div class="tbl_head01 tbl_wrap">
    <table>
        <caption>회원별 구독 현황</caption>
        <thead>
        <tr>
            <th scope="col">
                <label for="chkall" class="sound_only">전체</label>
                <input type="checkbox" name="chkall" id="chkall" onclick="check_all(this.form)">
            </th>
            <th scope="col">회원 정보</th>
            <th scope="col">구독 현황</th>
            <th scope="col">구독 기간</th>
            <th scope="col">상태</th>
            <th scope="col">관리</th>
        </tr>
        </thead>
        <tbody>
        <?php
        if (sql_num_rows($list_result) > 0) {
            while ($row = sql_fetch_array($list_result)) {
                $is_member = !empty($row['member_id']);
                $member_key = $is_member ? $row['member_id'] : $row['member_key'];
                $active_ratio = $row['device_count'] > 0 ? round(($row['active_count'] / $row['device_count']) * 100) : 0;
                
                // 단말기별 상태 분석
                $device_statuses = explode(',', $row['device_status']);
                $status_counts = array_count_values($device_statuses);
                $active_devices = $status_counts['1'] ?? 0;
                $inactive_devices = $status_counts['0'] ?? 0;
        ?>
        <tr>
            <td class="td_chk">
                <label for="chk_<?php echo htmlspecialchars($member_key) ?>" class="sound_only"><?php echo htmlspecialchars($member_key) ?> 선택</label>
                <input type="checkbox" name="selected_members[]" value="<?php echo htmlspecialchars($member_key) ?>" id="chk_<?php echo htmlspecialchars($member_key) ?>">
            </td>
            <td class="td_left">
                <?php if ($is_member): ?>
                    <strong><?php echo $row['member_id'] ?></strong>
                    <?php if ($row['mb_name']): ?>
                        <br><span style="color:#666;"><?php echo $row['mb_name'] ?></span>
                    <?php endif; ?>
                    <?php if ($row['mb_level']): ?>
                        <br><span style="font-size:11px; color:#999;">레벨: <?php echo $row['mb_level'] ?></span>
                    <?php endif; ?>
                <?php else: ?>
                    <span style="color:#999;">비회원</span>
                    <br><span style="font-size:11px;">Guest ID: <?php echo substr($member_key, 6) ?></span>
                <?php endif; ?>
            </td>
            <td class="td_center">
                <div style="font-size:12px;">
                    <strong>총 <?php echo $row['device_count'] ?>개 단말기</strong><br>
                    <span class="fc_373">활성: <?php echo $active_devices ?>개</span> / 
                    <span class="fc_999">비활성: <?php echo $inactive_devices ?>개</span><br>
                    <div style="margin-top:3px;">
                        <div style="background:#f0f0f0; height:8px; border-radius:4px; overflow:hidden;">
                            <div style="background:#28a745; height:100%; width:<?php echo $active_ratio ?>%; transition:width 0.3s;"></div>
                        </div>
                        <span style="font-size:10px; color:#666;"><?php echo $active_ratio ?>% 활성</span>
                    </div>
                </div>
            </td>
            <td class="td_center">
                <div style="font-size:11px;">
                    <strong>최초:</strong> <?php echo date('Y-m-d', strtotime($row['first_subscription'])) ?><br>
                    <strong>최근:</strong> <?php echo date('Y-m-d H:i', strtotime($row['last_updated'])) ?>
                </div>
            </td>
            <td class="td_center">
                <?php if ($active_devices > 0): ?>
                    <span class="fc_373">활성</span>
                <?php else: ?>
                    <span class="fc_999">비활성</span>
                <?php endif; ?>
            </td>
            <td class="td_center">
                <button type="button" onclick="showDeviceDetails('<?php echo htmlspecialchars($member_key) ?>')" class="btn_03 btn">상세</button>
                <button type="button" onclick="deleteMemberAll('<?php echo htmlspecialchars($member_key) ?>')" class="btn_02 btn">전체삭제</button>
            </td>
        </tr>
        <?php
            }
        } else {
        ?>
        <tr>
            <td colspan="6" class="empty_table">구독자가 없습니다.</td>
        </tr>
        <?php } ?>
        </tbody>
    </table>
</div>

<?php else: ?>
<!-- 단말기별 보기 (기존 방식) -->
<div class="tbl_head01 tbl_wrap">
    <table>
        <caption>단말기별 구독 현황</caption>
        <thead>
        <tr>
            <th scope="col">
                <label for="chkall" class="sound_only">전체</label>
                <input type="checkbox" name="chkall" id="chkall" onclick="check_all(this.form)">
            </th>
            <th scope="col">구독자 정보</th>
            <th scope="col">구독 정보</th>
            <th scope="col">접속 정보</th>
            <th scope="col">상태</th>
            <th scope="col">관리</th>
        </tr>
        </thead>
        <tbody>
        <?php
        if (sql_num_rows($list_result) > 0) {
            while ($row = sql_fetch_array($list_result)) {
                $is_member = !empty($row['member_id']);
                $status_class = $row['is_active'] ? 'fc_373' : 'fc_999';
                $status_text = $row['is_active'] ? '활성' : '비활성';
        ?>
        <tr>
            <td class="td_chk">
                <label for="chk_<?php echo $row['id'] ?>" class="sound_only"><?php echo $row['id'] ?> 선택</label>
                <input type="checkbox" name="selected_ids[]" value="<?php echo $row['id'] ?>" id="chk_<?php echo $row['id'] ?>">
            </td>
            <td class="td_left">
                <?php if ($is_member): ?>
                    <strong><?php echo $row['member_id'] ?></strong>
                    <?php if ($row['mb_name']): ?>
                        <br><span style="color:#666;"><?php echo $row['mb_name'] ?></span>
                    <?php endif; ?>
                    <?php if ($row['mb_level']): ?>
                        <br><span style="font-size:11px; color:#999;">레벨: <?php echo $row['mb_level'] ?></span>
                    <?php endif; ?>
                <?php else: ?>
                    <span style="color:#999;">비회원</span>
                    <br><span style="font-size:11px;">세션 구독</span>
                <?php endif; ?>
            </td>
            <td class="td_left">
                <div style="font-size:11px;">
                    <strong>가입:</strong> <?php echo date('Y-m-d H:i', strtotime($row['created_at'])) ?><br>
                    <?php if ($row['updated_at'] != $row['created_at']): ?>
                    <strong>갱신:</strong> <?php echo date('Y-m-d H:i', strtotime($row['updated_at'])) ?><br>
                    <?php endif; ?>
                    <strong>엔드포인트:</strong><br>
                    <span style="word-break:break-all; color:#666; font-family:monospace; font-size:10px;">
                        <?php echo mask_endpoint($row['endpoint']) ?>
                    </span>
                </div>
            </td>
            <td class="td_left">
                <div style="font-size:11px;">
                    <?php if ($row['ip_address']): ?>
                    <strong>IP:</strong> <?php echo $row['ip_address'] ?><br>
                    <?php endif; ?>
                    <?php if ($row['user_agent']): ?>
                    <strong>브라우저:</strong><br>
                    <span style="color:#666;">
                        <?php echo mb_substr($row['user_agent'], 0, 40) . (mb_strlen($row['user_agent']) > 40 ? '...' : '') ?>
                    </span>
                    <?php endif; ?>
                </div>
            </td>
            <td class="td_center">
                <span class="<?php echo $status_class ?>"><?php echo $status_text ?></span>
            </td>
            <td class="td_center">
                <button type="button" onclick="deleteDevice(<?php echo $row['id'] ?>)" class="btn_03 btn">삭제</button>
            </td>
        </tr>
        <?php
            }
        } else {
        ?>
        <tr>
            <td colspan="6" class="empty_table">구독자가 없습니다.</td>
        </tr>
        <?php } ?>
        </tbody>
    </table>
</div>
<?php endif; ?>

<?php if ($total_count > 0): ?>
<div class="btn_fixed_top">
    <input type="submit" name="bulk_delete" value="선택삭제" class="btn_02 btn">
</div>
<?php endif; ?>
</form>

<!-- 페이징 -->
<?php if ($total_pages > 1): ?>
<nav class="pg_wrap">
    <div class="pg">
        <?php
        $prev_page = max(1, $page - 1);
        $next_page = min($total_pages, $page + 1);
        $start_page = max(1, $page - 5);
        $end_page = min($total_pages, $page + 5);
        ?>
        
        <?php if ($page > 1): ?>
        <a href="?page=1<?php echo $query_string ?>" class="pg_page pg_start">처음</a>
        <a href="?page=<?php echo $prev_page ?><?php echo $query_string ?>" class="pg_page pg_prev">이전</a>
        <?php endif; ?>
        
        <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
            <?php if ($i == $page): ?>
            <strong class="pg_current"><?php echo $i ?></strong>
            <?php else: ?>
            <a href="?page=<?php echo $i ?><?php echo $query_string ?>" class="pg_page"><?php echo $i ?></a>
            <?php endif; ?>
        <?php endfor; ?>
        
        <?php if ($page < $total_pages): ?>
        <a href="?page=<?php echo $next_page ?><?php echo $query_string ?>" class="pg_page pg_next">다음</a>
        <a href="?page=<?php echo $total_pages ?><?php echo $query_string ?>" class="pg_page pg_end">마지막</a>
        <?php endif; ?>
    </div>
</nav>
<?php endif; ?>

<!-- 단말기 상세 모달 (회원별 보기에서 사용) -->
<div id="deviceModal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:1000;">
    <div style="position:absolute; top:50%; left:50%; transform:translate(-50%,-50%); background:white; padding:20px; border-radius:5px; max-width:800px; width:90%; max-height:80%; overflow-y:auto;">
        <h3 style="margin-top:0;">단말기별 구독 현황</h3>
        <div id="deviceModalContent">
            로딩 중...
        </div>
        <div style="text-align:center; margin-top:20px;">
            <button type="button" onclick="closeDeviceModal()" class="btn_02 btn">닫기</button>
        </div>
    </div>
</div>

<script>
function check_all(form) {
    var checkboxes = form.querySelectorAll('input[name="selected_ids[]"], input[name="selected_members[]"]');
    var checkAll = form.querySelector('#chkall');
    
    checkboxes.forEach(function(checkbox) {
        checkbox.checked = checkAll.checked;
    });
}

function deleteDevice(id) {
    if (!confirm('이 단말기의 구독을 삭제하시겠습니까?\\n삭제된 단말기는 더 이상 푸시 알림을 받을 수 없습니다.')) {
        return false;
    }
    
    var form = document.createElement('form');
    form.method = 'post';
    form.innerHTML = '<input type="hidden" name="delete_device" value="1">' +
                     '<input type="hidden" name="subscription_id" value="' + id + '">';
    document.body.appendChild(form);
    form.submit();
}

function deleteMemberAll(memberId) {
    if (!confirm('이 회원의 모든 단말기 구독을 삭제하시겠습니까?\\n삭제된 후에는 해당 회원의 모든 단말기에서 푸시 알림을 받을 수 없습니다.')) {
        return false;
    }
    
    var form = document.createElement('form');
    form.method = 'post';
    form.innerHTML = '<input type="hidden" name="delete_member_all" value="1">' +
                     '<input type="hidden" name="member_id" value="' + memberId + '">';
    document.body.appendChild(form);
    form.submit();
}

function confirmBulkDelete() {
    var viewType = document.querySelector('input[name="view_type"]').value;
    var checked;
    
    if (viewType === 'member') {
        checked = document.querySelectorAll('input[name="selected_members[]"]:checked');
        var itemType = '회원';
        var actionDesc = '회원들의 모든 구독';
    } else {
        checked = document.querySelectorAll('input[name="selected_ids[]"]:checked');
        var itemType = '단말기';
        var actionDesc = '단말기 구독';
    }
    
    if (checked.length === 0) {
        alert('삭제할 ' + itemType + '을 선택해주세요.');
        return false;
    }
    
    return confirm('선택된 ' + checked.length + '개의 ' + actionDesc + '을 삭제하시겠습니까?\\n삭제된 후에는 더 이상 푸시 알림을 받을 수 없습니다.');
}

function showDeviceDetails(memberKey) {
    var modal = document.getElementById('deviceModal');
    var content = document.getElementById('deviceModalContent');
    
    modal.style.display = 'block';
    content.innerHTML = '로딩 중...';
    
    // AJAX로 해당 회원의 단말기 목록 조회
    fetch('./push_device_details.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'member_key=' + encodeURIComponent(memberKey)
    })
    .then(response => response.text())
    .then(data => {
        content.innerHTML = data;
    })
    .catch(error => {
        content.innerHTML = '데이터 로딩 중 오류가 발생했습니다.';
        console.error('Error:', error);
    });
}

function closeDeviceModal() {
    document.getElementById('deviceModal').style.display = 'none';
}

// 모달 배경 클릭시 닫기
document.addEventListener('click', function(e) {
    var modal = document.getElementById('deviceModal');
    if (e.target === modal) {
        closeDeviceModal();
    }
});

// ESC 키로 모달 닫기
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeDeviceModal();
    }
});
</script>

<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');
?>