<?php
// push_setting_update.php - 알림 설정 저장 처리
include_once('./_common.php');

// pushmanager.lib.php 포함
$pushmanager_lib = G5_LIB_PATH . '/pushmanager.lib.php';
if (file_exists($pushmanager_lib)) {
    include_once($pushmanager_lib);
} else {
    alert('Push Manager 라이브러리를 찾을 수 없습니다.', './notification_setting.php');
}

// POST 요청만 허용
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    alert('잘못된 접근입니다.', './notification_setting.php');
}

// save_settings 확인
if (!isset($_POST['save_settings'])) {
    alert('잘못된 요청입니다.', './notification_setting.php');
}

// 필수 함수 존재 확인
if (!function_exists('save_user_notification_settings')) {
    alert('설정 저장 기능을 사용할 수 없습니다.', './notification_setting.php');
}

// 설정 배열 생성
$settings = array(
    'message_notification' => isset($_POST['message_notification']) ? 1 : 0,
    'comment_notification' => isset($_POST['comment_notification']) ? 1 : 0,
    'inquiry_notification' => isset($_POST['inquiry_notification']) ? 1 : 0
);

// 알림 설정 저장
$save_success = false;
try {
    $save_success = save_user_notification_settings($settings);
} catch (Exception $e) {
    alert('설정 저장 중 오류가 발생했습니다: ' . $e->getMessage(), './notification_setting.php');
}

// 저장 실패 시 수동 저장 시도
if (!$save_success) {
    global $member;
    
    if ($member['mb_id']) {
        $member_id = addslashes($member['mb_id']);
        $manual_sql = "
            INSERT INTO pushmanager_user_settings 
            (member_id, message_notification, comment_notification, inquiry_notification, created_at) 
            VALUES 
            ('{$member_id}', {$settings['message_notification']}, {$settings['comment_notification']}, {$settings['inquiry_notification']}, NOW())
            ON DUPLICATE KEY UPDATE 
            message_notification = {$settings['message_notification']},
            comment_notification = {$settings['comment_notification']},
            inquiry_notification = {$settings['inquiry_notification']},
            updated_at = NOW()
        ";
    } else {
        $session_id = session_id();
        if (empty($session_id)) {
            session_start();
            $session_id = session_id();
        }
        $session_id = addslashes($session_id);
        $manual_sql = "
            INSERT INTO pushmanager_user_settings 
            (session_id, message_notification, comment_notification, inquiry_notification, created_at) 
            VALUES 
            ('{$session_id}', {$settings['message_notification']}, {$settings['comment_notification']}, {$settings['inquiry_notification']}, NOW())
            ON DUPLICATE KEY UPDATE 
            message_notification = {$settings['message_notification']},
            comment_notification = {$settings['comment_notification']},
            inquiry_notification = {$settings['inquiry_notification']},
            updated_at = NOW()
        ";
    }
    
    $manual_result = sql_query($manual_sql, false);
    if ($manual_result) {
        $save_success = true;
    } else {
        alert('설정 저장에 실패했습니다. 다시 시도해주세요.', './notification_setting.php');
    }
}

// 알림 설정 저장 성공 시 기기별 설정 처리
if ($save_success && function_exists('get_user_devices') && function_exists('toggle_device_notification')) {
    // 모든 기기 목록 가져오기
    $all_devices = get_user_devices();
    
    // 체크된 기기들 활성화
    if (isset($_POST['device_settings']) && is_array($_POST['device_settings'])) {
        foreach ($_POST['device_settings'] as $device_id => $is_active) {
            toggle_device_notification(intval($device_id), 1);
        }
    }
    
    // 체크되지 않은 기기들 비활성화
    foreach ($all_devices as $device) {
        if (!isset($_POST['device_settings'][$device['id']])) {
            toggle_device_notification($device['id'], 0);
        }
    }
}

// 성공 메시지와 함께 원래 페이지로 리다이렉트
if ($save_success) {
    alert('설정이 성공적으로 저장되었습니다.', './notification_setting.php');
} else {
    alert('설정 저장에 실패했습니다. 다시 시도해주세요.', './notification_setting.php');
}
?>