<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>앱 설치하기</title>
    <link rel="manifest" href="./manifest.json">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, rgba(30, 41, 59, 0.95) 0%, rgba(51, 65, 85, 0.95) 100%), 
                        url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="20" cy="20" r="1" fill="%23ffffff" opacity="0.1"/><circle cx="80" cy="40" r="1" fill="%23ffffff" opacity="0.1"/><circle cx="40" cy="80" r="1" fill="%23ffffff" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            line-height: 1.6;
            color: white;
        }

        .container {
            text-align: center;
            max-width: 600px;
            width: 100%;
        }

        .brand {
            font-size: 14px;
            font-weight: 600;
            letter-spacing: 2px;
            text-transform: uppercase;
            color: #94a3b8;
            margin-bottom: 32px;
        }

        .hero-title {
            font-size: 48px;
            font-weight: 700;
            line-height: 1.1;
            margin-bottom: 24px;
            background: linear-gradient(135deg, #ffffff 0%, #e2e8f0 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .hero-description {
            font-size: 18px;
            color: #cbd5e1;
            margin-bottom: 48px;
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }

        .install-section {
            margin-bottom: 40px;
        }

        .install-section.hidden {
            display: none;
        }

        .install-button {
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
            color: white;
            border: none;
            padding: 18px 36px;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 8px 32px rgba(99, 102, 241, 0.3);
            margin-right: 16px;
            margin-bottom: 16px;
            display: inline-block;
        }

        .install-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 40px rgba(99, 102, 241, 0.4);
        }

        .steps-container {
            background: rgba(30, 41, 59, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 40px;
            margin-top: 32px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .steps-title {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 24px;
            color: white;
        }

        .steps {
            counter-reset: step-counter;
            text-align: left;
        }

        .step {
            margin-bottom: 20px;
            padding-left: 40px;
            position: relative;
        }

        .step:last-child {
            margin-bottom: 0;
        }

        .step::before {
            content: counter(step-counter);
            counter-increment: step-counter;
            position: absolute;
            left: 0;
            top: 2px;
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
            color: white;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
            font-weight: 600;
            box-shadow: 0 4px 12px rgba(99, 102, 241, 0.4);
        }

        .step-title {
            font-weight: 600;
            color: white;
            margin-bottom: 4px;
            font-size: 16px;
        }

        .step-description {
            color: #94a3b8;
            font-size: 14px;
        }

        .info-box {
            background: rgba(30, 41, 59, 0.8);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            padding: 24px;
            margin-top: 32px;
        }

        .info-box p {
            color: #cbd5e1;
            font-size: 16px;
            margin: 0;
        }

        .benefits {
            margin-top: 48px;
            background: rgba(30, 41, 59, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 40px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .benefits h3 {
            font-size: 24px;
            font-weight: 600;
            color: white;
            margin-bottom: 32px;
            text-align: center;
        }

        .benefit-list {
            display: grid;
            gap: 24px;
            max-width: 400px;
            margin: 0 auto;
        }

        .benefit-item {
            text-align: center;
            padding: 20px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .benefit-title {
            font-weight: 600;
            color: white;
            margin-bottom: 8px;
            font-size: 16px;
        }

        .benefit-desc {
            color: #94a3b8;
            font-size: 14px;
        }

        @media (max-width: 768px) {
            .hero-title {
                font-size: 36px;
            }
            
            .hero-description {
                font-size: 16px;
            }
            
            .steps-container,
            .benefits {
                padding: 24px;
            }
            
            .install-button {
                width: 100%;
                margin-right: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="brand">PWA INSTALLER</div>
        
        <h1 class="hero-title">홈화면에 앱 추가하기</h1>
        
        <p class="hero-description">
            더 빠르고 편리한 앱 경험을 위해 홈화면에 설치하세요. 
            브라우저 없이 네이티브 앱처럼 사용할 수 있습니다.
        </p>
        
        <!-- PWA 설치 버튼 -->
        <div id="pwa-install-section" class="install-section hidden">
            <button id="install-button" class="install-button">
                지금 설치하기
            </button>
        </div>

        <!-- iOS 안내 -->
        <div id="ios-install-section" class="install-section hidden">
            <div class="steps-container">
                <div class="steps-title">iOS에서 홈화면에 추가하기</div>
                <div class="steps">
                    <div class="step">
                        <div class="step-title">공유 버튼 탭</div>
                        <div class="step-description">화면 하단의 공유 버튼을 탭하세요</div>
                    </div>
                    <div class="step">
                        <div class="step-title">홈 화면에 추가</div>
                        <div class="step-description">메뉴에서 '홈 화면에 추가'를 선택하세요</div>
                    </div>
                    <div class="step">
                        <div class="step-title">추가 완료</div>
                        <div class="step-description">우상단 '추가' 버튼을 탭하세요</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Android 안내 -->
        <div id="android-install-section" class="install-section hidden">
            <div class="steps-container">
                <div class="steps-title">Android에서 앱 설치하기</div>
                <div class="steps">
                    <div class="step">
                        <div class="step-title">메뉴 열기</div>
                        <div class="step-description">우상단 점 세 개 메뉴를 탭하세요</div>
                    </div>
                    <div class="step">
                        <div class="step-title">앱 설치</div>
                        <div class="step-description">'앱 설치' 또는 '홈 화면에 추가'를 선택하세요</div>
                    </div>
                    <div class="step">
                        <div class="step-title">설치 완료</div>
                        <div class="step-description">확인 버튼을 탭하세요</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- 기타 브라우저 -->
        <div id="other-browser-section" class="install-section hidden">
            <div class="info-box">
                <p>Chrome, Safari, Edge에서 접속하면 앱 설치가 가능합니다</p>
            </div>
        </div>

        <!-- PWA 설치 장점 -->
        <div class="benefits">
            <h3>앱 설치 시 장점</h3>
            <div class="benefit-list">
                <div class="benefit-item">
                    <div class="benefit-title">빠른 실행</div>
                    <div class="benefit-desc">홈화면에서 바로 접속</div>
                </div>
                <div class="benefit-item">
                    <div class="benefit-title">푸시 알림</div>
                    <div class="benefit-desc">중요한 업데이트를 놓치지 않음</div>
                </div>
                <div class="benefit-item">
                    <div class="benefit-title">전체화면</div>
                    <div class="benefit-desc">브라우저 UI 없이 깔끔한 화면</div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function detectDevice() {
            const userAgent = navigator.userAgent;
            const isIOS = /iPad|iPhone|iPod/.test(userAgent);
            const isAndroid = /Android/.test(userAgent);
            const isSafari = /Safari/.test(userAgent) && !/Chrome/.test(userAgent);
            const isChrome = /Chrome/.test(userAgent);

            return { isIOS, isAndroid, isSafari, isChrome };
        }

        let deferredPrompt;
        const installButton = document.getElementById('install-button');

        window.addEventListener('beforeinstallprompt', (e) => {
            e.preventDefault();
            deferredPrompt = e;
            document.getElementById('pwa-install-section').classList.remove('hidden');
        });

        installButton.addEventListener('click', async () => {
            if (deferredPrompt) {
                deferredPrompt.prompt();
                const { outcome } = await deferredPrompt.userChoice;
                deferredPrompt = null;
                
                if (outcome === 'accepted') {
                    document.getElementById('pwa-install-section').classList.add('hidden');
                }
            }
        });

        window.addEventListener('appinstalled', () => {
            document.getElementById('pwa-install-section').classList.add('hidden');
        });

        function init() {
            const device = detectDevice();
            
            if (window.matchMedia && window.matchMedia('(display-mode: standalone)').matches) {
                document.querySelector('.hero-title').textContent = '앱이 설치되어 있습니다';
                document.querySelector('.hero-description').textContent = '현재 설치된 앱에서 실행 중입니다';
                return;
            }

            if (device.isIOS && device.isSafari) {
                document.getElementById('ios-install-section').classList.remove('hidden');
            } else if (device.isAndroid && device.isChrome) {
                document.getElementById('android-install-section').classList.remove('hidden');
                
                setTimeout(() => {
                    if (document.getElementById('pwa-install-section').classList.contains('hidden')) {
                        console.log('PWA prompt not available, showing Android instructions');
                    }
                }, 1000);
            } else if (device.isChrome || device.isEdge) {
                setTimeout(() => {
                    if (document.getElementById('pwa-install-section').classList.contains('hidden')) {
                        document.getElementById('other-browser-section').classList.remove('hidden');
                    }
                }, 1000);
            } else {
                document.getElementById('other-browser-section').classList.remove('hidden');
            }
        }

        document.addEventListener('DOMContentLoaded', init);
    </script>
</body>
</html>