<?php
$sub_menu = '700990';
include_once('./_common.php');
include_once(G5_ADMIN_PATH.'/admin.lib.php');
include_once(G5_ADMIN_PATH.'/xlog.lib.php');

// super only
if ($is_admin !== 'super') alert('최고관리자만 접근 가능합니다.');

$g5['title'] = '감사 이력 (열람/삭제)';
include_once('./admin.head.php');

// ---------------- Filters ----------------
$action = isset($_GET['action']) ? trim($_GET['action']) : '';
$target = isset($_GET['target']) ? trim($_GET['target']) : '';
$admin_id = isset($_GET['admin_id']) ? trim($_GET['admin_id']) : '';

// whitelist (from DB)
$actions = array();
$q1 = sql_query("SELECT DISTINCT action FROM g5_activity_audit ORDER BY action");
while ($r = sql_fetch_array($q1)) { if ($r['action'] !== '') $actions[] = $r['action']; }

$targets = array();
$q2 = sql_query("SELECT DISTINCT target_menu_key FROM g5_activity_audit ORDER BY target_menu_key");
while ($r = sql_fetch_array($q2)) { if ($r['target_menu_key'] !== '') $targets[] = $r['target_menu_key']; }

$where = array();
if ($action !== '' && in_array($action, $actions, true)) {
    $where[] = "action = '".sql_escape_string($action)."'";
}
if ($target !== '' && in_array($target, $targets, true)) {
    $where[] = "target_menu_key = '".sql_escape_string($target)."'";
}
if ($admin_id !== '') {
    $where[] = "admin_id = '".sql_escape_string($admin_id)."'";
}

$sql_where = '';
if (!empty($where)) $sql_where = ' WHERE '.implode(' AND ', $where);

// --------------- Query -------------------
// (간단히 최근 500건. 필요 시 페이지네이션 추가 가능)
$sql = "SELECT id, created_at, admin_id, action, target_menu_key, `filter`, affected_count, ip, user_agent
          FROM g5_activity_audit
          {$sql_where}
         ORDER BY id DESC
         LIMIT 500";
$result = sql_query($sql);

$rows = array();
for ($i=0; $row=sql_fetch_array($result); $i++) {
    // readable fields
    $row['_filter'] = $row['filter'];
    if (function_exists('xlog_ip_text')) {
        $row['_ip'] = xlog_ip_text($row['ip']);
    } else if (function_exists('inet_ntop')) {
        // ip is VARBINARY/ BLOB
        $row['_ip'] = @inet_ntop($row['ip']);
    } else {
        $row['_ip'] = '';
    }
    $rows[] = $row;
}
?>

<div class="local_ov01 local_ov">
  <form method="get" class="local_sch01" style="display:flex;gap:12px;align-items:center;flex-wrap:wrap">
    <label>행위
      <select name="action">
        <option value="">전체</option>
        <?php foreach ($actions as $a) { $sel = ($a===$action)?'selected':''; ?>
          <option value="<?php echo get_text($a); ?>" <?php echo $sel; ?>><?php echo get_text($a); ?></option>
        <?php } ?>
      </select>
    </label>
    <label>대상메뉴
      <select name="target">
        <option value="">전체</option>
        <?php foreach ($targets as $t) { $sel = ($t===$target)?'selected':''; ?>
          <option value="<?php echo get_text($t); ?>" <?php echo $sel; ?>><?php echo get_text($t); ?></option>
        <?php } ?>
      </select>
    </label>
    <label>관리자 ID
      <input type="text" name="admin_id" value="<?php echo get_text($admin_id); ?>" class="frm_input" style="width:140px;">
    </label>
    <button type="submit" class="btn btn_02">검색</button>
    <a href="<?php echo G5_ADMIN_URL.'/xlog_audit.php'; ?>" class="btn btn_01">초기화</a>
  </form>
</div>

<div class="tbl_head01 tbl_wrap">
  <table>
    <caption>감사 이력</caption>
    <thead>
      <tr>
        <th scope="col">시각</th>
        <th scope="col">관리자</th>
        <th scope="col">행위</th>
        <th scope="col">대상메뉴</th>
        <th scope="col">조건</th>
        <th scope="col">영향건수</th>
        <th scope="col">IP</th>
      </tr>
    </thead>
    <tbody>
    <?php if (!empty($rows)) {
        foreach ($rows as $row) { ?>
      <tr>
        <td><?php echo get_text($row['created_at']); ?></td>
        <td><?php echo get_text($row['admin_id']); ?></td>
        <td><?php echo get_text($row['action']); ?></td>
        <td><?php echo get_text($row['target_menu_key']); ?></td>
        <td class="td_ovf" title="<?php echo get_text($row['_filter']); ?>"><?php echo get_text($row['_filter']); ?></td>
        <td class="td_num"><?php echo (int)$row['affected_count']; ?></td>
        <td><?php echo get_text($row['_ip']); ?></td>
      </tr>
    <?php } } else { ?>
      <tr><td colspan="7" class="empty_table">자료가 없습니다.</td></tr>
    <?php } ?>
    </tbody>
  </table>
</div>

<?php
include_once('./admin.tail.php');
