<?php
$sub_menu = '700910';
include_once('./_common.php');
include_once(G5_ADMIN_PATH.'/admin.lib.php');
include_once(G5_ADMIN_PATH.'/xlog.lib.php');

auth_check_menu($auth, $sub_menu, 'r');
$g5['title'] = '게시글/댓글 로그';

$mb_id = isset($_GET['mb_id']) ? trim($_GET['mb_id']) : '';
$show_deleted = ($is_admin === 'super' && isset($_GET['sd']) && $_GET['sd']=='1') ? 1 : 0;

/* --- 소프트 삭제 --- */
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['act']) && $_POST['act']==='soft_delete') {
    if (!($is_admin === 'super' || auth_check_menu($auth, $sub_menu, 'd', true))) alert('삭제 권한이 없습니다.');
    check_admin_token();

    $ids = array_map('intval', (array)($_POST['chk'] ?? []));
    $ids = array_values(array_filter($ids));
    if ($ids) {
        $in = implode(',', $ids);
        sql_query("UPDATE g5_activity_log SET is_deleted=1 WHERE id IN ({$in})", false);
        xlog_audit('delete','xlog_content', ['ids'=>$ids], count($ids));
    }
    $q=[]; if($mb_id!=='')$q[]='mb_id='.urlencode($mb_id); if($show_deleted)$q[]='sd=1';
    goto_url($_SERVER['SCRIPT_NAME'].( $q ? '?'.implode('&',$q) : '' ));
    exit;
}

/* --- 조건/카운트/데이터 --- */
$where = "act_type IN ('post_write','post_edit','post_delete','comment_write','comment_edit','comment_delete')";
if ($mb_id !== '') $where .= " AND mb_id='".sql_escape_string($mb_id)."'";
if (!$show_deleted) $where .= " AND (is_deleted=0 OR is_deleted IS NULL)";

$total = (int)xlog_fetch_value("SELECT COUNT(*) FROM g5_activity_log WHERE {$where}");

$sql = "SELECT id, created_at, mb_id, act_type, bo_table, wr_id, cm_id, ip, user_agent, is_deleted
        FROM g5_activity_log
        WHERE {$where}
        ORDER BY id DESC
        LIMIT 200";
$result = sql_query($sql);

include_once('./admin.head.php');
?>
<div class="local_ov01 local_ov">
  <form method="get" class="local_sch01 local_sch">
    회원아이디
    <input type="text" name="mb_id" value="<?php echo get_text($mb_id); ?>" class="frm_input" style="width:120px">
    <?php if ($is_admin === 'super') { ?>
      <label style="margin-left:12px;">
        <input type="checkbox" name="sd" value="1" <?php echo $show_deleted?'checked':''; ?>> 삭제 로그 보기
      </label>
    <?php } ?>
    <button type="submit" class="btn_submit">검색</button>
    <span class="ov_num">총 <?php echo number_format($total); ?>건</span>
  </form>
</div>

<form method="post" onsubmit="return confirm('선택한 로그를 삭제하시겠습니까?');">
<input type="hidden" name="act" value="soft_delete">
<input type="hidden" name="token" value="<?php echo get_admin_token(); ?>">

<div class="tbl_head01 tbl_wrap">
  <table>
    <caption>게시글/댓글 로그</caption>
    <colgroup>
      <col style="width:36px">
      <col style="width:80px">
      <col style="width:160px">
      <col style="width:120px">
      <col style="width:120px">
      <col style="width:140px">
      <col style="width:90px">
      <col style="width:90px">
      <col>
      <col style="width:160px">
      <col style="width:70px">
    </colgroup>
    <thead>
      <tr>
        <th><input type="checkbox" onclick="document.querySelectorAll('input[name^=chk]').forEach(c=>c.checked=this.checked)"></th>
        <th>ID</th>
        <th>시각</th>
        <th>회원</th>
        <th>유형</th>
        <th>게시판</th>
        <th>WR</th>
        <th>댓글</th>
        <th>제목</th>
        <th>IP</th>
        <th>상태</th>
      </tr>
    </thead>
    <tbody>
    <?php
      for ($i=0; $row=sql_fetch_array($result); $i++) {
        $subject = xlog_get_subject($row['bo_table'], (int)$row['wr_id']);
        $url = xlog_get_post_url($row['bo_table'], (int)$row['wr_id'], (int)$row['cm_id']);
        $ip = xlog_ip_text($row['ip']);
        $deleted_badge = $row['is_deleted'] ? '<span class="btn btn_03">삭제됨</span>' : '-';
    ?>
      <tr<?php echo $row['is_deleted']?' style="opacity:.6"':''; ?>>
        <td class="td_chk"><input type="checkbox" name="chk[]" value="<?php echo (int)$row['id']; ?>" <?php echo $row['is_deleted']?'disabled':''; ?>></td>
        <td class="td_num"><?php echo (int)$row['id']; ?></td>
        <td><?php echo $row['created_at']; ?></td>
        <td><?php echo get_text($row['mb_id']); ?></td>
        <td><?php echo $row['act_type']; ?></td>
        <td><?php echo get_text($row['bo_table']); ?></td>
        <td class="td_num"><?php echo (int)$row['wr_id']; ?></td>
        <td class="td_num"><?php echo (int)$row['cm_id']; ?></td>
        <td class="td_ovf" title="<?php echo get_text($subject); ?>">
          <?php echo get_text(cut_str($subject, 60, '…')); ?>
          <?php if ($url) { ?><a class="btn btn_02" href="<?php echo $url; ?>" target="_blank" style="margin-left:6px">열기</a><?php } ?>
        </td>
        <td><?php echo get_text($ip); ?></td>
        <td class="td_mngsmall"><?php echo $deleted_badge; ?></td>
      </tr>
    <?php }
      if ($i==0) echo '<tr><td colspan="11" class="empty_table">자료가 없습니다.</td></tr>';
    ?>
    </tbody>
  </table>
</div>

<div class="btn_fixed_top">
  <?php if ($is_admin === 'super' || auth_check_menu($auth, $sub_menu, 'd', true)) { ?>
    <button type="submit" class="btn btn_02">선택삭제</button>
  <?php } ?>
</div>
</form>
<?php
xlog_audit('view','xlog_content', array_filter(['mb_id'=>$mb_id, 'sd'=>$show_deleted?1:null]), $total);
include_once('./admin.tail.php');
