<?php
include_once('./_common.php');
include_once(G5_ADMIN_PATH.'/xlog.lib.php');  // ← 추가

$sub_menu = '700920';
auth_check_menu($auth, $sub_menu, 'r');

$g5['title'] = '활동 로그 - 페이지 접속';
include_once(G5_ADMIN_PATH.'/admin.head.php');

$can_delete   = (isset($is_admin) && $is_admin==='super') || (!empty($auth[$sub_menu]['d'])); // ← 추가
$show_deleted = (isset($_GET['sd']) && $_GET['sd']=='1') ? 1 : 0; // ← 삭제로그 보기 유지

// 삭제 처리 (페이지 접속 로그도 지원)
if ($_SERVER['REQUEST_METHOD']==='POST' && (isset($_POST['act']) ? $_POST['act'] : '')==='bulk_delete') {
    auth_check_menu($auth, $sub_menu, 'd');
    check_admin_token();

    $ids = isset($_POST['ids']) && is_array($_POST['ids']) ? array_map('intval', $_POST['ids']) : array();
    $cnt = 0;
    if ($ids) {
        $in  = implode(',', $ids);
        $cnt = (int)sql_fetch("SELECT COUNT(*) AS c FROM g5_activity_log WHERE id IN ({$in})")['c'];
        // 소프트 삭제로 변경
        sql_query("UPDATE g5_activity_log SET is_deleted=1 WHERE id IN ({$in}) AND act_type='page_view'");
    }
    // 감사 로그
    xlog_audit('delete', 'xlog_page', array('ids'=>$ids), $cnt);
    alert('삭제되었습니다.', G5_ADMIN_URL.'/xlog_page.php'.($show_deleted?'?sd=1':''));
}

$mb_id = trim($_GET['mb_id'] ?? '');
$where = "act_type='page_view'";
if (!$show_deleted) $where .= " AND is_deleted=0"; // ← 기본은 삭제 제외
if ($mb_id) $where .= " AND mb_id = '".sql_real_escape_string($mb_id)."'";

$page=max(1,(int)($_GET['page']??1)); $rows=50; $from=($page-1)*$rows;
$total = sql_fetch("SELECT COUNT(*) AS cnt FROM g5_activity_log WHERE {$where}")['cnt'];
$q = sql_query("SELECT * FROM g5_activity_log WHERE {$where} ORDER BY id DESC LIMIT {$from}, {$rows}");
?>
<style>
/* 표 전체를 고정 레이아웃으로: 긴 텍스트는 칼럼 폭을 넘기지 않고 말줄임 */
.tbl_wrap table { table-layout: fixed; }
.td_id      { width: 70px; }
.td_dt      { width: 150px; white-space: nowrap; }
.td_mb      { width: 140px; }
.td_ip      { width: 140px; white-space: nowrap; }
.td_uri, .td_ua, .td_ref { max-width: 420px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; }
@media (max-width: 1280px) {
  .td_uri, .td_ua, .td_ref { max-width: 320px; }
}
/* 긴 라인이 꼭 필요하면 테이블 상자 자체로 가로 스크롤 허용 */
.tbl_wrap { overflow-x: auto; }
</style>

<div class="local_ov01 local_ov">
  <form method="get" class="local_sch01" style="display:flex;gap:10px;align-items:center;flex-wrap:wrap">
    <label>회원아이디</label>
    <input type="text" name="mb_id" value="<?php echo get_sanitize_input($mb_id); ?>" class="frm_input" style="min-width:140px">
    <?php if ($is_admin === 'super') { ?>
      <label style="margin-left:12px;">
        <input type="checkbox" name="sd" value="1" <?php echo $show_deleted?'checked':''; ?>> 삭제 로그 보기
      </label>
    <?php } ?>
    <button class="btn btn_02">검색</button>
    <a class="btn btn_01" href="<?php echo G5_ADMIN_URL.'/xlog_page.php'; ?>">초기화</a>
  </form>
</div>

<form method="post"> <!-- ← 추가: 일괄삭제용 폼 -->
<input type="hidden" name="token" value="<?php echo get_admin_token(); ?>">
<input type="hidden" name="act"   value="bulk_delete">

<div class="tbl_head01 tbl_wrap">
  <table>
    <thead>
      <tr>
        <?php if ($can_delete): ?><th class="td_chk"><input type="checkbox" onclick="var c=document.querySelectorAll('.xchk'); for(var i=0;i<c.length;i++) c[i].checked=this.checked;"></th><?php endif; ?>
        <th class="td_id">ID</th><th class="td_dt">시각</th><th class="td_mb">회원</th><th class="td_uri">URI</th><th class="td_ip">IP</th><th class="td_ua">UA</th><th class="td_ref">Referer</th>
      </tr>
    </thead>
    <tbody>
      <?php for($i=0;$r=sql_fetch_array($q);$i++): $isdel = ((int)($r['is_deleted'] ?? 0) === 1); ?>
      <tr<?php echo $isdel ? ' style="opacity:.6"' : ''; ?>>
        <?php if ($can_delete): ?><td class="td_chk"><input type="checkbox" class="xchk" name="ids[]" value="<?php echo (int)$r['id']; ?>" <?php echo $isdel ? 'disabled' : ''; ?>></td><?php endif; ?>
        <td class="td_num_small td_id"><?php echo (int)$r['id']; ?></td>
        <td class="td_dt"><?php echo $r['created_at']; ?></td>
        <td class="td_mb"><?php echo get_text($r['mb_id']); ?></td>
        <?php $uri = isset($r['uri']) ? $r['uri'] : (isset($r['path']) ? $r['path'] : ''); ?>
        <td class="td_uri" title="<?php echo get_text($uri); ?>"><?php echo get_text($uri); ?></td>
        <td class="td_ip"><?php echo function_exists('xlog_ip_text') ? xlog_ip_text($r['ip']) : (function_exists('inet_ntop') ? @inet_ntop($r['ip']) : ''); ?></td>
        <td class="td_ua" title="<?php echo get_text($r['user_agent']); ?>"><?php echo get_text($r['user_agent']); ?></td>
        <td class="td_ref" title="<?php echo get_text($r['referer']); ?>"><?php echo get_text($r['referer']); ?></td>
      </tr>
      <?php endfor; if(!$i): ?>
      <tr><td colspan="<?php echo $can_delete?8:7; ?>" class="empty_table">자료가 없습니다.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<div class="btn_fixed_top">
  <?php if ($can_delete): ?>
    <button class="btn btn_02" onclick="return confirm('선택 항목을 삭제할까요?')">선택삭제</button>
  <?php endif; ?>
</div>
</form>

<?php
echo get_paging(10, $page, ceil($total/$rows), G5_ADMIN_URL.'/xlog_page.php?mb_id='.urlencode($mb_id).($show_deleted?'&amp;sd=1':'').'&amp;page=');
include_once(G5_ADMIN_PATH.'/admin.tail.php');

// ★ 목록을 다 그린 뒤, 실제 건수($i)로 감사로그 기록
xlog_audit('view', 'xlog_page', $_GET ?? null, (int)($i ?? 0));
