<?php
include_once('./_common.php');
include_once(G5_ADMIN_PATH.'/xlog.lib.php');

$sub_menu = '700930';
auth_check_menu($auth, $sub_menu, 'w');

$g5['title'] = '활동 로그 - 보관/제한 설정';
include_once(G5_ADMIN_PATH.'/admin.head.php');

xlog_audit('view', 'xlog_settings', $_GET ?? null, 0);

if ($_SERVER['REQUEST_METHOD']==='POST') {
    check_admin_token();
    xlog_opt_set('retain_days', max(0, (int)$_POST['retain_days']));
    xlog_opt_set('max_rows',   max(0, (int)$_POST['max_rows']));
    xlog_opt_set('log_admin_pages', isset($_POST['log_admin_pages']) ? 1 : 0);
    $map = [
      'login'          => 'enable_login',
      'login_fail'     => 'enable_login_fail',
      'logout'         => 'enable_logout',
      'member_update'  => 'enable_member_update',
      'post_write'     => 'enable_post_write',
      'post_edit'      => 'enable_post_edit',
      'post_delete'    => 'enable_post_delete',
      'comment_write'  => 'enable_comment_write',
      'comment_edit'   => 'enable_comment_edit',
      'comment_delete' => 'enable_comment_delete',
      'page_view'      => 'enable_page_view',
    ];
    $enable = isset($_POST['enable']) && is_array($_POST['enable']) ? $_POST['enable'] : [];
    foreach ($map as $t => $key) xlog_conf_set($key, isset($enable[$t]) ? '1' : '0');
    alert('저장되었습니다.', G5_ADMIN_URL.'/xlog_settings.php');
}

if (!function_exists('xlog_conf')) { echo '<p class="empty_table">설정 로더 오류</p>'; include_once(G5_ADMIN_PATH.'/admin.tail.php'); exit; }
$conf = xlog_conf();
?>
<form method="post">
<input type="hidden" name="token" value="<?php echo get_admin_token(); ?>">
<div class="tbl_frm01 tbl_wrap">
  <table>
    <tr>
      <th>보관 기간(일)</th>
      <td><input type="number" name="retain_days" value="<?php echo (int)$conf['retain_days']; ?>" class="frm_input" min="0"> (0=무제한)</td>
    </tr>
    <tr>
      <th>보관 최대건수</th>
      <td><input type="number" name="max_rows" value="<?php echo (int)$conf['max_rows']; ?>" class="frm_input" min="0"> (0=무제한)</td>
    </tr>
    <tr>
      <th>관리자페이지 접속도 기록</th>
      <td><label><input type="checkbox" name="log_admin_pages" value="1" <?php echo !empty($conf['log_admin_pages'])?'checked':''; ?>> 사용</label></td>
    </tr>
    <tr>
      <th>기록 활성화 (타입별)</th>
      <td>
        <?php
          $groups = array(
            '회원'   => array('login','login_fail','logout','member_update'),
            '게시글' => array('post_write','post_edit','post_delete'),
            '댓글'   => array('comment_write','comment_edit','comment_delete'),
            '기타'   => array('page_view')
          );
          foreach ($groups as $label=>$arr) {
            echo '<fieldset style="margin-bottom:8px"><legend>'.$label.'</legend>';
            foreach ($arr as $t) {
              $ck = !empty($conf['enable'][$t]) ? 'checked' : '';
              echo '<label style="margin-right:10px"><input type="checkbox" name="enable['.$t.']" value="1" '.$ck.'> '.$t.'</label>';
            }
            echo '</fieldset>';
          }
        ?>
      </td>
    </tr>
  </table>
</div>
<div class="btn_fixed_top">
  <button class="btn btn_submit">저장</button>
</div>
</form>
<?php include_once(G5_ADMIN_PATH.'/admin.tail.php'); ?>
