<?php
if (!defined('_GNUBOARD_')) exit;

/* ==== XLOG 설정: 기본값/테이블/로더/세터 ==== */

if (!function_exists('xlog_conf_defaults')) {
    function xlog_conf_defaults() {
        return array(
            'xlog_on_login_success'   => '1',
            'xlog_on_login_fail'      => '1',
            'xlog_on_logout'      => '1',
            'xlog_on_member_update'   => '1',
            'xlog_on_post_write'      => '1',
            'xlog_on_post_edit'       => '1',
            'xlog_on_post_delete'     => '1',
            'xlog_on_comment_write'   => '1',
            'xlog_on_comment_edit'    => '1',
            'xlog_on_comment_delete'  => '1',
            'xlog_on_page_access'     => '1',
            'xlog_skip_admin_pages'   => '0',
            'xlog_keep_days'          => '0', // 0=무제한
            'xlog_keep_max'           => '0', // 0=무제한
        );
    }
}

if (!function_exists('xlog_conf_ensure_table')) {
    function xlog_conf_ensure_table() {
        @sql_query("CREATE TABLE IF NOT EXISTS g5_activity_conf (
            k VARCHAR(64) NOT NULL PRIMARY KEY,
            v TEXT NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4", false);
    }
}

// 화면용 enable[...]을 한 번에 채우는 가벼운 매핑 (O(K))
if (!function_exists('xlog_conf__build_enable')) {
    function xlog_conf__build_enable(&$cfg) {
        // 템플릿에서 사용하는 타입 -> 실제 저장 키
        static $MAP = array(
            'login'         => 'xlog_on_login_success',
            'login_fail'    => 'xlog_on_login_fail',
            'logout'        => 'xlog_on_logout',
            'member_update' => 'xlog_on_member_update',
            'post_write'    => 'xlog_on_post_write',
            'post_edit'     => 'xlog_on_post_edit',
            'post_delete'   => 'xlog_on_post_delete',
            'comment_write' => 'xlog_on_comment_write',
            'comment_edit'  => 'xlog_on_comment_edit',
            'comment_delete'=> 'xlog_on_comment_delete',
            'page_view'     => 'xlog_on_page_access',
        );

        $en = array();
        foreach ($MAP as $t => $key) {
            // 1순위: 새 키(xlog_on_*), 2순위: 기존 enable[...] 값(있다면)
            $v = isset($cfg[$key]) ? $cfg[$key]
               : (isset($cfg['enable'][$t]) ? $cfg['enable'][$t] : '0');
            $en[$t] = ($v === '1' || $v === 1) ? '1' : '0';
        }
        $cfg['enable'] = $en; // 템플릿에서 그대로 사용
    }
}


/* 내부: DB에서 한 번 로드(캐시 없이) */
if (!function_exists('xlog_conf__load_raw')) {
    function xlog_conf__load_raw() {
        $cfg = xlog_conf_defaults();
        xlog_conf_ensure_table();
        $res = @sql_query("SELECT k, v FROM g5_activity_conf", false);
        if ($res) {
            while ($row = sql_fetch_array($res)) {
                if (!isset($row['k'])) continue;
                $cfg[$row['k']] = isset($row['v']) ? $row['v'] : '';
            }
        }
        xlog_conf__build_enable($cfg);
        return $cfg;
    }
}

/* ✅ 기존 API 유지: 전체 설정 배열 리턴 */
if (!function_exists('xlog_conf')) {
    function xlog_conf() {
        static $cache = null;
        if ($cache === null) $cache = xlog_conf__load_raw();
        return $cache;
    }
}

/* 편의: 강제 재로딩 */
if (!function_exists('xlog_conf_reload')) {
    function xlog_conf_reload() {
        // static 캐시를 리셋하려면 호출 스코프 내에서 다시 계산
        // 가장 간단히: xlog_conf()를 다시 평가하게 static 변수를 초기화하는 대체 방식
        // (PHP에서 static 재설정은 함수 재정의 없이 불가 → 전역 캐시로도 병행)
        $GLOBALS['__xlog_conf_cache_bypass'] = true;
        return xlog_conf__load_raw();
    }
}

/* ✅ 키 단위 접근 (새 스타일) */
if (!function_exists('xlog_conf_get')) {
    function xlog_conf_get($k, $default='') {
        // xlog_conf() 캐시 우선
        if (empty($GLOBALS['__xlog_conf_cache_bypass'])) {
            $conf = xlog_conf();
            return array_key_exists($k, $conf) ? $conf[$k] : $default;
        }
        // 재로딩 강제 시
        $conf = xlog_conf__load_raw();
        return array_key_exists($k, $conf) ? $conf[$k] : $default;
    }
}

if (!function_exists('xlog_conf_set')) {
    function xlog_conf_set($k, $v) {
        xlog_conf_ensure_table();
        $k = sql_escape_string($k);
        $v = sql_escape_string($v);
        @sql_query("INSERT INTO g5_activity_conf (k, v) VALUES ('{$k}','{$v}')
                    ON DUPLICATE KEY UPDATE v=VALUES(v)", false);
        // 캐시 갱신(둘 다 반영)
        static $cache = null;
        if ($cache === null) $cache = xlog_conf__load_raw();
        $cache[$k] = $v;
        // 전역 스타일로도 노출(원하면 사용)
        $GLOBALS['__xlog_conf_cache'][$k] = $v;
    }
}

/* (선택) 여러 키 한 번에 저장 */
if (!function_exists('xlog_conf_set_many')) {
    function xlog_conf_set_many($arr) {
        if (!is_array($arr)) return;
        foreach ($arr as $k=>$v) xlog_conf_set($k, $v);
    }
}

/* (선택) 새 이름을 이미 쓰고 있다면 호환 alias 제공 */
if (!function_exists('xlog_conf_load')) {
    function xlog_conf_load() { return xlog_conf(); }
}

/* ==== 공통 헬퍼 ==== */

if (!function_exists('xlog_fetch_value')) {
    // SELECT ... 쿼리의 첫 번째 컬럼 값을 반환 (그누보드 5.6 호환)
    function xlog_fetch_value($sql) {
        $row = sql_fetch($sql);
        if (!$row) return null;
        foreach ($row as $k=>$v) { return $v; }
        return null;
    }
}

if (!function_exists('xlog_affected_rows')) {
    function xlog_affected_rows() {
        return function_exists('sql_affected_rows') ? (int)sql_affected_rows() : 0;
    }
}

if (!function_exists('xlog_audit')) {
    // 감사로그 기록: 빈 값은 제거해서 저장
    function xlog_audit($action, $target_menu_key, $filter = array(), $affected_count = 0) {
        if (!function_exists('sql_query')) return;
        if (!is_array($filter)) $filter = array();

        foreach ($filter as $k=>$v) {
            if ($v === '' || $v === null) unset($filter[$k]);
        }
        ksort($filter);

        $admin_id = isset($GLOBALS['member']['mb_id']) ? $GLOBALS['member']['mb_id'] : '';
        $ip_bin = @inet_pton(isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '0.0.0.0');
        $ua = substr(isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '', 255);

        $cols = "created_at, admin_id, action, target_menu_key, filter, affected_count, ip, user_agent";
        $vals = array(
            "NOW()",
            "'".sql_escape_string($admin_id)."'",
            "'".sql_escape_string($action)."'",
            "'".sql_escape_string($target_menu_key)."'",
            "'".sql_escape_string(json_encode($filter, JSON_UNESCAPED_UNICODE))."'",
            (int)$affected_count,
            "UNHEX('".bin2hex($ip_bin)."')",
            "'".sql_escape_string($ua)."'"
        );
        @sql_query("INSERT INTO g5_activity_audit ({$cols}) VALUES (".implode(',', $vals).")", false);
    }
}

if (!function_exists('xlog_ip_text')) {
    // VARBINARY(16) / HEX 문자열 모두 안전 변환
    function xlog_ip_text($raw) {
        if ($raw === null || $raw === '') return '';
        // HEX 문자열이면 bin으로 변환
        if (is_string($raw) && preg_match('/^[0-9A-Fa-f]{8,32}$/', $raw)) {
            $bin = @hex2bin($raw);
        } else {
            $bin = $raw;
        }
        if ($bin === false || is_resource($bin)) return '';
        $len = strlen($bin);
        if ($len === 4 || $len === 16) {
            $txt = @inet_ntop($bin);
            if ($txt !== false) return $txt;
        }
        // fallback: HEX → ipv4
        $h = @bin2hex($bin);
        if ($h && strlen($h) === 8) {
            $a = array_map('hexdec', str_split($h, 2));
            return implode('.', $a);
        }
        return $h ?: '';
    }
}

if (!function_exists('xlog_opt_set')) {
    function xlog_opt_set($k, $v) {
        $k = sql_escape_string($k);
        $v = sql_escape_string($v);
        sql_query("INSERT INTO g5_activity_conf (k, v) VALUES ('{$k}','{$v}') ON DUPLICATE KEY UPDATE v=VALUES(v)");
    }
}

/* ==== 게시글/댓글 제목 & 링크 ==== */

if (!function_exists('xlog_get_write_table')) {
    function xlog_get_write_table($bo_table) {
        $bo_table = preg_replace('~[^a-z0-9_]+~i', '', $bo_table);
        return $GLOBALS['g5']['write_prefix'].$bo_table;
    }
}
if (!function_exists('xlog_get_subject')) {
    function xlog_get_subject($bo_table, $wr_id) {
        $wr_id = (int)$wr_id;
        if ($wr_id <= 0) return '';
        $tbl = xlog_get_write_table($bo_table);
        $row = sql_fetch("SELECT wr_subject FROM {$tbl} WHERE wr_id={$wr_id} AND wr_is_comment=0");
        return $row ? $row['wr_subject'] : '';
    }
}
if (!function_exists('xlog_get_post_url')) {
    function xlog_get_post_url($bo_table, $wr_id, $cm_id=0) {
        $url = G5_BBS_URL.'/board.php?bo_table='.urlencode($bo_table).'&wr_id='.(int)$wr_id;
        if ($cm_id) $url .= '#c_'.(int)$cm_id;
        return $url;
    }
}

/* -------- extra 파서 & 키 추출 (JSON / serialize / querystring 모두 지원) -------- */
if (!function_exists('xlog_extra_parse')) {
    // 다양한 포맷을 배열로 표준화
    function xlog_extra_parse($raw) {
        if (is_array($raw)) return $raw;
        if (!is_string($raw) || $raw==='') return array();

        // 1) JSON
        $a = json_decode($raw, true);
        if (is_array($a)) return $a;

        // 2) PHP serialize
        if (preg_match('/^(a|O|s|i|d)\:/', $raw)) {
            $a = @unserialize($raw);
            if (is_array($a)) return $a;
        }

        // 3) query string (uri=/...&referer=...)
        if (strpos($raw, '=') !== false) {
            parse_str($raw, $q);
            if (is_array($q)) return $q;
        }

        return array();
    }
}

if (!function_exists('xlog_extra_pick')) {
    // candidates: ['uri','request_uri','path','url', ...]
    // 배열 중 복수 형태/중첩도 지원 (dot 표기: 'page.uri')
    function xlog_extra_pick($raw, $candidates) {
        $arr = xlog_extra_parse($raw);
        if (!$arr) return '';

        // 1) dot-path 직접 탐색
        foreach ($candidates as $cand) {
            $parts = explode('.', $cand);
            $cur = $arr; $ok = true;
            foreach ($parts as $p) {
                if (!is_array($cur) || !array_key_exists($p, $cur)) { $ok = false; break; }
                $cur = $cur[$p];
            }
            if ($ok && is_string($cur) && $cur!=='') return $cur;
        }

        // 2) 깊이 우선으로 key 이름 매칭(케이스 무시)
        $want = array_map('strtolower', $candidates);
        $stack = array($arr);
        while ($stack) {
            $node = array_pop($stack);
            if (!is_array($node)) continue;
            foreach ($node as $k=>$v) {
                if (in_array(strtolower($k), $want, true) && is_string($v) && $v!=='') return $v;
                if (is_array($v)) $stack[] = $v;
            }
        }
        return '';
    }
}

