<?php
include_once('./_common.php');

// only super admin can run
if ($is_admin != 'super') {
    die('최고 관리자 이외 접속 금지합니다.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_domain = trim($_POST['new_domain'] ?? '');
    $changed_count = 0;

    if ($new_domain) {
        // get all boards
        $sql_boards = "SELECT bo_table FROM {$g5['board_table']}";
        $result_boards = sql_query($sql_boards);

        while ($board = sql_fetch_array($result_boards)) {
            $write_table = $g5['write_prefix'] . $board['bo_table'];

            // find content with http
            $sql = "SELECT wr_id, wr_content FROM {$write_table} WHERE wr_content LIKE '%http%'";
            $rs  = sql_query($sql);

            while ($row = sql_fetch_array($rs)) {
                $new_content = $row['wr_content'];

                // extract domains and replace
                if (preg_match_all('/https?:\/\/([^\/"\']+)/i', $row['wr_content'], $matches)) {
                    foreach (array_unique($matches[1]) as $domain) {
                        $new_content = str_replace("http://{$domain}", $new_domain, $new_content);
                        $new_content = str_replace("https://{$domain}", $new_domain, $new_content);
                    }
                }

                // update if changed
                if ($new_content !== $row['wr_content']) {
                    $sql_update = "
                        UPDATE {$write_table}
                        SET wr_content = '".sql_real_escape_string($new_content)."'
                        WHERE wr_id = '{$row['wr_id']}'
                    ";
                    sql_query($sql_update);
                    $changed_count++;
                }
            }
        }

        echo "<div style='padding:20px; background:#e0f7e9; border:1px solid #4caf50;'>
                <strong>Done:</strong> {$changed_count} rows updated.
              </div>";
    } else {
        echo "<div style='padding:20px; background:#fdecea; border:1px solid #f44336;'>
                <strong>Error:</strong>
              </div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>서버 이전후 본문 내용 액박 해결하기</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">

<h2>긴급 패치</h2>
<form method="post" class="mt-4">
    <div class="mb-3">
        <label for="new_domain" class="form-label">새 도메인</label>
        <input type="text" name="new_domain" id="new_domain" class="form-control"
               placeholder="Example: https://newdomain.com" required>
    </div>
    <button type="submit" class="btn btn-danger">확인</button>
</form>

</body>
</html>
