<?php
include_once('../common.php');
include_once(G5_THEME_PATH.'/head.php');

error_reporting(E_ALL);
ini_set('display_errors', '1');

// 세션이 없으면 시작 (세션이 없다면 게임을 처음 시작하는 것)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 회원만 접근 가능하도록 처리 (비회원은 로그인 페이지로 리다이렉트)
if (!$is_member) {
    echo "<script>
            alert('회원만 접속 가능합니다');
            window.location.replace('https://bear0724.hs.vc/');
          </script>";
    return; // 접근 제한 후 코드 실행 종료
}

// 게임 초기화 (처음 세션이 없으면 초기화)
if (!isset($_SESSION['randomNumber'])) {
    $_SESSION['randomNumber'] = rand(1, 100); // 1부터 100까지의 랜덤 숫자 생성
    $_SESSION['attempts'] = 10; // 남은 기회 10번
    $_SESSION['message'] = ""; // 게임 메시지 초기화
    $_SESSION['game_over'] = false; // 게임 오버 여부 초기화
}

// 사용자가 숫자를 제출한 경우
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['reset'])) {
    $userGuess = intval($_POST['guess']); // 사용자가 입력한 숫자

    // 기회가 모두 소진되었을 경우
    if ($_SESSION['attempts'] <= 0) {
        $_SESSION['message'] = "<p style='font-weight:bold;'>기회가 모두 소진되었습니다.</p><p style='font-weight:bold;'>버튼을 누르고 다시 도전해주세요!</p>";
        $_SESSION['game_over'] = true;
    } else {
        // 사용자가 입력한 숫자와 랜덤 숫자 비교
        if ($userGuess < $_SESSION['randomNumber']) {
            $_SESSION['message'] = "<p style='color: #d9534f;'>업! 더 높은 숫자를 입력하세요.</p>"; // '업' 메시지 빨간색
        } elseif ($userGuess > $_SESSION['randomNumber']) {
            $_SESSION['message'] = "<p style='color: #4f90d9;'>다운! 더 낮은 숫자를 입력하세요.</p>"; // '다운' 메시지 파란색
        } else {
            $_SESSION['message'] = "<p style='color: #d9534f;'>정답입니다!<br>100포인트가 적립되었습니다.</p>"; // 정답일 경우 빨간색 메시지
            $point = 100;
            $content = '숫자 맞추기 게임 포인트 적립';
            insert_point($member['mb_id'], $point, $content, '@passive', 'number'.uniqid(), 'number_game');
            $_SESSION['attempts'] = 0; // 기회 소진
            $_SESSION['game_over'] = true; // 게임 종료
        }

        // 기회가 남아 있으면 남은 기회 차감
        if ($_SESSION['attempts'] > 0 && $_SESSION['game_over'] === false) {
            $_SESSION['attempts']--;
            
            // 기회가 모두 소진되면 게임 종료
            if ($_SESSION['attempts'] == 0) {
                $_SESSION['message'] = "<p style='font-weight:bold;'>기회가 모두 소진되었습니다.</p><p style='font-weight:bold;'>버튼을 누르고 다시 도전해주세요!</p>";
                $_SESSION['game_over'] = true;
            }
        }
    }
}

// '다시 시작하기' 버튼 클릭 시 게임을 완전히 초기화
if (isset($_POST['reset'])) {
    $_SESSION['randomNumber'] = rand(1, 100); // 새 랜덤 숫자 생성
    $_SESSION['attempts'] = 10; // 기회 10번 초기화
    $_SESSION['message'] = ""; // 메시지 초기화
    $_SESSION['game_over'] = false; // 게임 오버 여부 초기화
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>숫자 맞추기 게임</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>숫자 맞추기 게임</h1>
        <p>1부터 100까지의 숫자 중 하나를 맞춰보세요!</p>
        <p>기회는 10번입니다.</p>

        <p class="message"><?php echo $_SESSION['message']; ?></p> <!-- 게임 메시지 출력 -->
        <p class="attempts">남은 기회: <?php echo $_SESSION['attempts']; ?></p> <!-- 남은 기회 출력 -->

        <?php if ($_SESSION['attempts'] > 0 && $_SESSION['game_over'] === false): ?>
            <form method="post">
                <label for="guess">숫자 입력: </label>
                <input type="number" id="guess" name="guess" min="1" max="100" required>
                <button type="submit">제출</button>
            </form>
        <?php else: ?>
            <form method="post">
                <button type="submit" name="reset">다시 시작하기</button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>

<?php
include_once(G5_THEME_PATH.'/tail.php');