<?php
include_once('../common.php');
include_once(G5_THEME_PATH.'/head.php'); 
error_reporting(E_ALL); 
ini_set('display_errors', '1'); 

// 세션이 시작되지 않은 경우 세션 시작
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// 회원만 접근 가능하도록 처리 (비회원은 로그인 페이지로 리다이렉트)
if (!$is_member) {
    echo "<script>
            alert('회원만 접속 가능합니다');
            window.location.replace('https://bear0724.hs.vc/');
          </script>";
    return; // 접근 제한 후 코드 실행 종료
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>단어 맞추기 게임</title>
    <link rel="stylesheet" href="style.css">
    <script>
        // 힌트 표시 함수
        function showHint(index) {
            document.getElementById('hint' + index).style.display = 'block';
        }
    </script>
</head>
<body>
    <div class="container">
        <?php
        // 퀴즈 질문 배열 생성
        $questions = [
            ["문제 1: 동남아, 중국 등에서 요리에 많이 넣어 먹는 채소중 하나입니다. <br> 이것은 무엇일까요?", "쌀국수에 이것을 넣어먹음", "고수"],
            ["문제 2: 문자와 피싱의 합성어로 악성 앱 주소가 포함된 문자를<br>대량을 전송 후 이용자가 악성앱을 설치 하도록 유도해<br>금융정보 등을 탈취하는 신종 사기수법은?", "초성 힌트 ㅅㅁㅅ", "스미싱"],
            ["문제 3: 복날에 먹는 음식으로 닭으로 만든 음식은?", "○○탕", "삼계탕"],
            ["문제 4: 가격 대비 성능의 비율을 줄여 이르는말은?", "이것이 높다라고 표현함", "가성비"],
            ["문제 5: 퇴근시간이 되자마자 조금도 지체 없이 바로 퇴근한다는 뜻은?", "2글자", "칼퇴"]
        ];

        $errorMessage = ''; // 오류 메시지 초기화

        // 세션 초기화: current_question이 설정되지 않았을 경우 초기화
        if (!isset($_SESSION['current_question'])) {
            $_SESSION['current_question'] = 0; // 현재 문제 번호
            $_SESSION['correct_answers'] = 0; // 맞춘 문제 수
        }

        // 폼 제출 시 답변 처리
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $currentQuestionIndex = $_SESSION['current_question']; // 현재 문제 번호 저장
            $userAnswer = strtolower(trim($_POST['answer'])); // 사용자 답변 가져와 소문자 변환 후 공백 제거

            // 빈 답변 제출 시 오류 메시지 출력
            if (empty($userAnswer)) {
                $errorMessage = '정답을 입력하세요.';
            } else {
                // 답변이 올바른지 확인
                $correctAnswer = $questions[$currentQuestionIndex][2];
                if ($userAnswer === $correctAnswer) {
                    $_SESSION['correct_answers']++; // 맞춘 문제 수 증가
                }
                $_SESSION['current_question']++; // 다음 문제로 이동
            }
        }

        $currentQuestionIndex = $_SESSION['current_question']; // 현재 문제 번호 갱신

        // 모든 문제를 푼 후 결과 표시
        if ($currentQuestionIndex >= count($questions)) {
            echo "<h1>결과</h1>";
            $correctAnswers = $_SESSION['correct_answers']; // 총 맞춘 문제 수
            if ($correctAnswers >= 3) {
                echo "<p class='result'>3개 이상 맞췄습니다. 100포인트가 적립되었습니다.</p>";
                // 포인트 적립 함수 호출
                $point = 100;
                $content = '단어 퀴즈 게임 포인트 적립';
                insert_point($member['mb_id'], $point, $content, '@passive', 'wordquiz'.uniqid(), 'wordquiz_game');
            } else {
                echo "<p class='result'>아쉽지만, 3개 이상 맞추지 못했습니다.</p>";
            }
            // 맞춘 문제 수와 다시 풀기 버튼 표시
            echo "<p>맞춘 문제 수: $correctAnswers / " . count($questions) . "</p>";
            echo '<button onclick="window.location.href=\'wordquiz.php?reset=1\'">다시 풀기</button>';
        } else {
            // 현재 문제 표시
            $currentQuestion = $questions[$currentQuestionIndex];
            // 마지막 문제에서는 버튼 텍스트를 "결과 보기"로 변경
            $buttonText = ($currentQuestionIndex === count($questions) - 1) ? "결과 보기" : "다음 문제로 넘어가기";
            
            // 퀴즈 질문과 입력 폼
            echo "<h1>단어 맞추기 게임</h1>";
            echo "<form action='wordquiz.php' method='post'>";
            echo "<div class='question'>";
            echo "<p>{$currentQuestion[0]}</p>";
            echo "<p><input type='text' name='answer' id='answer'></p>"; // 사용자 답변 입력란
            echo "<p><button type='button' class='hint-button' onclick='showHint($currentQuestionIndex)'>힌트 보기</button></p>";
            echo "<p id='hint$currentQuestionIndex' class='hint'>{$currentQuestion[1]}</p>"; // 힌트 표시
            echo "</div>";
            if (!empty($errorMessage)) {
                echo "<p class='error-message'>$errorMessage</p>"; // 오류 메시지 출력
            }
            echo "<button type='submit'>$buttonText</button>"; // 다음 문제로 이동 또는 결과 보기 버튼
            echo "</form>";
        }

        // '다시 풀기' 버튼 클릭 시 세션 초기화 및 페이지 새로고침
        if (isset($_GET['reset']) && $_GET['reset'] == 1) {
            unset($_SESSION['current_question']);
            unset($_SESSION['correct_answers']);
            header("Location: wordquiz.php"); // 퀴즈 페이지 리로드
            exit();
        }
        ?>
    </div>
</body>
</html>
<?php
include_once(G5_THEME_PATH.'/tail.php');
?>
