<?php
// 공통 설정 파일 포함 (사이트 공통 기능을 제공하는 파일)
include_once('../common.php');

// 헤더 파일 포함 (테마 헤더 파일)
include_once(G5_THEME_PATH . '/head.php');

// 세션 시작: 세션이 활성화되지 않았을 경우 세션 초기화
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 세션 확인: 비회원일 경우 경고 메시지 출력 후 특정 URL로 리다이렉션
if (!$is_member) {
    echo "<script>
            alert('회원만 접속 가능합니다');
            window.location.replace('https://bear0724.hs.vc/');
          </script>";
    exit; // 이후 코드 실행 중단
}

// 문제와 정답 파일 경로를 설정 (문제 번호와 각 문제의 텍스트, 정답 파일 매핑)
$questions = [
    1 => ['text' => '1. 기아 자동차의 자동차 중 이름 3가지 이상을 적어보세요.(대한민국 내수용 기준)', 'file' => 'answer1.txt'],
    2 => ['text' => '2. 대한민국의 광역시 3가지 이상을 적어보세요', 'file' => 'answer2.txt'],
    3 => ['text' => '3. 아파트 브랜드 3가지 이상 적어보세요(나무위키 top 20 브랜드만)', 'file' => 'answer3.txt'],
    4 => ['text' => '4. 서울 지하철 2호선 역명 중 3가지 이상 적어보세요.', 'file' => 'answer4.txt'],
    5 => ['text' => '5. 서울 특별시 자치구 3가지 이상 적어보세요.', 'file' => 'answer5.txt'],
];

// 세션에서 맞춘 문제 수 초기화 (초기화가 안 되어 있을 경우 0으로 설정)
if (!isset($_SESSION['correctCount'])) {
    $_SESSION['correctCount'] = 0;
}

// 정답 확인 함수: 제출된 정답과 파일에 저장된 정답을 비교
function checkAnswers($answers, $questionNumber, $questions) {
    // 문제 번호에 해당하는 정답 파일 경로 가져오기
    $file = $questions[$questionNumber]['file'];
    
    // 파일이 존재하지 않을 경우 false 반환
    if (!file_exists($file)) return false;

    // 정답 파일에서 정답 목록 읽기 (trim을 통해 공백 제거)
    $correctAnswers = array_map('trim', file($file));
    
    // 사용자 제출 답변이 있을 경우 유효한 항목만 필터링
    $userAnswers = isset($answers) ? array_filter($answers, 'trim') : [];

    // 정답 개수를 카운트
    $matchCount = 0;
    foreach ($userAnswers as $answer) {
        if (in_array(trim($answer), $correctAnswers)) {
            $matchCount++;
        }
    }

    // 정답 3개 이상일 경우 true 반환
    return $matchCount >= 3;
}

// 현재 문제 번호를 GET 파라미터에서 가져오며 유효하지 않을 경우 기본값 1로 설정
$currentQuestion = isset($_GET['question']) ? (int)$_GET['question'] : 1;
if ($currentQuestion < 1 || $currentQuestion > count($questions)) {
    $currentQuestion = 1;
}

// 폼 제출 후 처리: 사용자가 정답을 제출했을 경우 실행
$resultMessage = ""; // 결과 메시지 초기화
$showNextButton = false; // "다음 문제" 버튼 표시 여부
$showQuestion = true; // 문제 표시 여부

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // 사용자가 제출한 답변 가져오기
    $userAnswers = isset($_POST["answers"]) ? $_POST["answers"] : [];
    
    // 정답 확인
    $isCorrect = checkAnswers($userAnswers, $currentQuestion, $questions);

    // 결과에 따른 메시지와 세션 값 업데이트
    if ($isCorrect) {
        $_SESSION['correctCount']++;
        $resultMessage = "<h3>축하합니다. 정답을 3개 이상 맞췄습니다.</h3>";
    } else {
        $resultMessage = "<h3>아쉽습니다. 정답을 3개 이상 틀렸습니다.</h3>";
    }

    // 다음 문제 버튼 활성화 여부 설정
    $showNextButton = $currentQuestion < count($questions);
    $showQuestion = false; // 현재 문제는 숨김
}

// 모든 문제 완료 후 포인트 적립 처리
if ($currentQuestion === count($questions) && $_SERVER["REQUEST_METHOD"] === "POST") {
    // 최소 3문제 이상 맞춘 경우 포인트 적립
    if ($_SESSION['correctCount'] >= 3) {
        $resultMessage = "<h3>축하합니다! 3문제 이상 맞춰 포인트가 적립되었습니다.</h3>";
        $point = 100;
        $content = '이름 맞추기 퀴즈 포인트 적립';

        // 포인트 적립 함수 호출 (member 정보 필요)
        insert_point($member['mb_id'], $point, $content, '@passive', 'card' . uniqid(), 'card_game');
    } else {
        $resultMessage = "<h3>아쉽습니다. 3문제 이상 맞추지 못했습니다.</h3>";
    }

    // 세션 초기화 (게임 상태 초기화)
    unset($_SESSION['correctCount']);
    $showQuestion = false;
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>이름 맞추기 퀴즈</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div id="quiz_container">
    <h1>이름 맞추기 퀴즈</h1>
    <h3 id="rule">한 문제당 최소 3개의 정답을 맞혀야 정답으로 인정되며, 총 3문제 이상 정답을 맞히면 포인트가 적립됩니다.</h3>

    <!-- 결과 메시지 출력 -->
    <?php if (!empty($resultMessage)) : ?>
        <?= $resultMessage ?>
    <?php endif; ?>

    <!-- 현재 문제 표시 -->
    <?php if ($showQuestion): ?>
    <form method="POST">
        <div class="question">
            <p><?= $questions[$currentQuestion]['text'] ?></p>
            <input type="text" name="answers[]" placeholder="정답 1">
            <input type="text" name="answers[]" placeholder="정답 2">
            <input type="text" name="answers[]" placeholder="정답 3">
            <input type="text" name="answers[]" placeholder="정답 4">
        </div>
        <button type="submit">제출하기</button>
    </form>
    <?php endif; ?>

    <!-- "다음 문제" 버튼 표시 -->
    <?php if ($showNextButton): ?>
    <div class="next-button">
        <a href="?question=<?= $currentQuestion + 1 ?>">다음 문항 풀기</a>
    </div>
    <?php endif; ?>
</div>
</body>
</html>

<?php include_once(G5_THEME_PATH . '/tail.php'); ?>
