<?php
// 공통 설정 파일 포함
include_once('../common.php');

// 세션 시작 여부 확인 후 시작
if (session_status() === PHP_SESSION_NONE) {
    session_start(); // 세션 시작
}

// 모든 오류 보고 설정
error_reporting(E_ALL);
ini_set('display_errors', '1');

// AJAX 요청이 아닌 경우에만 헤더 파일 포함
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    include_once(G5_THEME_PATH . '/head.php');
}

// 세션 확인: 회원이 아닌 경우 경고 메시지와 리다이렉션
if (!$is_member) {
    echo "<script>
            alert('회원만 접속 가능합니다');
            window.location.replace('https://test.neonserver.space/');
          </script>";
    exit;
}

// 하루 뽑기 제한 확인
$today = date('Y-m-d'); // 오늘 날짜
$max_attempts = 3; // 하루 최대 뽑기 횟수

// 게임 세션 초기화: 날짜가 바뀌면 초기화
if (!isset($_SESSION['card_game_date']) || $_SESSION['card_game_date'] != $today) {
    $_SESSION['card_game_attempts'] = 0; // 뽑기 횟수 초기화
    $_SESSION['card_game_date'] = $today; // 오늘 날짜 갱신
}

// 횟수가 초과된 경우
if ($_SESSION['card_game_attempts'] >= $max_attempts) {
    echo "<script>
            alert('하루에 최대 3번만 가능합니다. 내일 다시 시도해 주세요.');
            window.location.replace('https://test.neonserver.space/');
          </script>";
    exit;
}

// AJAX 요청 처리 부분
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (isset($data['number'])) {
        // 세션에 횟수 증가
        $_SESSION['card_game_attempts']++;

        $cvalue = htmlspecialchars($data['number']);
        $point = $cvalue;
        $content = '카드 뽑기 게임V2 포인트 적립';

        // 포인트 적립
        insert_point($member['mb_id'], $point, $content, '@passive', 'card' . uniqid(), 'card_game');

        echo "<div style='text-align: center; margin-top: 20px;'>
                <div style='display: inline-block; background-color: #f8f9fa; border: 2px solid #4CAF50; padding: 15px; border-radius: 10px; box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);'>
                    <h3 style='color: #4CAF50; margin: 0;'>축하합니다!</h3>
                    <p style='color: #333; font-size: 18px; margin: 10px 0;'>
                        <strong>{$cvalue} 포인트</strong>가 적립되었습니다.
                    </p>
                    <p style='color: #555; margin: 5px 0; font-size: 16px;'>
                        오늘의 남은 카드 뽑기 횟수 : <strong>{$_SESSION['card_game_attempts']}</strong> / {$max_attempts} 회
                    </p>
                </div>
              </div>";       
			  exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>랜덤 카드 선택</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div id="select_card">
        <p id="game_title">랜덤 카드 선택</p>
        <p id="instruction">
            카드를 선택하시면 랜덤으로 포인트가 적립됩니다.<br>
            한번에 한장 하루에 최대 3번까지 가능합니다.
        </p>
        <div id="cardsContainer">
            <!-- 5개의 카드 생성 -->
            <div class="card"><div class="card-inner"><div class="card-front"></div><div class="card-back"></div></div></div>
            <div class="card"><div class="card-inner"><div class="card-front"></div><div class="card-back"></div></div></div>
            <div class="card"><div class="card-inner"><div class="card-front"></div><div class="card-back"></div></div></div>
            <div class="card"><div class="card-inner"><div class="card-front"></div><div class="card-back"></div></div></div>
            <div class="card"><div class="card-inner"><div class="card-front"></div><div class="card-back"></div></div></div>
        </div>
        <p id="result"></p>
    </div>

    <script>
        const cards = document.querySelectorAll('.card'); // 모든 카드 선택

        cards.forEach(card => {
            card.addEventListener('click', function () {
                if (card.classList.contains('disabled')) return; // 이미 비활성화된 카드 무시
                
                let randomNum = Math.floor(Math.random() * 301); // 0 ~ 300 랜덤 숫자
                
                // 선택된 카드 뒤집기
                card.querySelector('.card-back').textContent = randomNum;
                card.classList.add('flipped', 'disabled'); // 카드 뒤집기 및 비활성화
                
                // 나머지 카드 비활성화
                cards.forEach(otherCard => {
                    if (otherCard !== card) {
                        otherCard.classList.add('disabled');
                    }
                });

                // AJAX 요청
                fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ number: randomNum })
                })
                .then(response => response.text())
                .then(data => {
                    document.getElementById('result').innerHTML = data; // 결과 표시
                })
                .catch(error => {
                    console.error('Error:', error);
                });
            });
        });
    </script>
</body>
</html>

<?php include_once(G5_THEME_PATH . '/tail.php'); ?>
