<?php
// 모든 오류 보고 설정
error_reporting(E_ALL);
ini_set('display_errors', '1');

// 공통 파일과 헤더 포함
include_once('../common.php');
include_once(G5_THEME_PATH.'/head.php');

// 로그인 상태가 아니면 접근 제한
if (!$is_member) {
    echo "<script>
        alert('회원만 접속 가능합니다');
        window.location.replace('https://bear0724.hs.vc/');
    </script>";
    exit; // 코드가 추가로 실행되지 않도록 스크립트 종료
}

// POST 요청 처리
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // POST로 전달된 값 확인
    $gvalue = isset($_POST['gvalue']) ? $_POST['gvalue'] : 0;

    // "꽝"이 아닌 경우에만 포인트 지급
    if ($gvalue !== '꽝' && (int)$gvalue > 0) {
        // 포인트 지급 계산 (룰렛 값 * 100 포인트)
        $point = (int)$gvalue * 100;
        $content = '룰렛 게임 포인트 적립';
        // insert_point 함수 호출로 포인트 지급
        insert_point($member['mb_id'], $point, $content, '@passive', 'roulette_'.uniqid(), 'roulette_game');
        echo json_encode([
            'error' => false,
            'message' => $point . '포인트가 적립되었습니다.',
            'gvalue' => $gvalue
        ]);
    } else {
        // "꽝"인 경우 메시지 전달
        echo json_encode([
            'error' => false,  // 에러 상태가 false로 설정됨
            'message' => '아쉽게도 꽝입니다.',
            'gvalue' => $gvalue
        ]);
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Spin Wheel App</title>
    <!-- 폰트 및 스타일링 -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="wrapper">
        <!-- 룰렛 게임 UI -->
        <div class="roulette">
            <canvas id="wheel"></canvas> <!-- 룰렛 차트용 캔버스 -->
            <button id="spin-btn">Spin</button> <!-- 스핀 버튼 -->
            <div id="spinner-arrow"></div> <!-- 화살표 표시 -->
        </div>
        <div id="final-value">
            <p>시작하려면 Spin 버튼을 눌러주세요</p>
            <p>적립 포인트 : 당첨된 숫자X100</p>
        </div>
    </div>

    <!-- Chart.js 및 플러그인 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/chartjs-plugin-datalabels/2.1.0/chartjs-plugin-datalabels.min.js"></script>

    <script>
        // JavaScript 코드로 룰렛 기능 구현
        const wheel = document.getElementById("wheel");
        const spinBtn = document.getElementById("spin-btn");
        const finalValue = document.getElementById("final-value");

        // 각도에 따른 룰렛 값 설정
        const rotationValues = [
            { minDegree: 0, maxDegree: 30, value: "1" },
            { minDegree: 31, maxDegree: 90, value: "2" },
            { minDegree: 91, maxDegree: 150, value: "3" },
            { minDegree: 151, maxDegree: 210, value: "4" },
            { minDegree: 211, maxDegree: 270, value: "5" },
            { minDegree: 271, maxDegree: 330, value: "6" },
            { minDegree: 331, maxDegree: 360, value: "꽝" },
        ];

        let pieColors = ["#8b35bc", "#b163da", "#8b35bc", "#b163da", "#8b35bc", "#b163da"];
        let data = [16, 16, 16, 16, 16, 16];
        let labelColors = Array(pieColors.length).fill("#ffffff");
        let generatedValue = null;

        // Chart.js를 사용하여 파이 차트 생성
        let myChart = new Chart(wheel, {
            plugins: [ChartDataLabels],
            type: "pie",
            data: {
                labels: ["1", "2", "3", "4", "5", "6"],
                datasets: [{
                    backgroundColor: pieColors,
                    data: data,
                }],
            },
            options: {
                responsive: true,
                animation: { duration: 0 },
                plugins: {
                    tooltip: false, // 툴팁 비활성화
                    legend: { display: false }, // 범례 비활성화
                    datalabels: {
                        color: function (context) {
                            return labelColors[context.dataIndex];
                        },
                        formatter: (_, context) => context.chart.data.labels[context.dataIndex],
                        font: { size: 24 },
                    },
                },
            },
        });

        // 특정 각도에 따른 포인트 및 UI 업데이트 함수
        const valueGenerator = (angleValue) => {
            for (let i of rotationValues) {
                if (angleValue >= i.minDegree && angleValue <= i.maxDegree) {
                    // 생성된 값을 변수에 저장
                    generatedValue = i.value;

                    // 포인트 또는 "꽝" 메시지 출력
                    finalValue.innerHTML = `<p>${i.value === '꽝' ? '아쉽게도 꽝입니다.' : `당첨된 포인트 : ${i.value * 100}`}</p>`;

                    // 색상 업데이트
                    let index = parseInt(i.value) - 1;
                    if (!isNaN(index) && index >= 0 && index < pieColors.length) {
                        pieColors[index] = "#FFFFFF";
                        labelColors[index] = "#000000";

                        // 차트 업데이트
                        myChart.data.datasets[0].backgroundColor = pieColors;
                        myChart.update();
                    }

                    spinBtn.disabled = true; // 스핀 버튼 비활성화

                    // AJAX로 값 전송
                    fetch("", { // URL은 동일 파일로 설정
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: new URLSearchParams({ 'gvalue': generatedValue })
                    })
                    .then(response => response.json()) // JSON 응답 처리
                    .catch(error => {
                        console.error('Error:', error);
                    });

                    break;
                }
            }
        };

        let count = 0;
        let resultValue = 101;

        // 스핀 버튼 클릭 이벤트 처리
        spinBtn.addEventListener("click", () => {
            spinBtn.disabled = true; // 버튼 비활성화
            finalValue.innerHTML = `<p>Good Luck!</p>`;
            let randomDegree = Math.floor(Math.random() * 360); // 랜덤 각도 설정
            let rotationInterval = window.setInterval(() => {
                myChart.options.rotation += resultValue;
                myChart.update();

                if (myChart.options.rotation >= 360) {
                    count += 1;
                    resultValue -= 5;
                    myChart.options.rotation = 0;
                } else if (count > 15 && myChart.options.rotation == randomDegree) {
                    valueGenerator(randomDegree);
                    clearInterval(rotationInterval);
                    count = 0;
                    resultValue = 101;
                }
            }, 10);
        });
    </script>
</body>
</html>
<?php
// 푸터 포함
include_once(G5_THEME_PATH.'/tail.php');
?>
