<?php
session_start(); // 세션 시작을 맨 위에 위치시킴

include_once('../common.php'); // 공통 설정 파일 포함
include_once(G5_THEME_PATH.'/head.php'); // 헤더 파일 포함

// 세션 초기화 및 오류 표시 활성화
ini_set('display_errors', 1);
error_reporting(E_ALL);

// 회원 확인: 회원이 아니면 경고 메시지 표시 후 리다이렉션
if (!$is_member) {
    echo "<script>
            alert('회원만 접속 가능합니다'); // 회원만 접근 허용
			window.location.replace('https://bear0724.hs.vc/'); // 비회원일 경우 리다이렉션
          </script>";
    exit; // 스크립트 종료하여 추가 코드 실행을 방지
}

// 퀴즈를 풀었는지 확인하는 함수
function hasQuizPassed() {
    // 세션에 퀴즈 풀었는지 기록된 타임스탬프 확인, 5분 이내에 푼 경우에는 다시 푼 것으로 간주
    return isset($_SESSION['quizTimestamp']) && (time() - $_SESSION['quizTimestamp']) < 5 * 60; // 5분
}

// POST 요청이 있을 때 처리
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $score = (int)$_POST['score']; // 퀴즈 점수

    // 5분 이내에 퀴즈를 풀었으면 이미 푼 퀴즈로 처리
    if (hasQuizPassed()) {
        echo "<div class='quiz-container'>";
        echo "<h1>퀴즈 결과</h1>";
        echo "<p>이미 퀴즈를 풀었습니다. 5분 후 다시 퀴즈를 풀 수 있습니다.</p>";
        echo "</div>";
    } else {
        // 새로운 퀴즈를 풀었을 때
        $_SESSION['quizTimestamp'] = time();  // 퀴즈 푼 시간 저장
        echo "<div class='quiz-container'>";
        echo "<h1>퀴즈 결과</h1>";

        // 점수에 따라 결과 출력
        if ($score >= 3) {
            echo "<p>문제를 3개 이상 맞췄습니다.</p>";
            $point = 100; // 맞춘 문제 수에 따른 포인트 설정
            $content = '퀴즈 포인트 적립'; // 포인트 설명
            // insert_point 함수 호출하여 포인트 적립
            insert_point($member['mb_id'], $point, $content, '@passive', 'quiz_'.uniqid(), 'quiz_game');
            echo "<p>포인트가 적립되었습니다.</p>";
        } else {
            echo "<p>문제를 3개 미만으로 맞췄습니다.</p>";
        }
        echo "<p>맞춘 문제 수: $score / 5</p>"; // 맞춘 문제 수 출력
        echo "<p>3개 이상 맞춘 경우 포인트 적립이 됩니다.</p>";
		echo "<p>퀴즈는 5분마다 가능합니다.</p>";
        echo "</div>";
    }
} else {
    // 퀴즈가 아직 풀리지 않았으면 퀴즈 시작 가능
    if (hasQuizPassed()) {
        echo "<div class='quiz-container'>";
        echo "<h1>퀴즈 결과</h1>";
        echo "<p>이미 퀴즈를 풀었습니다. 5분 후 다시 퀴즈를 풀 수 있습니다.</p>";
        echo "</div>";
    } else {
        // 퀴즈 게임 시작 화면
        ?>
        <div class="quiz-container">
            <p id="game_title">퀴즈 게임 5문제</p>
			<p>3문제 이상 맞춰야 포인트가 적립됩니다.</p>
            <form id="quizForm" method="POST">
                <p id="question">질문이 여기에 표시됩니다.</p>
                <div>
                    <!-- 선택지 -->
                    <label class="option"><input type="radio" name="option" value="0"> <span>선택지 1</span></label>
                    <label class="option"><input type="radio" name="option" value="1"> <span>선택지 2</span></label>
                    <label class="option"><input type="radio" name="option" value="2"> <span>선택지 3</span></label>
                    <label class="option"><input type="radio" name="option" value="3"> <span>선택지 4</span></label>
                </div>
                <button id="quiz_button" type="button" onclick="nextQuestion()">다음 문제 풀기</button> <!-- 문제 풀이 후 다음 문제로 넘어가기 -->
                <input type="hidden" name="score" value="0" id="scoreInput"> <!-- 점수를 숨은 입력값으로 전송 -->
            </form>
        </div>
        <?php
    }
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>퀴즈 게임</title>
    <link rel="stylesheet" href="style.css"> <!-- 스타일 시트 링크 -->
    <script>
        let currentQuestion = 0; // 현재 문제 인덱스
        let score = 0; // 퀴즈 점수

        // 퀴즈 데이터 배열 (질문, 선택지, 정답)
        const quizData = [
            { question: "다음중 기생충의 개봉 년도는?", options: ["2018", "2019", "2020", "2021"], answer: 1 },
            { question: "다음중 우체국이 하지 않는 서비스는?", options: ["현금배달", "등기", "알뜰폰", "버스표 예매"], answer: 3 },
            { question: "다음중 돼지고기의 부위가 아닌 것은??", options: ["목살", "채끝살", "앞다리살", "등심"], answer: 1 },
            { question: "다음중 지역과 특산물이 올바르지 않는 것은?", options: ["공주 - 밤", "영광 - 굴비", "성주 - 참외", "충주 - 인삼"], answer: 3 },
            { question: "다음중 민들레의 꽃말은?", options: ["행복과 감사", "화해", "환영", "수줍음"], answer: 0 }
        ];

        // 문제를 화면에 표시하는 함수
        function displayQuestion() {
            const questionElement = document.getElementById("question");
            const options = document.getElementsByName("option");

            if (questionElement && options.length > 0) {
                questionElement.innerText = quizData[currentQuestion].question; // 질문 표시

                quizData[currentQuestion].options.forEach((optionText, index) => {
                    options[index].nextElementSibling.innerText = optionText; // 선택지 표시
                    options[index].value = index;
                });
            }
        }

        // 다음 문제로 넘어가는 함수
        function nextQuestion() {
            const options = document.getElementsByName("option");
            let selectedOption = -1;

            options.forEach((option) => {
                if (option.checked) {
                    selectedOption = parseInt(option.value, 10); // 선택된 옵션 저장
                }
                option.checked = false; // 선택 해제
            });

            // 정답 체크
            if (selectedOption === quizData[currentQuestion].answer) {
                score++; // 정답이면 점수 증가
            }

            currentQuestion++; // 다음 문제로
            if (currentQuestion < quizData.length) {
                displayQuestion(); // 다음 문제 표시
            } else {
                // 모든 문제를 푼 후 점수 전송
                document.getElementById("scoreInput").value = score;
                document.getElementById("quizForm").submit(); // 폼 제출
            }
        }

        // 페이지 로드 시 첫 번째 문제 표시
        window.onload = displayQuestion;
    </script>
</head>
<body>
</body>
</html>

<?php
include_once(G5_THEME_PATH.'/tail.php'); // 푸터 파일 포함
