<?php
// 공통 설정 파일 포함
include_once('../common.php');

// 모든 오류 보고 설정
error_reporting(E_ALL);
ini_set('display_errors', '1');

// AJAX 요청이 아닌 경우에만 헤더 파일 포함
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    include_once(G5_THEME_PATH . '/head.php');
}

// 세션 확인: 회원이 아닌 경우 경고 메시지와 리다이렉션
if (!$is_member) {
    echo "<script>
            alert('회원만 접속 가능합니다');
            window.location.replace('https://bear0724.hs.vc/');
          </script>";
    exit; // 추가 코드 실행 방지
}

// AJAX 요청 처리 부분
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // POST 데이터 JSON으로 수신 및 디코딩
    $data = json_decode(file_get_contents('php://input'), true);

    // 'number' 값이 설정되어 있는지 확인
    if (isset($data['number'])) {
        $cvalue = htmlspecialchars($data['number']); // 입력 값 필터링
        $point = $cvalue; // 포인트 설정
        $content = '카드 뽑기 게임 포인트 적립';

        // insert_point 함수 호출로 포인트 지급
        insert_point($member['mb_id'], $point, $content, '@passive', 'card' . uniqid(), 'card_game');
        echo "<p>" . $cvalue . "포인트가 적립되었습니다</p>";

        exit; // AJAX 요청 처리 후 종료하여 추가 코드 실행 방지
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>랜덤 카드 선택</title>
    <!-- 스타일시트 포함 -->
    <link rel="stylesheet" href="style.css">
</head>
<body>
	<div id="select_card">
        <p id="game_title">랜덤 카드 선택</p>
        <div id="cardsContainer">
            <!-- 카드 선택 요소 -->
            <div class="card">?</div>
            <div class="card">?</div>
            <div class="card">?</div>
            <div class="card">?</div>
            <div class="card">?</div>
        </div>
        <!-- 랜덤 카드 뽑기 버튼 -->
        <button id="randomButton">카드 뽑기</button>
        <p id="result"></p>
	</div>

    <script>
        // '카드 뽑기' 버튼 클릭 이벤트
        document.getElementById('randomButton').addEventListener('click', function() {
            let randomNum = Math.floor(Math.random() * 301); // 0에서 300까지의 랜덤 숫자 생성
            let cards = document.querySelectorAll('.card'); // 카드 요소 선택
            let randomCardIndex = Math.floor(Math.random() * cards.length); // 랜덤 카드 인덱스 선택
            cards.forEach(card => card.textContent = '?'); // 모든 카드의 텍스트 초기화
            cards[randomCardIndex].textContent = randomNum; // 선택된 카드에 숫자 표시

            // AJAX 요청으로 데이터를 서버로 전송
            fetch('', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ number: randomNum }) // 전송할 데이터
            })
            .then(response => response.text()) // 서버 응답 처리
            .then(data => {
                document.getElementById('result').innerHTML = data; // 응답 내용을 화면에 표시
            })
            .catch(error => {
                console.error('Error:', error); // 오류 처리
            });
        });
    </script>

</body>
</html>

<?php include_once(G5_THEME_PATH . '/tail.php'); ?>
