<?php
include_once('./_common.php');
//240923









?><!DOCTYPE html>
<html lang="ko">

<head>
    <meta charset="UTF-8">
    <title>Firebase 채팅방</title>
    <style>
        * {
            -webkit-box-sizing: border-box;
            -moz-box-sizing: border-box;
            box-sizing: border-box;
        }

        html,
        body {
            background: #fff;
            height: 100%;
            overflow: hidden;
        }

        body {
            margin: 0;
            padding: 0;
            font-weight: 400;
            font-size: 1rem;
            line-height: 1.58;
            color: #333;
            height: 100%;
        }

        #chat-box {
            padding: 10px;
            height: 90vh;
            overflow-y: scroll;
        }

        .clearfix:after {
            display: block;
            content: "";
            clear: both;
        }

        .form-control {
            width: 100%;
            min-height: 38px;
            font-size: 15px;
            border: 1px solid #c8c8c8;
        }

        input {
            outline: none;
            width: 100%;
            height: 32px;
            font-size: 15px;
            border: 0;
            border-radius: 0px;
            padding-left: 10px;
            height: 10vh;
        }

        .date {
            color: #696969;
            font-size: 11px;
            letter-spacing: -0.04em;
        }

    </style>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script type="module">
        import {
            initializeApp
        } from "https://www.gstatic.com/firebasejs/10.13.1/firebase-app.js";
        import {
            getDatabase,
            ref,
            push,
            onChildAdded
        } from "https://www.gstatic.com/firebasejs/10.13.1/firebase-database.js";

        // Firebase configuration
        const firebaseConfig = {
            apiKey: "",
            authDomain: "",
            projectId: "",
            storageBucket: "",
            messagingSenderId: "",
            appId: "",
            measurementId: ""
        };

        const app = initializeApp(firebaseConfig);
        const db = getDatabase(app);

        function sendMessage() {
            <?php if ($member['mb_id']){ ?>
            const username = $('#username').val();
            const message = $('#message').val();

            if (username && message) {
                const messageRef = ref(db, 'messages');
                push(messageRef, {
                    username: username,
                    message: message,
                    timestamp: Date.now()
                });
            }
            $('#message').val('');
            <?php }else{ ?>
            alert("로그인 하십시오.");
            $('#message').val('');
            <?php } ?>
        }

        function loadMessages() {
            const messageRef = ref(db, 'messages');
            const chatBox = $('#chat-box');
            onChildAdded(messageRef, (snapshot) => {
                const data = snapshot.val();
                const message = urlAutoLink(data.message);
                const datetime = formatTimeStamp(data.timestamp);
                chatBox.append(`<div><strong>${data.username}</strong>&nbsp;:&nbsp;&nbsp;${message}&nbsp;&nbsp;<span class="date">(${datetime})</span></div>`);
                chatBox.scrollTop(chatBox[0].scrollHeight);
            });
        }

        loadMessages();

        document.getElementById('message').addEventListener("keydown", function(e) {
            if (e.which == 13 && !e.shiftKey) {
                e.preventDefault();
                sendMessage();
            }
        });

        function urlAutoLink(str) {
            str = str.replace(/&lt;/g, "<")
                .replace(/&gt;/g, ">")
                .replace(/&amp;/g, "&")
                .replace(/&quot;/g, "\"")
                .replace(/&nbsp;/g, " ")
                .replace(/&#039;/g, "'");

            str = str.replace(/([^(href="?'?)|(src="?'?)]|\(|^)((http|https|ftp|telnet|news|mms):\/\/[가-힣a-zA-Z0-9\.-]+\.[가-힣\xA1-\xFEa-zA-Z0-9\.:&#!=_\?\/~\+%@;\-\|\,\(\)]+)/gi,
                function(match, prefix, url) {
                    return `${prefix}<a href="${url}" target="_blank">${url}</a>`;
                }
            );
            
            str = str.replace(/(^|[\"'\s(])(www\.[^\"'\s()]+)/gi,
                function(match, prefix, url) {
                    return `${prefix}<a href="http://${url}" target="_blank">${url}</a>`;
                }
            );

            str = str.replace(/[0-9a-z._%+-]+@[0-9a-z.-]+\.[a-z]{2,}/gi,
                function(email) {
                    return `<a href="mailto:${email}">${email}</a>`;
                }
            );

            return str;
        }

        //출처 https://be-direct.tistory.com/entry/javascript-%ED%83%80%EC%9E%84%EC%8A%A4%ED%83%AC%ED%94%84%EB%A5%BC-%EC%8B%9C%EA%B0%84-%EB%AC%B8%EC%9E%90%EC%97%B4%EB%A1%9C-%EB%B3%80%ED%99%98
        function formatTimeStamp(timeStamp, dateSeparator = "-", timeSeparator = ":") {
            var date = new Date(timeStamp); // 타임스탬프를 인자로 받아 Date 객체 생성

            // 생성한 Date 객체에서 년, 월, 일, 시, 분, 초를 각각 문자열로 추출
            var year = date.getFullYear().toString(); // 년도
            var month = ("0" + (date.getMonth() + 1)).slice(-2); // 월 2자리 (01, 02 ... 12)
            var day = ("0" + date.getDate()).slice(-2); // 일 2자리 (01, 02 ... 31)
            var hour = ("0" + date.getHours()).slice(-2); // 시 2자리 (00, 01 ... 23)
            var minute = ("0" + date.getMinutes()).slice(-2); // 분 2자리 (00, 01 ... 59)
            var second = ("0" + date.getSeconds()).slice(-2); // 초 2자리 (00, 01 ... 59)

            // 형식화된 문자열 생성
            var formattedDateTime = `${year}${dateSeparator}${month}${dateSeparator}${day} ${hour}${timeSeparator}${minute}${timeSeparator}${second}`;

            return formattedDateTime;
        }

    </script>
</head>

<body>
    <div id="chat-box"></div>
    <div class="input-group clearfix">
        <input type="hidden" id="username" value="<?php echo $member['mb_nick']; ?>">
        <input type="text" id="message" placeholder="<?php echo $is_guest?"채팅 회원만 가능합니다.":"메시지를 입력하세요."; ?>" autocomplete="off" class="form-control" />
    </div>
</body>

</html>
