<!DOCTYPE html>

<html lang="ko">

<head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<meta name="theme-color" content="#003152">
<meta http-equiv="imagetoolbar" content="no">
<meta property="og:image" content="./file/og_image.png">
<title>[ Html Editor ]</title>
<link rel="shortcut icon" href="./file/favicon.ico">

</head>

<link rel="stylesheet" href="//cdn.jsdelivr.net/font-nanum/1.0/nanumbarungothic/nanumbarungothic.css">
<style>
html, body { margin:0px; height:100%; }
#mainDiv { display:flex; width:100%; height:100%; justify-content:space-between; }
#leftDiv { width:50%; height:100%; box-sizing:border-box; padding:20px 10px 20px 20px; }
#rightDiv { width:50%; height:100%; box-sizing:border-box; padding:20px 20px 20px 10px; }
#inTextarea { display:block; width:100%; height:100%; padding:30px 20px 20px 20px; font-size:16px; font-family:'Nanum Barun Gothic'; background-color:#eeeeee; background-image:url('./file/in_code.png'); background-position:center; background-repeat:no-repeat; border:1px solid #cccccc; box-sizing:border-box; }
#inTextarea:focus { outline:none; }
#outDiv { height:100%; padding:20px; border:1px solid #cccccc; box-sizing:border-box; }
#outIframe { display:block; width:100%; height:100%; border:none; }
#sizeDiv { position:absolute; top:5px; left:20px; display:flex; justify-content:space-between; }
.size-div { width:70px; padding:5px; margin-left:5px; background-color:#d5e6f9; font-size:16px; font-weight:bold; font-family:'Nanum Barun Gothic'; text-align:center; cursor:pointer; border:1px solid #cccccc; }
#buttonDiv { position:absolute; top:5px; right:20px; display:flex; justify-content:space-between; }
#buttonDiv div { width:70px; padding:5px; margin-right:5px; font-size:16px; font-weight:bold; font-family:'Nanum Barun Gothic'; text-align:center; cursor:pointer; background-color:#f4e3d5; border:1px solid #cccccc; }
#linkHome { position:fixed; right:5px; bottom:5px; display:block; cursor:pointer; }
@media screen and (hover:none) and (pointer:coarse) { /*모바일*/
	#inTextarea { font-size:14px; background-image:url('./file/in_code_mobile.png'); }
	#sizeDiv, #buttonDiv div:nth-of-type(3), #buttonDiv div:nth-of-type(4) { display:none; }
	#buttonDiv div { font-size:14px; }
	@media (orientation:portrait) { /*모바일세로*/
		#mainDiv { flex-direction:column; }
		#leftDiv { width:100%; height:50%; padding:10px 10px 3px 10px; }
		#rightDiv { width:100%; height:50%; padding:3px 10px 10px 10px; }
		#inTextarea { padding:10px 10px 20px 10px; }
		#outDiv { padding:20px 10px 10px 10px; }
		#buttonDiv { width:255px; left:50%; top:50%; transform:translate(-50%, -50%); }
		#buttonDiv div { margin-right:0px; }
	}
	@media (orientation:landscape) { /*모바일가로*/
		#leftDiv { padding:10px 3px 10px 10px; }
		#rightDiv { padding:10px 10px 10px 3px; }
		#inTextarea { padding:30px 10px 10px 10px; }
		#outDiv { padding:20px 10px 10px 10px; }
		#buttonDiv { right:10px; }
	}
}
</style>

<body>

<div id="mainDiv">
	<div id="leftDiv"><textarea id="inTextarea"></textarea></div>
	<div id="rightDiv"><div id="outDiv"></div></div>
</div>
<div id="sizeDiv">
	<div class="size-div" data-size="25">25%</div>
	<div class="size-div" style="background-color:#f7d7e4" data-size="50">50%</div>
	<div class="size-div" data-size="75">75%</div>
	<div class="size-div" data-size="0">100%</div>
</div>
<div id="buttonDiv">
	<div onclick="wzHtml(inTextarea.value)" style="background-color:#d9eccc">결과보기</div>
	<div onclick="wzCopy()" style="background-color:#fdfdae">코드복사</div>
	<div onclick="wzHtml('')">결과삭제</div>
	<div onclick="inTextarea.value=''">코드삭제</div>
	<div onclick="location.reload()">처음으로</div>
</div>
		
<img id="linkHome" src="./file/link_logo.png" onclick="window.open('/')">

<script>
mobileMode = ("win16|win32|win64|mac|macintel").indexOf(navigator.platform.toLowerCase()) < 0;
iframeMode = location.href !== top.location.href; 
zoom100PaddingLeft = iframeMode ? "0px" : "20px";
linkHome.style.width = mobileMode ? "40px" : "50px";
if (iframeMode) {
	sizeDiv.style.left = buttonDiv.style.right = "5px";
	leftDiv.style.paddingLeft = rightDiv.style.paddingRight = "0px";
	if (mobileMode) {
		addEventListener("resize", mobileIframeSize = function() {
			leftDiv.style.paddingRight = rightDiv.style.paddingLeft = screen.height > screen.width ? "0px" : "3px";
		});
		mobileIframeSize();
	}
}
function wzHtml() { 
	outDiv.innerHTML = "<iframe id='outIframe'></iframe>";
	outIframe.contentWindow.document.open();
	outIframe.contentWindow.document.write("<!DOCTYPE html>" + arguments[0]);
	outIframe.contentWindow.document.close();
}
function wzZoom(zoom) {
	zoomMode = zoom;
	if (zoomMode === 0) {
		leftDiv.style.display = "none";
		rightDiv.style.width = "100%";
		rightDiv.style.paddingLeft = zoom100PaddingLeft;
	}
	else {
		leftDiv.style.display = "block";
		leftDiv.style.width = 100 - zoomMode + "%";
		rightDiv.style.width = zoomMode + "%";
		leftDiv.style.paddingRight = rightDiv.style.paddingLeft = "10px";
	}
}
function wzCopy() {
	inTextarea.select();
	document.execCommand("copy");
	alert("코드가 복사되었습니다");
}
for (size_div of document.querySelectorAll(".size-div")) {
	size_div.onclick = function() {
		for (size_div of document.querySelectorAll(".size-div")) size_div.style.backgroundColor = "#d5e6f9";
		this.style.backgroundColor = "#f7d7e4";
		wzZoom(zoomMode = Number(this.dataset.size));
	}
}
thisURL = new URL(location.href);
if (location.href.indexOf("?") > 0) {
	if (thisURL.searchParams.has("code") && location.href.slice(-4) !== "code" && location.href.slice(-5) !== "code=") {
		ajaxXhr = new XMLHttpRequest();
		ajaxXhr.open("get", "./code/" + thisURL.searchParams.get("code") + ".txt");
		ajaxXhr.onreadystatechange = function () {
			if (ajaxXhr.readyState === 4 && ajaxXhr.status === 404) {
				inTextarea.value = "";
				alert("코드가 존재하지 않습니다");
				location.href = "./";
			}
			else {
				inTextarea.value = ajaxXhr.responseText;
				inTextarea.style.backgroundImage = document.querySelectorAll("#buttonDiv div")[2].style.display = document.querySelectorAll("#buttonDiv div")[3].style.display = "none";
				document.querySelectorAll("#buttonDiv div")[0].onclick();
			}
        }
		ajaxXhr.send();
	}
	else location.href = "./";
}
inTextarea.onmousedown = () => {
    if (inTextarea.style.backgroundImage !== "none") inTextarea.style.backgroundImage = "none";
}
</script>

</body>

</html>