<?php
include_once('./_common.php');

if ($is_guest)
    alert('회원만 이용하실 수 있습니다.');

// 회원여부
$mb = get_member($me_recv_mb_id);

// 포인트 설정값
$max_point = 1000000;
$min_point = 10000;

// 알람
if (!$mb['mb_id'])
    alert('존재하지 않는 회원입니다.');

if ($mb['mb_id'] == $member['mb_id'])
    alert('자신한테는 선물할 수 없습니다.');

if ($point > $max_point)
    alert('최대 선물 포인트는 '.number_format($max_point).'포인트 입니다.');

// 고정 수수료 비율 5%
$fee_rate = 0.05;

// 수수료 계산
$fee = $point * $fee_rate;

// 발송인의 포인트가 충분한지 확인
if ($member['mb_point'] < ($point + $fee))
    alert('포인트가 부족합니다.');

// 발송인의 포인트 차감 (선물 포인트 + 수수료)
insert_point($member['mb_id'], "-".($point + $fee), $mb['mb_nick']."님에게 ".number_format($point)."포인트를 선물했습니다. [수수료: ".number_format($fee)."포인트]", '@passive', $member['mb_id'], $member['mb_id']  .'-'.uniqid(''));

// 수령인에게 전체 포인트 추가
insert_point($mb['mb_id'], "+".$point, $member['mb_nick']."님한테서 ".number_format($point)."포인트를 선물받았습니다.", '@passive', $mb['mb_id'], $mb['mb_id'].'-'.uniqid(''));

// 'wadmin' 계정에 수수료 적립
insert_point('wadmin', "+".$fee, "발송인 ".$member['mb_id']."로부터 수수료 적립: ".number_format($fee)."포인트", '@passive', 'wadmin', 'wadmin-'.uniqid(''));

// 로그 파일을 읽고 마지막 순번을 결정
$filename = "./Point_log.txt";
if (file_exists($filename)) {
    $lines = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $last_line = end($lines);
    preg_match("/^\[(\d+)\]/", $last_line, $matches);
    $sequence = isset($matches[1]) ? (int)$matches[1] + 1 : 1;
} else {
    $sequence = 1; // 파일이 없으면 첫 번째 순번부터 시작
}

// 현재 시간
$current_time = date("Y-m-d H:i:s");

// 로그 메시지 작성
$log_message = "[{$sequence}] 발송인: {$member['mb_id']}, 발송 포인트: ".number_format($point).", 수령인: {$mb['mb_id']}, 수수료: ".number_format($fee).", 시간: {$current_time}\n";

// 로그 파일에 작성
$file = fopen($filename, "a") or die("파일을 열 수 없습니다.");
fwrite($file, $log_message);
fclose($file);

alert_close('포인트를 정상적으로 선물했습니다.');
?>
