<?php
include_once "./_common.php";
if (!$is_member) {
    die('Access Denied.');
}
header('Content-Type: application/json');

$bo_upload_size = isset($_POST['bo_upload_size']) ? (int)$_POST['bo_upload_size'] : 1048576; // 기본값 1MB
$uploadLimitBytes = $bo_upload_size; // MB를 바이트로 변환

if (!function_exists('_get_hostname')) {
    /**
     *  사이트 URL
     */
    function _get_hostname()
    {
        if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || $_SERVER['SERVER_PORT'] == 443) {
            $protocol = 'https://';
        } else {
            $protocol = 'http://';
        }
        //cloudflare 사용시 처리
        if (isset($_SERVER['HTTP_CF_VISITOR']) && $_SERVER['HTTP_CF_VISITOR']) {
            if (json_decode($_SERVER['HTTP_CF_VISITOR'])->scheme == 'https')
                $_SERVER['HTTPS'] = 'on';
            $protocol = 'https://';
        }

        $domainName = $_SERVER['HTTP_HOST'];
        return $protocol . $domainName;
    }
}
$accepted_origins = array(_get_hostname());

# 이미지 저장 폴더
$imageFolder = G5_DATA_PATH . '/' . 'editor/';
$imageurl =  G5_DATA_URL . '/' . 'editor/';
@mkdir($imageFolder, G5_DIR_PERMISSION);



// 외부 URL 처리 추가
if (isset($_POST['external_url'])) {
    $external_url = $_POST['external_url'];
    $file_content = @file_get_contents($external_url);

    if ($file_content === false) {
        http_response_code(400);
        echo json_encode(['error' => '외부 이미지를 다운로드할 수 없습니다.']);
        exit;
    }

    $file_size = strlen($file_content);
    if ($file_size > $uploadLimitBytes) {
        $fileSize = round($file_size / (1024 * 1024), 2);
        http_response_code(413);
        echo json_encode([
            'error' => "이미지 업로드 실패: 파일 크기 초과",
            'message' => "현재 파일 크기 ({$fileSize}MB)가 허용된 최대 크기 ({$bo_upload_size}MB)를 초과했습니다."
        ]);
        exit;
    }

    $file_info = new finfo(FILEINFO_MIME_TYPE);
    $mime_type = $file_info->buffer($file_content);
    $extension = '';
    switch ($mime_type) {
        case 'image/jpeg':
            $extension = 'jpg';
            break;
        case 'image/png':
            $extension = 'png';
            break;
        case 'image/gif':
            $extension = 'gif';
            break;
        case 'image/webp':
            $extension = 'webp';
            break;
        default:
            http_response_code(400);
            echo json_encode(['error' => '지원하지 않는 이미지 형식입니다.']);
            exit;
    }

    $upload = cut_str(md5(sha1($_SERVER['REMOTE_ADDR'])), 5, '-') . uniqid() . '.' . $extension;
    $filetowrite = $imageFolder . $upload;
    $imageurl_full = $imageurl . $upload;

    if (file_put_contents($filetowrite, $file_content) === false) {
        http_response_code(500);
        echo json_encode(['error' => '이미지를 저장할 수 없습니다.']);
        exit;
    }

    echo json_encode(['location' => $imageurl_full]);
    exit;
}




reset($_FILES);
$temp = current($_FILES);
if (isset($temp['tmp_name']) && is_uploaded_file($temp['tmp_name'])) {

    if ($_FILES['file']['size'] > $uploadLimitBytes) {
        $fileSize = round($_FILES['file']['size'] / (1024 * 1024), 2); // 파일 크기를 MB 단위로 변환
        http_response_code(413);
        echo json_encode([
            'error' => "이미지 업로드 실패: 파일 크기 초과",
            'message' => "현재 파일 크기 ({$fileSize}MB)가 허용된 최대 크기 ({$bo_upload_size}MB)를 초과했습니다. 더 작은 파일을 선택하거나 이미지를 압축해 주세요."
        ]);
        exit;
    }


    if (isset($_SERVER['HTTP_ORIGIN'])) {
        // same-origin requests won't set an origin. If the origin is set, it must be valid.
        if (in_array($_SERVER['HTTP_ORIGIN'], $accepted_origins)) {
            header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
        } else {
            header("HTTP/1.1 403 Origin Denied");
            return;
        }
    }

    // Don't attempt to process the upload on an OPTIONS request
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        header("Access-Control-Allow-Methods: POST, OPTIONS");
        return;
    }

    // Sanitize input
    if (preg_match("/([^\w\s\d\-_~,;:\[\]\(\).가-힣])|([\.]{2,})/u", $temp['name'])) {
        header("HTTP/1.1 400 Invalid file name.");
        return;
    }


    // Verify extension
    if (!in_array(strtolower(pathinfo($temp['name'], PATHINFO_EXTENSION)), array("gif", "jpg", "png", 'webp'))) {
        header("HTTP/1.1 400 Invalid extension.");
        return;
    }

    //파일명 변경
    $upload = cut_str(md5(sha1($_SERVER['REMOTE_ADDR'])), 5, '-') . uniqid() . '-' . replace_filename($temp['name']);

    //이미지 SERVER PATH
    $filetowrite = $imageFolder . $upload;
    //이미지 URL
    $imageurl_full = $imageurl . $upload;
    move_uploaded_file($temp['tmp_name'], $filetowrite);
    // Respond to the successful upload with JSON.
    // Use a location key to specify the path to the saved image resource.
    // { location : '/your/uploaded/image/file'}
    echo json_encode(array('location' => $imageurl_full, 'POST' => $_POST, 'GET' => $_GET, 'FILES' => $_FILES));
} else {
    // Notify editor that the upload failed
    header("HTTP/1.1 500 Server Error");
}
