(function () {
    'use strict';

    var global = tinymce.util.Tools.resolve('tinymce.PluginManager');

    const setupAceEditor = (editor, url) => {
        let iframeElement = null;

        const createIframe = (content) => {
            const iframe = document.createElement('iframe');
            iframe.style.width = '100%';
            iframe.style.height = '100%';
            iframe.style.border = 'none';

            const html = `
                <!DOCTYPE html>
                <html>
                <head>
                    <script src="${url}/ace-builds/src-min-noconflict/ace.js"></script>
                    <script src="${url}/ace-builds/src-noconflict/ext-beautify.js"></script>
                    <style>
                        html, body { margin: 0; padding: 0; height: 100%; overflow: hidden; }
                        #editor { position: absolute; top: 0; right: 0; bottom: 0; left: 0; }
                    </style>
                </head>
                <body>
                    <div id="editor"></div>
                    <script>
                        var editor = ace.edit("editor");
                        editor.setTheme("ace/theme/twilight");
                        editor.session.setMode("ace/mode/html");
                        editor.setValue(\`${content.replace(/`/g, '\\`')}\`);
                        editor.clearSelection();
                        editor.setHighlightActiveLine(true);
                        
                        editor.session.setUseWrapMode(true);
                        editor.session.setWrapLimitRange(null, null);
                        editor.setOption("wrap", "free");
                                                
                        // 코드 포맷팅 기능 추가
                        var beautify = ace.require("ace/ext/beautify");
                                               
                        // 에디터 로드 완료 후 자동 포맷팅 실행
                        setTimeout(function(){
                            console.log('코드 포멧');
                            beautify.beautify(editor.session);
                        }, 100);
                        function getContent() {
                            return editor.getValue();
                        }

                        function resizeEditor() {
                            editor.resize();
                        }
                    </script>
                </body>
                </html>
            `;

            iframe.srcdoc = html;
            return iframe;
        };

        const openAceDialog = () => {
            const dialogConfig = {
                title: 'Ace Editor',
                size: 'large',
                body: {
                    type: 'panel',
                    items: [{
                        type: 'htmlpanel',
                        html: '<div id="ace-editor-container" style="width: 100%; height: 400px;"></div>'
                    }]
                },
                buttons: [
                    {
                        type: 'cancel',
                        text: 'Close'
                    },
                    {
                        type: 'submit',
                        text: 'Save',
                        primary: true
                    }
                ],
                onSubmit: (api) => {
                    if (iframeElement && iframeElement.contentWindow) {
                        const content = iframeElement.contentWindow.getContent();
                        editor.setContent(content);
                    }
                    api.close();
                },
                onClose: () => {
                    iframeElement = null;
                }
            };

            editor.windowManager.open(dialogConfig);

            setTimeout(() => {
                const container = document.getElementById('ace-editor-container');
                if (container) {
                    iframeElement = createIframe(editor.getContent());
                    container.appendChild(iframeElement);

                    container.style.height = '100%';
                    container.style.minHeight = '400px';

                    let parent = container.parentElement;
                    while (parent && !parent.classList.contains('tox-dialog__body-content')) {
                        parent.style.height = '100%';
                        parent = parent.parentElement;
                    }
                    if (parent) {
                        parent.style.height = '100%';
                    }

                    iframeElement.onload = () => {
                        iframeElement.contentWindow.resizeEditor();
                    };
                } else {
                    console.error('Ace editor container not found');
                }
            }, 100);
        };

        editor.ui.registry.addButton('ace', {
            text: 'Code',
            icon: 'code',
            tooltip: 'Open Ace Editor',
            onAction: openAceDialog
        });

        editor.ui.registry.addMenuItem('ace', {
            icon: 'code',
            text: 'Ace Editor',
            onAction: openAceDialog
        });
    };

    global.add('ace', (editor, url) => {
        setupAceEditor(editor, url);
        return {
            getMetadata: () => ({
                name: 'Ace Editor Plugin',
                url: 'https://www.ask-seo.net'
            })
        };
    });
})();