<?php
include_once "./_common.php";
if (!$is_member) {
    die('Access Denied.');
}

# 이미지 저장 폴더
$imageFolder = G5_DATA_PATH . '/' . 'editor/';
$imageurl =  G5_DATA_URL . '/' . 'editor/';
@mkdir($imageFolder, G5_DIR_PERMISSION);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $url = $data['url'] ?? '';

    if (empty($url)) {
        echo json_encode(['success' => false, 'error' => 'No URL provided']);
        exit;
    }

    $imageData = file_get_contents($url);
    if ($imageData === false) {
        echo json_encode(['success' => false, 'error' => 'Failed to fetch image']);
        exit;
    }

    // 이미지 타입 확인
    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mime_type = $finfo->buffer($imageData);

    // MIME 타입에 따른 확장자 결정
    switch ($mime_type) {
        case 'image/jpeg':
            $extension = 'jpg';
            break;
        case 'image/png':
            $extension = 'png';
            break;
        case 'image/gif':
            $extension = 'gif';
            break;
        case 'image/webp':
            $extension = 'webp';
            break;
        default:
            echo json_encode(['success' => false, 'error' => 'Unsupported image type']);
            exit;
    }

    $filename = 'uploaded_' . uniqid() . '.' . $extension;
    $uploadPath = $imageFolder . $filename;

    if (file_put_contents($uploadPath, $imageData) === false) {
        echo json_encode(['success' => false, 'error' => 'Failed to save image']);
        exit;
    }

    $publicUrl = $imageurl . $filename;
    echo json_encode(['success' => true, 'url' => $publicUrl]);
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid request method']);
}
