<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작업날짜 : 2024년 04월 01일 월요일 오후 12시 47분 / 맑음, 17.0, 일교차 주의, 18, 3, 0%, 0%, 3.4ms / 보통, 47, 15

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 관리자 > 프로그램 > 피리 카페 관리 > 설정하기
=====================================================================

*/

  include_once('./_common.php' );

  auth_check_menu($auth, $sub_menu, 'w');

  include_once( piree__path($piree_prog_a[770000]['num'], 'form.lib.php') );

  include_once( piree__path($piree_prog_a[770000]['num'], 'save.lib.php') );

  include_once( piree__path($sub_menu, 'p770099.config.var.php') );

  $get__p770000_conf = 0;

  $get__p770099 = 1;

  $prog_config_page = 1;

  include_once( piree__path($sub_menu, 'config') );

  $g5['title'] = '프로그램 > '. $piree_prog_a[$sub_menu]['name'] ." > 설정하기";

  include_once( G5_ADMIN_PATH .'/admin.head.php' );

  $top_menu = 'config';
  include_once( piree__admin_path($sub_menu, 'top.menu.inc.php') );

  $pwp_tab  = '<ul class="anchor">';
  $pwp_tab .= '  <li><a href="#anc_cf__charged">유료버젼 안내</a></li>';

  IF ( $piree_prog_a[$sub_menu]['include_use_n'] == 1 )
  {

      $pwp_tab .= '    <li><a href="#anc_cf__system">시스템 기본 설정</a></li>';
  }

  $pwp_tab .= '  <li><a href="#anc_cf__section_skin">섹션 스킨</a></li>';
  $pwp_tab .= '  <li><a href="#anc_cf__cafe_skin">카페 스킨</a></li>';
  $pwp_tab .= '  <li><a href="#anc_cf__screen">화면 설정</a></li>';
  $pwp_tab .= '</ul>';

  $page_form_name = "p". $sub_menu ."_config_form";

  $form_action_u = https_url_get(piree__admin_url($sub_menu, '__config.update.php'), 'https');

?>

  <form name="<?php echo $page_form_name; ?>" id="<?php echo $page_form_name; ?>" action="<?php echo $form_action_u; ?>" method="post" onsubmit="return p<?php echo $sub_menu; ?>_config_submit(this);">

  <section>
      <h2>"<?php echo $piree_prog_a[770099]['name'] ?>" 설정하기</h2>

      <div class="btn_fixed_top">
          <input type="submit" value="설정합니다" class="btn_submit btn">
      </div>

  </section>


<?php

/*
PIREE__PROG_ALL_SOSS
*/

  IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['include_use_n'] == 1 )
  {
?>
    <section id="anc_cf__system">
      <h2>시스템 기본 설정</h2>

      <?php echo $pwp_tab ?>

      <div class="tbl_frm01 tbl_wrap">
        <table>
          <colgroup>
            <col class="td_left_200" />
            <col>
          </colgroup>
          <tbody>

<?php

/*
PIREE__PROG_ALL_SOSS
*/

?>
          <tr>
            <th scope="row"><label for="prog_top_include_n">EXTEND 파일에서 파일 첨부<strong class="sound_only">선택 입력</strong></label></th>
            <td style="line-height:2.2em;">
              <input type="radio" name="prog_top_include_n" id="prog_top_include_1" value="1"<?php  IF ( $p770099__prog_top_include_n == 1 ) { echo " checked"; }  ?>> <?php

            IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['top_include_n'] == 1 )
            {
              ?><label for="prog_top_include_1" class="str_4466ff_bold_10">기본체크 > 항상 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }
            ELSE
            {
              ?><label for="prog_top_include_1" class="str_222_bold_10">항상 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }

              ?><br>
              <input type="radio" name="prog_top_include_n" id="prog_top_include_11" value="11"<?php  IF ( $p770099__prog_top_include_n == 11 ) { echo " checked"; }  ?>> <?php

            IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['top_include_n'] == 11 )
            {
              ?><label for="prog_top_include_11" class="str_4466ff_bold_10">기본체크 > 이 프로그램 사용할때만 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }
            ELSE
            {
              ?><label for="prog_top_include_11" class="str_222_bold_10">이 프로그램 사용할때만 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }

              ?><br>
              <input type="radio" name="prog_top_include_n" id="prog_top_include_0" value="0"<?php  IF ( $p770099__prog_top_include_n != 1 && $p770099__prog_top_include_n != 11 ) { echo " checked"; }  ?>> <?php

            IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['top_include_n'] != 1 && $piree_prog_a[$piree_prog_a[770099]['num']]['top_include_n'] != 11 )
            {
              ?><label for="prog_top_include_0" class="str_4466ff_bold_10">기본체크 > 사용하지 않습니다.<strong class="sound_only">선택 입력</strong></label><?php
            }
            ELSE
            {
              ?><label for="prog_top_include_0" class="str_222_bold_10">사용하지 않습니다.<strong class="sound_only">선택 입력</strong></label><?php
            }

              ?><br>
              <span class="font_197b30">[ piree.extend 파일 ]에서 기본으로 이 프로그램의 일부 파일을 첨부합니다.</span>
            </td>
          </tr>

          <tr>
            <th scope="row"><label for="prog_head_include_n">HEAD 태그에서 파일 첨부<strong class="sound_only">선택 입력</strong></label></th>
            <td style="line-height:2.2em;">
              <input type="radio" name="prog_head_include_n" id="prog_head_include_1" value="1"<?php  IF ( $p770099__prog_head_include_n == 1 ) { echo " checked"; }  ?>> <?php

            IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['head_include_n'] == 1 )
            {
              ?><label for="prog_head_include_1" class="str_4466ff_bold_10">기본체크 > 항상 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }
            ELSE
            {
              ?><label for="prog_head_include_1" class="str_222_bold_10">항상 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }

              ?><br>
              <input type="radio" name="prog_head_include_n" id="prog_head_include_11" value="11"<?php  IF ( $p770099__prog_head_include_n == 11 ) { echo " checked"; }  ?>> <?php

            IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['head_include_n'] == 11 )
            {
              ?><label for="prog_head_include_11" class="str_4466ff_bold_10">기본체크 > 이 프로그램 사용할때만 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }
            ELSE
            {
              ?><label for="prog_head_include_11" class="str_222_bold_10">이 프로그램 사용할때만 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }

              ?><br>
              <input type="radio" name="prog_head_include_n" id="prog_head_include_0" value="0"<?php  IF ( $p770099__prog_head_include_n != 1 && $p770099__prog_head_include_n != 11 ) { echo " checked"; }  ?>> <?php

            IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['head_include_n'] != 1 && $piree_prog_a[$piree_prog_a[770099]['num']]['head_include_n'] != 11 )
            {
              ?><label for="prog_head_include_0" class="str_4466ff_bold_10">기본체크 > 사용하지 않습니다.<strong class="sound_only">선택 입력</strong></label><?php
            }
            ELSE
            {
              ?><label for="prog_head_include_0" class="str_222_bold_10">사용하지 않습니다.<strong class="sound_only">선택 입력</strong></label><?php
            }

              ?><br>
              <span class="font_197b30">[ HEAD 태그 ]에서 기본으로 이 프로그램의 일부 파일을 첨부합니다.</span>
            </td>
          </tr>

          <tr>
            <th scope="row"><label for="prog_body_include_n">BODY 태그 상단에 파일 첨부<strong class="sound_only">선택 입력</strong></label></th>
            <td style="line-height:2.2em;">
              <input type="radio" name="prog_body_include_n" id="prog_body_include_1" value="1"<?php  IF ( $p770099__prog_body_include_n == 1 ) { echo " checked"; }  ?>> <?php

            IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['body_include_n'] == 1 )
            {
              ?><label for="prog_body_include_1" class="str_4466ff_bold_10">기본체크 > 항상 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }
            ELSE
            {
              ?><label for="prog_body_include_1" class="str_222_bold_10">항상 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }

              ?><br>
              <input type="radio" name="prog_body_include_n" id="prog_body_include_11" value="11"<?php  IF ( $p770099__prog_body_include_n == 11 ) { echo " checked"; }  ?>> <?php

            IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['body_include_n'] == 11 )
            {
              ?><label for="prog_body_include_11" class="str_4466ff_bold_10">기본체크 > 이 프로그램 사용할때만 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }
            ELSE
            {
              ?><label for="prog_body_include_11" class="str_222_bold_10">이 프로그램 사용할때만 첨부합니다.<strong class="sound_only">선택 입력</strong></label><?php
            }

              ?><br>
              <input type="radio" name="prog_body_include_n" id="prog_body_include_0" value="0"<?php  IF ( $p770099__prog_body_include_n != 1 && $p770099__prog_body_include_n != 11 ) { echo " checked"; }  ?>> <?php

            IF ( $piree_prog_a[$piree_prog_a[770099]['num']]['body_include_n'] != 1 && $piree_prog_a[$piree_prog_a[770099]['num']]['body_include_n'] != 11 )
            {
              ?><label for="prog_body_include_0" class="str_4466ff_bold_10">기본체크 > 사용하지 않습니다.<strong class="sound_only">선택 입력</strong></label><?php
            }
            ELSE
            {
              ?><label for="prog_body_include_0" class="str_222_bold_10">사용하지 않습니다.<strong class="sound_only">선택 입력</strong></label><?php
            }

              ?><br>
              <span class="font_197b30">[ BODY 태그 상단 ]에 기본으로 이 프로그램의 일부 파일을 첨부합니다.</span>
            </td>
          </tr>

          </tbody>
        </table>
      </div>
    </section>
    <br><br>

<?php
  }

?>

    <section id="anc_cf__section_skin">
      <h2>섹션 스킨</h2>

      <?php echo $pwp_tab; ?>

      <div class="tbl_frm01 tbl_wrap">
        <table>
          <colgroup>
            <col class="td_left_200" />
            <col>
          </colgroup>
          <tbody>

          <tr>
            <th scope="row"><label for="skin_pc_c">카페 섹션 페이지 스킨<strong class="sound_only">선택 입력</strong></label></th>
            <td>
              <div class="cl_bo ov_hi" style="height:46px;">

                <div class="fl_left td_left_120">
                  <label for="skin_pc_c" class="font_3334dd">PC 화면 스킨<strong class="sound_only">선택 입력</strong></label>
                </div>

                <div class="fl_left td_left_300">
                  <select id="skin_pc_c" name="skin_pc_c">
<?php

                  $skin_list_a = get_skin_dir(PIREE_SKIN_PC_DIR, $p770099__prog_p);

                  FOR ($loop_n=0; $loop_n<count($skin_list_a); $loop_n++ )
                  {

                    $selected = $p770099__skin_pc_c == $skin_list_a[$loop_n] ? " selected" : "";
?>
                    <option value="<?php echo $skin_list_a[$loop_n]; ?>"<?php echo $selected ?>><?php echo $skin_list_a[$loop_n]; ?></option>
<?php
                  }

?>
                  </select>
                </div>
              </div>

              <div class="cl_bo ov_hi" style="height:46px;">
                <div class="fl_left td_left_120">
                  <label for="skin_mo_c" class="font_3334dd">모바일 기본 스킨<strong class="sound_only">선택 입력</strong></label>
                </div>
                <div class="fl_left td_left_300">
                  <select id="skin_mo_c" name="skin_mo_c">
<?php

                  $skin_list_a = get_skin_dir(PIREE_SKIN_MO_DIR, $p770099__prog_p);

                  FOR ($loop_n=0; $loop_n<count($skin_list_a); $loop_n++ )
                  {

                    $selected = $p770099__skin_mo_c == $skin_list_a[$loop_n] ? " selected" : "";
?>
                    <option value="<?php echo $skin_list_a[$loop_n]; ?>"<?php echo $selected ?>><?php echo $skin_list_a[$loop_n]; ?></option>
<?php
                  }

?>
                  </select>
                </div>
              </div>

            </td>
          </tr>

          </tbody>
        </table>
      </div>
    </section>

    <br><br>

    <section id="anc_cf__cafe_skin">
      <h2>개별 카페의 스킨</h2>

      <?php echo $pwp_tab; ?>

      <div class="tbl_frm01 tbl_wrap">
        <table>
          <colgroup>
            <col class="td_left_200" />
            <col>
          </colgroup>
          <tbody>

          <tr>
            <th scope="row"><label for="cafe_skin_basic_pc_c">개별 카페 > 기본 스킨<strong class="sound_only">선택 입력</strong></label></th>
            <td>
              <div class="cl_bo ov_hi" style="height:46px;">

                <div class="fl_left td_left_120">
                  <label for="cafe_skin_basic_pc_c" class="font_3334dd">PC 화면 스킨<strong class="sound_only">선택 입력</strong></label>
                </div>

                <div class="fl_left td_left_300">
                  <select id="cafe_skin_basic_pc_c" name="cafe_skin_basic_pc_c">
<?php

                  $skin_list_a = get_skin_dir(PIREE_CAFE_SKIN_BASIC_PC_DIR, $p770099__prog_p);

                  FOR ($loop_n=0; $loop_n<count($skin_list_a); $loop_n++ )
                  {

                    $selected = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_basic_pc_c'] == $skin_list_a[$loop_n] ? " selected" : "";
?>
                    <option value="<?php echo $skin_list_a[$loop_n]; ?>"<?php echo $selected ?>><?php echo $skin_list_a[$loop_n]; ?></option>
<?php
                  }

?>
                  </select>
                </div>
              </div>

              <div class="cl_bo ov_hi" style="height:46px;">
                <div class="fl_left td_left_120">
                  <label for="cafe_skin_basic_mo_c" class="font_3334dd">모바일 스킨<strong class="sound_only">선택 입력</strong></label>
                </div>
                <div class="fl_left td_left_300">
                  <select id="cafe_skin_basic_mo_c" name="cafe_skin_basic_mo_c">
<?php

                  $skin_list_a = get_skin_dir(PIREE_CAFE_SKIN_BASIC_MO_DIR, $p770099__prog_p);

                  FOR ($loop_n=0; $loop_n<count($skin_list_a); $loop_n++ )
                  {

                    $selected = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_basic_mo_c'] == $skin_list_a[$loop_n] ? " selected" : "";
?>
                    <option value="<?php echo $skin_list_a[$loop_n]; ?>"<?php echo $selected ?>><?php echo $skin_list_a[$loop_n]; ?></option>
<?php
                  }

?>
                  </select>
                </div>
              </div>

            </td>
          </tr>

          <tr>
            <th scope="row"><label for="cafe_skin_manage_pc_c">개별 카페 > 카페 관리 스킨<strong class="sound_only">선택 입력</strong></label></th>
            <td>
              <div class="cl_bo ov_hi" style="height:46px;">

                <div class="fl_left td_left_120">
                  <label for="cafe_skin_manage_pc_c" class="font_3334dd">PC 화면 스킨<strong class="sound_only">선택 입력</strong></label>
                </div>

                <div class="fl_left td_left_300">
                  <select id="cafe_skin_manage_pc_c" name="cafe_skin_manage_pc_c">
<?php

                  $skin_list_a = get_skin_dir(PIREE_CAFE_SKIN_MANAGE_PC_DIR, PIREE_CAFE_MANAGE_PATH);

                  FOR ($loop_n=0; $loop_n<count($skin_list_a); $loop_n++ )
                  {

                    $selected = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_manage_pc_c'] == $skin_list_a[$loop_n] ? " selected" : "";
?>
                    <option value="<?php echo $skin_list_a[$loop_n]; ?>"<?php echo $selected ?>><?php echo $skin_list_a[$loop_n]; ?></option>
<?php
                  }

?>
                  </select>
                </div>
              </div>

              <div class="cl_bo ov_hi" style="height:46px;">
                <div class="fl_left td_left_120">
                  <label for="cafe_skin_manage_mo_c" class="font_3334dd">모바일 스킨<strong class="sound_only">선택 입력</strong></label>
                </div>
                <div class="fl_left td_left_300">
                  <select id="cafe_skin_manage_mo_c" name="cafe_skin_manage_mo_c">
<?php

                  $skin_list_a = get_skin_dir(PIREE_CAFE_SKIN_MANAGE_MO_DIR, PIREE_CAFE_MANAGE_PATH);

                  FOR ($loop_n=0; $loop_n<count($skin_list_a); $loop_n++ )
                  {

                    $selected = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_manage_mo_c'] == $skin_list_a[$loop_n] ? " selected" : "";
?>
                    <option value="<?php echo $skin_list_a[$loop_n]; ?>"<?php echo $selected ?>><?php echo $skin_list_a[$loop_n]; ?></option>
<?php
                  }

?>
                  </select>
                </div>
              </div>

            </td>
          </tr>

          </tbody>
        </table>
      </div>
    </section>

    <br><br>

    <section id="anc_cf__screen">
      <h2>화면설정</h2>

      <?php echo $pwp_tab; ?>

      <div class="tbl_frm01 tbl_wrap">
        <table>
          <colgroup>
            <col class="td_left_200" />
            <col>
          </colgroup>
          <tbody>

          <tr>
            <th scope="row"><label for="profile_image_width_n">프로필 이미지 해상도<strong class="sound_only">필수 입력</strong></label></th>
            <td>
              <div class="cl_bo">
                <div class="fl_left td_left_160">
                  <label for="profile_image_width_n" class="font_444">가로<strong class="sound_only">필수 입력</strong></label>
                  <input type="text" name="profile_image_width_n" id="profile_image_width_n" value="<?php echo $piree_prog_a[$piree_prog_a[770099]['num']]['profile_image_width_n']; ?>" class="frm_input" size="6"> 
                  <label for="profile_image_width_n" class="font_777">Pixel<strong class="sound_only">필수 입력</strong></label>
                </div>

                <div class="fl_left td_left_160">
                  <label for="profile_image_height_n" class="font_444">세로<strong class="sound_only">필수 입력</strong></label>
                  <input type="text" name="profile_image_height_n" id="profile_image_height_n" value="<?php echo $piree_prog_a[$piree_prog_a[770099]['num']]['profile_image_height_n']; ?>" class="frm_input" size="6"> 
                  <label for="profile_image_height_n" class="font_777">Pixel<strong class="sound_only">필수 입력</strong></label>
                </div>

                <div class="cl_bo td_left">
                  <label for="profile_image_height_n" class="font_37b44a">해상도는 가로 <?php echo $defa_prog_a[$piree_prog_a[770099]['num']]['profile_image_width_n']; ?>Pixel × 세로 <?php echo $defa_prog_a[$piree_prog_a[770099]['num']]['profile_image_height_n']; ?>Pixel 을 권장합니다.</label>
                </div>
              </div>
            </td>
          </tr>

          </tbody>
        </table>
      </div>
    </section>

  </form>

  <script>

    function p<?php echo $sub_menu; ?>_config_submit(gform)
    {

      return true;

    }

  </script>

<?php

  include_once( G5_ADMIN_PATH .'/admin.tail.php' );

?>