<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작업날짜 : 2024년 05월 16일 목요일 오후 21시 34분 / 맑음, 14.6, 일교차 주의, 20, 7, 2.1mm, 0%, 1.3ms / 27, 14, 0.014

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 관리자 > 프로그램 > 피리 카페 관리 > 카페 목록
=====================================================================


*/

  include_once('./_common.php' );

  auth_check_menu($auth, $sub_menu, 'r');

	include_once( piree__admin_path($piree_prog_a[770000]['num'], 'program.lib.php') );

	include_once(piree__path($sub_menu, 'cafe.list.head.inc.php') );

	$g5['title'] = "카페 목록 보기";

  include_once( G5_ADMIN_PATH .'/admin.head.php' );

  $top_menu = 'cafe.list';
  include_once( piree__admin_path($sub_menu, 'top.menu.inc.php') );

?>

  <section>

    <div class="cl_bo ov_hi" style="height:32px;">
      <div class="fl_left">
        <span class="font_999">전체</span> 
        <span class="str_4466ff_bold_11"><?php echo number_format($cafe_all_t); ?></span> 
        <span class="font_999">건</span> 
<?php

      IF ( $cafe_result_t > 0 )
      {
?>
        <span class="font_999"> | </span> 
        <span class="font_999">결과</span> 
        <span class="str_4466ff_bold_11"><?php echo number_format($cafe_result_t); ?></span> 
        <span class="font_999">건 | </span> 
<?php
      }

?>
      </div>
    </div>

		<div class="tbl_head01 tbl_wrap">
				<table>
				<caption>카페 분류 목록</caption>
				<thead>
				<tr>
					<th scope="col">번호</th>
					<th scope="col">카페 코드</th>
					<th scope="col">카페 이름</th>
					<th scope="col">카페 주인</th>
					<th scope="col">분류<br>지역</th>
					<th scope="col">기본 PC 스킨<br>기본 MO 스킨</th>
					<th scope="col">관리 PC 스킨<br>관리 MO 스킨</th>
					<th scope="col">회원수<br>아이피</th>
					<th scope="col">등록일시<br>수정일시</th>
				</tr>
				</thead>
				<tbody>

<?php

	IF ( $cafe_view_t > 0 )
	{

		foreach ( $cafe_list_a AS $key=>$cafe_a )
		{

				$loop_cafe_n = $cafe_a['cafe_row_n'];

				SWITCH ( $cafe_a['cafe_region_n'] )
				{
						CASE 770100 :     $loop_cafe_name_class_s = "str_3334dd_bold_11";     BREAK;
						DEFAULT :         $loop_cafe_name_class_s = "str_4466ff_11";          BREAK;
				}

				$loop_link_s = 'cafe.list.php?cafe_n='. $loop_cafe_n;

				$loop_cafe_name_s = get_text($cafe_a['cafe_name_s']);

?>
				<tr id="cafe_list_<?php echo $loop_cafe_n ?>">
					<td class="td_right_40">
					  <a href="<?php echo cafe_index_go($loop_cafe_n); ?>"><?php echo $loop_cafe_n ?></a>
					</td>
					<td class="td_left">
					  <a href="<?php echo cafe_index_go($loop_cafe_n); ?>" class="str_197b30"><?php echo $cafe_a['cafe_code_c']; ?></a>
					</td>
					<td class="td_left">
					  <a href="<?php echo cafe_index_go($loop_cafe_n); ?>" class="<?php echo $loop_cafe_name_class_s ?>" target="_blank"><?php echo $loop_cafe_name_s; ?></a>
					</td>
					<td class="td_left">
					  <a href="<?php echo cafe_index_go($loop_cafe_n); ?>" target="_blank"><?php echo $cafe_a['cafe_mem_nick']; ?></a>
					</td>
					<td class="td_left">
					  <p><?php

					  IF ( $cafe_a['cafe_cate_s_p'] )
					  {
					    echo '<a href="'. $in_link_m .'" class="str_6688ff_9">'. trim(str_replace('--', ' > ', $cafe_a['cafe_cate_s_p'])) .'</a>';
					  }
					  ELSE
					  {
					    echo '<span class="font_999">-</span>';
					  }

					  ?></p>
					  <p><?php

					  IF ( $cafe_a['cafe_region_s_p'] )
					  {
					    echo '<a href="'. $in_link_m .'" class="str_37b44a">'. trim(str_replace('--', ' > ', $cafe_a['cafe_region_s_p'])) .'</a>';
					  }
					  ELSE
					  {
					    echo '<span class="font_999">-</span>';
					  }

					  ?></p>
					</td>
					<td class="td_left">
					  <p><?php echo $cafe_a['cafe_skin_basic_pc_c']; ?></p>
					  <p><?php echo $cafe_a['cafe_skin_basic_mo_c']; ?></p>
					</td>
					<td class="td_left">
					  <p><?php echo $cafe_a['cafe_skin_manage_pc_c']; ?></p>
					  <p><?php echo $cafe_a['cafe_skin_manage_mo_c']; ?></p>
					</td>
					<td class="td_left">
					  <p><?php echo $cafe_a['cafe_member_t']; ?></p>
					  <p><?php echo $cafe_a['cafe_ip_s']; ?></p>
					</td>
					<td class="td_center_100">
					  <p><?php echo date('Y-m-d', $cafe_a['cafe_regi_time_n']); ?></p>
					  <p><?php

					  IF ( $cafe_a['cafe_modi_time_n'] > 0 )
					  {
					    echo date('Y-m-d', $cafe_a['cafe_modi_time_n']);
					  }
					  ELSE
					  {
					    echo '<span class="font_999">-</span>';
					  }

					  ?></p>
					</td>
				</tr>

<?php

/*

cafe_row_n
cafe_mem_n
cafe_mem_id
cafe_mem_nick
cafe_mem_level_n
cafe_code_c
cafe_name_s
cafe_image_face_s
cafe_cate_n
cafe_cate_n_p
cafe_cate_name_s
cafe_cate_s_p
cafe_region_n
cafe_region_n_p
cafe_region_l_s
cafe_region_s_p

cafe_skin_board_pc_c
cafe_skin_board_mo_c
cafe_skin_latest_pc_c
cafe_skin_latest_mo_c
cafe_join_level_n
cafe_join_article_check_n
cafe_join_comment_check_n
cafe_member_info_open_n
cafe_member_view_level_n
cafe_member_view_info_open_n
cafe_board_config_n
cafe_keyword_t

cafe_board_t
cafe_article_t
cafe_comment_t
cafe_image_t
cafe_intro_s
cafe_join_guide_s
cafe_contract_s

cafe_relo_time_n

?>

					<td class="td_right_70"></td>
					<td class="td_center_40"><span class="font_777"><?php echo $cafe_a['cate_depth_n'] ?></span></td>
					<td class="td_left">
						<div style="float:left;width:<?php echo $in_left_width ?>px;text-align:right;"><img src="<?php echo $in_left_image ?>"></div>
						<div style="float:left;padding-left:5px;"><a href="<?php echo $in_link_l ?>" class="<?php echo $depth_class ?>"><?php echo $cafe_a['cate_name_l_s'] ?></a></div>
					</td>
					<td class="td_center_40"><?php IF ( $cafe_a['cate_depth_n'] < 2 ) { ?><a href="category.regist.form.php?view_mode=<?php echo $view_mode ?>&cate_n=<?php echo $loop_cate_n ?>" class="str_37b44a">추가</a><?php } ?></td>
					<td class="td_center_40"><a href="category.regist.form.php?view_mode=<?php echo $view_mode ?>&cate_n=<?php echo $loop_cate_n ?>&mode=update" class="str_37b44a">수정</a></td>
					<td class="td_center_40"><a href="category.delete.form.php?view_mode=<?php echo $view_mode ?>&cate_n=<?php echo $loop_cate_n ?>" class="str_ff3333_9">삭제</a></td>
					<td class="td_right_60"><?php  IF ( $cafe_a['cate_depth_n'] < 2 )  { echo number_format($cafe_a['cate_sub_t']) .' <span class="font_999">개</span>'; }  ELSE  { echo '<span class="font_999">-</span>'; }  ?> </td>
					<td class="td_right_60"><?php echo number_format($cafe_a['cate_member_t']); ?> <span class="font_999">명</span></td>
					<td class="td_right_60"><?php echo number_format($cafe_a['cate_article_t']); ?> <span class="font_999">개</span></td>
					<td class="td_center_120"><?php echo $in_regist_date ?></td>
				</tr>
<?php

/*
/*

cafe_mem_n
cafe_mem_id
cafe_mem_nick
cafe_mem_level_n
cafe_code_c
cafe_name_s
cafe_image_face_s
cafe_cate_n
cafe_cate_n_p
cafe_cate_name_s
cafe_cate_s_p
cafe_region_n
cafe_region_n_p
cafe_region_l_s
cafe_region_s_p
cafe_skin_basic_pc_c
cafe_skin_basic_mo_c
cafe_skin_manage_pc_c
cafe_skin_manage_mo_c
cafe_skin_board_pc_c
cafe_skin_board_mo_c
cafe_skin_latest_pc_c
cafe_skin_latest_mo_c
cafe_join_level_n
cafe_join_article_check_n
cafe_join_comment_check_n
cafe_member_info_open_n
cafe_member_view_level_n
cafe_member_view_info_open_n
cafe_board_config_n
cafe_keyword_t
cafe_member_t
cafe_board_t
cafe_article_t
cafe_comment_t
cafe_image_t
cafe_intro_s
cafe_join_guide_s
cafe_contract_s
cafe_ip_s
cafe_regi_time_n
cafe_modi_time_n
cafe_relo_time_n

*/

		}

	}
	ELSE
	{

?>
				<tr>
					<td colspan="10" align="center"><strong>등록된 [ 카페 분류 ]가 없습니다.</strong></td>
				</tr>

<?php

	}

?>

				</tbody>
				</table>
		</div>

    <div class="fl_right" style="height:46px; background:#f0f0f0;">
      <?php echo $page_navi_s; ?>
    </div>

  </section>

<script>

  function category_standard_input(func_href_url)
  {

    IF ( confirm("정말로 [ 피리 카페 표준 카페 분류 ]를 입력하시겠습니까?") )
    {
      document.location.href = func_href_url;
    }

    return false

  }

  function category_list_submit(f)
  {

    if (!is_checked("chk[]")) {
        alert(document.pressed+" 하실 항목을 하나 이상 선택하세요.");
        return false;
    }

    IF (document.pressed == "선택삭제") {
        IF (!confirm("선택한 자료를 정말 삭제하시겠습니까?")) {
            return false;
        }
    }

    return true;

  }

</script>

<?php

  include_once( G5_ADMIN_PATH .'/admin.tail.php' );

?>