<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작업날짜 : 2024년 04월 07일 일요일 오후 20시 24분 / 맑음, 19.0, 일교차 주의, 22, 6, 0%, 0%, 1.3ms / 상당히 나쁨, 77, 43, 0.012

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 관리자 > 프로그램 > 피리 카페 관리 > 카페 분류 관리 > 카페 분류 관리 목록보기
=====================================================================

=================================================

가족/육아
건강/다이어트
게임
경제/금융
과학
교육
국제/외교
동물
동창/동문
문화/예술
방송/연예
생활
스포츠/레저
식물
애니메이션/만화
여행
영화
음악
인문
정치/사회
종교/봉사
지역
취미
친목/모임
컴퓨터/인터넷/통신
패션/미용
팬카페

=================================================

# 가족/육아
육아/자녀
결혼
임신/출산
여성
가족
이민
기타

# 건강/다이어트
건강
보험
운동
헬스/피트니스
다이어트
건강식품/영양제/보조제
질병
병원/보건소
심리상담
한방/대체의학
기타

# 게임
롤플레잉 게임
시뮬레이션 게임
슈팅 게임
액션/어드벤처 게임
레이싱 게임
스포츠 게임
모바일 게임
대항해시대
게임기
게이머
게임 제작
길드/클랜
고전 게임
오징어 게임

# 경제/금융
기업/경영
벤처/창업
재테크
부동산
보험
채권
대출
투자 상품
세무/세금
증권/주식
거래소
코스닥
산업
마케팅
무역
장외시장
취업
경제 이론
경제 단체
경제/금융 일반

# 과학
물리학
화학
지구과학
생물학
생명공학
재료공학
전자공학
건축/토목
의학

# 교육
유아/유치원
초등학교 교육
중등학교 교육
고등학교 교육
대학/대학원
대안학교
특수 교육
직업 교육
실버 교육
외국인 대상 교육
공무원/고시
자격증
유학/어학연수
과외
학원
교육일반

# 국제/외교
국제관계
통일/한반도
외교
유엔/국제기구

# 동물
강아지/애견
고양이
조류/새/닭
토끼
햄스터
고슴도치
파충류
양서류
어류/갑각류
곤충
동물보호
동물병원
동물 업계
기타

# 동창/동문
초등학교
중학교
고등학교
대학교/대학원
학원
기타

# 문화/예술
연극/공연
오페라
뮤지컬
무용/댄스/힙합
디자인
공계
조소/조각
도예
서예
사진
미술관
소설
시
수필
독서
문학작가/작품
패션
모임/단체
기타

# 방송/연예
TV/지상파/종편/케이블
라디오
인터넷방송/유튜브
신문/잡지
연예
오디션
가수/아이돌
방송인/방송업계
광고

# 생활
요리
인테리어
연애
살림
교통
생활가전
생활정보
운세
생활용품
기타

# 스포츠/레저
자전거
축구
농구
야구
배구
테니스
베드민턴
골프
탁구
볼링
당구
욕상/마라톤
수영
태권도
스케이트
유도
합기도
특공무술/주지수
씨름
검도
양궁
국궁
레슬링
체조
에어로빅
모터스포츠
올림픽/아시안게임
등산
낚시
필라테스
아웃도어
스포츠기타

# 식물
쌀
밀
잡곡
뿌리 작물/감자/고구마
잎 작물/채소류
과일
화훼/꽃
선인장
활엽수 나무
침엽수 나무
기타

# 애니메이션/만화
웹툰
순정
코믹
액션/무협지
공포
추리
판타지
스포츠
만화 창작
애니메이션
코스프레
창작자

# 여행
국내 > 역사/박물관/고궁/사찰
국내 > 산/산촌마을/계곡/산촌체험
국내 > 농촌/농촌체험
국내 > 바다/어촌체험
국내 > 꽃구경/화훼
국내 > 제주도
국내 > 섬
국내 > 숙박
해외 > 동남아시아
해외 > 일본
해외 > 중국
해외 > 북미/중미/남미
해외 > 유럽
해외 > 아프리카
해외 > 중동/중앙아시아
해외 > 인도/남아시아
해외 > 항공

# 영화
배우
비디오
영화음악
주제
영화평론
영화정보
영화제작
감독/영화 제작인
영화관/극장
영화제
기타

# 음악
발라드
댄스/입합
랩
팝
락/메탈
인디음악
재즈
클래식
성악/오페라 음악
국악/민요/풍물
OST
자사/작곡
노래/연주
콘서트/가요제
뮤직 비디오
개인밴드
모임
악기

# 인문
인문
천문학
역사/고고학
심리학
철학
자연/환경
수학

# 정치/사회
시사
정치/선거
이슈/화재
법률
행정/민원
환경/재난/재해
복지/인권
기타

# 종교/봉사
불교
가톨릭/천주교/성당
기독교/교회
원불교
기타 종교
토속 종교
종교 모임
봉사/봉사활동
기타

# 지역
광역지역/시, 도
기초지역/시, 군, 구
마을/동네
아파트 단지

# 취미
만들기
키우기
수집
수석
모형
수공예
원예
코스프레
장기/바둑
놀이
취미 정보
취미 모임
기타

# 친목/모임
사랑/만남
나이/또래
띠
가족
군대
연인
종친
대화
휴식
친구
회사 모임
업종/직업
동아리
이색/엽기
기타

# 컴퓨터/인터넷/통신
컴퓨터/노트북
서버/클라우드
웹프로그램/홈페이지 제작
홈페이지
웹디자인
웹기획
스마트폰/휴대폰
스마트폰 어플리케이션
스마트폰 어플리케이션 제작
통신/네트워크
하드웨어
소프트웨어
보안/해킹
운영체제>PC용 윈도우
운영체제>서버용 윈도우
운영체제>유닉스/리눅스
운영체제>안드로이드
애플/IOS/아이폰/맥북/애플 주변기기
인터넷
카메라/스트리밍 방송 촬용장비
기타

# 패션/미용
의류
잡화
쥬얼리/악세사리
명품
피부미용/피부관리
이발/헤어/미용실
네일
화장
성형
기타

# 팬카페
국내 가수
외국 가수
국내 배우
외국 배우
음악가
방송인
개그맨/코미디언
국내 모델
외국 모델
인터넷 방송인/유튜버
스포츠 선수
기타

=================================================

$category_sub_a = array();

$category_sub_a[] = "게임";
$category_sub_a[] = "애니메이션/만화";
$category_sub_a[] = "방송/연예";
$category_sub_a[] = "문화/예술";
$category_sub_a[] = "영화";
$category_sub_a[] = "음악";
$category_sub_a[] = "팬카페";
$category_sub_a[] = "여행";
$category_sub_a[] = "스포츠/레저";
$category_sub_a[] = "동물";
$category_sub_a[] = "식물";
$category_sub_a[] = "취미";
$category_sub_a[] = "생활";
$category_sub_a[] = "패션/미용";
$category_sub_a[] = "건강/다이어트";
$category_sub_a[] = "가족/육아";
$category_sub_a[] = "컴퓨터/인터넷/통신";
$category_sub_a[] = "교육";
$category_sub_a[] = "인문";
$category_sub_a[] = "과학";
$category_sub_a[] = "경제/금융";
$category_sub_a[] = "정치/사회";
$category_sub_a[] = "국제/외교";
$category_sub_a[] = "동창/동문";
$category_sub_a[] = "친목/모임";
$category_sub_a[] = "종교/봉사";
$category_sub_a[] = "지역";

sort($category_sub_a);

FOREACH( $category_sub_a AS $key=>$val )
{

echo $val ."\n";

$sql_select  = "SELECT `cate_name_l_s`, `cate_depth_n` FROM `g5__piree__category` ";
$sql_select .= "WHERE `cate_1_s` = '".$val."'";
//$result = sql_query($sql_select);

FOR ( $loop_n = 0; $row = sql_fetch_array($result); $loop_n++ )
{
echo "#". $row['cate_depth_n'] ." > ". $row['cate_name_l_s'] ."\n";
}

}

*/

  include_once('./_common.php' );

  auth_check_menu($auth, $sub_menu, 'r');

  include_once(piree__admin_path($sub_menu, 'category.list.head.inc.php') );

  $g5['title'] = "카페 분류 목록 보기";

  include_once( G5_ADMIN_PATH .'/admin.head.php' );

  $top_menu = 'category.list';
  include_once( piree__admin_path($sub_menu, 'top.menu.inc.php') );


?>

  <section>

    <div class="cl_bo ov_hi">
      <div class="fl_left">
        <a href="category.regist.form.php?view_mode=<?php echo $view_mode ?>" class="btn_frmline btn">카페 분류 등록하기</a>
        <a href="category.list.php" class="btn_frmline btn">전체보기</a>
        <a href="category.list.php?view_mode=top" class="btn_frmline btn">최상위보기</a>
        <a href="category.list.php?view_mode=depth&cate_n=<?php echo $cate_n ?>" class="btn_frmline btn">계층보기</a>
        <a href="category.insert.update.php" class="btn_frmline btn" onclick="category_standard_input(this.href); return false;">피리 카페 표준 카페 분류 입력</a>
      </div>

      <div class="fl_right">
        <?php echo $page_navi_s; ?>
      </div>
    </div>

    <div class="cl_bo" style="margin-top:16px;">
      <span class="font_999">전체</span> 
      <span class="str_4466ff_bold_11"><?php echo number_format($list_all_t); ?></span> 
      <span class="font_999">건</span> 
<?php

    IF ( $list_res_t > 0 )
    {
?>
      <span class="font_999"> | </span> 
      <span class="font_999">결과</span> 
      <span class="str_4466ff_bold_11"><?php echo number_format($list_all_t); ?></span> 
      <span class="font_999">건 | </span> 
<?php
    }

?>
    </div>

    <div class="tbl_head01 tbl_wrap">
        <table>
        <caption>카페 분류 목록</caption>
        <thead>
        <tr>
          <th scope="col">분류 번호</th>
          <th scope="col">단계</th>
          <th scope="col">카페 분류 이름</th>
          <th scope="col">추가</th>
          <th scope="col">수정</th>
          <th scope="col">삭제</th>
          <th scope="col">하위<br>분류</th>
          <th scope="col">회원</th>
          <th scope="col">게시글</th>
          <th scope="col">등록일시</th>
        </tr>
        </thead>
        <tbody>

<?php

  IF ( $list_res_t > 0 )
  {

    FOR ( $i=0; $row=sql_fetch_array($result); $i++ )
    {

        $loop_cate_n = $row['cate_n'];

        $cate_name_l_s = get_text($row['cate_name_l_s']);

        $in_regist_date = date('Y-m-d H:i', $row['cate_regi_time_n']);

        SWITCH ( $row['cate_depth_n'] )
        {
            CASE 1 :     $in_left_width = 2;      $in_left_image = $left_image_trans;     $depth_class = "str_3334dd_bold_11";     BREAK;
            CASE 2 :     $in_left_width = 27;     $in_left_image = $left_image_arrow;     $depth_class = "str_4466ff_11";          BREAK;
        }

        $in_qry_s  = 'view_mode='. $view_mode .'&cate_n='. $loop_cate_n;
        $in_qry_s  = 'view_mode=depth&cate_n='. $loop_cate_n;
        $in_link_l = 'category.list.php?'. $in_qry_s;
        $in_link_m = 'category.list.multi.php?'. $in_qry_s;

?>
        <tr id="category_point_<?php echo $loop_cate_n ?>">
          <td class="td_right_70"><a href="<?php echo $in_link_m ?>"><?php echo $loop_cate_n ?></a></td>
          <td class="td_center_40"><span class="font_777"><?php echo $row['cate_depth_n'] ?></span></td>
          <td class="td_left">
            <div style="float:left;width:<?php echo $in_left_width ?>px;text-align:right;"><img src="<?php echo $in_left_image ?>"></div>
            <div style="float:left;padding-left:5px;"><a href="<?php echo $in_link_l ?>" class="<?php echo $depth_class ?>"><?php echo $row['cate_name_l_s'] ?></a></div>
          </td>
          <td class="td_center_40"><?php IF ( $row['cate_depth_n'] < 2 ) { ?><a href="category.regist.form.php?view_mode=<?php echo $view_mode ?>&cate_n=<?php echo $loop_cate_n ?>" class="str_37b44a">추가</a><?php } ?></td>
          <td class="td_center_40"><a href="category.regist.form.php?view_mode=<?php echo $view_mode ?>&cate_n=<?php echo $loop_cate_n ?>&mode=update" class="str_37b44a">수정</a></td>
          <td class="td_center_40"><a href="category.delete.form.php?view_mode=<?php echo $view_mode ?>&cate_n=<?php echo $loop_cate_n ?>" class="str_ff3333_9">삭제</a></td>
          <td class="td_right_60"><?php  IF ( $row['cate_depth_n'] < 2 )  { echo number_format($row['cate_sub_t']) .' <span class="font_999">개</span>'; }  ELSE  { echo '<span class="font_999">-</span>'; }  ?> </td>
          <td class="td_right_60"><?php echo number_format($row['cate_member_t']); ?> <span class="font_999">명</span></td>
          <td class="td_right_60"><?php echo number_format($row['cate_article_t']); ?> <span class="font_999">개</span></td>
          <td class="td_center_120"><?php echo $in_regist_date ?></td>
        </tr>
<?php

    }

  }
  ELSE
  {

?>
        <tr>
          <td colspan="10" align="center"><strong>등록된 [ 카페 분류 ]가 없습니다.</strong></td>
        </tr>

<?php

  }

?>

        </tbody>
        </table>
    </div>

    <div class="cl_bo ov_hi">
      <div class="fl_left">
        <a href="category.regist.form.php?view_mode=<?php echo $view_mode ?>" class="btn_frmline btn">카페 분류 등록하기</a>
        <a href="category.list.php" class="btn_frmline btn">전체보기</a>
        <a href="category.list.php?view_mode=top" class="btn_frmline btn">최상위보기</a>
        <a href="category.list.php?view_mode=depth&cate_n=<?php echo $cate_n ?>" class="btn_frmline btn">계층보기</a>
        <a href="category.insert.update.php" class="btn_frmline btn" onclick="category_standard_input(this.href); return false;">피리 카페 표준 카페 분류 입력</a>
      </div>

      <div class="fl_right">
        <?php echo $page_navi_s; ?>
      </div>
    </div>

  </section>

<br>

<?php

  include_once( piree__admin_path($sub_menu, 'charged.guide.inc.php') );

?>

<script>

  function category_standard_input(func_href_url)
  {

    IF ( confirm("정말로 [ 피리 카페 표준 카페 분류 ]를 입력하시겠습니까?") )
    {
      document.location.href = func_href_url;
    }

    return false

  }

  function category_list_submit(f)
  {

    if (!is_checked("chk[]")) {
        alert(document.pressed+" 하실 항목을 하나 이상 선택하세요.");
        return false;
    }

    IF (document.pressed == "선택삭제") {
        IF (!confirm("선택한 자료를 정말 삭제하시겠습니까?")) {
            return false;
        }
    }

    return true;

  }

</script>

<?php

  include_once( G5_ADMIN_PATH .'/admin.tail.php' );

?>