<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작업날짜 : 2024년 04월 05일 금요일 오후 17시 50분

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 관리자 > 프로그램 > 피리 카페 관리 > 지역 관리 > 지역 관리 목록보기
=====================================================================


*/

  include_once('./_common.php' );

  auth_check_menu($auth, $sub_menu, 'r');

  include_once('region.list.head.inc.php' );

  $g5['title'] = "지역 목록 보기";

  include_once( G5_ADMIN_PATH .'/admin.head.php' );

  $top_menu = 'region.list';
  include_once( piree__admin_path($sub_menu, 'top.menu.inc.php') );


?>

  <section>

    <div class="cl_bo ov_hi">
      <div class="fl_left">
        <a href="region.regist.form.php?view_mode=<?php echo $view_mode ?>" class="btn_frmline btn">지역 등록하기</a>
        <a href="region.list.php" class="btn_frmline btn">전체보기</a>
        <a href="region.list.php?view_mode=top" class="btn_frmline btn">최상위보기</a>
        <a href="region.list.php?view_mode=depth" class="btn_frmline btn">계층보기</a>
      </div>

      <div class="fl_right">
        <?php echo $page_navi_s; ?>
      </div>
    </div>

    <div class="cl_bo" style="margin-top:16px;">
      <span class="font_999">전체</span> 
      <span class="str_4466ff_bold_11"><?php echo number_format($list_all_t); ?></span> 
      <span class="font_999">건</span> 
<?php

    IF ( $list_res_t > 0 )
    {
?>
      <span class="font_999"> | </span> 
      <span class="font_999">결과</span> 
      <span class="str_4466ff_bold_11"><?php echo number_format($list_all_t); ?></span> 
      <span class="font_999">건 | </span> 
<?php
    }

?>
    </div>

    <div class="tbl_head01 tbl_wrap">
        <table>
        <caption>지역 목록</caption>
        <thead>
        <tr>
          <th scope="col">지역번호</th>
          <th scope="col">단계</th>
          <th scope="col">지역이름</th>
          <th scope="col">추가</th>
          <th scope="col">수정</th>
          <th scope="col">삭제</th>
          <th scope="col">하위지역</th>
          <th scope="col">회원</th>
          <th scope="col">게시글</th>
          <th scope="col">등록일시</th>
        </tr>
        </thead>
        <tbody>

<?php

  IF ( $list_res_t > 0 )
  {

    FOR ( $i=0; $row=sql_fetch_array($result); $i++ )
    {

        $loop_region_n = $row['region_n'];

        $region_l_s = get_text($row['region_l_s']);

        $in_regist_date = date('Y-m-d H:i', $row['region_regi_time_n']);

        SWITCH ( $row['region_depth_n'] )
        {
            CASE 1 :     $in_left_width = 2;      $in_left_image = $left_image_trans;     $depth_class = "str_3334dd_bold_11";     BREAK;
            CASE 2 :     $in_left_width = 27;     $in_left_image = $left_image_arrow;     $depth_class = "str_4466ff_11";          BREAK;
        }

        $in_qry_s  = 'view_mode='. $view_mode .'&region_n='. $loop_region_n;
        $in_qry_s  = 'view_mode=depth&region_n='. $loop_region_n;
        $in_link_l = 'region.list.php?'. $in_qry_s;
        $in_link_m = 'region.list.multi.php?'. $in_qry_s;

?>
        <tr id="region_point_<?php echo $loop_region_n ?>">
          <td class="td_right_70"><a href="<?php echo $in_link_m ?>"><?php echo $loop_region_n ?></a></td>
          <td class="td_center_40"><span class="font_777"><?php echo $row['region_depth_n'] ?></span></td>
          <td class="td_left">
            <div style="float:left;width:<?php echo $in_left_width ?>px;text-align:right;"><img src="<?php echo $in_left_image ?>"></div>
            <div style="float:left;padding-left:5px;"><a href="<?php echo $in_link_l ?>" class="<?php echo $depth_class ?>"><?php echo $row['region_l_s'] ?></a><?php  IF ( $row['region_s_s'] && $row['region_l_s'] != $row['region_s_s'] ) { echo "<br><span class=\"font_999\">( ". $row['region_s_s'] ." )</span>"; }  ?></div>
          </td>
          <td class="td_center_40"><?php IF ( $row['region_depth_n'] < 2 ) { ?><a href="region.regist.form.php?view_mode=<?php echo $view_mode ?>&region_n=<?php echo $loop_region_n ?>" class="str_37b44a">추가</a><?php } ?></td>
          <td class="td_center_40"><a href="region.regist.form.php?view_mode=<?php echo $view_mode ?>&region_n=<?php echo $loop_region_n ?>&mode=update" class="str_37b44a">수정</a></td>
          <td class="td_center_40"><a href="region.delete.form.php?view_mode=<?php echo $view_mode ?>&region_n=<?php echo $loop_region_n ?>" class="str_ff3333_9">삭제</a></td>
          <td class="td_right_60"><?php  IF ( $row['region_depth_n'] < 2 )  { echo number_format($row['region_sub_t']) .' <span class="font_999">개</span>'; }  ELSE  { echo '<span class="font_999">-</span>'; }  ?> </td>
          <td class="td_right_60"><?php echo number_format($row['region_member_t']); ?> <span class="font_999">명</span></td>
          <td class="td_right_60"><?php echo number_format($row['region_article_t']); ?> <span class="font_999">개</span></td>
          <td class="td_center_120"><?php echo $in_regist_date ?></td>
        </tr>
<?php

    }

  }
  ELSE
  {

?>
        <tr>
          <td colspan="10" align="center"><strong>등록된 [ 지역 ]이 없습니다.</strong></td>
        </tr>

<?php

  }

?>

        </tbody>
        </table>
    </div>

    <div class="cl_bo ov_hi">
      <div class="fl_left">
        <a href="region.regist.form.php?view_mode=<?php echo $view_mode ?>" class="btn_frmline btn">지역 등록하기</a>
        <a href="region.list.php" class="btn_frmline btn">전체보기</a>
        <a href="region.list.php?view_mode=top" class="btn_frmline btn">최상위보기</a>
        <a href="region.list.php?view_mode=depth" class="btn_frmline btn">계층보기</a>
      </div>

      <div class="fl_right">
        <?php echo $page_navi_s; ?>
      </div>
    </div>

  </section>

<br>

<?php

  include_once( piree__admin_path($sub_menu, 'charged.guide.inc.php') );

?>

<script>

function region_list_submit(f)
{
    if (!is_checked("chk[]")) {
        alert(document.pressed+" 하실 항목을 하나 이상 선택하세요.");
        return false;
    }

    IF (document.pressed == "선택삭제") {
        IF (!confirm("선택한 자료를 정말 삭제하시겠습니까?")) {
            return false;
        }
    }

    return true;
}

</script>

<?php

  include_once( G5_ADMIN_PATH .'/admin.tail.php' );

?>