<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작업날짜 : 2024년 04월 01일 월요일 오전 10시 52분 / 맑음, 14.0, 일교차 주의, 18, 3, 0%, 0%, 3.3ms / 나쁨, 58, 20

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 프로그램 > 피리 카페 관리 > CONFIG 파일
=====================================================================

function 

  $piree['cafe'] = G5_TABLE_PREFIX .'_piree__cafe';

DROP TABLE `g5__piree__board_category`;
DROP TABLE `g5__piree__cafe`;
DROP TABLE `g5__piree__cafe_keyword`;
DROP TABLE `g5__piree__cafe_member`;
DROP TABLE `g5__piree__category`;
DROP TABLE `g5__piree__region`;

DELETE FROM g5_write_piree_cafe_1`;

DELETE FROM `g5_board_new`;
DELETE FROM `g5_board_good`;
DELETE FROM `g5_board_file`;
DELETE FROM `g5_scrap`

cut_str($str, $len, $suffix="…")

//-8 문자열 자르기
utf8_strcut( $str, $size, $suffix='...' )

  function piree_cafe_skin_path_get($get_skin_a)

https://piree.kr/nett_dev/piree.nett/program/p770099/keyword.regist.ajax.php?prog_n=770099&piree_cafe_n=1&work_c=piree_cafe.search&keyword_s=%EB%8C%80%ED%95%9C%EB%AF%BC%EA%B5%AD

    IF ( $piree_cafe_n > 0 && $is_cafe_manager == $piree_cafe_n )
    {

    }

    IF ( $is_cafe_manager != $piree_cafe_n )
    {

    }

    $is_cafe_manager = $piree_cafe_n;

피리가 인생을 살며 보고, 듣고, 느낀 이야기들을 기록하는 피리 카페입니다.
열심히 기록할께요.

*/

  IF (!defined('_GNUBOARD_'))                      EXIT;

  IF ( $get__p770000_conf == 1 )
  {

      include_once( piree__path($piree_prog_a[770000]['num'], 'config', 0) );

  }

  $nett_prog_n = 770099;

  $piree_prog_a[$nett_prog_n]['name_l'] = "피리 카페 심플";

  $piree_prog_a[$nett_prog_n]['name_s'] = "피리 카페 그누보드5.5";

  $piree_prog_a[$nett_prog_n]['prog_c'] = "Piree cafe For Gnuboard5.5 Original";

  $piree_prog_a[$nett_prog_n]['version_s'] = "0.0.0.1";

  $piree_prog_a[$nett_prog_n]['memo_s'] = "[ 피리 카페 ]를 기본 관리하는 기능입니다.";

  define('PIREE_CAFE_MANAGE_DIR',         'manage');
  define('PIREE_CAFE_SKIN_BASIC_PC_DIR',  '_basic_skin_pc');
  define('PIREE_CAFE_SKIN_BASIC_MO_DIR',  '_basic_skin_mo');
  define('PIREE_CAFE_SKIN_MANAGE_PC_DIR', '_manage_skin_pc');
  define('PIREE_CAFE_SKIN_MANAGE_MO_DIR', '_manage_skin_mo');
  define('PIREE_CAFE_SKIN_BOARD_PC_DIR',  '_board_skin_pc');
  define('PIREE_CAFE_SKIN_BOARD_MO_DIR',  '_board_skin_mo');
  define('PIREE_CAFE_SKIN_LATEST_PC_DIR', '_latest_skin_pc');
  define('PIREE_CAFE_SKIN_LATEST_MO_DIR', '_latest_skin_mo');

  define('PIREE_CAFE_MAIN_URL',  piree__url($piree_prog_a[770099]['num'], 'cafe.index.php'));
  define('PIREE_CAFE_MAIN_PATH', piree__path($piree_prog_a[770099]['num'], 'cafe.index.php'));

  define('PIREE_CAFE_MANAGE_URL',  piree__url($piree_prog_a[770099]['num'], '') . PIREE_CAFE_MANAGE_DIR);
  define('PIREE_CAFE_MANAGE_PATH', piree__path($piree_prog_a[770099]['num'], '') . PIREE_CAFE_MANAGE_DIR);

  $p770099__cafe_logo_url_s = piree__url($piree_prog_a[770099]['num'], 'piree__156_38__1.png');

  $p770099__word_data_work_c = 'piree_cafe.search';

  $p770099__piree_cafe_code_len_min_n = 8;
  $p770099__piree_cafe_code_len_max_n = 16;

  $p770099__piree_cafe_name_len_min_n = 12;
  $p770099__piree_cafe_name_len_max_n = 254;

  $sql_article_category_s = "`wr_pi_piree_cafe_n` = '". $piree_cafe_n ."'";

  $cafe_member_level_a = array();

  $cafe_member_level_a[250] = array('num'=>250, 'name'=>'주인');
  $cafe_member_level_a[240] = array('num'=>240, 'name'=>'관리자');
  $cafe_member_level_a[230] = array('num'=>230, 'name'=>'매니저');

  $cafe_member_level_a[10]  = array('num'=>10,  'name'=>'레벨 10');
  $cafe_member_level_a[9]   = array('num'=>9,   'name'=>'레벨 9');
  $cafe_member_level_a[8]   = array('num'=>8,   'name'=>'레벨 8');
  $cafe_member_level_a[7]   = array('num'=>7,   'name'=>'레벨 7');
  $cafe_member_level_a[6]   = array('num'=>6,   'name'=>'레벨 6');
  $cafe_member_level_a[5]   = array('num'=>5,   'name'=>'레벨 5');
  $cafe_member_level_a[4]   = array('num'=>4,   'name'=>'레벨 4');
  $cafe_member_level_a[3]   = array('num'=>3,   'name'=>'레벨 3');
  $cafe_member_level_a[2]   = array('num'=>2,   'name'=>'레벨 2');
  $cafe_member_level_a[1]   = array('num'=>1,   'name'=>'레벨 1');

  $piree['cafe'] = G5_TABLE_PREFIX .'_piree__cafe';

  $piree['cafe_member'] = G5_TABLE_PREFIX .'_piree__cafe_member';

  $piree['cafe_keyword'] = G5_TABLE_PREFIX .'_piree__cafe_keyword';

  $piree['category'] = G5_TABLE_PREFIX .'_piree__category';

  $piree['cafe_board'] = G5_TABLE_PREFIX .'_piree__board_category';

  $piree['region'] = G5_TABLE_PREFIX .'_piree__region';

  $piree['cafe_board_code'] = 'piree_cafe_1';

  $piree['cafe_article'] = $g5['write_prefix'] . $piree['cafe_board_code'];

  function piree_cafe_auth_get()
  {

    global $is_admin;
    global $member;
    global $piree_cafe_n;
    global $piree_cafe_a;
    global $is_cafe_manager;

    $save_auth_n = 0;

    IF ( $is_admin == 'super' )
    {

      $save_auth_n++;
    }

    IF ( $piree_cafe_n > 0 && $is_cafe_manager == $piree_cafe_n )
    {

      $save_auth_n++;
    }

    IF ( $member['mb_id'] && $member['mb_id'] == $piree_cafe_a['cafe_mem_id'] )
    {

      $save_auth_n++;
    }

    return $save_auth_n;

  }

  function piree_cafe_sql_get($get_piree_cafe_n=0, $get_piree_cafe_c='')
  {

    $where_a = array();

    $where_s = '';

    IF ( $get_piree_cafe_n > 0 || $get_piree_cafe_c )
    {

      IF ( $get_piree_cafe_n > 0 )
      {

        $where_a[] = "`cafe_row_n` = '". $get_piree_cafe_n ."'";

      }

      IF ( $get_piree_cafe_c )
      {

        $where_a[] = "`cafe_code_c` = '". $get_piree_cafe_c ."'";

      }

      IF ( count($where_a) > 0 )
      {

        $where_s = implode(' OR ', $where_a);

      }

    }

    return $where_s;

  }

  function get_piree_cafe_info($get_piree_cafe_n=0, $get_piree_cafe_c='')
  {

    global $piree;

    $piree_cafe_row_a = array();

    IF ( $get_piree_cafe_n > 0 || $get_piree_cafe_c )
    {

      $where_s = piree_cafe_sql_get($get_piree_cafe_n, $get_piree_cafe_c);

      $sql_select  = "SELECT * FROM `". $piree['cafe'] ."` ";
      $sql_select .= "WHERE ". $where_s;
      $piree_cafe_row_a = sql_fetch($sql_select);

    }

    return $piree_cafe_row_a;

  }

  function get_piree_cafe_page($get_page_s='', $get_qry_s='')
  {

    global $piree;
    global $piree_prog_a;
    global $piree_cafe__prog_a;

    $piree_cafe__url_s = '';

    SWITCH ($get_page_s)
    {
      CASE '' :                         $piree_cafe__url_s = piree__path($piree_prog_a[770099]['num'], $get_page_s);                   BREAK;
      CASE 'member.join.form.php' :     $piree_cafe__url_s = piree__path($piree_prog_a[770099]['num'], $get_page_s);                   BREAK;
      DEFAULT :                         $piree_cafe__url_s = piree__path($piree_prog_a[770099]['num'], '') .'/'. $get_page_s;          BREAK;
    }

    IF ( $get_qry_s )
    {

      $piree_cafe__url_s .= '?'. $get_qry_s;

    }

    return $piree_cafe__url_s;

  }

  function cafe_index_go($get_piree_cafe_n=0, $get_piree_cafe_c='', $func_url_get_n=1)
  {

    IF ( $get_piree_cafe_c )
    {

      $piree_cafe_url_s = PIREE_CAFE_MAIN_URL .'?piree_cafe_c='. $get_piree_cafe_c;

    }

    IF ( $get_piree_cafe_n > 0 )
    {

      $piree_cafe_url_s = PIREE_CAFE_MAIN_URL .'?piree_cafe_n='. $get_piree_cafe_n;

    }

    IF ( $func_url_get_n == 1 )
    {
      return $piree_cafe_url_s;
    }
    ELSE
    {
      goto_url($piree_cafe_url_s);
      EXIT;
    }

  }

  function get_piree_cafe_main($get_piree_cafe_n=0, $get_piree_cafe_c='')
  {

    global $piree;

    $piree_cafe_url_s = '';

    IF ( $get_piree_cafe_n > 0 || $get_piree_cafe_c )
    {

      $piree_cafe_info_a = get_piree_cafe_info($get_piree_cafe_n, $get_piree_cafe_c);

    }

    IF ( $get_piree_cafe_c )
    {

      $piree_cafe_url_s = PIREE_CAFE_MAIN_URL .'?piree_cafe_c='. $get_piree_cafe_c;

    }

    IF ( $get_piree_cafe_n > 0 )
    {

      $piree_cafe_url_s = PIREE_CAFE_MAIN_URL .'?piree_cafe_n='. $get_piree_cafe_n;

    }

    return $piree_cafe_url_s;

  }

  function get_piree_cafe_url($get_prog_n=0, $get_file_s='', $get_folder_sub_c='')
  {

    global $func_global_a;

    $return_var = '';

    $put_var_a = array();
    $put_var_a['prog_n']     = $get_prog_n;
    $put_var_a['file_s']     = $get_file_s;
    $put_var_a['path_s']     = piree__path($piree_prog_a[770099]['num'], '');
    $put_var_a['folder_c']   = 'piree_cafe_';
    $put_var_a['folder_sub'] = $get_folder_sub_c;

    $return_var = file_path_get($put_var_a);

    return $return_var;

  }

  function get_piree_cafe_path($get_prog_n=0, $get_file_s='', $get_folder_sub_c='')
  {

    global $func_global_a;

    $return_var = '';

    $put_var_a = array();
    $put_var_a['prog_n']     = $get_prog_n;
    $put_var_a['file_s']     = $get_file_s;
    $put_var_a['path_s']     = piree__path($piree_prog_a[770099]['num'], '');
    $put_var_a['folder_c']   = 'piree_cafe_';
    $put_var_a['folder_sub'] = $get_folder_sub_c;

    $return_var = file_path_get($put_var_a);

    return $return_var;

  }

  function get_piree_cafe_domain($get_domain_s)
  {

    $domain_at_s = '';

    IF ( $get_domain_s )
    {

      $domain_at_s = '@'. $get_domain_s;

    }

    return $domain_at_s;

  }

  function get_piree_cafe_member_row($get_piree_cafe_n, $get_cafe_member_id)
  {

    $piree_cafe_member_a = array();

    IF ( $get_piree_cafe_n > 0 && $get_cafe_member_id )
    {

      global $piree;

      $sql_select  = "SELECT * FROM `". $piree['cafe_member'] ."` ";
      $sql_select .= "WHERE `cfml_cafe_n` = '". $get_piree_cafe_n ."' AND `cfml_mem_id` = '". $get_cafe_member_id ."'";
      $piree_cafe_member_a = sql_fetch($sql_select);

    }

    return $piree_cafe_member_a;

  }

  function go_piree_cafe_board($get_file_s='piree.cafe.board.php', $get_piree_cafe_n, $get_board_cate_n, $get_article_n=0, $get_comment_n=0)
  {

    global $piree;
    global $piree_prog_a;

    $return_article_url = '';

    IF ( $get_piree_cafe_n > 0 )
    {

      $piree_cafe_board_file_a = array();
      $piree_cafe_board_file_a[] = 'piree.cafe.board.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.write.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.delete.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.password.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.move.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.scrap.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.scrap_popin.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.good.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.comment_delete.php';
      $piree_cafe_board_file_a[] = 'member.info.view.php';

      IF ( !in_array($get_file_s, $piree_cafe_board_file_a) )
      {
        $get_file_s = 'piree.cafe.board.php';
      }

      $return_article_url  = piree__url($piree_prog_a[770099]['num'], $get_file_s) .'?';
      $return_article_url .= 'piree_cafe_n='. $get_piree_cafe_n;
      $return_article_url .= '&amp;bo_table='. $piree['cafe_board_code'];

      IF ( $get_board_cate_n > 0 )
      {

        $return_article_url .= '&amp;board_cate_n='. $get_board_cate_n;

      }

      IF ( $get_article_n > 0 )
      {

        $return_article_url .= '&amp;wr_id='. $get_article_n;

      }

      IF ( $get_comment_n > 0 )
      {

        $return_article_url .= '#c_'. $get_comment_n;

      }

    }

    return $return_article_url;

  }

  function get_piree_cafe_sql_search($search_field, $search_text, $search_operator='and')
  {

    global $g5;

    $func_sql_where_s = "";

    $search_text = strip_tags(($search_text));
    $search_text = trim(stripslashes($search_text));

    IF ( !$search_text && $search_text !== '0' )
    {

      return '0';

    }

    IF ( $func_sql_where_s )
    {

      $func_sql_where_s .= " AND ";

    }

    $op1 = "";

    $s = array();
    $s = explode(" ", $search_text);


    $tmp = array();
    $tmp = explode(",", trim($search_field));

    $field = explode("||", $tmp[0]);

    $not_comment = "";

    IF ( !empty($tmp[1]) )
    {

      $not_comment = $tmp[1];
    }

    $func_sql_where_s .= "(";

    FOR ( $loop_one_n=0; $loop_one_n<count($s); $loop_one_n++ )
    {

      $search_str = trim($s[$loop_one_n]);

      IF ( $search_str == "" )
      {

        continue;

      }

      insert_popular($field, $search_str);

      $func_sql_where_s .= $op1;
      $func_sql_where_s .= "(";

      $op2 = "";

      FOR ( $loop_two_n=0; $loop_two_n<count($field); $loop_two_n++ )
      {

        $field[$loop_two_n] = preg_match("/^[\w\,\|]+$/", $field[$loop_two_n]) ? strtolower($field[$loop_two_n]) : "wr_subject";

        $func_sql_where_s .= $op2;

        SWITCH ($field[$loop_two_n])
        {

          CASE "mb_id" :

          BREAK;

          CASE "wr_name" :
            $func_sql_where_s .= " ". $field[$loop_two_n] ." = '". $s[$loop_one_n] ."' ";
          BREAK;

          CASE "wr_hit" :

          BREAK;

          CASE "wr_good" :

          BREAK;

          CASE "wr_nogood" :
            $func_sql_where_s .= " ". $field[$loop_two_n] ." >= '". $s[$loop_one_n] ."' ";
          BREAK;

          CASE "wr_num" :
            $func_sql_where_s .= " ". $field[$loop_two_n] ." = ". ((-1)*$s[$loop_one_n]);
          BREAK;

          CASE "wr_ip" :

          BREAK;

          CASE "wr_password" :
            $func_sql_where_s .= "1=0";
          BREAK;

          DEFAULT :

            IF ( preg_match("/[a-zA-Z]/", $search_str) )
            {
              $func_sql_where_s .= "INSTR(LOWER(". $field[$loop_two_n] ."), LOWER('". $search_str ."'))";
            }
            ELSE
            {
              $func_sql_where_s .= "INSTR(". $field[$loop_two_n] .", '". $search_str ."')";
            }

          BREAK;

        }

        $op2 = " OR ";

      }

      $func_sql_where_s .= ")";

      $op1 = " ". $search_operator ." ";

    }

    $func_sql_where_s .= " ) ";

    IF ( $not_comment )
    {
      $func_sql_where_s .= " AND `wr_is_comment` = '0' ";
    }

    return $func_sql_where_s;

  }

  function get_piree_cafe_board_sort_fields($board_cate_a=array(), $make_key_return='')
  {

    $bo_sort_fields = run_replace('get_board_sort_fields', array(
        array('wr_num, wr_reply', '기본'),
        array('wr_datetime asc', '날짜 이전것 부터'),
        array('wr_datetime desc', '날짜 최근것 부터'),
        array('wr_hit asc, wr_num, wr_reply', '조회수 낮은것 부터'),
        array('wr_hit desc, wr_num, wr_reply', '조회수 높은것 부터'),
        array('wr_last asc', '최근글 이전것 부터'),
        array('wr_last desc', '최근글 최근것 부터'),
        array('wr_comment asc, wr_num, wr_reply', '댓글수 낮은것 부터'),
        array('wr_comment desc, wr_num, wr_reply', '댓글수 높은것 부터'),
        array('wr_good asc, wr_num, wr_reply', '추천수 낮은것 부터'),
        array('wr_good desc, wr_num, wr_reply', '추천수 높은것 부터'),
        array('wr_nogood asc, wr_num, wr_reply', '비추천수 낮은것 부터'),
        array('wr_nogood desc, wr_num, wr_reply', '비추천수 높은것 부터'),
        array('wr_subject asc, wr_num, wr_reply', '제목 오름차순'),
        array('wr_subject desc, wr_num, wr_reply', '제목 내림차순'),
        array('wr_name asc, wr_num, wr_reply', '글쓴이 오름차순'),
        array('wr_name desc, wr_num, wr_reply', '글쓴이 내림차순'),
        array('ca_name asc, wr_num, wr_reply', '분류명 오름차순'),
        array('ca_name desc, wr_num, wr_reply', '분류명 내림차순'),
    ), $board_cate_a, $make_key_return);

    IF ( $make_key_return )
    {
        
      $returns = array();

      FOREACH( $bo_sort_fields as $v )
      {
        $key = preg_replace("/[\<\>\'\"\\\'\\\"\%\=\(\)\/\^\*\s]/", "", $v[0]);
        $returns[$key] = $v[0];
      }
        
      return $returns;

    }

    return $bo_sort_fields;

  }

  function get_piree_cafe_article_count($func_cate_n, $func_cate_depth_n, $func_fd_c='wr_pi_board_cate_n')
  {

    global $g5;

    $func_sql_where_s = "";

    IF ( $func_cate_n > 0 )
    {

      SWITCH ( $func_cate_depth_n )
      {
        CASE 1 :     $func_sql_where_s .= "`". $func_fd_c ."` BETWEEN '". $func_cate_n ."' AND '". ($func_cate_n+99) ."'";     BREAK;
        CASE 2 :     $func_sql_where_s .= "`". $func_fd_c ."` = '". $func_cate_n ."'";                                        BREAK;
      }

    }

    return $func_sql_where_s;

  }

  function piree_cafe_latest_make($func_piree_cafe_n, $func_board_cate_n=0, $skin_dir='', $func_scale_n=10, $subject_len=40, $cache_time=1, $options='')
  {

    global $g5;
    global $piree;
    global $piree_prog_a;
    global $piree_cafe_a;
    global $board_cate_list_a;
    global $piree_cafe_skin_basic_u;
    global $piree_cafe_skin_basic_p;

    IF ( !$skin_dir )
    {
      $skin_dir = 'piree_basic';
    }

    $time_unit = 3600;

    $caches = false;

    IF ( G5_USE_CACHE )
    {

      $cache_file_name = "latest-". $func_piree_cafe_n ."-". $func_board_cate_n ."-". $skin_dir ."-". $func_scale_n ."-". $subject_len ."-". g5_cache_secret_key();

      $caches = g5_get_cache($cache_file_name, (int) $time_unit * (int) $cache_time);

      $cache_list = isset($caches['list']) ? $caches['list'] : array();

      piree_cafe_latest_cache_data($func_piree_cafe_n, $func_board_cate_n, $cache_list);

    }

    $caches = false;

    IF ( $caches === false )
    {

      $list = array();

      $func_board_cate_a = $board_cate_list_a[$func_board_cate_n];

      IF ( !$func_board_cate_a )
      {
        return '';
      }

      IF ( $func_board_cate_a['bca_s_p'] )
      {

        $bca_cate_s = $func_board_cate_a['bca_s_p'];
        $bca_cate_s = str_replace('--', ' > ', $func_board_cate_a['bca_s_p']);
        $bca_cate_s = get_text($bca_cate_s);
        $bca_cate_s = trim($bca_cate_s);

      }
      ELSE
      {

        $bca_cate_s = get_text($func_board_cate_a['bca_cate_s']);

      }

      $sql_where_a = array();

      $sql_where_s = "";

      $sql_where_a[] = "`wr_pi_piree_cafe_n` = '". $func_piree_cafe_n ."'";

      IF ( $func_board_cate_n > 0 )
      {

        include_once( piree__path($piree_prog_a[770000]['num'], 'cafe.board.category.smallint.2.lib.php') );

        $temp_cate_a = get_category_upper_smallint2_cafe_board($func_board_cate_n);

        $board_cate_depth_n = $temp_cate_a[0];

        SWITCH ( $board_cate_depth_n )
        {
          CASE 1 :     $sql_where_cafe_cate_where_s = "(`wr_pi_board_cate_n` BETWEEN '". $func_board_cate_n ."' AND '". ($func_board_cate_n+99) ."')";     BREAK;
          CASE 2 :     $sql_where_cafe_cate_where_s = "`wr_pi_board_cate_n` = '". $func_board_cate_n ."'";                                                 BREAK;
        }

        $sql_where_a[] = $sql_where_cafe_cate_where_s;

      }

      IF ( count($sql_where_a) > 0 )
      {

        $sql_where_s = implode(' AND ', $sql_where_a);

      }

      $sql_select  = "SELECT * FROM `". $piree['cafe_article'] ."` ";
      $sql_select .= "WHERE ". $sql_where_s ." AND `wr_is_comment` = '0' ";
      $sql_select .= "ORDER BY `wr_num` LIMIT 0, ". $func_scale_n;
      $result = sql_query($sql_select);

      FOR ( $loop_n=0; $row = sql_fetch_array($result); $loop_n++ )
      {

        try
        {
          unset($row['wr_password']);
        }
        catch (Exception $e)
        {
        }

        $row['wr_email'] = '';

        IF ( strstr($row['wr_option'], 'secret') )
        {
          $row['wr_content'] = $row['wr_link1'] = $row['wr_link2'] = '';
          $row['file'] = array('count'=>0);
        }

        $list[$loop_n] = get_list($row, $func_board_cate_a, $latest_skin_url, $subject_len);

        $list[$loop_n]['first_file_thumb'] = (isset($row['wr_file']) && $row['wr_file']) ? get_board_file_db($bca_table, $row['wr_id'], 'bf_file, bf_content', "and bf_type in (1, 2, 3, 18) ", true) : array('bf_file'=>'', 'bf_content'=>'');

        $list[$loop_n]['cafe_name_s'] = $piree_cafe_a['cfml_cafe_s'];

        $list[$loop_n]['bo_table'] = $piree['cafe_board_code'];

        IF ( $options && is_string($options) )
        {

          $options_arr = explode(',', $options);
          $thumb_width = $options_arr[0];
          $thumb_height = $options_arr[1];
          $thumb = get_list_thumbnail($bca_table, $row['wr_id'], $thumb_width, $thumb_height, false, true);

          IF ( $thumb['src'] )
          {
            $img_content = '<img src="'. $thumb['src'].'" alt="'. $thumb['alt'].'" width="'. $thumb_width.'" height="'. $thumb_height.'">';
            $list[$loop_n]['img_thumbnail'] = '<a href="'. $list[$loop_n]['href'].'" class="lt_img">'. $img_content.'</a>';
          }
          ELSE
          {
          }

        }

        IF ( !isset($list[$loop_n]['icon_file']) )
        {
          $list[$loop_n]['icon_file'] = '';
        }

      }

      piree_cafe_latest_cache_data($func_piree_cafe_n, $func_board_cate_n, $list);

      IF ( G5_USE_CACHE )
      {

        $caches = array(
                        'list' => $list,
                        'bca_cate_s' => sql_escape_string($bca_cate_s),
                        'piree_cafe_n' => $func_piree_cafe_n,
                        'board_cate_n' => $func_board_cate_n,
                        'board_cate_depth_n' => $board_cate_depth_n
                        );

        g5_set_cache($cache_file_name, $caches, (int) $time_unit * (int) $cache_time);

      }

    }
    ELSE
    {

      $list = $cache_list;

      $bca_cate_s = (is_array($caches) && isset($caches['bca_cate_s'])) ? $caches['bca_cate_s'] : '';

    }

    ob_start();

    include get_cafe_skin_file('path', 'basic', 'latest.skin.php');

    $content = ob_get_contents();

    ob_end_clean();

    return $content;

  }

  function piree_cafe_latest_cache_data($func_piree_cafe_n, $func_board_cate_n=0, $cache_list=array(), $find_wr_id=0)
  {

    static $cache = array();

    IF ( $bo_table && $cache_list && ! isset($cache[$bo_table]) )
    {

      FOREACH( (array) $cache_list as $wr )
      {

        IF ( empty($wr) || ! isset($wr['wr_id']) )
        {
          continue;
        }

        $cache[$bo_table][$wr['wr_id']] = $wr;

      }

    }

    IF ( $find_wr_id && isset($cache[$bo_table][$find_wr_id]) )
    {
      return $cache[$bo_table][$find_wr_id];
    }

  }

  function get_cafe_skin_file($func_schema_c='path', $func_div_c, $func_skin_file_s='', $func_device_c='')
  {

    global $piree_prog_a;
    global $piree_cafe_a;
    global $p770099__prog_u;
    global $p770099__prog_p;

    IF ( !$func_skin_file_s )
    {

      alert("불러오려는 파일 이름이 없습니다.");
    }

    $skin_file_exist_n = 0;

    $piree_cafe_skin_c = '';
    $piree_cafe_skin_u = '';
    $piree_cafe_skin_p = '';

    SWITCH ( $func_div_c )
    {

      CASE 'manage' :

        IF ( G5_IS_MOBILE && $func_device_c != 'pc' )
        {

/*

          $piree_cafe_skin_mo_c = $piree_cafe_a['cafe_skin_manage_mo_c'];

          $piree_cafe_skin_mo_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;

// ( file_exists($piree_cafe_skin_mo_p) )
// ( is_dir($piree_cafe_skin_mo_p) )
          IF ( file_exists($piree_cafe_skin_mo_p) )
          {

            $piree_cafe_skin_mo_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;

            $skin_file_exist_n++;

          }
          ELSE
          {

            $piree_cafe_skin_mo_c = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_manage_mo_c'];

            $piree_cafe_skin_mo_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;

            IF ( file_exists($piree_cafe_skin_mo_p) )
            {

              $piree_cafe_skin_mo_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;

              $skin_file_exist_n++;

            }

          }

          IF ( $skin_file_exist_n > 0 )
          {

            $piree_cafe_skin_c = $piree_cafe_skin_mo_c;
            $piree_cafe_skin_u = $piree_cafe_skin_mo_u;
            $piree_cafe_skin_p = $piree_cafe_skin_mo_p;

          }

*/

          $piree_cafe_skin_pc_c = $piree_cafe_a['cafe_skin_manage_pc_c'];

          $piree_cafe_skin_pc_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

          IF ( file_exists($piree_cafe_skin_pc_p) )
          {

            $piree_cafe_skin_pc_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

            $skin_file_exist_n++;

          }
          ELSE
          {

            $piree_cafe_skin_pc_c = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_manage_pc_c'];

            $piree_cafe_skin_pc_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

            IF ( file_exists($piree_cafe_skin_pc_p) )
            {

              $piree_cafe_skin_pc_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

              $skin_file_exist_n++;

            }

          }

          IF ( $skin_file_exist_n > 0 )
          {

            $piree_cafe_skin_c = $piree_cafe_skin_pc_c;
            $piree_cafe_skin_u = $piree_cafe_skin_pc_u;
            $piree_cafe_skin_p = $piree_cafe_skin_pc_p;

          }

        }
        ELSE
        {

          $piree_cafe_skin_pc_c = $piree_cafe_a['cafe_skin_manage_pc_c'];

          $piree_cafe_skin_pc_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

          IF ( file_exists($piree_cafe_skin_pc_p) )
          {

            $piree_cafe_skin_pc_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

            $skin_file_exist_n++;

          }
          ELSE
          {

            $piree_cafe_skin_pc_c = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_manage_pc_c'];

            $piree_cafe_skin_pc_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

            IF ( file_exists($piree_cafe_skin_pc_p) )
            {

              $piree_cafe_skin_pc_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

              $skin_file_exist_n++;

            }

          }

          IF ( $skin_file_exist_n > 0 )
          {

            $piree_cafe_skin_c = $piree_cafe_skin_pc_c;
            $piree_cafe_skin_u = $piree_cafe_skin_pc_u;
            $piree_cafe_skin_p = $piree_cafe_skin_pc_p;

          }

        }

      BREAK;

      # CASE 'basic' :
      DEFAULT :

        IF ( G5_IS_MOBILE && $func_device_c != 'pc' )
        {

          $piree_cafe_skin_mo_c = $piree_cafe_a['cafe_skin_basic_mo_c'];

          $piree_cafe_skin_mo_p = $p770099__prog_p . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;

          IF ( file_exists($piree_cafe_skin_mo_p) )
          {

            $piree_cafe_skin_mo_u = $p770099__prog_u . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;

            $skin_file_exist_n++;

          }
          ELSE
          {

            $piree_cafe_skin_mo_c = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_basic_mo_c'];

            $piree_cafe_skin_mo_p = $p770099__prog_p . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;

            IF ( file_exists($piree_cafe_skin_mo_p) )
            {

              $piree_cafe_skin_mo_u = $p770099__prog_u . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;

              $skin_file_exist_n++;

            }

          }

          IF ( $skin_file_exist_n > 0 )
          {

            $piree_cafe_skin_c = $piree_cafe_skin_mo_c;
            $piree_cafe_skin_u = $piree_cafe_skin_mo_u;
            $piree_cafe_skin_p = $piree_cafe_skin_mo_p;

          }

        }
        ELSE
        {

          $piree_cafe_skin_pc_c = $piree_cafe_a['cafe_skin_basic_pc_c'];

          $piree_cafe_skin_pc_p = $p770099__prog_p . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

          IF ( file_exists($piree_cafe_skin_pc_p) )
          {

            $piree_cafe_skin_pc_u = $p770099__prog_u . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

            $skin_file_exist_n++;

          }
          ELSE
          {

            $piree_cafe_skin_pc_c = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_basic_pc_c'];

            $piree_cafe_skin_pc_p = $p770099__prog_p . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

            IF ( file_exists($piree_cafe_skin_pc_p) )
            {

              $piree_cafe_skin_pc_u = $p770099__prog_u . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;

              $skin_file_exist_n++;

            }

          }

          IF ( $skin_file_exist_n > 0 )
          {

            $piree_cafe_skin_c = $piree_cafe_skin_pc_c;
            $piree_cafe_skin_u = $piree_cafe_skin_pc_u;
            $piree_cafe_skin_p = $piree_cafe_skin_pc_p;

          }

        }

      BREAK;

    }

    SWITCH ( $func_schema_c )
    {

      CASE 'path' :

        return $piree_cafe_skin_p;

      BREAK;

      CASE 'url' :

        return $piree_cafe_skin_u;

      BREAK;

      DEFAULT :

        $return_a = array();
        $return_a['url']  = $piree_cafe_skin_u;
        $return_a['path'] = $piree_cafe_skin_p;

        return $return_a;

      BREAK;

    }

  }

  function piree_cafe_table_get($func_piree_cafe_n=0, $func_table_n=0)
  {

    IF ( $func_piree_cafe_n > 0 || $func_table_n > 0 )
    {

      global $piree;

      $table_info_a['table_n'] = 0;
      $table_info_a['table_c'] = '';

      IF ( $func_piree_cafe_n > 0 )
      {
        $table_info_a['table_n'] = ceil($func_piree_cafe_n/$piree['lindex_data_div_n']);
      }
      ELSE
      {
        $table_info_a['table_n'] = $func_table_n;
      }

      $table_info_a['table_c'] = $piree['cafe'] .'_'. $table_info_a['table_n'];

      return $table_info_a;

    }

  }

  function get__prog_info__770099($func_prog_version_s)
  {

      global $piree, $piree_prog_a, $prog_config_page;

      $prog_info = array();

      IF ( $piree_prog_a[770099]['num'] > 0 )
      {

          $sql_select  = "SELECT * FROM `". $piree['program_sam'] ."` ";
          $sql_select .= "WHERE `pgs_prog_n` = '". $piree_prog_a[770099]['num'] ."' AND `pgs_version_s` = '". $func_prog_version_s ."'";
          $row = sql_fetch($sql_select, false);

          IF ( !isset($row['pgs_prog_n'] ))
          {

              global $is_admin, $is_extend;

              IF ( $is_admin)
              {

                  IF ( $prog_config_page != 1 && $is_extend == 0 )
                  {

                      $move_url = piree__admin_url($piree_prog_a[770099]['num']);

                      alert("선택하신 프로그램이 설치되지 않았거나 DB정보가 없습니다. 770099", $move_url);

                  }

              }
              ELSE
              {

                  IF ( $is_extend == 0 )
                  {

//("선택하신 프로그램이 설치되지 않았거나 DB정보가 없습니다. 770099", G5_DOMAIN);

                  }

              }

          }

          IF ( $piree_prog_a[770099]['num'] == $row['pgs_prog_n'] )
          {

              $prog_info = $row;

          }

      }

      return $prog_info;

  }

  function get__piree_cafe__config($func_prog_version_s)
  {

      global $piree, $nett_prog_n, $get__p770000_conf;

      IF ( isset($piree['program_sam'] ) && $get__p770000_conf == 1 )
      {

          $prog_conf = get__prog_info($nett_prog_n, $func_prog_version_s);

      }
      ELSE
      {

          $prog_conf = get__prog_info__770099($func_prog_version_s);

      }

      $prog_conf['g_program_n'] = $nett_prog_n;

      return $prog_conf;

  }

  $use__p770099 = 0;

  IF ( $get__p770099 == 1 )
  {

      $prog_conf = get__piree_cafe__config($piree_prog_a[$piree_prog_a[770099]['num']]['version_s']);

      $p770099__prog_dir = 'p'. $nett_prog_n;

      $p770099__prog_c = $prog_conf['pgs_prog_c'];

      $p770099__prog_u = piree__url($piree_prog_a[770099]['num']);
      $p770099__prog_p = piree__path($piree_prog_a[770099]['num']);

      IF ( $nett_prog_n == $prog_conf['pgs_prog_n'] )
      {

          $use__p770099 = 1;

          $piree_prog_a[$piree_prog_a[770099]['num']]['prog_n'] = $prog_conf['pgs_prog_n'];

          $piree_prog_a[$piree_prog_a[770099]['num']]['prog_prog_c'] = $prog_conf['pgs_prog_c'];

          $piree_prog_a[$piree_prog_a[770099]['num']]['prog_prog_s'] = $prog_conf['pgs_prog_s'];

          $piree_prog_a[$piree_prog_a[770099]['num']]['prog_version_s'] = $prog_conf['pgs_version_s'];

          $piree_prog_a[$piree_prog_a[770099]['num']]['prog_regi_time_n'] = $prog_conf['pgs_regi_time_n'];

          $p770099__prog_top_include_n = $prog_conf['pgs_top_include_n'];
          IF ( $p770099__prog_top_include_n != 1 && $p770099__prog_top_include_n != 11 )
          {
              $p770099__prog_top_include_n = 0;
          }

          $p770099__prog_head_include_n = $prog_conf['pgs_head_include_n'];
          IF ( $p770099__prog_head_include_n != 1 && $p770099__prog_head_include_n != 11 )
          {
              $p770099__prog_head_include_n = 0;
          }

          $p770099__prog_body_include_n = $prog_conf['pgs_body_include_n'];
          IF ( $p770099__prog_body_include_n != 1 && $p770099__prog_body_include_n != 11 )
          {
              $p770099__prog_body_include_n = 0;
          }

          $p770099__skin_pc_c = $prog_conf['pgs_skin_pc_c'];
          $p770099__skin_pc_u = $p770099__prog_u . PIREE_SKIN_PC_DIR ."/". $p770099__skin_pc_c;
          $p770099__skin_pc_p = $p770099__prog_p . PIREE_SKIN_PC_DIR ."/". $p770099__skin_pc_c;

          $p770099__skin_mo_c = $prog_conf['pgs_skin_mo_c'];
          $p770099__skin_mo_u = $p770099__prog_u . PIREE_SKIN_MO_DIR ."/". $p770099__skin_mo_c;
          $p770099__skin_mo_p = $p770099__prog_p . PIREE_SKIN_MO_DIR ."/". $p770099__skin_mo_c;

          IF ( G5_IS_MOBILE )
          {

              $p770099__skin_c = $p770099__skin_mo_c;
              $p770099__skin_u = $p770099__skin_mo_u;
              $p770099__skin_p = $p770099__skin_mo_p;

          }
          ELSE
          {

              $p770099__skin_c = $p770099__skin_pc_c;
              $p770099__skin_u = $p770099__skin_pc_u;
              $p770099__skin_p = $p770099__skin_pc_p;

          }

          $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_basic_pc_c'] = $prog_conf['pgs_cf_2_s'];

          $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_basic_mo_c'] = $prog_conf['pgs_cf_3_s'];

          $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_manage_pc_c'] = $prog_conf['pgs_cf_4_s'];

          $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_manage_mo_c'] = $prog_conf['pgs_cf_5_s'];

          $piree_prog_a[$piree_prog_a[770099]['num']]['profile_image_width_n'] = $prog_conf['pgs_cf_7_n'];

          $piree_prog_a[$piree_prog_a[770099]['num']]['profile_image_height_n'] = $prog_conf['pgs_cf_8_n'];

          $p770099__cafe_skin_basic_c = '';
          $p770099__cafe_skin_basic_u = '';
          $p770099__cafe_skin_basic_p = '';

          $p770099__cafe_skin_basic_pc_c = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_basic_pc_c'];
          $p770099__cafe_skin_basic_pc_u = $p770099__prog_u . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $p770099__cafe_skin_basic_pc_c;
          $p770099__cafe_skin_basic_pc_p = $p770099__prog_p . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $p770099__cafe_skin_basic_pc_c;

          $p770099__cafe_skin_basic_mo_c = $piree_prog_a[$piree_prog_a[770099]['num']]['piree_cafe_skin_basic_mo_c'];
          $p770099__cafe_skin_basic_mo_u = $p770099__prog_u . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $p770099__cafe_skin_basic_mo_c;
          $p770099__cafe_skin_basic_mo_p = $p770099__prog_p . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $p770099__cafe_skin_basic_mo_c;

          IF ( G5_IS_MOBILE )
          {

              $p770099__cafe_skin_basic_c = $p770099__cafe_skin_basic_mo_c;
              $p770099__cafe_skin_basic_u = $p770099__cafe_skin_basic_mo_u;
              $p770099__cafe_skin_basic_p = $p770099__cafe_skin_basic_mo_p;

          }
          ELSE
          {

              $p770099__cafe_skin_basic_c = $p770099__cafe_skin_basic_pc_c;
              $p770099__cafe_skin_basic_u = $p770099__cafe_skin_basic_pc_u;
              $p770099__cafe_skin_basic_p = $p770099__cafe_skin_basic_pc_p;

          }

      }

  }

?>