<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 04월 07일 일요일 오후 14시 57분 / 맑음, 23.2, 일교차 주의, 22, 6, 0%, 0%, 2.3ms / 나쁨, 60, 35, 0.008

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 피리 카페 관리 > 스킨 > MAIN > 회원 목록 보기
=====================================================================


*/

  IF ( !defined('_GNUBOARD_') )                             EXIT;

  // add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
  add_stylesheet('<link rel="stylesheet" href="'. get_cafe_skin_file('url', 'manage', 'p770099.manage.style.pc.css') .'">', 0);

?>
<!---- 시작 => 설정_폼__박스 ---->
  <div class="piree_cafe_body_out">

    <div class="piree_cafe_body_title"><?php echo $g5['title']; ?></div>

    <div class="piree_cafe_body_line" style="margin-bottom:10px;">
      <div class="piree_cafe_body_label td_left_180">
        <span class="font_999">회원</span> 
        <strong><?php echo number_format($piree_cafe_a['cafe_member_t']); ?></strong> <span class="font_999">명</span>
<?php

      IF ( $member_t != $search_t && $search_t > 0 )
      {
?>
        &nbsp; 
        <span class="font_999">/</span> &nbsp; 
        <span class="font_999">화면 결과</span> 
        <strong><?php echo number_format($cafe_member_view_t); ?></strong> <span class="font_999">명</span>
<?php
      }

?>
      </div>
    </div>

<?php

  IF ( $list_pages )
  {
?>
    <div class="piree_cafe_body_line">
      <p style="text-align:center"><?php echo $list_pages;  ?></p>
    </div>
<?php
  }

?>

    <form name="member_list_form" id="member_list_form" action="<?php echo $piree_cafe_board_list_action_u; ?>" onsubmit="return member_list_form_submit(this);" method="post">
    <input type="hidden" name="mode_c"       value="member_list_update">
    <input type="hidden" name="piree_cafe_n" value="<?php echo $piree_cafe_n ?>">
    <input type="hidden" name="board_cate_n" value="<?php echo $board_cate_n ?>">
    <input type="hidden" name="page"         value="<?php echo $page ?>">

    <div id="piree_cafe_member_list" class="tbl_head01 tbl_wrap" style="margin-bottom:90px;">
      <table>
          <caption>회원관리 목록</caption>
        <thead>
        <tr>
          <th scope="col" class="all_chk chk_box" style="padding-left:6px;">
            <input type="checkbox" id="chkall" onclick="if ( this.checked ) all_checked(true); else all_checked(false);" class="selec_chk">
            <label for="chkall">
              <b class="sound_only">현재 페이지 회원  전체선택</b>
            </label>
          </th>
          <th scope="col">번호</th>
          <th scope="col">닉네임</th>
          <th scope="col">아이디</th>
          <th scope="col" colspan="2">카페레벨</th>
          <th scope="col">게시글 수</th>
          <th scope="col">댓글 수</th>
          <th scope="col">가입일시</th>
        </tr>
        </thead>

        <tbody>
<?php

  IF ( $cafe_member_view_t > 0 )
  {

    $loop_n = 0;

    FOREACH ( $cafe_member_list_a AS $key=>$val )
    {

      $in_member_n = $key;

      IF ( $in_member_n%2 == 0 )                    $loop_bg_class = ' class="cl_bg_fbfbfb"';
      ELSE                                          $loop_bg_class = '';

      IF ( $in_member_n%2 == 0 )                    $loop_bg_class = '';
      ELSE                                          $loop_bg_class = ' class="cl_bg_fbfbfb"';

      $member_nick = get_sideview($val['cfml_mem_id'], get_text($val['cfml_mem_nick']));

?>
        <tr>
<?php

        IF ( $val['cfml_cafe_mem_level_n'] > 0 && $val['cfml_cafe_mem_level_n'] < 10 )
        {
?>
          <td class="td_chk chk_box">
            <input type="checkbox" name="chk_member_n[]" value="<?php echo $in_member_n ?>" id="chk_member_n_<?php echo $loop_n ?>" class="selec_chk">
            <label for="chk_member_n_<?php echo $loop_n ?>">
              <span></span>
              <b class="sound_only"><?php echo $val['cfml_mem_id'] ?></b>
            </label>
          </td>
<?php
        }
        ELSE
        {
?>
          <td class="td_chk chk_box"><span class="font_999">-</span></td>
<?php
        }

?>
          <td class="td_center_70"><?php echo $val['cfml_row_n']; ?></td>
          <td class="td_left_280"><?php echo $member_nick; ?></td>
          <td class="td_left_210"><?php echo $val['cfml_mem_id']; ?></td>
<?php

        IF ( $val['cfml_cafe_mem_level_n'] > 0 && $val['cfml_cafe_mem_level_n'] < 10 )
        {
?>
          <td class="td_left_80"><label for="cafe_member_level_<?php echo $in_member_n ?>" class="font_bold_10"><?php echo $cafe_member_level_a[$val['cfml_cafe_mem_level_n']]['name']; ?><strong class="sound_only">필수 선택</strong></label></td>
          <td class="td_left_90">
            <?php echo get_member_level_select__piree('cafe_member_level['. $in_member_n .']', 'cafe_member_level_'. $in_member_n, 1, 9, $val['cfml_cafe_mem_level_n'], '', ''); ?> 
          </td>
<?php
        }
        ELSE
        {
?>
          <td class="td_left_80"><span class="font_222_bold_10"><?php echo $cafe_member_level_a[$val['cfml_cafe_mem_level_n']]['name']; ?></span></td>
          <td class="td_left_90"><span class="font_999">변경 불가</span></td>
<?php
        }

?>
          <td class="td_right_80"><?php echo $val['cfml_article_t']; ?> <span class="font_999">개</span></td>
          <td class="td_right_80"><?php echo $val['cfml_comment_t']; ?> <span class="font_999">개</span></td>
          <td class="td_center_130"><?php echo date('Y-m-d H:i', $val['cfml_join_time_n']); ?></td>
        </tr>
<?php

      $loop_n++;

    }

  }
  ELSE
  {

?>
        <tr>
          <td colspan="7" class="empty_table">피리 카페에 가입된 회원이 없습니다.</td>
        </tr>
<?php

  }

?>

        </tbody>
      </table>
    </div>

    <?php echo $write_pages; ?>

    <div class="btn_confirm fl_left">
        <button type="submit" id="btn_submit" class="btn_submit btn">선택한 회원의 정보를 수정합니다.</button>
    </div>

    </form>

<?php

  IF ( $list_pages )
  {
?>
    <div class="piree_cafe_body_line">
      <p style="text-align:center"><?php echo $list_pages;  ?></p>
    </div>
<?php
  }

?>

  </div>
  <!-- 끝 => 내가__몸통이다 -->

  <script>

    function member_list_form_submit(gform)
    {

      var chk_count = 0;

      for ( var loop_n=0; loop_n<gform.length; loop_n++ )
      {
        if ( gform.elements[loop_n].name == "chk_member_n[]" && gform.elements[loop_n].checked )
        {
          chk_count++;
        }
      }

      if ( !chk_count )
      {
        alert("회원을 1명 이상 선택해 주세요.");
        return false;
      }

      return true;

    }

    function all_checked(sw)
    {

      var f = document.member_list_form;

      for ( var i=0; i<f.length; i++ )
      {
      if ( f.elements[i].name == "chk_member_n[]" )
      {
        f.elements[i].checked = sw;
      }
      }

    }

  </script>
