<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 04월 22일 월요일 오전 08시 23분 / 구름많음, 14.6, 쾌적, 20, 13, 28%, 30%, 1.7ms / 양호, 39, 17

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 프로그램 > 피리 카페 관리 > 내 카페 > 게시판 > 스크랩 하기 > 처리하기
=====================================================================

*/

  include_once('./_common.php');

  run_event('bbs_good_before', $piree['cafe_board_code'], $wr_id, $good);

  include_once( piree__path($piree_prog_a[770099]['num'], '_CAFE.INFO.CHECK.inc.php') );

  @include_once($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/good.head.skin.php' );

  IF ( isset($_POST['js']) && $_POST['js'] === "on" )
  {

      $error = $count = "";

      function print_result($error, $count)
      {

          echo '{ "error": "' . $error . '", "count": "' . $count . '" }';

          IF ( $error )
          {

              exit;

          }

      }

      IF ( !$is_member )
      {
          $error = '회원만 가능합니다.';
          print_result($error, $count);
      }

      IF ( !($piree['cafe_board_code'] && $wr_id) )
      {
          $error = '값이 제대로 넘어오지 않았습니다.';
          print_result($error, $count);
      }

      $ss_name = 'ss_view_'. $piree['cafe_board_code'] .'_'. $wr_id;

      IF ( !get_session($ss_name) )
      {
          $error = '해당 게시물에서만 추천 또는 비추천 하실 수 있습니다.';
          print_result($error, $count);
      }

      $sql_select = "SELECT COUNT(*) AS cnt FROM `". $piree['cafe_article'] ."`";
      $row = sql_fetch($sql_select, FALSE);

      IF ( !$row['cnt'] )
      {
          $error = '존재하는 게시판이 아닙니다.';
          print_result($error, $count);
      }

      IF ( $good == 'good' || $good == 'nogood')
      {

          IF ( $write['mb_id'] == $member['mb_id'] )
          {
              $error = '자신의 글에는 추천 또는 비추천 하실 수 없습니다.';
              print_result($error, $count);
          }

          IF ( !$board_cate_list_a[$board_cate_n]['bca_use_good'] && $good == 'good' )\
          {
              $error = '이 게시판은 추천 기능을 사용하지 않습니다.';
              print_result($error, $count);
          }

          IF ( !$board_cate_list_a[$board_cate_n]['bca_use_nogood'] && $good == 'nogood' )
          {
              $error = '이 게시판은 비추천 기능을 사용하지 않습니다.';
              print_result($error, $count);
          }

          $sql_select  = "SELECT `bg_flag` FROM `". $g5['board_good_table'] ."` ";
          $sql_select .= "WHERE `bo_table` = '". $piree['cafe_board_code'] ."' AND `wr_id` = '". $wr_id ."' AND `mb_id` = '". $member['mb_id'] ."' AND `bg_flag` in ('good', 'nogood')";
          $row = sql_fetch($sql_select);

          IF ( isset($row['bg_flag']) && $row['bg_flag'] )
          {

              IF ( $row['bg_flag'] == 'good' )
              {
                  $status = '추천';
              }
              ELSE
              {
                  $status = '비추천';
              }

              $error = "이미 ". $status ." 하신 글 입니다.";
              print_result($error, $count);

          }
          ELSE
          {

                  $sql_update  = "UPDATE `". $piree['cafe_article'] ."` SET ";
                  $sql_update .= "`wr_". $good ."` = `wr_". $good ."` + 1 ";
                  $sql_update .= "WHERE `wr_id` = '". $wr_id ."'";
                  sql_query($sql_update);

                  $sql_insert  = "INSERT `". $g5['board_good_table'] ."` SET ";
                  $sql_insert .= "`bo_table`           = '". $piree['cafe_board_code'] ."', ";
                  $sql_insert .= "`wr_id`              = '". $wr_id ."', ";
                  $sql_insert .= "`mb_id`              = '". $member['mb_id'] ."', ";
                  $sql_insert .= "`bg_flag`            = '". $good ."', ";
                  $sql_insert .= "`bg_datetime`        = '". G5_TIME_YMDHIS ."', ";
                  $sql_insert .= "`bg_pi_piree_cafe_n` = '". $write['wr_pi_piree_cafe_n'] ."', ";
                  $sql_insert .= "`bg_pi_board_cate_n` = '". $write['wr_pi_board_cate_n'] ."', ";
                  $sql_insert .= "`bg_pi_piree_cafe_s` = '". addslashes($write['wr_pi_piree_cafe_s']) ."', ";
                  $sql_insert .= "`bg_pi_board_cate_s` = '". addslashes($write['wr_pi_board_cate_s']) ."'";

                  IF ( !sql_query($sql_insert) )
                  {

                    $sql_alter = "ALTER TABLE `". $g5['board_good_table'] ."` ADD `bg_pi_piree_cafe_n` INT UNSIGNED NOT NULL DEFAULT '0'";
                    sql_query($sql_alter, false);

                    $sql_alter = "ALTER TABLE `". $g5['board_good_table'] ."` ADD `bg_pi_board_cate_n` INT UNSIGNED NOT NULL DEFAULT '0'";
                    sql_query($sql_alter, false);

                    $sql_alter = "ALTER TABLE `". $g5['board_good_table'] ."` ADD `bg_pi_piree_cafe_s` VARCHAR(255) NOT NULL DEFAULT ''";
                    sql_query($sql_alter, false);

                    $sql_alter = "ALTER TABLE `". $g5['board_good_table'] ."` ADD `bg_pi_board_cate_s` VARCHAR(255) NOT NULL DEFAULT ''";
                    sql_query($sql_alter, false);

                    IF ( !sql_query($sql_update) )
                    {

                      alert("[ 추천, 비추천 반응 ]을 입력하지 못하였습니다.");
                    }

                  }

                  $sql_select  = "SELECT `wr_". $good ."` FROM `". $piree['cafe_article']."` ";
                  $sql_select .= "WHERE `wr_id` = '". $wr_id ."'";
                  $count = (int)sql_efv($sql);

                  run_event('bbs_increase_good_json', $piree['cafe_board_code'], $wr_id, $good);

                  print_result($error, $count);

          }

      }

  }
  ELSE
  {

      include_once( get_cafe_skin_file('path', 'basic', '_head.sub.php') );

      IF ( !$is_member )
      {
          $href = G5_BBS_URL.'/login.php?'. $qstr .'&amp;url='. urlencode(go_piree_cafe_board('', $piree_cafe_n, $board_cate_n, $wr_id));

          alert('회원만 가능합니다.', $href);
      }

      IF ( !($piree['cafe_board_code'] && $wr_id) )
      {
          alert('값이 제대로 넘어오지 않았습니다.');
      }

      $ss_name = 'ss_view_'. $piree['cafe_board_code'] .'_'. $wr_id;

      IF ( !get_session($ss_name) )
      {
          alert('해당 게시물에서만 추천 또는 비추천 하실 수 있습니다.');
      }

      $sql_select = "SELECT COUNT(*) AS cnt FROM `". $piree['cafe_article'] ."`";
      $row = sql_fetch($sql_select, FALSE);

      IF ( !$row['cnt'] )
      {
          $error = '존재하는 게시판이 아닙니다.';
          print_result($error, $count);
      }

      IF ( $good == 'good' || $good == 'nogood' )
      {

          IF ( $write['mb_id'] == $member['mb_id'])
          {
              alert('자신의 글에는 추천 또는 비추천 하실 수 없습니다.');
          }

          IF ( !$board_cate_list_a[$board_cate_n]['bca_use_good'] && $good == 'good')
          {
              alert('이 게시판은 추천 기능을 사용하지 않습니다.');
          }

          IF ( !$board_cate_list_a[$board_cate_n]['bca_use_nogood'] && $good == 'nogood')
          {
              alert('이 게시판은 비추천 기능을 사용하지 않습니다.');
          }

          $sql_select  = "SELECT `bg_flag` FROM `". $g5['board_good_table'] ."` ";
          $sql_select .= "WHERE `bo_table` = '". $piree['cafe_board_code'] ."' AND `wr_id` = '". $wr_id ."' AND `mb_id` = '". $member['mb_id'] ."' AND `bg_flag` in ('good', 'nogood')";
          $row = sql_fetch($sql);

          IF ( isset($row['bg_flag']) && $row['bg_flag'] )
          {

              IF ( $row['bg_flag'] == 'good' )
              {
                  $status = '추천';
              }
              ELSE
              {
                  $status = '비추천';
              }

              alert("이미 ". $status ." 하신 글 입니다.");

          }
          ELSE
          {

                  $sql_update  = "UPDATE `". $piree['cafe_article'] ."` SET ";
                  $sql_update .= "`wr_". $good ."` = `wr_". $good ."` + 1 ";
                  $sql_update .= "WHERE `wr_id` = '". $wr_id ."'";
                  sql_query($sql_update);

                  $sql_insert  = "INSERT `". $g5['board_good_table'] ."` SET ";
                  $sql_insert .= "`bo_table`           = '". $piree['cafe_board_code'] ."', ";
                  $sql_insert .= "`wr_id`              = '". $wr_id ."', ";
                  $sql_insert .= "`mb_id`              = '". $member['mb_id'] ."', ";
                  $sql_insert .= "`bg_flag`            = '". $good ."', ";
                  $sql_insert .= "`bg_datetime`        = '". G5_TIME_YMDHIS ."', ";
                  $sql_insert .= "`bg_pi_piree_cafe_n` = '". $write['wr_pi_piree_cafe_n'] ."', ";
                  $sql_insert .= "`bg_pi_board_cate_n` = '". $write['wr_pi_board_cate_n'] ."', ";
                  $sql_insert .= "`bg_pi_piree_cafe_s` = '". addslashes($write['wr_pi_piree_cafe_s']) ."', ";
                  $sql_insert .= "`bg_pi_board_cate_s` = '". addslashes($write['wr_pi_board_cate_s']) ."'";

                  IF ( !sql_query($sql_insert) )
                  {

                    $sql_alter = "ALTER TABLE `". $g5['board_good_table'] ."` ADD `bg_pi_piree_cafe_n` INT UNSIGNED NOT NULL DEFAULT '0'";
                    sql_query($sql_alter, false);

                    $sql_alter = "ALTER TABLE `". $g5['board_good_table'] ."` ADD `bg_pi_board_cate_n` INT UNSIGNED NOT NULL DEFAULT '0'";
                    sql_query($sql_alter, false);

                    $sql_alter = "ALTER TABLE `". $g5['board_good_table'] ."` ADD `bg_pi_piree_cafe_s` VARCHAR(255) NOT NULL DEFAULT ''";
                    sql_query($sql_alter, false);

                    $sql_alter = "ALTER TABLE `". $g5['board_good_table'] ."` ADD `bg_pi_board_cate_s` VARCHAR(255) NOT NULL DEFAULT ''";
                    sql_query($sql_alter, false);

                    IF ( !sql_query($sql_update) )
                    {

                      alert("[ 추천, 비추천 반응 ]을 입력하지 못하였습니다.");
                    }

                  }

                  IF ( $good == 'good' )
                  {
                      $status = '추천';
                  }
                  ELSE
                  {
                      $status = '비추천';
                  }

                  $href = go_piree_cafe_board('', $piree_cafe_n, $board_cate_n, $wr_id);

                  run_event('bbs_increase_good_html', $piree['cafe_board_code'], $wr_id, $good, $href);

                  alert("이 글을 ". $status ." 하셨습니다.", '', false);

          }

      }

  }

  run_event('bbs_good_after', $piree['cafe_board_code'], $wr_id, $good);

  @include_once($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/good.tail.skin.php' );

