<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 04월 12일 금요일 오후 15시 50분 / 맑음, 25.6, 건조주의보, 29, 9, 1%, 0%, 0.8ms / 나쁨, 52, 31

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 프로그램 > 피리 카페 관리 > 내 카페 > 게시판 > 게시글 목록, 게시글 내용 보기
=====================================================================

*/

  include_once('./_common.php');

  $g5['title'] = $piree_cafe_name_s ." > 피리 카페";

  include_once( piree__path($piree_prog_a[770099]['num'], '_CAFE.INFO.CHECK.inc.php') );

  check_device($board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_device']);

  IF ( isset($write['wr_is_comment']) && $write['wr_is_comment'] )
  {

    goto_url( go_piree_cafe_board('', $piree_cafe_n, $board_cate_n, $write['wr_parent'], $wr_id) );

  }

  IF ( (isset($wr_id) && $wr_id) || (isset($wr_seo_title) && $wr_seo_title) )
  {

    IF ( !isset($write['wr_id']) )
    {
      $msg = '게시글이 존재하지 않습니다.\\n\\n글이 삭제되었거나 이동된 경우입니다.';
      alert($msg, go_piree_cafe_board('', $piree_cafe_n, $board_cate_n) );
    }

    IF ( $cafe_member_a['cafe_mem_level_n'] < $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_read_level'] )
    {

      IF ( $is_member )
      {
        alert('카페 레벨 ['. $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_read_level'] .'] 이상 회원만 글을 읽을 수 있습니다.\\n\\n회원님의 레벨은 ['. $cafe_member_a['cafe_mem_level_n'] .'] 입니다.', cafe_index_go($piree_cafe_n));
      }
      ELSE
      {
        alert('글을 읽을 권한이 없습니다.\\n\\n회원이시라면 로그인 후 이용해 보십시오.', go_login_url(PIREE_THIS_URL, 1));
      }

    }

    IF ( $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_cert'] != '' && $config['cf_cert_use'] && !piree_cafe_auth_get() )
    {

      IF ( $is_guest )
      {
          alert('이 게시판은 본인확인 하신 회원님만 글읽기가 가능합니다.\\n\\n회원이시라면 로그인 후 이용해 보십시오.', go_login_url(PIREE_THIS_URL, 1));
      }

      IF ( strlen($member['mb_dupinfo']) == 64 && $member['mb_certify'] )
      {
        goto_url(G5_BBS_URL."/member_cert_refresh.php?url=". urlencode(PIREE_THIS_URL));
      }

      IF ( $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_cert'] == 'cert' && !$member['mb_certify'] )
      {    
        alert('이 게시판은 본인확인 하신 회원님만 글읽기가 가능합니다.\\n\\n회원정보 수정에서 본인확인을 해주시기 바랍니다.', cafe_index_go($piree_cafe_n));
      }

      IF ( $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_cert'] == 'adult' && !$member['mb_adult'] )
      {
          alert('이 게시판은 본인확인으로 성인인증 된 회원님만 글읽기가 가능합니다.\\n\\n현재 성인인데 글읽기가 안된다면 회원정보 수정에서 본인확인을 다시 해주시기 바랍니다.', cafe_index_go($piree_cafe_n));
      }

    }

    IF ( ( $write['mb_id'] && $write['mb_id'] === $member['mb_id'] ) || $is_admi || $is_cafe_managern == $piree_cafe_n )
    {

      ;

    }
    ELSE
    {

      IF ( strstr($write['wr_option'], "secret") )
      {

        $is_owner = false;

        IF ( $write['wr_reply'] && $member['mb_id'] )
        {

          $sql_select  = "SELECT `mb_id` FROM `". $piree['cafe_article'] ."` ";
          $sql_select .= "WHERE `wr_num` = '". $write['wr_num'] ."' AND `wr_reply` = '' AND `wr_is_comment` = '0'";
          $row = sql_fetch($sql_select);

          IF ( $row['mb_id'] === $member['mb_id'] )
          {

            $is_owner = true;

          }

        }

        $ss_name = 'ss_secret_'. $piree['cafe_board_code'] .'_'. $write['wr_num'];

        IF ( !$is_owner )
        {

//$ss_name = "ss_secret_{$piree['cafe_board_code']}_{$wr_id}";
//  저장된 게시물이 아니면서 관리자가 아니라면
// ( "$bo_table|$write['wr_num']" != get_session("ss_secret"))
          IF ( !get_session($ss_name) )
          {
            goto_url(piree__url($piree_prog_a[770099]['num'], 'password.php') .'?w=s&amp;bo_table='. $piree['cafe_board_code'] .'&amp;wr_id='. $wr_id.$qstr);
          }

        }

        set_session($ss_name, TRUE);

      }

    }

    $ss_name = 'ss_view_'. $piree['cafe_board_code'].'_'. $wr_id;

    IF ( !get_session($ss_name) )
    {

      $sql_update  = "UPDATE `". $piree['cafe_article'] ."` SET ";
      $sql_update .= "`wr_hit` = `wr_hit` + 1 ";
      $sql_update .= "WHERE `wr_id` = '". $wr_id ."'";
      sql_query($sql_update);

      IF ( $write['mb_id'] && $write['mb_id'] === $member['mb_id'] )
      {

        ;

      }
      ELSE IF ( $is_guest && $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_read_level'] == 1 && $write['wr_ip'] == $_SERVER['REMOTE_ADDR'] )
      {

        ;

      }
      ELSE
      {

        IF ( $config['cf_use_point'] && $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_read_point'] && $member['mb_point'] + $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_read_point'] < 0 )
        {
          alert('보유하신 포인트('.number_format($member['mb_point']).')가 없거나 모자라서 글읽기('.number_format($board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_read_point']).')가 불가합니다.\\n\\n포인트를 모으신 후 다시 글읽기 해 주십시오.');
        }

        insert_point($member['mb_id'], $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_read_point'], '피리 카페 게시판 > '. $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_cate_s'] .' > '. $wr_id .' 글읽기', $piree['cafe_board_code'], $wr_id, '읽기');

      }

      set_session($ss_name, TRUE);

    }

    $g5['title'] = strip_tags(conv_subject($write['wr_subject'], 255)) ." > ". $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_cate_s'];
    $g5['title'] = $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_cate_s'];

  }
  ELSE
  {

    IF ( $cafe_member_a['cafe_mem_level_n'] < $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_list_level'] )
    {

      IF ( $member['mb_id'] )
      {
        alert('목록을 볼 권한이 없습니다.', cafe_index_go($piree_cafe_n));
      }
      ELSE
      {
//('목록을 볼 권한이 없습니다.\\n\\n회원이시라면 로그인 후 이용해 보십시오.', go_login_url(PIREE_THIS_URL, 1));
      }

    }

    IF ( $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_cert'] != '' && $config['cf_cert_use'] && !piree_cafe_auth_get() )
    {

      IF ( $is_guest )
      {
        alert('이 게시판은 본인확인 하신 회원님만 글읽기가 가능합니다.\\n\\n회원이시라면 로그인 후 이용해 보십시오.', G5_BBS_URL.'/login.php?wr_id='. $wr_id.$qstr. '&amp;url='.urlencode(PIREE_THIS_URL));
      }

      IF ( strlen($member['mb_dupinfo']) == 64 && $member['mb_certify'] )
      {
        goto_url(G5_BBS_URL."/member_cert_refresh.php?url=". urlencode(PIREE_THIS_URL));
      }

      IF ( $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_cert'] == 'cert' && !$member['mb_certify'] )
      {    
        alert('이 게시판은 본인확인 하신 회원님만 글읽기가 가능합니다.\\n\\n회원정보 수정에서 본인확인을 해주시기 바랍니다.', cafe_index_go($piree_cafe_n));
      }

      IF ( $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_cert'] == 'adult' && !$member['mb_adult'] )
      {
        alert('이 게시판은 본인확인으로 성인인증 된 회원님만 글읽기가 가능합니다.\\n\\n현재 성인인데 글읽기가 안된다면 회원정보 수정에서 본인확인을 다시 해주시기 바랍니다.', cafe_index_go($piree_cafe_n));
      }

    }

    IF ( !isset($page) || ( isset($page) && $page == 0 ) )
    {
      $page = 1;
    }

    $g5['title'] = $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_cate_s'] .' '. $page .' 페이지';

  }

  $is_auth = piree_cafe_auth_get() ? true : false;

  $width = $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_table_width'];

  IF ( $width <= 100 )
  {
    $width .= '%';
  }
  ELSE
  {
    $width .='px';
  }

  $ip = "";

  $is_ip_view = $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_ip_view'];

  IF ( piree_cafe_auth_get() )
  {

    $is_ip_view = true;

    IF ( $write && array_key_exists('wr_ip', $write) )
    {
      $ip = $write['wr_ip'];
    }

  }
  ELSE
  {

    IF ( isset($write['wr_ip']) )
    {
      $ip = preg_replace("/([0-9]+).([0-9]+).([0-9]+).([0-9]+)/", G5_IP_DISPLAY, $write['wr_ip']);
    }

  }

  $admin_href = "";

  IF ( $member['mb_id'] && piree_cafe_auth_get() )
  {
    $cafe_manager_href = G5_ADMIN_URL.'/board_form.php?w=u&amp;bo_table='. $piree['cafe_board_code'];
  }

  $cafe_manager_href = "";

  IF ( $is_cafe_managern == $piree_cafe_n )
  {
    $cafe_manager_href  = piree__url($piree_prog_a[770099]['num'], 'piree.cafe.board.category.regist.form.php' );
    $cafe_manager_href .= '?'. $board_cate_list_a[$write['wr_pi_board_cate_n']]['piree_cafe_board_query'] . '&mode_c=modify';
  }

  $is_good = false;

  IF ($board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_good'] )
  {
    $is_good = true;
  }

  $is_nogood = false;

  IF ($board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_nogood'] )
  {
    $is_nogood = true;
  }

  include_once( get_cafe_skin_file('path', 'basic', '_head.sub.php') );

  include_once( get_cafe_skin_file('path', 'basic', '_head.skin.php') );

  IF (isset($wr_id) && $wr_id )
  {
    include_once( piree__path($piree_prog_a[770099]['num'], 'piree.cafe.board.view.php') );
  }

//  "예" 또는 wr_id 값이 없다면 목록을 보임
  IF ( $cafe_member_a['cafe_mem_level_n'] >= $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_list_level'] && $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_list_view'] || empty($wr_id) )
  {

    include_once( piree__path($piree_prog_a[770099]['num'], 'piree.cafe.board.list.php') );
  }

  echo "\n<!-- 사용스킨 : ".(G5_IS_MOBILE ? $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_mo_skin'] : $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_pc_skin'])." -->\n";

  include_once( get_cafe_skin_file('path', 'basic', '_tail.skin.php') );

  include_once( get_cafe_skin_file('path', 'basic', '_tail.sub.php') );

?>