<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 04월 14일 일요일 오후 18시 30분 / 맑음, 26.5, 건조주의보, 28, 9, 0%, 0%, 2.4ms / 양호, 33, 12, 0.005

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 프로그램 > 피리 카페 관리 > 내 카페 > 게시판 > 게시글 쓰기
=====================================================================

*/

  include_once('./_common.php');

  include_once( piree__path($piree_prog_a[770099]['num'], '_CAFE.INFO.CHECK.inc.php') );

  $sop = strtolower($sop);

  IF ( $sop != 'and' && $sop != 'or' )
  {

    $sop = 'and';

  }

  $sql_search = "";

  IF ( $sca || $stx || $stx === '0' )
  {

    $is_search_bbs = true;

    $sql_search = get_piree_cafe_sql_search($board_cate_n, $board_cate_list_a[$board_cate_n]['bca_depth_n'], $sfl, $stx, $sop);

    $search_href = go_piree_cafe_board('', $piree_cafe_n, $board_cate_n) . '&amp;page='. $page.$qstr;

    $list_href = go_piree_cafe_board('', $piree_cafe_n, $board_cate_n);

  }
  ELSE
  {

    $search_href = '';

    $list_href = go_piree_cafe_board('', $piree_cafe_n, $board_cate_n) . $qstr;

  }

  @include_once($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/piree.view.head.skin.php' );

  IF ( !$board_cate_list_a[$board_cate_n]['bca_use_list_view'] )
  {

    IF ( $sql_search )
    {
        $sql_search = " AND " . $sql_search;
    }

    $sql_select  = "SELECT `wr_id`, `wr_subject`, `wr_datetime` FROM `". $piree['cafe_article'] ."` ";
    $sql_select .= "WHERE ". $article_range_sql_where_s ." AND ";
    $sql_select .= "`wr_is_comment` = '0' AND `wr_num` = '". $write['wr_num'] ."' AND `wr_reply` < '". $write['wr_reply'] ."' ". $sql_search ." ";
    $sql_select .= "ORDER BY `wr_num` DESC, `wr_reply` DESC LIMIT 1 ";
    $prev = sql_fetch($sql_select);

    IF ( ! (isset($prev['wr_id']) && $prev['wr_id']) )
    {
        $sql_select  = "SELECT `wr_id`, `wr_subject`, `wr_datetime` FROM `". $piree['cafe_article'] ."` ";
        $sql_select .= "WHERE ". $article_range_sql_where_s ." AND ";
        $sql_select .= "`wr_is_comment` = '0' AND `wr_num` < '". $write['wr_num'] ."' ". $sql_search ." ";
        $sql_select .= "ORDER BY `wr_num` desc, `wr_reply` DESC LIMIT 1 ";
        $prev = sql_fetch($sql_select);
    }

    $sql_select  = "SELECT `wr_id`, `wr_subject`, `wr_datetime` FROM `". $piree['cafe_article'] ."` ";
    $sql_select .= "WHERE ". $article_range_sql_where_s ." AND ";
    $sql_select .= "`wr_is_comment` = '0' AND `wr_num` = '". $write['wr_num'] ."' and `wr_reply` > '". $write['wr_reply'] ."' ". $sql_search ." ";
    $sql_select .= "ORDER BY `wr_num`, `wr_reply` LIMIT 1 ";
    $next = sql_fetch($sql_select);

    IF ( ! (isset($next['wr_id']) && $next['wr_id']) )
    {
        $sql_select  = "SELECT `wr_id`, `wr_subject`, `wr_datetime` FROM `". $piree['cafe_article'] ."` ";
        $sql_select .= "WHERE ". $article_range_sql_where_s ." AND ";
        $sql_select .= "`wr_is_comment` = '0' AND `wr_num` > '". $write['wr_num'] ."' ". $sql_search ." ";
        $sql_select .= "ORDER BY `wr_num`, `wr_reply` LIMIT 1 ";
        $next = sql_fetch($sql_select);
    }

  }

  $prev_href = '';

  IF ( isset($prev['wr_id']) && $prev['wr_id'] )
  {
    $prev_wr_subject = get_text(cut_str($prev['wr_subject'], 255));
    $prev_wr_date = $prev['wr_datetime'];
    $prev_href = go_piree_cafe_board('', $piree_cafe_n, $board_cate_n, $prev['wr_id']) . $qstr;
  }

  $next_href = '';

  IF ( isset($next['wr_id']) && $next['wr_id'] )
  {
    $next_wr_subject = get_text(cut_str($next['wr_subject'], 255));
    $next_wr_date = $next['wr_datetime'];
    $next_href = go_piree_cafe_board('', $piree_cafe_n, $board_cate_n, $next['wr_id']) . $qstr;
  }

  $write_href = '';

  IF ( $cafe_member_a['cafe_mem_level_n'] >= $board_cate_list_a[$board_cate_n]['bca_write_level'] )
  {
    $write_href = go_piree_cafe_board('piree.cafe.board.write.php', $piree_cafe_n, $board_cate_n);
  }

  $reply_href = '';

  IF ( $cafe_member_a['cafe_mem_level_n'] >= $board_cate_list_a[$board_cate_n]['bca_reply_level'] )
  {
    $reply_href = go_piree_cafe_board('piree.cafe.board.write.php', $piree_cafe_n, $board_cate_n, $wr_id) .'&amp;w=r&amp;'. $qstr;
  }

  $update_href = '';

  $delete_href = '';

// 글이라면 또는 관리자라면 비밀번호를 묻지 않고 바로 수정, 삭제 가능
  IF ( ($member['mb_id'] && ($member['mb_id'] === $write['mb_id'])) || piree_cafe_auth_get() )
  {

    $update_href = go_piree_cafe_board('piree.cafe.board.write.php', $piree_cafe_n, $board_cate_n, $wr_id) .'&amp;w=u&amp;page='. $page . $qstr;

    set_session('ss_delete_token', $token = uniqid(time()));

    $delete_href = go_piree_cafe_board('piree.cafe.board.delete.php', $piree_cafe_n, $board_cate_n, $wr_id) .'&amp;token='. $token .'&amp;'. urldecode($qstr);

  }
  ELSE IF ( !$write['mb_id'])
  {

    $update_href = go_piree_cafe_board('piree.cafe.board.password.php', $piree_cafe_n, $board_cate_n, $wr_id) .'&w=u&amp;page='. $page.$qstr;

    $delete_href = go_piree_cafe_board('piree.cafe.board.password.php', $piree_cafe_n, $board_cate_n, $wr_id) .'&w=d&amp;page='. $page.$qstr;

  }

  $scrap_href = '';

  $good_href = '';

  $nogood_href = '';

  IF  ( $is_member )
  {

    $scrap_href = go_piree_cafe_board('piree.cafe.scrap_popin.php', $piree_cafe_n, $write['wr_pi_board_cate_n'], $wr_id);

    IF ( $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_good'] )
    {

        $good_href = go_piree_cafe_board('piree.cafe.board.good.php', $piree_cafe_n, $write['wr_pi_board_cate_n'], $wr_id) .'&amp;good=good';

    }

    IF ( $board_cate_list_a[$write['wr_pi_board_cate_n']]['bca_use_nogood'] )
    {

        $nogood_href = go_piree_cafe_board('piree.cafe.board.good.php', $piree_cafe_n, $write['wr_pi_board_cate_n'], $wr_id) .'&amp;good=nogood';

    }

  }

  $view = get_view($write, $board, $board_cate_list_a[$board_cate_n]['board_skin_p']);

  IF ( strstr($sfl, 'subject') )
  {
      $view['subject'] = search_font($stx, $view['subject']);
  }

  $html = 0;

  IF ( strstr($view['wr_option'], 'html1') )
  {
    $html = 1;
  }
  ELSE IF ( strstr($view['wr_option'], 'html2') )
  {
    $html = 2;
  }

  $view['content'] = conv_content($view['wr_content'], $html);

  IF ( strstr($sfl, 'content') )
  {
    $view['content'] = search_font($stx, $view['content']);
  }

//$view['rich_content'] = preg_replace("/{이미지\:([0-9]+)[:]?([^}]*)}/ie", "view_image(\$view, '\\1', '\\2')", $view['content']);
  function conv_rich_content($matches)
  {
      global $view;
      return view_image($view, $matches[1], $matches[2]);
  }

  $view['rich_content'] = preg_replace_callback("/{이미지\:([0-9]+)[:]?([^}]*)}/i", "conv_rich_content", $view['content']);

// / 사용_안함
  $is_signature = false;

  $signature = '';

  IF ( $board_cate_list_a[$board_cate_n]['bca_use_signature'] && $view['mb_id'] )
  {

// / 사용_함
    $is_signature = true;

    $mb = get_member($view['mb_id']);

    $signature = $mb['mb_signature'];

    $signature = conv_content($signature, 1);

  }

  include_once($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/piree.cafe.view.skin.php' );

  @include_once($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/piree.view.tail.skin.php' );

?>