<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https:/\/piree.kr/nett_dev

  작업날짜 : 2024년 04월 05일 금요일 오후 20시 46분 / 맑음, 13.8, 쾌적, 17, 7, 19%, 20%, 0.3ms / 보통, 43, 24

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 관리자 > 프로그램 > 피리 카페 관리 > 지역 관리 > 입력하기, 수정하기 > 폼
=====================================================================

연결지역

인근지역

이미지맵표시

*/

  include_once('./_common.php' );

  auth_check_menu($auth, $sub_menu, 'w');

  $get__p770099 = 1;

  $prog_config_page = 0;

  include_once( piree__path($sub_menu, 'config') );

  $old_region_l_s = "";

  $old_region_s_s = "";

  $old_region_kor_p = '';

  $top_region_info_title = '지역정보';

  $region_s_l = '';

  $region_s_s = '';

  IF ( $region_n > 0 )
  {

      $sql  = "SELECT * FROM `". $piree['region'] ."` ";
      $sql .= "WHERE `region_n` = '". $region_n ."'";
      $region_row = sql_fetch($sql);

      IF ( $region_n == $region_row['region_n'] )
      {

          $old_region_l_s = $region_row['region_l_s'];

          $old_region_s_s = $region_row['region_s_s'];

          $old_region_kor_p = str_replace('--', ' > ', $region_row['region_kor_p']);

          IF ( $mode == 'update' )
          {

              $active_s = "수정하기";

              $top_region_info_title = "[ ". $active_s ." ] 지역정보";

              $region_l_s = $old_region_l_s;

              $region_s_s = $old_region_s_s;

          }
          ELSE
          {

              $active_s = "등록하기";

              $top_region_info_title = "[ ". $active_s ." ] 상위 지역정보";

              IF ( $region_row['region_depth_n'] > 1 )
              {
                  alert ("2단계 이상의 지역을 등록할수 없습니다.", 'region.list.php' );
              }

          }

      }

  }

  $g5['title'] = "지역 관리, 지역게시판  PLUS G5 > 지역 ". $active_s;

  include_once( G5_ADMIN_PATH .'/admin.head.php' );

  $top_menu = 'region.list';
  include_once( piree__admin_path($sub_menu, 'top.menu.inc.php') );

?>

<section>

<?php

/*
    <div class="btn_confirm">
          <input type="submit" class="btn_submit" value=" 등 록 합 니 다 ">
          <input type="button" class="btn_cancel" value=" 지역목록 " onClick="PageUrl('region.list.php')">
    </div>
*/

  IF ( $old_region_l_s )
  {
?>
    <section id="region_parent">

        <h2>▒▒ <?php echo $top_region_info_title ?></h2>

        <div class="tbl_frm01 tbl_wrap">
            <table>
            <col class="td_left_180" />
            <col>
            <tbody>

            <tr>
                <th scope="row">긴 지역 이름</th>
                <td class="line_h_1_6"><?php echo $old_region_l_s ?></td>
            </tr>

            <tr>
                <th scope="row">지역 짧은 이름</th>
                <td class="line_h_1_6"><?php echo $old_region_s_s ?></td>
            </tr>

            <tr>
                <th scope="row">지역 경로</th>
                <td class="line_h_1_6"><?php echo $old_region_kor_p ?></td>
            </tr>

            </tbody>
            </table>
        </div>

    </section>

    <br /><br /><br />

<?php
  }

?>

    <form name="region_regist_form" id="region_regist_form" action="region.regist.update.php" onsubmit="return submit__region_regist(this);" method="post">
    <input type="hidden" name="mode" value="<?php echo $mode ?>">
    <input type="hidden" name="region_n" value="<?php echo $region_n ?>">
    <input type="hidden" name="view_mode" value="<?php echo $view_mode ?>">

    <section id="region_this">

        <h2>▒▒ 지역정보 입력</h2>

        <div class="tbl_frm01 tbl_wrap">
            <table>
            <col class="td_left_180" />
            <col>
            <tbody>

            <tr>
                <th scope="row"><label for="region_l_s">긴 지역 이름<strong class="sound_only">선택입력</strong></label></th>
                <td class="line_h_2_2">
                    <input type="text" name="region_l_s" id="region_l_s" value="<?php echo $region_l_s ?>" class="frm_input" size="120"><br>
                    <span class="font_37b44a">한글로 지역 이름을 입력해 주세요.</span><br>
                    <span class="font_37b44a">예) "서울"은 "서울특별시" , "충남"은 "충청남도" 와 같이 입력해 주세요.</span>
                </td>
            </tr>

            <tr>
                <th scope="row"><label for="region_s_s">지역 짧은 이름<strong class="sound_only">선택입력</strong></label></th>
                <td class="line_h_2_2">
                    <input type="text" name="region_s_s" id="region_s_s" value="<?php echo $region_s_s ?>" class="frm_input" size="120"><br>
                    <span class="font_37b44a">한글로 지역 이름을 입력해 주세요.</span><br>
                    <span class="font_37b44a">예) "서울특별시"은 "서울" , "충청남도"은 "충남" 와 같이 입력해 주세요.</span>
                </td>
            </tr>

<?php

        IF ( $mode != 'update' )
        {
?>
            <tr>
                <th scope="row"><label>일괄 등록하기</label></th>
                <td class="line_h_2_2">
                    <textarea name="region_multi_s" id="region_multi_s" class="frm_input" style="width:100%;height:200px;"><?php echo $region_multi_s ?></textarea><br>
                    <span class="font_37b44a">이 칸에 여러 지역을 한꺼번에 등록할수 있습니다.</span><br>
                    <span class="font_37b44a">줄바꿈으로 여러 지역을 등록합니다.</span><br>
                    <span class="font_37b44a">한 지역의 정보를 "긴 지역 이름 | 지역 짧은 이름 | 이미지맵 PC 외곽선 좌표 | 이미지맵 PC 지역이름 좌표"로 구분합니다.</span><br>
                </td>
            </tr>
<?php
        }

?>

            </tbody>
            </table>
        </div>

        <div class="btn_fixed_top">
            <a href="region.list.php" class="btn_02 btn">지역목록</a>
            <input type="submit" value="저장합니다" class="btn_submit btn">
        </div>

    </section>

    </form>

</section>

<script>

function submit__region_regist(gform)
{

    return true;

}
</script>

<?php

  include_once( G5_ADMIN_PATH .'/admin.tail.php' );

?>