<?php

/*
=====================================================================

  프로젝트 이름 : 피리 웹프로그램

  만든사람 : 피리 PIREE ( piree1977@gmail.com )

  홈페이지 : www.piree.kr

  작성날짜 : 2024년 04월 09일 화요일 오후 13시 06분 / 맑음, 17.2, 건조 주의보, 18, 8, 1%, 0%, 2.6ms / 좋음, 29, 13

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
            그누보드 외에 추가된 소스는~
            만든사람의 허락없이 무단으로 사용할수 없습니다.
            사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
            http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 피리 기본 관리 > 라이브러리 > 게시판 카테고리 > SMALLINT > 2단계
=====================================================================

*/

  IF (!defined('_GNUBOARD_'))                      EXIT;

  function get_category_record_map_smallint2_cafe_board($fnc_mb_id)
  {

      global $piree_prog_a;

      $in_link_s = "";

      IF ( $fnc_mb_id )
      {

          $in_link_s  = piree__url($piree_prog_a[770100]['num'], 'member_category_record.php' );
          $in_link_s .= '?mem_id='. $fnc_mb_id;

      }

      return $in_link_s;

  }

  function get_category_row_smallint2_cafe_board($board_cate_n, $func_fd_c='')
  {

      global $piree;

      $category_arr = array();

      IF ( $board_cate_n > 0 )
      {

          $sql  = "SELECT ". $func_fd_c ." FROM `". $piree['cafe_board'] ."` ";
          $sql .= "WHERE `bca_cafe_n` = '". $board_cate_n ."'";
          $res  = sql_fetch($sql);

          IF ( $res['category_kor_p'] )
          {

              $res['category_kor_p2'] = str_replace('--', ' > ', $res['category_kor_p']);

          }

      }

      return $res;

  }

  function get_category_upper_smallint2_cafe_board($board_cate_n)
  {

      global $piree;

      $category_i_a = array();

      IF ( !$board_cate_n || $board_cate_n == 0 )
      {
          return false;
      }

      $category_i_a[1] = floor($board_cate_n/100) * 100;
      $category_i_a[2] = floor($board_cate_n/1) * 1;

      IF ( $board_cate_n == $category_i_a[1] )
      {

          $category_i_a[0] = 1;

          $category_i_a[2] = 0;

          $category_i_a[6] = $category_i_a[1] .'--';

      }
      ELSE IF ( $board_cate_n == $category_i_a[2] )
      {

          $category_i_a[0] = 2;

          $category_i_a[6] = $category_i_a[1] .'--'. $category_i_a[2] .'--';

      }

      return $category_i_a;

  }

  function get_category_sql_where_smallint2_cafe_board($board_cate_num_a, $sql_fd_s, $board_cate_n = 0, $get_children = 0)
  {

      global $piree;

      IF ( !$sql_fd_s )
      {
          return false;
      }

      $sql_where_a = array();

      FOR ( $loop_n=1; $loop_n<3; $loop_n++)
      {

          IF ( $board_cate_num_a[$loop_n] > 0 )
          {

              $sql_where_a[] = "`". $sql_fd_s ."` = '". $board_cate_num_a[$loop_n] ."'";

          }

      }

      $sql_where_s = implode(' OR ', $sql_where_a);

      IF ( $get_children == 1 )
      {

          IF ( $board_cate_n > 0 )
          {

              $sql_where_s .= " OR `bca_parent_n` = '". $board_cate_n ."'";

          }

      }

      return $sql_where_s;

  }

  function get_cate_name_path_smallint2_cafe_board($board_cate_num_a, $sql_where_s)
  {

      global $piree;

      IF ( !$board_cate_num_a )
      {
          return false;
      }

      IF ( !$sql_where_s )
      {
          return false;
      }

      $category_str_a[0] = '';
      $category_str_a[1] = '';
      $category_str_a[2] = '';
      $category_str_a[6] = '';

      $category_kor_p = '';

      $sql_select  = "SELECT `bca_cafe_n`, `category_s`, `bca_depth_n` FROM `". $piree['cafe_board'] ."` ";
      $sql_select .= "WHERE ". $sql_where_s ." ORDER BY `bca_cafe_n` ASC";
      $result = sql_query($sql_select);

      WHILE ( $res = sql_fetch_array($result) )
      {

          IF ( $res['bca_cafe_n'] > 0 )
          {

              IF ( $res['category_s'] )
              {

                  $in_depth_n = $res['bca_depth_n'];

                  $in_category_s = clean_str($res['category_s']);

                  $category_str_a[$in_depth_n] = $in_category_s;

                  $category_kor_p .= $in_category_s .'--';

              }

          }

      }

      $category_str_a[6] = $category_kor_p;

      return $category_str_a;

  }

  function get_new_cate_num_smallint2_cafe_board($func_piree_cafe_n, $parent_cate_n, $depth_n)
  {

      global $piree;

      IF ( !$func_piree_cafe_n || $func_piree_cafe_n == 0 )
      {
        return false;
      }

      IF ( !$depth_n || $depth_n == 0 )
      {
        return false;
      }

      IF ( !$parent_cate_n )
      {
        $parent_cate_n = 0;
      }

      IF ( $depth_n > 1 )
      {

        IF ( $parent_cate_n == 1 )
        {
            return false;
        }

      }

      $sql_select  = "SELECT MAX(`bca_cate_n`) FROM `". $piree['cafe_board'] ."` ";
      $sql_select .= "WHERE `bca_cafe_n` = '". $func_piree_cafe_n ."' AND `bca_parent_n` = '". $parent_cate_n ."' AND `bca_depth_n` = '". $depth_n ."'";
      $temp_n = sql_efv($sql_select);

      IF ( !$temp_n )
      {

        $temp_n = $parent_cate_n;

      }

      $new_cate_n = 0;

      SWITCH ( $depth_n )
      {
        CASE 1 :          $new_cate_n = $temp_n + 100;                BREAK;
        CASE 2 :          $new_cate_n = $temp_n + 1;                  BREAK;
      }

      return $new_cate_n;

  }

  function get_category_range_smallint2_cafe_board($board_cate_n, $board_cate_depth_n, $sql_fd_s)
  {

      global $piree;

      IF ( !$board_cate_n )
      {
          return false;
      }

      IF ( !$board_cate_depth_n )
      {

          $sql  = "SELECT cate_depth_n FROM `". $piree['cafe_board'] ."` ";
          $sql .= "WHERE `bca_cafe_n` = '". $board_cate_n ."'";
          $board_cate_depth_n = sql_efv($sql);

      }

      $range_a[0] = $board_cate_n;
      $range_a[1] = "";
      $range_a[2] = "";
      $range_a[3] = "";

      SWITCH ( $board_cate_depth_n )
      {
          CASE 1 :          $range_a[1] = $board_cate_n + 99;                BREAK;
          CASE 2 :          $range_a[1] = $board_cate_n;                    BREAK;
      }

      IF ( $sql_fd_s )
      {

          IF ( $board_cate_n )
          {

              IF ( $range_a[1] > $board_cate_n )
              {

                  $range_a[2] = "(`". $sql_fd_s ."` BETWEEN '". $board_cate_n ."' AND '". $range_a[1] ."')";
                  $range_a[3] = "(`". $sql_fd_s ."` BETWEEN '". ($board_cate_n+1) ."' AND '". $range_a[1] ."')";

              }
              ELSE
              {

                  $range_a[2] = "`". $sql_fd_s ."` = '". $board_cate_n ."'";
                  $range_a[3] = "";

              }

          }

      }

      return $range_a;

  }

  function get_sub_category_count_depth_smallint2_cafe_board($category_i_a, $board_cate_n)
  {

      global $piree;

      IF ( !count($category_i_a) )
      {
          return false;
      }

      IF ( !$board_cate_n )
      {
          return false;
      }

      FOR ( $i=1; $i<6; $i++ )
      {

          IF ( $category_i_a[$i] > 0 )
          {

              IF ( $board_cate_n != $category_i_a[$i] )
              {

                  get_sub_category_count_single_smallint2_cafe_board($category_i_a[$i], $i, 1);

              }

          }

      }

  }

  function get_sub_category_count_single_smallint2_cafe_board($board_cate_n, $board_cate_depth_n, $is_db_update = 0)
  {

      global $piree;

      IF ( !$board_cate_n )
      {
          return false;
      }

      $range_a = get_category_range_smallint2_cafe_board($board_cate_n, $board_cate_depth_n, 'bca_cafe_n');

      $sql  = "SELECT COUNT(*) FROM `". $piree['cafe_board'] ."` ";
      $sql .= "WHERE ". $range_a[3];
      $board_cate_sub_t = (int)sql_efv($sql);

      IF ( $is_db_update == 1 )
      {

          $sql  = "UPDATE `". $piree['cafe_board'] ."` SET ";
          $sql .= "`bca_sub_t` = '". $board_cate_sub_t ."' ";
          $sql .= "WHERE `bca_cafe_n` = '". $board_cate_n ."'";

          IF ( !sql_query($sql) )
          {

              alert ("[ ". $board_cate_n ." ] 카테고리의 하위게시판 카테고리 수를 새로고침하지 못했습니다.");
          }

      }

      return $board_cate_sub_t;

  }

  function set__colorbox_css_js()
  {

  // add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
      add_stylesheet('<link rel="stylesheet" href="http://.jacklmoore.com/colorbox/example3/colorbox.css">', 0);

  // add_javascript('js 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
      add_javascript('<script src="http://.jacklmoore.com/colorbox/jquery.colorbox.js"></script>', 75);

  }

/*

  function get__0000($0000)
  {

      global $piree;

      IF (  )
      {

      }

      return $aaaa;

  }

  function get__0000($0000)
  {

      global $piree;

      IF (  )
      {

      }

      return $aaaa;

  }

*/

?>